# Konveyor > Forklift > Validation Rules

When running as the `forklift-validation` pod in OpenShift, the rules can be called by making an https POST call to `<pod>/v1/data/io/konveyor/forklift/<provider>/validate`, where <provider> is "vmware" or "ovirt"

The call must provide a JSON payload containing the provider VM "workload" details from the forklift inventory, in the following format:

```
{
    "input": {    
        "selfLink": "providers/vsphere/73195853-3daf-4063-8c0d-da8ee56f0af4/workloads/vm-431",
        "id": "vm-431",
        "parent": {
            "kind": "Folder",
            "id": "group-v22"
        },
...
```

The return is a JSON structure containing the concerns relevant to that VM, for example:

```
{
    "result": {
        "concerns": [
            {
                "assessment": "CPU affinity is not currently supported by OpenShift Virtualization. The VM can be migrated but it will not have this feature in the target environment.",
                "category": "Warning",
                "label": "CPU affinity detected"
            },
            {
                "assessment": "Distributed resource scheduling is not currently supported by OpenShift Virtualization. The VM can be migrated but it will not have this feature in the target environment.",
                "category": "Information",
                "label": "VM running in a DRS-enabled cluster"
            },
            {
                "assessment": "NUMA node affinity is not currently supported by OpenShift Virtualization. The VM can be migrated but it will not have this feature in the target environment.",
                "category": "Warning",
                "label": "NUMA node affinity detected"
            },
            {
                "assessment": "Hot pluggable CPU or memory is not currently supported by OpenShift Virtualization. Review CPU or memory configuration after migration.",
                "category": "Warning",
                "label": "CPU/Memory hotplug detected"
            }
        ],
        "errors": [],
        "rules_version": 1
    }
}
```

An error in the JSON body of the POST request will be returned as:

```
{
    "result": {
        "concerns": [],
        "errors": [
            "No VM found that matches input parameters"
        ],
        "rules_version": 1
    }
}
```

The rules versions can be queried by making a GET to `<pod>/v1/data/io/konveyor/forklift/<provider>/rules_version`

This will return a JSON structure such as:

```
{
    "result": {
        "rules_version": 1
    }
}
```

The rules in the repository can be tested from the command line using the Open Policy Agent CLI (see [OPA doc](https://www.openpolicyagent.org/docs/latest/#running-opa)).

Then you can run the unit tests with:

```
$ opa test policies --explain fails
```

Whenever the rules are edited or updated, the relevant `policies/io/konveyor/forklift/<provider>/rules_version.rego` file **must** be updated with an incremented number, for example:

```
RULES_VERSION := 2
```

