// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.12.3
// source: google/cloud/audit/audit_log.proto

package audit

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	any "github.com/golang/protobuf/ptypes/any"
	_struct "github.com/golang/protobuf/ptypes/struct"
	attribute_context "google.golang.org/genproto/googleapis/rpc/context/attribute_context"
	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Common audit log format for Google Cloud Platform API operations.
type AuditLog struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the API service performing the operation. For example,
	// `"datastore.googleapis.com"`.
	ServiceName string `protobuf:"bytes,7,opt,name=service_name,json=serviceName,proto3" json:"service_name,omitempty"`
	// The name of the service method or operation.
	// For API calls, this should be the name of the API method.
	// For example,
	//
	//     "google.datastore.v1.Datastore.RunQuery"
	//     "google.logging.v1.LoggingService.DeleteLog"
	MethodName string `protobuf:"bytes,8,opt,name=method_name,json=methodName,proto3" json:"method_name,omitempty"`
	// The resource or collection that is the target of the operation.
	// The name is a scheme-less URI, not including the API service name.
	// For example:
	//
	//     "shelves/SHELF_ID/books"
	//     "shelves/SHELF_ID/books/BOOK_ID"
	ResourceName string `protobuf:"bytes,11,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// The resource location information.
	ResourceLocation *ResourceLocation `protobuf:"bytes,20,opt,name=resource_location,json=resourceLocation,proto3" json:"resource_location,omitempty"`
	// The resource's original state before mutation. Present only for
	// operations which have successfully modified the targeted resource(s).
	// In general, this field should contain all changed fields, except those
	// that are already been included in `request`, `response`, `metadata` or
	// `service_data` fields.
	// When the JSON object represented here has a proto equivalent,
	// the proto name will be indicated in the `@type` property.
	ResourceOriginalState *_struct.Struct `protobuf:"bytes,19,opt,name=resource_original_state,json=resourceOriginalState,proto3" json:"resource_original_state,omitempty"`
	// The number of items returned from a List or Query API method,
	// if applicable.
	NumResponseItems int64 `protobuf:"varint,12,opt,name=num_response_items,json=numResponseItems,proto3" json:"num_response_items,omitempty"`
	// The status of the overall operation.
	Status *status.Status `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
	// Authentication information.
	AuthenticationInfo *AuthenticationInfo `protobuf:"bytes,3,opt,name=authentication_info,json=authenticationInfo,proto3" json:"authentication_info,omitempty"`
	// Authorization information. If there are multiple
	// resources or permissions involved, then there is
	// one AuthorizationInfo element for each {resource, permission} tuple.
	AuthorizationInfo []*AuthorizationInfo `protobuf:"bytes,9,rep,name=authorization_info,json=authorizationInfo,proto3" json:"authorization_info,omitempty"`
	// Metadata about the operation.
	RequestMetadata *RequestMetadata `protobuf:"bytes,4,opt,name=request_metadata,json=requestMetadata,proto3" json:"request_metadata,omitempty"`
	// The operation request. This may not include all request parameters,
	// such as those that are too large, privacy-sensitive, or duplicated
	// elsewhere in the log record.
	// It should never include user-generated data, such as file contents.
	// When the JSON object represented here has a proto equivalent, the proto
	// name will be indicated in the `@type` property.
	Request *_struct.Struct `protobuf:"bytes,16,opt,name=request,proto3" json:"request,omitempty"`
	// The operation response. This may not include all response elements,
	// such as those that are too large, privacy-sensitive, or duplicated
	// elsewhere in the log record.
	// It should never include user-generated data, such as file contents.
	// When the JSON object represented here has a proto equivalent, the proto
	// name will be indicated in the `@type` property.
	Response *_struct.Struct `protobuf:"bytes,17,opt,name=response,proto3" json:"response,omitempty"`
	// Other service-specific data about the request, response, and other
	// information associated with the current audited event.
	Metadata *_struct.Struct `protobuf:"bytes,18,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// Deprecated, use `metadata` field instead.
	// Other service-specific data about the request, response, and other
	// activities.
	ServiceData *any.Any `protobuf:"bytes,15,opt,name=service_data,json=serviceData,proto3" json:"service_data,omitempty"`
}

func (x *AuditLog) Reset() {
	*x = AuditLog{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_audit_log_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuditLog) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuditLog) ProtoMessage() {}

func (x *AuditLog) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_audit_log_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuditLog.ProtoReflect.Descriptor instead.
func (*AuditLog) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_audit_log_proto_rawDescGZIP(), []int{0}
}

func (x *AuditLog) GetServiceName() string {
	if x != nil {
		return x.ServiceName
	}
	return ""
}

func (x *AuditLog) GetMethodName() string {
	if x != nil {
		return x.MethodName
	}
	return ""
}

func (x *AuditLog) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

func (x *AuditLog) GetResourceLocation() *ResourceLocation {
	if x != nil {
		return x.ResourceLocation
	}
	return nil
}

func (x *AuditLog) GetResourceOriginalState() *_struct.Struct {
	if x != nil {
		return x.ResourceOriginalState
	}
	return nil
}

func (x *AuditLog) GetNumResponseItems() int64 {
	if x != nil {
		return x.NumResponseItems
	}
	return 0
}

func (x *AuditLog) GetStatus() *status.Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *AuditLog) GetAuthenticationInfo() *AuthenticationInfo {
	if x != nil {
		return x.AuthenticationInfo
	}
	return nil
}

func (x *AuditLog) GetAuthorizationInfo() []*AuthorizationInfo {
	if x != nil {
		return x.AuthorizationInfo
	}
	return nil
}

func (x *AuditLog) GetRequestMetadata() *RequestMetadata {
	if x != nil {
		return x.RequestMetadata
	}
	return nil
}

func (x *AuditLog) GetRequest() *_struct.Struct {
	if x != nil {
		return x.Request
	}
	return nil
}

func (x *AuditLog) GetResponse() *_struct.Struct {
	if x != nil {
		return x.Response
	}
	return nil
}

func (x *AuditLog) GetMetadata() *_struct.Struct {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *AuditLog) GetServiceData() *any.Any {
	if x != nil {
		return x.ServiceData
	}
	return nil
}

// Authentication information for the operation.
type AuthenticationInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The email address of the authenticated user (or service account on behalf
	// of third party principal) making the request. For privacy reasons, the
	// principal email address is redacted for all read-only operations that fail
	// with a "permission denied" error.
	PrincipalEmail string `protobuf:"bytes,1,opt,name=principal_email,json=principalEmail,proto3" json:"principal_email,omitempty"`
	// The authority selector specified by the requestor, if any.
	// It is not guaranteed that the principal was allowed to use this authority.
	AuthoritySelector string `protobuf:"bytes,2,opt,name=authority_selector,json=authoritySelector,proto3" json:"authority_selector,omitempty"`
	// The third party identification (if any) of the authenticated user making
	// the request.
	// When the JSON object represented here has a proto equivalent, the proto
	// name will be indicated in the `@type` property.
	ThirdPartyPrincipal *_struct.Struct `protobuf:"bytes,4,opt,name=third_party_principal,json=thirdPartyPrincipal,proto3" json:"third_party_principal,omitempty"`
	// The name of the service account key used to create or exchange
	// credentials for authenticating the service account making the request.
	// This is a scheme-less URI full resource name. For example:
	//
	// "//iam.googleapis.com/projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}/keys/{key}"
	ServiceAccountKeyName string `protobuf:"bytes,5,opt,name=service_account_key_name,json=serviceAccountKeyName,proto3" json:"service_account_key_name,omitempty"`
	// Identity delegation history of an authenticated service account that makes
	// the request. It contains information on the real authorities that try to
	// access GCP resources by delegating on a service account. When multiple
	// authorities present, they are guaranteed to be sorted based on the original
	// ordering of the identity delegation events.
	ServiceAccountDelegationInfo []*ServiceAccountDelegationInfo `protobuf:"bytes,6,rep,name=service_account_delegation_info,json=serviceAccountDelegationInfo,proto3" json:"service_account_delegation_info,omitempty"`
	// String representation of identity of requesting party.
	// Populated for both first and third party identities.
	PrincipalSubject string `protobuf:"bytes,8,opt,name=principal_subject,json=principalSubject,proto3" json:"principal_subject,omitempty"`
}

func (x *AuthenticationInfo) Reset() {
	*x = AuthenticationInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_audit_log_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuthenticationInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthenticationInfo) ProtoMessage() {}

func (x *AuthenticationInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_audit_log_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthenticationInfo.ProtoReflect.Descriptor instead.
func (*AuthenticationInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_audit_log_proto_rawDescGZIP(), []int{1}
}

func (x *AuthenticationInfo) GetPrincipalEmail() string {
	if x != nil {
		return x.PrincipalEmail
	}
	return ""
}

func (x *AuthenticationInfo) GetAuthoritySelector() string {
	if x != nil {
		return x.AuthoritySelector
	}
	return ""
}

func (x *AuthenticationInfo) GetThirdPartyPrincipal() *_struct.Struct {
	if x != nil {
		return x.ThirdPartyPrincipal
	}
	return nil
}

func (x *AuthenticationInfo) GetServiceAccountKeyName() string {
	if x != nil {
		return x.ServiceAccountKeyName
	}
	return ""
}

func (x *AuthenticationInfo) GetServiceAccountDelegationInfo() []*ServiceAccountDelegationInfo {
	if x != nil {
		return x.ServiceAccountDelegationInfo
	}
	return nil
}

func (x *AuthenticationInfo) GetPrincipalSubject() string {
	if x != nil {
		return x.PrincipalSubject
	}
	return ""
}

// Authorization information for the operation.
type AuthorizationInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource being accessed, as a REST-style string. For example:
	//
	//     bigquery.googleapis.com/projects/PROJECTID/datasets/DATASETID
	Resource string `protobuf:"bytes,1,opt,name=resource,proto3" json:"resource,omitempty"`
	// The required IAM permission.
	Permission string `protobuf:"bytes,2,opt,name=permission,proto3" json:"permission,omitempty"`
	// Whether or not authorization for `resource` and `permission`
	// was granted.
	Granted bool `protobuf:"varint,3,opt,name=granted,proto3" json:"granted,omitempty"`
	// Resource attributes used in IAM condition evaluation. This field contains
	// resource attributes like resource type and resource name.
	//
	// To get the whole view of the attributes used in IAM
	// condition evaluation, the user must also look into
	// `AuditLog.request_metadata.request_attributes`.
	ResourceAttributes *attribute_context.AttributeContext_Resource `protobuf:"bytes,5,opt,name=resource_attributes,json=resourceAttributes,proto3" json:"resource_attributes,omitempty"`
}

func (x *AuthorizationInfo) Reset() {
	*x = AuthorizationInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_audit_log_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AuthorizationInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AuthorizationInfo) ProtoMessage() {}

func (x *AuthorizationInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_audit_log_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AuthorizationInfo.ProtoReflect.Descriptor instead.
func (*AuthorizationInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_audit_log_proto_rawDescGZIP(), []int{2}
}

func (x *AuthorizationInfo) GetResource() string {
	if x != nil {
		return x.Resource
	}
	return ""
}

func (x *AuthorizationInfo) GetPermission() string {
	if x != nil {
		return x.Permission
	}
	return ""
}

func (x *AuthorizationInfo) GetGranted() bool {
	if x != nil {
		return x.Granted
	}
	return false
}

func (x *AuthorizationInfo) GetResourceAttributes() *attribute_context.AttributeContext_Resource {
	if x != nil {
		return x.ResourceAttributes
	}
	return nil
}

// Metadata about the request.
type RequestMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The IP address of the caller.
	// For caller from internet, this will be public IPv4 or IPv6 address.
	// For caller from a Compute Engine VM with external IP address, this
	// will be the VM's external IP address. For caller from a Compute
	// Engine VM without external IP address, if the VM is in the same
	// organization (or project) as the accessed resource, `caller_ip` will
	// be the VM's internal IPv4 address, otherwise the `caller_ip` will be
	// redacted to "gce-internal-ip".
	// See https://cloud.google.com/compute/docs/vpc/ for more information.
	CallerIp string `protobuf:"bytes,1,opt,name=caller_ip,json=callerIp,proto3" json:"caller_ip,omitempty"`
	// The user agent of the caller.
	// This information is not authenticated and should be treated accordingly.
	// For example:
	//
	// +   `google-api-python-client/1.4.0`:
	//     The request was made by the Google API client for Python.
	// +   `Cloud SDK Command Line Tool apitools-client/1.0 gcloud/0.9.62`:
	//     The request was made by the Google Cloud SDK CLI (gcloud).
	// +   `AppEngine-Google; (+http://code.google.com/appengine; appid:
	// s~my-project`:
	//     The request was made from the `my-project` App Engine app.
	CallerSuppliedUserAgent string `protobuf:"bytes,2,opt,name=caller_supplied_user_agent,json=callerSuppliedUserAgent,proto3" json:"caller_supplied_user_agent,omitempty"`
	// The network of the caller.
	// Set only if the network host project is part of the same GCP organization
	// (or project) as the accessed resource.
	// See https://cloud.google.com/compute/docs/vpc/ for more information.
	// This is a scheme-less URI full resource name. For example:
	//
	//     "//compute.googleapis.com/projects/PROJECT_ID/global/networks/NETWORK_ID"
	CallerNetwork string `protobuf:"bytes,3,opt,name=caller_network,json=callerNetwork,proto3" json:"caller_network,omitempty"`
	// Request attributes used in IAM condition evaluation. This field contains
	// request attributes like request time and access levels associated with
	// the request.
	//
	//
	// To get the whole view of the attributes used in IAM
	// condition evaluation, the user must also look into
	// `AuditLog.authentication_info.resource_attributes`.
	RequestAttributes *attribute_context.AttributeContext_Request `protobuf:"bytes,7,opt,name=request_attributes,json=requestAttributes,proto3" json:"request_attributes,omitempty"`
	// The destination of a network activity, such as accepting a TCP connection.
	// In a multi hop network activity, the destination represents the receiver of
	// the last hop. Only two fields are used in this message, Peer.port and
	// Peer.ip. These fields are optionally populated by those services utilizing
	// the IAM condition feature.
	DestinationAttributes *attribute_context.AttributeContext_Peer `protobuf:"bytes,8,opt,name=destination_attributes,json=destinationAttributes,proto3" json:"destination_attributes,omitempty"`
}

func (x *RequestMetadata) Reset() {
	*x = RequestMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_audit_log_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RequestMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RequestMetadata) ProtoMessage() {}

func (x *RequestMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_audit_log_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RequestMetadata.ProtoReflect.Descriptor instead.
func (*RequestMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_audit_log_proto_rawDescGZIP(), []int{3}
}

func (x *RequestMetadata) GetCallerIp() string {
	if x != nil {
		return x.CallerIp
	}
	return ""
}

func (x *RequestMetadata) GetCallerSuppliedUserAgent() string {
	if x != nil {
		return x.CallerSuppliedUserAgent
	}
	return ""
}

func (x *RequestMetadata) GetCallerNetwork() string {
	if x != nil {
		return x.CallerNetwork
	}
	return ""
}

func (x *RequestMetadata) GetRequestAttributes() *attribute_context.AttributeContext_Request {
	if x != nil {
		return x.RequestAttributes
	}
	return nil
}

func (x *RequestMetadata) GetDestinationAttributes() *attribute_context.AttributeContext_Peer {
	if x != nil {
		return x.DestinationAttributes
	}
	return nil
}

// Location information about a resource.
type ResourceLocation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The locations of a resource after the execution of the operation.
	// Requests to create or delete a location based resource must populate
	// the 'current_locations' field and not the 'original_locations' field.
	// For example:
	//
	//     "europe-west1-a"
	//     "us-east1"
	//     "nam3"
	CurrentLocations []string `protobuf:"bytes,1,rep,name=current_locations,json=currentLocations,proto3" json:"current_locations,omitempty"`
	// The locations of a resource prior to the execution of the operation.
	// Requests that mutate the resource's location must populate both the
	// 'original_locations' as well as the 'current_locations' fields.
	// For example:
	//
	//     "europe-west1-a"
	//     "us-east1"
	//     "nam3"
	OriginalLocations []string `protobuf:"bytes,2,rep,name=original_locations,json=originalLocations,proto3" json:"original_locations,omitempty"`
}

func (x *ResourceLocation) Reset() {
	*x = ResourceLocation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_audit_log_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResourceLocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResourceLocation) ProtoMessage() {}

func (x *ResourceLocation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_audit_log_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResourceLocation.ProtoReflect.Descriptor instead.
func (*ResourceLocation) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_audit_log_proto_rawDescGZIP(), []int{4}
}

func (x *ResourceLocation) GetCurrentLocations() []string {
	if x != nil {
		return x.CurrentLocations
	}
	return nil
}

func (x *ResourceLocation) GetOriginalLocations() []string {
	if x != nil {
		return x.OriginalLocations
	}
	return nil
}

// Identity delegation history of an authenticated service account.
type ServiceAccountDelegationInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Entity that creates credentials for service account and assumes its
	// identity for authentication.
	//
	// Types that are assignable to Authority:
	//	*ServiceAccountDelegationInfo_FirstPartyPrincipal_
	//	*ServiceAccountDelegationInfo_ThirdPartyPrincipal_
	Authority isServiceAccountDelegationInfo_Authority `protobuf_oneof:"Authority"`
}

func (x *ServiceAccountDelegationInfo) Reset() {
	*x = ServiceAccountDelegationInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_audit_log_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServiceAccountDelegationInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceAccountDelegationInfo) ProtoMessage() {}

func (x *ServiceAccountDelegationInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_audit_log_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceAccountDelegationInfo.ProtoReflect.Descriptor instead.
func (*ServiceAccountDelegationInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_audit_log_proto_rawDescGZIP(), []int{5}
}

func (m *ServiceAccountDelegationInfo) GetAuthority() isServiceAccountDelegationInfo_Authority {
	if m != nil {
		return m.Authority
	}
	return nil
}

func (x *ServiceAccountDelegationInfo) GetFirstPartyPrincipal() *ServiceAccountDelegationInfo_FirstPartyPrincipal {
	if x, ok := x.GetAuthority().(*ServiceAccountDelegationInfo_FirstPartyPrincipal_); ok {
		return x.FirstPartyPrincipal
	}
	return nil
}

func (x *ServiceAccountDelegationInfo) GetThirdPartyPrincipal() *ServiceAccountDelegationInfo_ThirdPartyPrincipal {
	if x, ok := x.GetAuthority().(*ServiceAccountDelegationInfo_ThirdPartyPrincipal_); ok {
		return x.ThirdPartyPrincipal
	}
	return nil
}

type isServiceAccountDelegationInfo_Authority interface {
	isServiceAccountDelegationInfo_Authority()
}

type ServiceAccountDelegationInfo_FirstPartyPrincipal_ struct {
	// First party (Google) identity as the real authority.
	FirstPartyPrincipal *ServiceAccountDelegationInfo_FirstPartyPrincipal `protobuf:"bytes,1,opt,name=first_party_principal,json=firstPartyPrincipal,proto3,oneof"`
}

type ServiceAccountDelegationInfo_ThirdPartyPrincipal_ struct {
	// Third party identity as the real authority.
	ThirdPartyPrincipal *ServiceAccountDelegationInfo_ThirdPartyPrincipal `protobuf:"bytes,2,opt,name=third_party_principal,json=thirdPartyPrincipal,proto3,oneof"`
}

func (*ServiceAccountDelegationInfo_FirstPartyPrincipal_) isServiceAccountDelegationInfo_Authority() {}

func (*ServiceAccountDelegationInfo_ThirdPartyPrincipal_) isServiceAccountDelegationInfo_Authority() {}

// First party identity principal.
type ServiceAccountDelegationInfo_FirstPartyPrincipal struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The email address of a Google account.
	PrincipalEmail string `protobuf:"bytes,1,opt,name=principal_email,json=principalEmail,proto3" json:"principal_email,omitempty"`
	// Metadata about the service that uses the service account.
	ServiceMetadata *_struct.Struct `protobuf:"bytes,2,opt,name=service_metadata,json=serviceMetadata,proto3" json:"service_metadata,omitempty"`
}

func (x *ServiceAccountDelegationInfo_FirstPartyPrincipal) Reset() {
	*x = ServiceAccountDelegationInfo_FirstPartyPrincipal{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_audit_log_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServiceAccountDelegationInfo_FirstPartyPrincipal) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceAccountDelegationInfo_FirstPartyPrincipal) ProtoMessage() {}

func (x *ServiceAccountDelegationInfo_FirstPartyPrincipal) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_audit_log_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceAccountDelegationInfo_FirstPartyPrincipal.ProtoReflect.Descriptor instead.
func (*ServiceAccountDelegationInfo_FirstPartyPrincipal) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_audit_log_proto_rawDescGZIP(), []int{5, 0}
}

func (x *ServiceAccountDelegationInfo_FirstPartyPrincipal) GetPrincipalEmail() string {
	if x != nil {
		return x.PrincipalEmail
	}
	return ""
}

func (x *ServiceAccountDelegationInfo_FirstPartyPrincipal) GetServiceMetadata() *_struct.Struct {
	if x != nil {
		return x.ServiceMetadata
	}
	return nil
}

// Third party identity principal.
type ServiceAccountDelegationInfo_ThirdPartyPrincipal struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Metadata about third party identity.
	ThirdPartyClaims *_struct.Struct `protobuf:"bytes,1,opt,name=third_party_claims,json=thirdPartyClaims,proto3" json:"third_party_claims,omitempty"`
}

func (x *ServiceAccountDelegationInfo_ThirdPartyPrincipal) Reset() {
	*x = ServiceAccountDelegationInfo_ThirdPartyPrincipal{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_audit_audit_log_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServiceAccountDelegationInfo_ThirdPartyPrincipal) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceAccountDelegationInfo_ThirdPartyPrincipal) ProtoMessage() {}

func (x *ServiceAccountDelegationInfo_ThirdPartyPrincipal) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_audit_audit_log_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceAccountDelegationInfo_ThirdPartyPrincipal.ProtoReflect.Descriptor instead.
func (*ServiceAccountDelegationInfo_ThirdPartyPrincipal) Descriptor() ([]byte, []int) {
	return file_google_cloud_audit_audit_log_proto_rawDescGZIP(), []int{5, 1}
}

func (x *ServiceAccountDelegationInfo_ThirdPartyPrincipal) GetThirdPartyClaims() *_struct.Struct {
	if x != nil {
		return x.ThirdPartyClaims
	}
	return nil
}

var File_google_cloud_audit_audit_log_proto protoreflect.FileDescriptor

var file_google_cloud_audit_audit_log_proto_rawDesc = []byte{
	0x0a, 0x22, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x75, 0x64, 0x69, 0x74, 0x2f, 0x61, 0x75, 0x64, 0x69, 0x74, 0x5f, 0x6c, 0x6f, 0x67, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x12, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x61, 0x6e, 0x79, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x2f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x5f,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc6, 0x06, 0x0a, 0x08, 0x41, 0x75, 0x64, 0x69, 0x74,
	0x4c, 0x6f, 0x67, 0x12, 0x21, 0x0a, 0x0c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6d, 0x65, 0x74,
	0x68, 0x6f, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x51, 0x0a, 0x11,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x4f, 0x0a, 0x17, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6f, 0x72, 0x69, 0x67,
	0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x15, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x4f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x2c, 0x0a, 0x12, 0x6e, 0x75, 0x6d, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x5f, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x03, 0x52, 0x10, 0x6e, 0x75,
	0x6d, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x49, 0x74, 0x65, 0x6d, 0x73, 0x12, 0x2a,
	0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x57, 0x0a, 0x13, 0x61, 0x75,
	0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x66,
	0x6f, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x41, 0x75, 0x74,
	0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x52,
	0x12, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49,
	0x6e, 0x66, 0x6f, 0x12, 0x54, 0x0a, 0x12, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x75, 0x64, 0x69, 0x74, 0x2e, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x11, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x4e, 0x0a, 0x10, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x31, 0x0a, 0x07, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x52, 0x07, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x33, 0x0a, 0x08,
	0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x08, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x33, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x12, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x08, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x37, 0x0a, 0x0c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x41,
	0x6e, 0x79, 0x52, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x44, 0x61, 0x74, 0x61, 0x22,
	0x98, 0x03, 0x0a, 0x12, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x27, 0x0a, 0x0f, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69,
	0x70, 0x61, 0x6c, 0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0e, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x12,
	0x2d, 0x0a, 0x12, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x73, 0x65, 0x6c,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x61, 0x75, 0x74,
	0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x4b,
	0x0a, 0x15, 0x74, 0x68, 0x69, 0x72, 0x64, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x79, 0x5f, 0x70, 0x72,
	0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x13, 0x74, 0x68, 0x69, 0x72, 0x64, 0x50, 0x61, 0x72,
	0x74, 0x79, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x12, 0x37, 0x0a, 0x18, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x6b,
	0x65, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x15, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4b, 0x65, 0x79,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x77, 0x0a, 0x1f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f,
	0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x67, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64,
	0x69, 0x74, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x44, 0x65, 0x6c, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x52,
	0x1c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x44,
	0x65, 0x6c, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x2b, 0x0a,
	0x11, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x5f, 0x73, 0x75, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69,
	0x70, 0x61, 0x6c, 0x53, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x22, 0xc9, 0x01, 0x0a, 0x11, 0x41,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f,
	0x12, 0x1a, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x1e, 0x0a, 0x0a,
	0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07,
	0x67, 0x72, 0x61, 0x6e, 0x74, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x67,
	0x72, 0x61, 0x6e, 0x74, 0x65, 0x64, 0x12, 0x5e, 0x0a, 0x13, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x2e, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x52, 0x12, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x41, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x22, 0xd1, 0x02, 0x0a, 0x0f, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x1b, 0x0a, 0x09, 0x63, 0x61,
	0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x69, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x63,
	0x61, 0x6c, 0x6c, 0x65, 0x72, 0x49, 0x70, 0x12, 0x3b, 0x0a, 0x1a, 0x63, 0x61, 0x6c, 0x6c, 0x65,
	0x72, 0x5f, 0x73, 0x75, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x17, 0x63, 0x61, 0x6c,
	0x6c, 0x65, 0x72, 0x53, 0x75, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x55, 0x73, 0x65, 0x72, 0x41,
	0x67, 0x65, 0x6e, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x61,
	0x6c, 0x6c, 0x65, 0x72, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x5b, 0x0a, 0x12, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
	0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x72, 0x70, 0x63, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x2e, 0x41, 0x74, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x2e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x52, 0x11, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x41, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x12, 0x60, 0x0a, 0x16, 0x64, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
	0x65, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x2e, 0x41, 0x74,
	0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x2e, 0x50,
	0x65, 0x65, 0x72, 0x52, 0x15, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73, 0x22, 0x6e, 0x0a, 0x10, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2b,
	0x0a, 0x11, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x63, 0x75, 0x72, 0x72, 0x65,
	0x6e, 0x74, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2d, 0x0a, 0x12, 0x6f,
	0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x11, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61,
	0x6c, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x86, 0x04, 0x0a, 0x1c, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x44, 0x65, 0x6c,
	0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x7a, 0x0a, 0x15, 0x66,
	0x69, 0x72, 0x73, 0x74, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x79, 0x5f, 0x70, 0x72, 0x69, 0x6e, 0x63,
	0x69, 0x70, 0x61, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x44, 0x65,
	0x6c, 0x65, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x46, 0x69, 0x72,
	0x73, 0x74, 0x50, 0x61, 0x72, 0x74, 0x79, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c,
	0x48, 0x00, 0x52, 0x13, 0x66, 0x69, 0x72, 0x73, 0x74, 0x50, 0x61, 0x72, 0x74, 0x79, 0x50, 0x72,
	0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x12, 0x7a, 0x0a, 0x15, 0x74, 0x68, 0x69, 0x72, 0x64,
	0x5f, 0x70, 0x61, 0x72, 0x74, 0x79, 0x5f, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x2e, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x44, 0x65, 0x6c, 0x65, 0x67, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x54, 0x68, 0x69, 0x72, 0x64, 0x50, 0x61,
	0x72, 0x74, 0x79, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x48, 0x00, 0x52, 0x13,
	0x74, 0x68, 0x69, 0x72, 0x64, 0x50, 0x61, 0x72, 0x74, 0x79, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69,
	0x70, 0x61, 0x6c, 0x1a, 0x82, 0x01, 0x0a, 0x13, 0x46, 0x69, 0x72, 0x73, 0x74, 0x50, 0x61, 0x72,
	0x74, 0x79, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x12, 0x27, 0x0a, 0x0f, 0x70,
	0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x45,
	0x6d, 0x61, 0x69, 0x6c, 0x12, 0x42, 0x0a, 0x10, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x1a, 0x5c, 0x0a, 0x13, 0x54, 0x68, 0x69, 0x72,
	0x64, 0x50, 0x61, 0x72, 0x74, 0x79, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x12,
	0x45, 0x0a, 0x12, 0x74, 0x68, 0x69, 0x72, 0x64, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x79, 0x5f, 0x63,
	0x6c, 0x61, 0x69, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x52, 0x10, 0x74, 0x68, 0x69, 0x72, 0x64, 0x50, 0x61, 0x72, 0x74, 0x79,
	0x43, 0x6c, 0x61, 0x69, 0x6d, 0x73, 0x42, 0x0b, 0x0a, 0x09, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72,
	0x69, 0x74, 0x79, 0x42, 0x65, 0x0a, 0x16, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x64, 0x69, 0x74, 0x42, 0x0d, 0x41,
	0x75, 0x64, 0x69, 0x74, 0x4c, 0x6f, 0x67, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x37,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72,
	0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x75, 0x64, 0x69,
	0x74, 0x3b, 0x61, 0x75, 0x64, 0x69, 0x74, 0xf8, 0x01, 0x01, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_cloud_audit_audit_log_proto_rawDescOnce sync.Once
	file_google_cloud_audit_audit_log_proto_rawDescData = file_google_cloud_audit_audit_log_proto_rawDesc
)

func file_google_cloud_audit_audit_log_proto_rawDescGZIP() []byte {
	file_google_cloud_audit_audit_log_proto_rawDescOnce.Do(func() {
		file_google_cloud_audit_audit_log_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_audit_audit_log_proto_rawDescData)
	})
	return file_google_cloud_audit_audit_log_proto_rawDescData
}

var file_google_cloud_audit_audit_log_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_google_cloud_audit_audit_log_proto_goTypes = []interface{}{
	(*AuditLog)(nil),                                         // 0: google.cloud.audit.AuditLog
	(*AuthenticationInfo)(nil),                               // 1: google.cloud.audit.AuthenticationInfo
	(*AuthorizationInfo)(nil),                                // 2: google.cloud.audit.AuthorizationInfo
	(*RequestMetadata)(nil),                                  // 3: google.cloud.audit.RequestMetadata
	(*ResourceLocation)(nil),                                 // 4: google.cloud.audit.ResourceLocation
	(*ServiceAccountDelegationInfo)(nil),                     // 5: google.cloud.audit.ServiceAccountDelegationInfo
	(*ServiceAccountDelegationInfo_FirstPartyPrincipal)(nil), // 6: google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal
	(*ServiceAccountDelegationInfo_ThirdPartyPrincipal)(nil), // 7: google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal
	(*_struct.Struct)(nil),                                   // 8: google.protobuf.Struct
	(*status.Status)(nil),                                    // 9: google.rpc.Status
	(*any.Any)(nil),                                          // 10: google.protobuf.Any
	(*attribute_context.AttributeContext_Resource)(nil),      // 11: google.rpc.context.AttributeContext.Resource
	(*attribute_context.AttributeContext_Request)(nil),       // 12: google.rpc.context.AttributeContext.Request
	(*attribute_context.AttributeContext_Peer)(nil),          // 13: google.rpc.context.AttributeContext.Peer
}
var file_google_cloud_audit_audit_log_proto_depIdxs = []int32{
	4,  // 0: google.cloud.audit.AuditLog.resource_location:type_name -> google.cloud.audit.ResourceLocation
	8,  // 1: google.cloud.audit.AuditLog.resource_original_state:type_name -> google.protobuf.Struct
	9,  // 2: google.cloud.audit.AuditLog.status:type_name -> google.rpc.Status
	1,  // 3: google.cloud.audit.AuditLog.authentication_info:type_name -> google.cloud.audit.AuthenticationInfo
	2,  // 4: google.cloud.audit.AuditLog.authorization_info:type_name -> google.cloud.audit.AuthorizationInfo
	3,  // 5: google.cloud.audit.AuditLog.request_metadata:type_name -> google.cloud.audit.RequestMetadata
	8,  // 6: google.cloud.audit.AuditLog.request:type_name -> google.protobuf.Struct
	8,  // 7: google.cloud.audit.AuditLog.response:type_name -> google.protobuf.Struct
	8,  // 8: google.cloud.audit.AuditLog.metadata:type_name -> google.protobuf.Struct
	10, // 9: google.cloud.audit.AuditLog.service_data:type_name -> google.protobuf.Any
	8,  // 10: google.cloud.audit.AuthenticationInfo.third_party_principal:type_name -> google.protobuf.Struct
	5,  // 11: google.cloud.audit.AuthenticationInfo.service_account_delegation_info:type_name -> google.cloud.audit.ServiceAccountDelegationInfo
	11, // 12: google.cloud.audit.AuthorizationInfo.resource_attributes:type_name -> google.rpc.context.AttributeContext.Resource
	12, // 13: google.cloud.audit.RequestMetadata.request_attributes:type_name -> google.rpc.context.AttributeContext.Request
	13, // 14: google.cloud.audit.RequestMetadata.destination_attributes:type_name -> google.rpc.context.AttributeContext.Peer
	6,  // 15: google.cloud.audit.ServiceAccountDelegationInfo.first_party_principal:type_name -> google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal
	7,  // 16: google.cloud.audit.ServiceAccountDelegationInfo.third_party_principal:type_name -> google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal
	8,  // 17: google.cloud.audit.ServiceAccountDelegationInfo.FirstPartyPrincipal.service_metadata:type_name -> google.protobuf.Struct
	8,  // 18: google.cloud.audit.ServiceAccountDelegationInfo.ThirdPartyPrincipal.third_party_claims:type_name -> google.protobuf.Struct
	19, // [19:19] is the sub-list for method output_type
	19, // [19:19] is the sub-list for method input_type
	19, // [19:19] is the sub-list for extension type_name
	19, // [19:19] is the sub-list for extension extendee
	0,  // [0:19] is the sub-list for field type_name
}

func init() { file_google_cloud_audit_audit_log_proto_init() }
func file_google_cloud_audit_audit_log_proto_init() {
	if File_google_cloud_audit_audit_log_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_audit_audit_log_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AuditLog); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_audit_log_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AuthenticationInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_audit_log_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AuthorizationInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_audit_log_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RequestMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_audit_log_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResourceLocation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_audit_log_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServiceAccountDelegationInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_audit_log_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServiceAccountDelegationInfo_FirstPartyPrincipal); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_audit_audit_log_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ServiceAccountDelegationInfo_ThirdPartyPrincipal); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_audit_audit_log_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*ServiceAccountDelegationInfo_FirstPartyPrincipal_)(nil),
		(*ServiceAccountDelegationInfo_ThirdPartyPrincipal_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_audit_audit_log_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_audit_audit_log_proto_goTypes,
		DependencyIndexes: file_google_cloud_audit_audit_log_proto_depIdxs,
		MessageInfos:      file_google_cloud_audit_audit_log_proto_msgTypes,
	}.Build()
	File_google_cloud_audit_audit_log_proto = out.File
	file_google_cloud_audit_audit_log_proto_rawDesc = nil
	file_google_cloud_audit_audit_log_proto_goTypes = nil
	file_google_cloud_audit_audit_log_proto_depIdxs = nil
}
