// Copyright 2019 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.12.3
// source: google/cloud/datalabeling/v1beta1/evaluation.proto

package datalabeling

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Describes an evaluation between a machine learning model's predictions and
// ground truth labels. Created when an [EvaluationJob][google.cloud.datalabeling.v1beta1.EvaluationJob] runs successfully.
type Evaluation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Resource name of an evaluation. The name has the following
	// format:
	//
	// "projects/<var>{project_id}</var>/datasets/<var>{dataset_id}</var>/evaluations/<var>{evaluation_id</var>}'
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Options used in the evaluation job that created this
	// evaluation.
	Config *EvaluationConfig `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
	// Output only. Timestamp for when the evaluation job that created this
	// evaluation ran.
	EvaluationJobRunTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=evaluation_job_run_time,json=evaluationJobRunTime,proto3" json:"evaluation_job_run_time,omitempty"`
	// Output only. Timestamp for when this evaluation was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Metrics comparing predictions to ground truth labels.
	EvaluationMetrics *EvaluationMetrics `protobuf:"bytes,5,opt,name=evaluation_metrics,json=evaluationMetrics,proto3" json:"evaluation_metrics,omitempty"`
	// Output only. Type of task that the model version being evaluated performs,
	// as defined in the
	//
	// [evaluationJobConfig.inputConfig.annotationType][google.cloud.datalabeling.v1beta1.EvaluationJobConfig.input_config]
	// field of the evaluation job that created this evaluation.
	AnnotationType AnnotationType `protobuf:"varint,6,opt,name=annotation_type,json=annotationType,proto3,enum=google.cloud.datalabeling.v1beta1.AnnotationType" json:"annotation_type,omitempty"`
	// Output only. The number of items in the ground truth dataset that were used
	// for this evaluation. Only populated when the evaulation is for certain
	// AnnotationTypes.
	EvaluatedItemCount int64 `protobuf:"varint,7,opt,name=evaluated_item_count,json=evaluatedItemCount,proto3" json:"evaluated_item_count,omitempty"`
}

func (x *Evaluation) Reset() {
	*x = Evaluation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_evaluation_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Evaluation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Evaluation) ProtoMessage() {}

func (x *Evaluation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_evaluation_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Evaluation.ProtoReflect.Descriptor instead.
func (*Evaluation) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_evaluation_proto_rawDescGZIP(), []int{0}
}

func (x *Evaluation) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Evaluation) GetConfig() *EvaluationConfig {
	if x != nil {
		return x.Config
	}
	return nil
}

func (x *Evaluation) GetEvaluationJobRunTime() *timestamp.Timestamp {
	if x != nil {
		return x.EvaluationJobRunTime
	}
	return nil
}

func (x *Evaluation) GetCreateTime() *timestamp.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Evaluation) GetEvaluationMetrics() *EvaluationMetrics {
	if x != nil {
		return x.EvaluationMetrics
	}
	return nil
}

func (x *Evaluation) GetAnnotationType() AnnotationType {
	if x != nil {
		return x.AnnotationType
	}
	return AnnotationType_ANNOTATION_TYPE_UNSPECIFIED
}

func (x *Evaluation) GetEvaluatedItemCount() int64 {
	if x != nil {
		return x.EvaluatedItemCount
	}
	return 0
}

// Configuration details used for calculating evaluation metrics and creating an
// [Evaluation][google.cloud.datalabeling.v1beta1.Evaluation].
type EvaluationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Vertical specific options for general metrics.
	//
	// Types that are assignable to VerticalOption:
	//	*EvaluationConfig_BoundingBoxEvaluationOptions
	VerticalOption isEvaluationConfig_VerticalOption `protobuf_oneof:"vertical_option"`
}

func (x *EvaluationConfig) Reset() {
	*x = EvaluationConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_evaluation_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EvaluationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EvaluationConfig) ProtoMessage() {}

func (x *EvaluationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_evaluation_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EvaluationConfig.ProtoReflect.Descriptor instead.
func (*EvaluationConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_evaluation_proto_rawDescGZIP(), []int{1}
}

func (m *EvaluationConfig) GetVerticalOption() isEvaluationConfig_VerticalOption {
	if m != nil {
		return m.VerticalOption
	}
	return nil
}

func (x *EvaluationConfig) GetBoundingBoxEvaluationOptions() *BoundingBoxEvaluationOptions {
	if x, ok := x.GetVerticalOption().(*EvaluationConfig_BoundingBoxEvaluationOptions); ok {
		return x.BoundingBoxEvaluationOptions
	}
	return nil
}

type isEvaluationConfig_VerticalOption interface {
	isEvaluationConfig_VerticalOption()
}

type EvaluationConfig_BoundingBoxEvaluationOptions struct {
	// Only specify this field if the related model performs image object
	// detection (`IMAGE_BOUNDING_BOX_ANNOTATION`). Describes how to evaluate
	// bounding boxes.
	BoundingBoxEvaluationOptions *BoundingBoxEvaluationOptions `protobuf:"bytes,1,opt,name=bounding_box_evaluation_options,json=boundingBoxEvaluationOptions,proto3,oneof"`
}

func (*EvaluationConfig_BoundingBoxEvaluationOptions) isEvaluationConfig_VerticalOption() {}

// Options regarding evaluation between bounding boxes.
type BoundingBoxEvaluationOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Minimum
	// [intersection-over-union
	//
	// (IOU)](/vision/automl/object-detection/docs/evaluate#intersection-over-union)
	// required for 2 bounding boxes to be considered a match. This must be a
	// number between 0 and 1.
	IouThreshold float32 `protobuf:"fixed32,1,opt,name=iou_threshold,json=iouThreshold,proto3" json:"iou_threshold,omitempty"`
}

func (x *BoundingBoxEvaluationOptions) Reset() {
	*x = BoundingBoxEvaluationOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_evaluation_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BoundingBoxEvaluationOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BoundingBoxEvaluationOptions) ProtoMessage() {}

func (x *BoundingBoxEvaluationOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_evaluation_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BoundingBoxEvaluationOptions.ProtoReflect.Descriptor instead.
func (*BoundingBoxEvaluationOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_evaluation_proto_rawDescGZIP(), []int{2}
}

func (x *BoundingBoxEvaluationOptions) GetIouThreshold() float32 {
	if x != nil {
		return x.IouThreshold
	}
	return 0
}

type EvaluationMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Common metrics covering most general cases.
	//
	// Types that are assignable to Metrics:
	//	*EvaluationMetrics_ClassificationMetrics
	//	*EvaluationMetrics_ObjectDetectionMetrics
	Metrics isEvaluationMetrics_Metrics `protobuf_oneof:"metrics"`
}

func (x *EvaluationMetrics) Reset() {
	*x = EvaluationMetrics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_evaluation_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EvaluationMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EvaluationMetrics) ProtoMessage() {}

func (x *EvaluationMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_evaluation_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EvaluationMetrics.ProtoReflect.Descriptor instead.
func (*EvaluationMetrics) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_evaluation_proto_rawDescGZIP(), []int{3}
}

func (m *EvaluationMetrics) GetMetrics() isEvaluationMetrics_Metrics {
	if m != nil {
		return m.Metrics
	}
	return nil
}

func (x *EvaluationMetrics) GetClassificationMetrics() *ClassificationMetrics {
	if x, ok := x.GetMetrics().(*EvaluationMetrics_ClassificationMetrics); ok {
		return x.ClassificationMetrics
	}
	return nil
}

func (x *EvaluationMetrics) GetObjectDetectionMetrics() *ObjectDetectionMetrics {
	if x, ok := x.GetMetrics().(*EvaluationMetrics_ObjectDetectionMetrics); ok {
		return x.ObjectDetectionMetrics
	}
	return nil
}

type isEvaluationMetrics_Metrics interface {
	isEvaluationMetrics_Metrics()
}

type EvaluationMetrics_ClassificationMetrics struct {
	ClassificationMetrics *ClassificationMetrics `protobuf:"bytes,1,opt,name=classification_metrics,json=classificationMetrics,proto3,oneof"`
}

type EvaluationMetrics_ObjectDetectionMetrics struct {
	ObjectDetectionMetrics *ObjectDetectionMetrics `protobuf:"bytes,2,opt,name=object_detection_metrics,json=objectDetectionMetrics,proto3,oneof"`
}

func (*EvaluationMetrics_ClassificationMetrics) isEvaluationMetrics_Metrics() {}

func (*EvaluationMetrics_ObjectDetectionMetrics) isEvaluationMetrics_Metrics() {}

// Metrics calculated for a classification model.
type ClassificationMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Precision-recall curve based on ground truth labels, predicted labels, and
	// scores for the predicted labels.
	PrCurve *PrCurve `protobuf:"bytes,1,opt,name=pr_curve,json=prCurve,proto3" json:"pr_curve,omitempty"`
	// Confusion matrix of predicted labels vs. ground truth labels.
	ConfusionMatrix *ConfusionMatrix `protobuf:"bytes,2,opt,name=confusion_matrix,json=confusionMatrix,proto3" json:"confusion_matrix,omitempty"`
}

func (x *ClassificationMetrics) Reset() {
	*x = ClassificationMetrics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_evaluation_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ClassificationMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ClassificationMetrics) ProtoMessage() {}

func (x *ClassificationMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_evaluation_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ClassificationMetrics.ProtoReflect.Descriptor instead.
func (*ClassificationMetrics) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_evaluation_proto_rawDescGZIP(), []int{4}
}

func (x *ClassificationMetrics) GetPrCurve() *PrCurve {
	if x != nil {
		return x.PrCurve
	}
	return nil
}

func (x *ClassificationMetrics) GetConfusionMatrix() *ConfusionMatrix {
	if x != nil {
		return x.ConfusionMatrix
	}
	return nil
}

// Metrics calculated for an image object detection (bounding box) model.
type ObjectDetectionMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Precision-recall curve.
	PrCurve *PrCurve `protobuf:"bytes,1,opt,name=pr_curve,json=prCurve,proto3" json:"pr_curve,omitempty"`
}

func (x *ObjectDetectionMetrics) Reset() {
	*x = ObjectDetectionMetrics{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_evaluation_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ObjectDetectionMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ObjectDetectionMetrics) ProtoMessage() {}

func (x *ObjectDetectionMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_evaluation_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ObjectDetectionMetrics.ProtoReflect.Descriptor instead.
func (*ObjectDetectionMetrics) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_evaluation_proto_rawDescGZIP(), []int{5}
}

func (x *ObjectDetectionMetrics) GetPrCurve() *PrCurve {
	if x != nil {
		return x.PrCurve
	}
	return nil
}

type PrCurve struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The annotation spec of the label for which the precision-recall curve
	// calculated. If this field is empty, that means the precision-recall curve
	// is an aggregate curve for all labels.
	AnnotationSpec *AnnotationSpec `protobuf:"bytes,1,opt,name=annotation_spec,json=annotationSpec,proto3" json:"annotation_spec,omitempty"`
	// Area under the precision-recall curve. Not to be confused with area under
	// a receiver operating characteristic (ROC) curve.
	AreaUnderCurve float32 `protobuf:"fixed32,2,opt,name=area_under_curve,json=areaUnderCurve,proto3" json:"area_under_curve,omitempty"`
	// Entries that make up the precision-recall graph. Each entry is a "point" on
	// the graph drawn for a different `confidence_threshold`.
	ConfidenceMetricsEntries []*PrCurve_ConfidenceMetricsEntry `protobuf:"bytes,3,rep,name=confidence_metrics_entries,json=confidenceMetricsEntries,proto3" json:"confidence_metrics_entries,omitempty"`
	// Mean average prcision of this curve.
	MeanAveragePrecision float32 `protobuf:"fixed32,4,opt,name=mean_average_precision,json=meanAveragePrecision,proto3" json:"mean_average_precision,omitempty"`
}

func (x *PrCurve) Reset() {
	*x = PrCurve{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_evaluation_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrCurve) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrCurve) ProtoMessage() {}

func (x *PrCurve) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_evaluation_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrCurve.ProtoReflect.Descriptor instead.
func (*PrCurve) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_evaluation_proto_rawDescGZIP(), []int{6}
}

func (x *PrCurve) GetAnnotationSpec() *AnnotationSpec {
	if x != nil {
		return x.AnnotationSpec
	}
	return nil
}

func (x *PrCurve) GetAreaUnderCurve() float32 {
	if x != nil {
		return x.AreaUnderCurve
	}
	return 0
}

func (x *PrCurve) GetConfidenceMetricsEntries() []*PrCurve_ConfidenceMetricsEntry {
	if x != nil {
		return x.ConfidenceMetricsEntries
	}
	return nil
}

func (x *PrCurve) GetMeanAveragePrecision() float32 {
	if x != nil {
		return x.MeanAveragePrecision
	}
	return 0
}

// Confusion matrix of the model running the classification. Only applicable
// when the metrics entry aggregates multiple labels. Not applicable when the
// entry is for a single label.
type ConfusionMatrix struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Row []*ConfusionMatrix_Row `protobuf:"bytes,1,rep,name=row,proto3" json:"row,omitempty"`
}

func (x *ConfusionMatrix) Reset() {
	*x = ConfusionMatrix{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_evaluation_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConfusionMatrix) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfusionMatrix) ProtoMessage() {}

func (x *ConfusionMatrix) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_evaluation_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfusionMatrix.ProtoReflect.Descriptor instead.
func (*ConfusionMatrix) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_evaluation_proto_rawDescGZIP(), []int{7}
}

func (x *ConfusionMatrix) GetRow() []*ConfusionMatrix_Row {
	if x != nil {
		return x.Row
	}
	return nil
}

type PrCurve_ConfidenceMetricsEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Threshold used for this entry.
	//
	// For classification tasks, this is a classification threshold: a
	// predicted label is categorized as positive or negative (in the context of
	// this point on the PR curve) based on whether the label's score meets this
	// threshold.
	//
	// For image object detection (bounding box) tasks, this is the
	// [intersection-over-union
	//
	// (IOU)](/vision/automl/object-detection/docs/evaluate#intersection-over-union)
	// threshold for the context of this point on the PR curve.
	ConfidenceThreshold float32 `protobuf:"fixed32,1,opt,name=confidence_threshold,json=confidenceThreshold,proto3" json:"confidence_threshold,omitempty"`
	// Recall value.
	Recall float32 `protobuf:"fixed32,2,opt,name=recall,proto3" json:"recall,omitempty"`
	// Precision value.
	Precision float32 `protobuf:"fixed32,3,opt,name=precision,proto3" json:"precision,omitempty"`
	// Harmonic mean of recall and precision.
	F1Score float32 `protobuf:"fixed32,4,opt,name=f1_score,json=f1Score,proto3" json:"f1_score,omitempty"`
	// Recall value for entries with label that has highest score.
	RecallAt1 float32 `protobuf:"fixed32,5,opt,name=recall_at1,json=recallAt1,proto3" json:"recall_at1,omitempty"`
	// Precision value for entries with label that has highest score.
	PrecisionAt1 float32 `protobuf:"fixed32,6,opt,name=precision_at1,json=precisionAt1,proto3" json:"precision_at1,omitempty"`
	// The harmonic mean of [recall_at1][google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry.recall_at1] and [precision_at1][google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry.precision_at1].
	F1ScoreAt1 float32 `protobuf:"fixed32,7,opt,name=f1_score_at1,json=f1ScoreAt1,proto3" json:"f1_score_at1,omitempty"`
	// Recall value for entries with label that has highest 5 scores.
	RecallAt5 float32 `protobuf:"fixed32,8,opt,name=recall_at5,json=recallAt5,proto3" json:"recall_at5,omitempty"`
	// Precision value for entries with label that has highest 5 scores.
	PrecisionAt5 float32 `protobuf:"fixed32,9,opt,name=precision_at5,json=precisionAt5,proto3" json:"precision_at5,omitempty"`
	// The harmonic mean of [recall_at5][google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry.recall_at5] and [precision_at5][google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry.precision_at5].
	F1ScoreAt5 float32 `protobuf:"fixed32,10,opt,name=f1_score_at5,json=f1ScoreAt5,proto3" json:"f1_score_at5,omitempty"`
}

func (x *PrCurve_ConfidenceMetricsEntry) Reset() {
	*x = PrCurve_ConfidenceMetricsEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_evaluation_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PrCurve_ConfidenceMetricsEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrCurve_ConfidenceMetricsEntry) ProtoMessage() {}

func (x *PrCurve_ConfidenceMetricsEntry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_evaluation_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrCurve_ConfidenceMetricsEntry.ProtoReflect.Descriptor instead.
func (*PrCurve_ConfidenceMetricsEntry) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_evaluation_proto_rawDescGZIP(), []int{6, 0}
}

func (x *PrCurve_ConfidenceMetricsEntry) GetConfidenceThreshold() float32 {
	if x != nil {
		return x.ConfidenceThreshold
	}
	return 0
}

func (x *PrCurve_ConfidenceMetricsEntry) GetRecall() float32 {
	if x != nil {
		return x.Recall
	}
	return 0
}

func (x *PrCurve_ConfidenceMetricsEntry) GetPrecision() float32 {
	if x != nil {
		return x.Precision
	}
	return 0
}

func (x *PrCurve_ConfidenceMetricsEntry) GetF1Score() float32 {
	if x != nil {
		return x.F1Score
	}
	return 0
}

func (x *PrCurve_ConfidenceMetricsEntry) GetRecallAt1() float32 {
	if x != nil {
		return x.RecallAt1
	}
	return 0
}

func (x *PrCurve_ConfidenceMetricsEntry) GetPrecisionAt1() float32 {
	if x != nil {
		return x.PrecisionAt1
	}
	return 0
}

func (x *PrCurve_ConfidenceMetricsEntry) GetF1ScoreAt1() float32 {
	if x != nil {
		return x.F1ScoreAt1
	}
	return 0
}

func (x *PrCurve_ConfidenceMetricsEntry) GetRecallAt5() float32 {
	if x != nil {
		return x.RecallAt5
	}
	return 0
}

func (x *PrCurve_ConfidenceMetricsEntry) GetPrecisionAt5() float32 {
	if x != nil {
		return x.PrecisionAt5
	}
	return 0
}

func (x *PrCurve_ConfidenceMetricsEntry) GetF1ScoreAt5() float32 {
	if x != nil {
		return x.F1ScoreAt5
	}
	return 0
}

type ConfusionMatrix_ConfusionMatrixEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The annotation spec of a predicted label.
	AnnotationSpec *AnnotationSpec `protobuf:"bytes,1,opt,name=annotation_spec,json=annotationSpec,proto3" json:"annotation_spec,omitempty"`
	// Number of items predicted to have this label. (The ground truth label for
	// these items is the `Row.annotationSpec` of this entry's parent.)
	ItemCount int32 `protobuf:"varint,2,opt,name=item_count,json=itemCount,proto3" json:"item_count,omitempty"`
}

func (x *ConfusionMatrix_ConfusionMatrixEntry) Reset() {
	*x = ConfusionMatrix_ConfusionMatrixEntry{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_evaluation_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConfusionMatrix_ConfusionMatrixEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfusionMatrix_ConfusionMatrixEntry) ProtoMessage() {}

func (x *ConfusionMatrix_ConfusionMatrixEntry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_evaluation_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfusionMatrix_ConfusionMatrixEntry.ProtoReflect.Descriptor instead.
func (*ConfusionMatrix_ConfusionMatrixEntry) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_evaluation_proto_rawDescGZIP(), []int{7, 0}
}

func (x *ConfusionMatrix_ConfusionMatrixEntry) GetAnnotationSpec() *AnnotationSpec {
	if x != nil {
		return x.AnnotationSpec
	}
	return nil
}

func (x *ConfusionMatrix_ConfusionMatrixEntry) GetItemCount() int32 {
	if x != nil {
		return x.ItemCount
	}
	return 0
}

// A row in the confusion matrix. Each entry in this row has the same
// ground truth label.
type ConfusionMatrix_Row struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The annotation spec of the ground truth label for this row.
	AnnotationSpec *AnnotationSpec `protobuf:"bytes,1,opt,name=annotation_spec,json=annotationSpec,proto3" json:"annotation_spec,omitempty"`
	// A list of the confusion matrix entries. One entry for each possible
	// predicted label.
	Entries []*ConfusionMatrix_ConfusionMatrixEntry `protobuf:"bytes,2,rep,name=entries,proto3" json:"entries,omitempty"`
}

func (x *ConfusionMatrix_Row) Reset() {
	*x = ConfusionMatrix_Row{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_datalabeling_v1beta1_evaluation_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ConfusionMatrix_Row) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ConfusionMatrix_Row) ProtoMessage() {}

func (x *ConfusionMatrix_Row) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datalabeling_v1beta1_evaluation_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ConfusionMatrix_Row.ProtoReflect.Descriptor instead.
func (*ConfusionMatrix_Row) Descriptor() ([]byte, []int) {
	return file_google_cloud_datalabeling_v1beta1_evaluation_proto_rawDescGZIP(), []int{7, 1}
}

func (x *ConfusionMatrix_Row) GetAnnotationSpec() *AnnotationSpec {
	if x != nil {
		return x.AnnotationSpec
	}
	return nil
}

func (x *ConfusionMatrix_Row) GetEntries() []*ConfusionMatrix_ConfusionMatrixEntry {
	if x != nil {
		return x.Entries
	}
	return nil
}

var File_google_cloud_datalabeling_v1beta1_evaluation_proto protoreflect.FileDescriptor

var file_google_cloud_datalabeling_v1beta1_evaluation_proto_rawDesc = []byte{
	0x0a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x5f, 0x73, 0x65, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0xdd, 0x04, 0x0a, 0x0a, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x4b, 0x0a, 0x06, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e,
	0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x06, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x51, 0x0a, 0x17, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x72, 0x75, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x14, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x75,
	0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x63, 0x0a, 0x12, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x73, 0x52, 0x11, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x5a, 0x0a, 0x0f, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x0e, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x30, 0x0a, 0x14, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x65, 0x64,
	0x5f, 0x69, 0x74, 0x65, 0x6d, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x12, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x65, 0x64, 0x49, 0x74, 0x65, 0x6d,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x3a, 0x6b, 0xea, 0x41, 0x68, 0x0a, 0x26, 0x64, 0x61, 0x74, 0x61,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x3e, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x73, 0x2f,
	0x7b, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x7d, 0x2f, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x22, 0xb0, 0x01, 0x0a, 0x10, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x88, 0x01, 0x0a, 0x1f, 0x62, 0x6f, 0x75, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x5f, 0x62, 0x6f, 0x78, 0x5f, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x42, 0x6f,
	0x78, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x48, 0x00, 0x52, 0x1c, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x42, 0x6f,
	0x78, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x42, 0x11, 0x0a, 0x0f, 0x76, 0x65, 0x72, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x5f, 0x6f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x43, 0x0a, 0x1c, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x42, 0x6f, 0x78, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x69, 0x6f, 0x75, 0x5f, 0x74, 0x68, 0x72,
	0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0c, 0x69, 0x6f,
	0x75, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x22, 0x88, 0x02, 0x0a, 0x11, 0x45,
	0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x12, 0x71, 0x0a, 0x16, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x48, 0x00, 0x52, 0x15, 0x63, 0x6c,
	0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x12, 0x75, 0x0a, 0x18, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x64, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e,
	0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x48, 0x00, 0x52, 0x16, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x42, 0x09, 0x0a, 0x07, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x22, 0xbd, 0x01, 0x0a, 0x15, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12,
	0x45, 0x0a, 0x08, 0x70, 0x72, 0x5f, 0x63, 0x75, 0x72, 0x76, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x72, 0x43, 0x75, 0x72, 0x76, 0x65, 0x52, 0x07, 0x70,
	0x72, 0x43, 0x75, 0x72, 0x76, 0x65, 0x12, 0x5d, 0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x66, 0x75, 0x73,
	0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x61,
	0x74, 0x72, 0x69, 0x78, 0x52, 0x0f, 0x63, 0x6f, 0x6e, 0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x4d,
	0x61, 0x74, 0x72, 0x69, 0x78, 0x22, 0x5f, 0x0a, 0x16, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x44,
	0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12,
	0x45, 0x0a, 0x08, 0x70, 0x72, 0x5f, 0x63, 0x75, 0x72, 0x76, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x72, 0x43, 0x75, 0x72, 0x76, 0x65, 0x52, 0x07, 0x70,
	0x72, 0x43, 0x75, 0x72, 0x76, 0x65, 0x22, 0xb1, 0x05, 0x0a, 0x07, 0x50, 0x72, 0x43, 0x75, 0x72,
	0x76, 0x65, 0x12, 0x5a, 0x0a, 0x0f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x0e,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x28,
	0x0a, 0x10, 0x61, 0x72, 0x65, 0x61, 0x5f, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x5f, 0x63, 0x75, 0x72,
	0x76, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0e, 0x61, 0x72, 0x65, 0x61, 0x55, 0x6e,
	0x64, 0x65, 0x72, 0x43, 0x75, 0x72, 0x76, 0x65, 0x12, 0x7f, 0x0a, 0x1a, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x5f, 0x65,
	0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x50, 0x72, 0x43, 0x75, 0x72, 0x76, 0x65, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65,
	0x6e, 0x63, 0x65, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x18, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x12, 0x34, 0x0a, 0x16, 0x6d, 0x65, 0x61,
	0x6e, 0x5f, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x70, 0x72, 0x65, 0x63, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x02, 0x52, 0x14, 0x6d, 0x65, 0x61, 0x6e, 0x41,
	0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x50, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x1a,
	0xe8, 0x02, 0x0a, 0x16, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x31, 0x0a, 0x14, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f,
	0x6c, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x52, 0x13, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64,
	0x65, 0x6e, 0x63, 0x65, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x12, 0x16, 0x0a,
	0x06, 0x72, 0x65, 0x63, 0x61, 0x6c, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x06, 0x72,
	0x65, 0x63, 0x61, 0x6c, 0x6c, 0x12, 0x1c, 0x0a, 0x09, 0x70, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x52, 0x09, 0x70, 0x72, 0x65, 0x63, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x08, 0x66, 0x31, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x02, 0x52, 0x07, 0x66, 0x31, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x12, 0x1d,
	0x0a, 0x0a, 0x72, 0x65, 0x63, 0x61, 0x6c, 0x6c, 0x5f, 0x61, 0x74, 0x31, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x02, 0x52, 0x09, 0x72, 0x65, 0x63, 0x61, 0x6c, 0x6c, 0x41, 0x74, 0x31, 0x12, 0x23, 0x0a,
	0x0d, 0x70, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x74, 0x31, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x02, 0x52, 0x0c, 0x70, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x41,
	0x74, 0x31, 0x12, 0x20, 0x0a, 0x0c, 0x66, 0x31, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x5f, 0x61,
	0x74, 0x31, 0x18, 0x07, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0a, 0x66, 0x31, 0x53, 0x63, 0x6f, 0x72,
	0x65, 0x41, 0x74, 0x31, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x63, 0x61, 0x6c, 0x6c, 0x5f, 0x61,
	0x74, 0x35, 0x18, 0x08, 0x20, 0x01, 0x28, 0x02, 0x52, 0x09, 0x72, 0x65, 0x63, 0x61, 0x6c, 0x6c,
	0x41, 0x74, 0x35, 0x12, 0x23, 0x0a, 0x0d, 0x70, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x5f, 0x61, 0x74, 0x35, 0x18, 0x09, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0c, 0x70, 0x72, 0x65, 0x63,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x74, 0x35, 0x12, 0x20, 0x0a, 0x0c, 0x66, 0x31, 0x5f, 0x73,
	0x63, 0x6f, 0x72, 0x65, 0x5f, 0x61, 0x74, 0x35, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0a,
	0x66, 0x31, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x41, 0x74, 0x35, 0x22, 0xb6, 0x03, 0x0a, 0x0f, 0x43,
	0x6f, 0x6e, 0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x12, 0x48,
	0x0a, 0x03, 0x72, 0x6f, 0x77, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x43, 0x6f, 0x6e, 0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x2e,
	0x52, 0x6f, 0x77, 0x52, 0x03, 0x72, 0x6f, 0x77, 0x1a, 0x91, 0x01, 0x0a, 0x14, 0x43, 0x6f, 0x6e,
	0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x4d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x5a, 0x0a, 0x0f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x73, 0x70, 0x65, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x0e, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x1d, 0x0a,
	0x0a, 0x69, 0x74, 0x65, 0x6d, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x09, 0x69, 0x74, 0x65, 0x6d, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x1a, 0xc4, 0x01, 0x0a,
	0x03, 0x52, 0x6f, 0x77, 0x12, 0x5a, 0x0a, 0x0f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63,
	0x52, 0x0e, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63,
	0x12, 0x61, 0x0a, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x4d,
	0x61, 0x74, 0x72, 0x69, 0x78, 0x2e, 0x43, 0x6f, 0x6e, 0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e, 0x4d,
	0x61, 0x74, 0x72, 0x69, 0x78, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x65, 0x6e, 0x74, 0x72,
	0x69, 0x65, 0x73, 0x42, 0x78, 0x0a, 0x25, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x50, 0x01, 0x5a, 0x4d,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72,
	0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x61, 0x74, 0x61,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x3b, 0x64, 0x61, 0x74, 0x61, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x69, 0x6e, 0x67, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_datalabeling_v1beta1_evaluation_proto_rawDescOnce sync.Once
	file_google_cloud_datalabeling_v1beta1_evaluation_proto_rawDescData = file_google_cloud_datalabeling_v1beta1_evaluation_proto_rawDesc
)

func file_google_cloud_datalabeling_v1beta1_evaluation_proto_rawDescGZIP() []byte {
	file_google_cloud_datalabeling_v1beta1_evaluation_proto_rawDescOnce.Do(func() {
		file_google_cloud_datalabeling_v1beta1_evaluation_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_datalabeling_v1beta1_evaluation_proto_rawDescData)
	})
	return file_google_cloud_datalabeling_v1beta1_evaluation_proto_rawDescData
}

var file_google_cloud_datalabeling_v1beta1_evaluation_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_google_cloud_datalabeling_v1beta1_evaluation_proto_goTypes = []interface{}{
	(*Evaluation)(nil),                           // 0: google.cloud.datalabeling.v1beta1.Evaluation
	(*EvaluationConfig)(nil),                     // 1: google.cloud.datalabeling.v1beta1.EvaluationConfig
	(*BoundingBoxEvaluationOptions)(nil),         // 2: google.cloud.datalabeling.v1beta1.BoundingBoxEvaluationOptions
	(*EvaluationMetrics)(nil),                    // 3: google.cloud.datalabeling.v1beta1.EvaluationMetrics
	(*ClassificationMetrics)(nil),                // 4: google.cloud.datalabeling.v1beta1.ClassificationMetrics
	(*ObjectDetectionMetrics)(nil),               // 5: google.cloud.datalabeling.v1beta1.ObjectDetectionMetrics
	(*PrCurve)(nil),                              // 6: google.cloud.datalabeling.v1beta1.PrCurve
	(*ConfusionMatrix)(nil),                      // 7: google.cloud.datalabeling.v1beta1.ConfusionMatrix
	(*PrCurve_ConfidenceMetricsEntry)(nil),       // 8: google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry
	(*ConfusionMatrix_ConfusionMatrixEntry)(nil), // 9: google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry
	(*ConfusionMatrix_Row)(nil),                  // 10: google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row
	(*timestamp.Timestamp)(nil),                  // 11: google.protobuf.Timestamp
	(AnnotationType)(0),                          // 12: google.cloud.datalabeling.v1beta1.AnnotationType
	(*AnnotationSpec)(nil),                       // 13: google.cloud.datalabeling.v1beta1.AnnotationSpec
}
var file_google_cloud_datalabeling_v1beta1_evaluation_proto_depIdxs = []int32{
	1,  // 0: google.cloud.datalabeling.v1beta1.Evaluation.config:type_name -> google.cloud.datalabeling.v1beta1.EvaluationConfig
	11, // 1: google.cloud.datalabeling.v1beta1.Evaluation.evaluation_job_run_time:type_name -> google.protobuf.Timestamp
	11, // 2: google.cloud.datalabeling.v1beta1.Evaluation.create_time:type_name -> google.protobuf.Timestamp
	3,  // 3: google.cloud.datalabeling.v1beta1.Evaluation.evaluation_metrics:type_name -> google.cloud.datalabeling.v1beta1.EvaluationMetrics
	12, // 4: google.cloud.datalabeling.v1beta1.Evaluation.annotation_type:type_name -> google.cloud.datalabeling.v1beta1.AnnotationType
	2,  // 5: google.cloud.datalabeling.v1beta1.EvaluationConfig.bounding_box_evaluation_options:type_name -> google.cloud.datalabeling.v1beta1.BoundingBoxEvaluationOptions
	4,  // 6: google.cloud.datalabeling.v1beta1.EvaluationMetrics.classification_metrics:type_name -> google.cloud.datalabeling.v1beta1.ClassificationMetrics
	5,  // 7: google.cloud.datalabeling.v1beta1.EvaluationMetrics.object_detection_metrics:type_name -> google.cloud.datalabeling.v1beta1.ObjectDetectionMetrics
	6,  // 8: google.cloud.datalabeling.v1beta1.ClassificationMetrics.pr_curve:type_name -> google.cloud.datalabeling.v1beta1.PrCurve
	7,  // 9: google.cloud.datalabeling.v1beta1.ClassificationMetrics.confusion_matrix:type_name -> google.cloud.datalabeling.v1beta1.ConfusionMatrix
	6,  // 10: google.cloud.datalabeling.v1beta1.ObjectDetectionMetrics.pr_curve:type_name -> google.cloud.datalabeling.v1beta1.PrCurve
	13, // 11: google.cloud.datalabeling.v1beta1.PrCurve.annotation_spec:type_name -> google.cloud.datalabeling.v1beta1.AnnotationSpec
	8,  // 12: google.cloud.datalabeling.v1beta1.PrCurve.confidence_metrics_entries:type_name -> google.cloud.datalabeling.v1beta1.PrCurve.ConfidenceMetricsEntry
	10, // 13: google.cloud.datalabeling.v1beta1.ConfusionMatrix.row:type_name -> google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row
	13, // 14: google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry.annotation_spec:type_name -> google.cloud.datalabeling.v1beta1.AnnotationSpec
	13, // 15: google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row.annotation_spec:type_name -> google.cloud.datalabeling.v1beta1.AnnotationSpec
	9,  // 16: google.cloud.datalabeling.v1beta1.ConfusionMatrix.Row.entries:type_name -> google.cloud.datalabeling.v1beta1.ConfusionMatrix.ConfusionMatrixEntry
	17, // [17:17] is the sub-list for method output_type
	17, // [17:17] is the sub-list for method input_type
	17, // [17:17] is the sub-list for extension type_name
	17, // [17:17] is the sub-list for extension extendee
	0,  // [0:17] is the sub-list for field type_name
}

func init() { file_google_cloud_datalabeling_v1beta1_evaluation_proto_init() }
func file_google_cloud_datalabeling_v1beta1_evaluation_proto_init() {
	if File_google_cloud_datalabeling_v1beta1_evaluation_proto != nil {
		return
	}
	file_google_cloud_datalabeling_v1beta1_annotation_proto_init()
	file_google_cloud_datalabeling_v1beta1_annotation_spec_set_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_datalabeling_v1beta1_evaluation_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Evaluation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_evaluation_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EvaluationConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_evaluation_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*BoundingBoxEvaluationOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_evaluation_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EvaluationMetrics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_evaluation_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ClassificationMetrics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_evaluation_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ObjectDetectionMetrics); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_evaluation_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PrCurve); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_evaluation_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConfusionMatrix); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_evaluation_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PrCurve_ConfidenceMetricsEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_evaluation_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConfusionMatrix_ConfusionMatrixEntry); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_datalabeling_v1beta1_evaluation_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ConfusionMatrix_Row); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_datalabeling_v1beta1_evaluation_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*EvaluationConfig_BoundingBoxEvaluationOptions)(nil),
	}
	file_google_cloud_datalabeling_v1beta1_evaluation_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*EvaluationMetrics_ClassificationMetrics)(nil),
		(*EvaluationMetrics_ObjectDetectionMetrics)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_datalabeling_v1beta1_evaluation_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_datalabeling_v1beta1_evaluation_proto_goTypes,
		DependencyIndexes: file_google_cloud_datalabeling_v1beta1_evaluation_proto_depIdxs,
		MessageInfos:      file_google_cloud_datalabeling_v1beta1_evaluation_proto_msgTypes,
	}.Build()
	File_google_cloud_datalabeling_v1beta1_evaluation_proto = out.File
	file_google_cloud_datalabeling_v1beta1_evaluation_proto_rawDesc = nil
	file_google_cloud_datalabeling_v1beta1_evaluation_proto_goTypes = nil
	file_google_cloud_datalabeling_v1beta1_evaluation_proto_depIdxs = nil
}
