// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package opsworks

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAssignInstance = "AssignInstance"

// AssignInstanceRequest generates a "aws/request.Request" representing the
// client's request for the AssignInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssignInstance for more information on using the AssignInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssignInstanceRequest method.
//    req, resp := client.AssignInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/AssignInstance
func (c *OpsWorks) AssignInstanceRequest(input *AssignInstanceInput) (req *request.Request, output *AssignInstanceOutput) {
	op := &request.Operation{
		Name:       opAssignInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssignInstanceInput{}
	}

	output = &AssignInstanceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssignInstance API operation for AWS OpsWorks.
//
// Assign a registered instance to a layer.
//
//    * You can assign registered on-premises instances to any layer type.
//
//    * You can assign registered Amazon EC2 instances only to custom layers.
//
//    * You cannot use this action with instances that were created with AWS
//    OpsWorks Stacks.
//
// Required Permissions: To use this action, an AWS Identity and Access Management
// (IAM) user must have a Manage permissions level for the stack or an attached
// policy that explicitly grants permissions. For more information on user permissions,
// see Managing User Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation AssignInstance for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/AssignInstance
func (c *OpsWorks) AssignInstance(input *AssignInstanceInput) (*AssignInstanceOutput, error) {
	req, out := c.AssignInstanceRequest(input)
	return out, req.Send()
}

// AssignInstanceWithContext is the same as AssignInstance with the addition of
// the ability to pass a context and additional request options.
//
// See AssignInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) AssignInstanceWithContext(ctx aws.Context, input *AssignInstanceInput, opts ...request.Option) (*AssignInstanceOutput, error) {
	req, out := c.AssignInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssignVolume = "AssignVolume"

// AssignVolumeRequest generates a "aws/request.Request" representing the
// client's request for the AssignVolume operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssignVolume for more information on using the AssignVolume
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssignVolumeRequest method.
//    req, resp := client.AssignVolumeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/AssignVolume
func (c *OpsWorks) AssignVolumeRequest(input *AssignVolumeInput) (req *request.Request, output *AssignVolumeOutput) {
	op := &request.Operation{
		Name:       opAssignVolume,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssignVolumeInput{}
	}

	output = &AssignVolumeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssignVolume API operation for AWS OpsWorks.
//
// Assigns one of the stack's registered Amazon EBS volumes to a specified instance.
// The volume must first be registered with the stack by calling RegisterVolume.
// After you register the volume, you must call UpdateVolume to specify a mount
// point before calling AssignVolume. For more information, see Resource Management
// (https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation AssignVolume for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/AssignVolume
func (c *OpsWorks) AssignVolume(input *AssignVolumeInput) (*AssignVolumeOutput, error) {
	req, out := c.AssignVolumeRequest(input)
	return out, req.Send()
}

// AssignVolumeWithContext is the same as AssignVolume with the addition of
// the ability to pass a context and additional request options.
//
// See AssignVolume for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) AssignVolumeWithContext(ctx aws.Context, input *AssignVolumeInput, opts ...request.Option) (*AssignVolumeOutput, error) {
	req, out := c.AssignVolumeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateElasticIp = "AssociateElasticIp"

// AssociateElasticIpRequest generates a "aws/request.Request" representing the
// client's request for the AssociateElasticIp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateElasticIp for more information on using the AssociateElasticIp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateElasticIpRequest method.
//    req, resp := client.AssociateElasticIpRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/AssociateElasticIp
func (c *OpsWorks) AssociateElasticIpRequest(input *AssociateElasticIpInput) (req *request.Request, output *AssociateElasticIpOutput) {
	op := &request.Operation{
		Name:       opAssociateElasticIp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateElasticIpInput{}
	}

	output = &AssociateElasticIpOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssociateElasticIp API operation for AWS OpsWorks.
//
// Associates one of the stack's registered Elastic IP addresses with a specified
// instance. The address must first be registered with the stack by calling
// RegisterElasticIp. For more information, see Resource Management (https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation AssociateElasticIp for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/AssociateElasticIp
func (c *OpsWorks) AssociateElasticIp(input *AssociateElasticIpInput) (*AssociateElasticIpOutput, error) {
	req, out := c.AssociateElasticIpRequest(input)
	return out, req.Send()
}

// AssociateElasticIpWithContext is the same as AssociateElasticIp with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateElasticIp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) AssociateElasticIpWithContext(ctx aws.Context, input *AssociateElasticIpInput, opts ...request.Option) (*AssociateElasticIpOutput, error) {
	req, out := c.AssociateElasticIpRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAttachElasticLoadBalancer = "AttachElasticLoadBalancer"

// AttachElasticLoadBalancerRequest generates a "aws/request.Request" representing the
// client's request for the AttachElasticLoadBalancer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AttachElasticLoadBalancer for more information on using the AttachElasticLoadBalancer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AttachElasticLoadBalancerRequest method.
//    req, resp := client.AttachElasticLoadBalancerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/AttachElasticLoadBalancer
func (c *OpsWorks) AttachElasticLoadBalancerRequest(input *AttachElasticLoadBalancerInput) (req *request.Request, output *AttachElasticLoadBalancerOutput) {
	op := &request.Operation{
		Name:       opAttachElasticLoadBalancer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachElasticLoadBalancerInput{}
	}

	output = &AttachElasticLoadBalancerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AttachElasticLoadBalancer API operation for AWS OpsWorks.
//
// Attaches an Elastic Load Balancing load balancer to a specified layer. AWS
// OpsWorks Stacks does not support Application Load Balancer. You can only
// use Classic Load Balancer with AWS OpsWorks Stacks. For more information,
// see Elastic Load Balancing (https://docs.aws.amazon.com/opsworks/latest/userguide/layers-elb.html).
//
// You must create the Elastic Load Balancing instance separately, by using
// the Elastic Load Balancing console, API, or CLI. For more information, see
// Elastic Load Balancing Developer Guide (https://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/Welcome.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation AttachElasticLoadBalancer for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/AttachElasticLoadBalancer
func (c *OpsWorks) AttachElasticLoadBalancer(input *AttachElasticLoadBalancerInput) (*AttachElasticLoadBalancerOutput, error) {
	req, out := c.AttachElasticLoadBalancerRequest(input)
	return out, req.Send()
}

// AttachElasticLoadBalancerWithContext is the same as AttachElasticLoadBalancer with the addition of
// the ability to pass a context and additional request options.
//
// See AttachElasticLoadBalancer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) AttachElasticLoadBalancerWithContext(ctx aws.Context, input *AttachElasticLoadBalancerInput, opts ...request.Option) (*AttachElasticLoadBalancerOutput, error) {
	req, out := c.AttachElasticLoadBalancerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCloneStack = "CloneStack"

// CloneStackRequest generates a "aws/request.Request" representing the
// client's request for the CloneStack operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CloneStack for more information on using the CloneStack
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CloneStackRequest method.
//    req, resp := client.CloneStackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/CloneStack
func (c *OpsWorks) CloneStackRequest(input *CloneStackInput) (req *request.Request, output *CloneStackOutput) {
	op := &request.Operation{
		Name:       opCloneStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CloneStackInput{}
	}

	output = &CloneStackOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CloneStack API operation for AWS OpsWorks.
//
// Creates a clone of a specified stack. For more information, see Clone a Stack
// (https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-cloning.html).
// By default, all parameters are set to the values used by the parent stack.
//
// Required Permissions: To use this action, an IAM user must have an attached
// policy that explicitly grants permissions. For more information about user
// permissions, see Managing User Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation CloneStack for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/CloneStack
func (c *OpsWorks) CloneStack(input *CloneStackInput) (*CloneStackOutput, error) {
	req, out := c.CloneStackRequest(input)
	return out, req.Send()
}

// CloneStackWithContext is the same as CloneStack with the addition of
// the ability to pass a context and additional request options.
//
// See CloneStack for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) CloneStackWithContext(ctx aws.Context, input *CloneStackInput, opts ...request.Option) (*CloneStackOutput, error) {
	req, out := c.CloneStackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateApp = "CreateApp"

// CreateAppRequest generates a "aws/request.Request" representing the
// client's request for the CreateApp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateApp for more information on using the CreateApp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAppRequest method.
//    req, resp := client.CreateAppRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/CreateApp
func (c *OpsWorks) CreateAppRequest(input *CreateAppInput) (req *request.Request, output *CreateAppOutput) {
	op := &request.Operation{
		Name:       opCreateApp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAppInput{}
	}

	output = &CreateAppOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateApp API operation for AWS OpsWorks.
//
// Creates an app for a specified stack. For more information, see Creating
// Apps (https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation CreateApp for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/CreateApp
func (c *OpsWorks) CreateApp(input *CreateAppInput) (*CreateAppOutput, error) {
	req, out := c.CreateAppRequest(input)
	return out, req.Send()
}

// CreateAppWithContext is the same as CreateApp with the addition of
// the ability to pass a context and additional request options.
//
// See CreateApp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) CreateAppWithContext(ctx aws.Context, input *CreateAppInput, opts ...request.Option) (*CreateAppOutput, error) {
	req, out := c.CreateAppRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDeployment = "CreateDeployment"

// CreateDeploymentRequest generates a "aws/request.Request" representing the
// client's request for the CreateDeployment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDeployment for more information on using the CreateDeployment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDeploymentRequest method.
//    req, resp := client.CreateDeploymentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/CreateDeployment
func (c *OpsWorks) CreateDeploymentRequest(input *CreateDeploymentInput) (req *request.Request, output *CreateDeploymentOutput) {
	op := &request.Operation{
		Name:       opCreateDeployment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDeploymentInput{}
	}

	output = &CreateDeploymentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDeployment API operation for AWS OpsWorks.
//
// Runs deployment or stack commands. For more information, see Deploying Apps
// (https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-deploying.html)
// and Run Stack Commands (https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-commands.html).
//
// Required Permissions: To use this action, an IAM user must have a Deploy
// or Manage permissions level for the stack, or an attached policy that explicitly
// grants permissions. For more information on user permissions, see Managing
// User Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation CreateDeployment for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/CreateDeployment
func (c *OpsWorks) CreateDeployment(input *CreateDeploymentInput) (*CreateDeploymentOutput, error) {
	req, out := c.CreateDeploymentRequest(input)
	return out, req.Send()
}

// CreateDeploymentWithContext is the same as CreateDeployment with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDeployment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) CreateDeploymentWithContext(ctx aws.Context, input *CreateDeploymentInput, opts ...request.Option) (*CreateDeploymentOutput, error) {
	req, out := c.CreateDeploymentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateInstance = "CreateInstance"

// CreateInstanceRequest generates a "aws/request.Request" representing the
// client's request for the CreateInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateInstance for more information on using the CreateInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateInstanceRequest method.
//    req, resp := client.CreateInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/CreateInstance
func (c *OpsWorks) CreateInstanceRequest(input *CreateInstanceInput) (req *request.Request, output *CreateInstanceOutput) {
	op := &request.Operation{
		Name:       opCreateInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateInstanceInput{}
	}

	output = &CreateInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateInstance API operation for AWS OpsWorks.
//
// Creates an instance in a specified stack. For more information, see Adding
// an Instance to a Layer (https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-add.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation CreateInstance for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/CreateInstance
func (c *OpsWorks) CreateInstance(input *CreateInstanceInput) (*CreateInstanceOutput, error) {
	req, out := c.CreateInstanceRequest(input)
	return out, req.Send()
}

// CreateInstanceWithContext is the same as CreateInstance with the addition of
// the ability to pass a context and additional request options.
//
// See CreateInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) CreateInstanceWithContext(ctx aws.Context, input *CreateInstanceInput, opts ...request.Option) (*CreateInstanceOutput, error) {
	req, out := c.CreateInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLayer = "CreateLayer"

// CreateLayerRequest generates a "aws/request.Request" representing the
// client's request for the CreateLayer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLayer for more information on using the CreateLayer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateLayerRequest method.
//    req, resp := client.CreateLayerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/CreateLayer
func (c *OpsWorks) CreateLayerRequest(input *CreateLayerInput) (req *request.Request, output *CreateLayerOutput) {
	op := &request.Operation{
		Name:       opCreateLayer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateLayerInput{}
	}

	output = &CreateLayerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLayer API operation for AWS OpsWorks.
//
// Creates a layer. For more information, see How to Create a Layer (https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-create.html).
//
// You should use CreateLayer for noncustom layer types such as PHP App Server
// only if the stack does not have an existing layer of that type. A stack can
// have at most one instance of each noncustom layer; if you attempt to create
// a second instance, CreateLayer fails. A stack can have an arbitrary number
// of custom layers, so you can call CreateLayer as many times as you like for
// that layer type.
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation CreateLayer for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/CreateLayer
func (c *OpsWorks) CreateLayer(input *CreateLayerInput) (*CreateLayerOutput, error) {
	req, out := c.CreateLayerRequest(input)
	return out, req.Send()
}

// CreateLayerWithContext is the same as CreateLayer with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLayer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) CreateLayerWithContext(ctx aws.Context, input *CreateLayerInput, opts ...request.Option) (*CreateLayerOutput, error) {
	req, out := c.CreateLayerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateStack = "CreateStack"

// CreateStackRequest generates a "aws/request.Request" representing the
// client's request for the CreateStack operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateStack for more information on using the CreateStack
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateStackRequest method.
//    req, resp := client.CreateStackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/CreateStack
func (c *OpsWorks) CreateStackRequest(input *CreateStackInput) (req *request.Request, output *CreateStackOutput) {
	op := &request.Operation{
		Name:       opCreateStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateStackInput{}
	}

	output = &CreateStackOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateStack API operation for AWS OpsWorks.
//
// Creates a new stack. For more information, see Create a New Stack (https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-edit.html).
//
// Required Permissions: To use this action, an IAM user must have an attached
// policy that explicitly grants permissions. For more information about user
// permissions, see Managing User Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation CreateStack for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/CreateStack
func (c *OpsWorks) CreateStack(input *CreateStackInput) (*CreateStackOutput, error) {
	req, out := c.CreateStackRequest(input)
	return out, req.Send()
}

// CreateStackWithContext is the same as CreateStack with the addition of
// the ability to pass a context and additional request options.
//
// See CreateStack for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) CreateStackWithContext(ctx aws.Context, input *CreateStackInput, opts ...request.Option) (*CreateStackOutput, error) {
	req, out := c.CreateStackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateUserProfile = "CreateUserProfile"

// CreateUserProfileRequest generates a "aws/request.Request" representing the
// client's request for the CreateUserProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateUserProfile for more information on using the CreateUserProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateUserProfileRequest method.
//    req, resp := client.CreateUserProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/CreateUserProfile
func (c *OpsWorks) CreateUserProfileRequest(input *CreateUserProfileInput) (req *request.Request, output *CreateUserProfileOutput) {
	op := &request.Operation{
		Name:       opCreateUserProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateUserProfileInput{}
	}

	output = &CreateUserProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateUserProfile API operation for AWS OpsWorks.
//
// Creates a new user profile.
//
// Required Permissions: To use this action, an IAM user must have an attached
// policy that explicitly grants permissions. For more information about user
// permissions, see Managing User Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation CreateUserProfile for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/CreateUserProfile
func (c *OpsWorks) CreateUserProfile(input *CreateUserProfileInput) (*CreateUserProfileOutput, error) {
	req, out := c.CreateUserProfileRequest(input)
	return out, req.Send()
}

// CreateUserProfileWithContext is the same as CreateUserProfile with the addition of
// the ability to pass a context and additional request options.
//
// See CreateUserProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) CreateUserProfileWithContext(ctx aws.Context, input *CreateUserProfileInput, opts ...request.Option) (*CreateUserProfileOutput, error) {
	req, out := c.CreateUserProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApp = "DeleteApp"

// DeleteAppRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApp for more information on using the DeleteApp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAppRequest method.
//    req, resp := client.DeleteAppRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DeleteApp
func (c *OpsWorks) DeleteAppRequest(input *DeleteAppInput) (req *request.Request, output *DeleteAppOutput) {
	op := &request.Operation{
		Name:       opDeleteApp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAppInput{}
	}

	output = &DeleteAppOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteApp API operation for AWS OpsWorks.
//
// Deletes a specified app.
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation DeleteApp for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DeleteApp
func (c *OpsWorks) DeleteApp(input *DeleteAppInput) (*DeleteAppOutput, error) {
	req, out := c.DeleteAppRequest(input)
	return out, req.Send()
}

// DeleteAppWithContext is the same as DeleteApp with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) DeleteAppWithContext(ctx aws.Context, input *DeleteAppInput, opts ...request.Option) (*DeleteAppOutput, error) {
	req, out := c.DeleteAppRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteInstance = "DeleteInstance"

// DeleteInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteInstance for more information on using the DeleteInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteInstanceRequest method.
//    req, resp := client.DeleteInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DeleteInstance
func (c *OpsWorks) DeleteInstanceRequest(input *DeleteInstanceInput) (req *request.Request, output *DeleteInstanceOutput) {
	op := &request.Operation{
		Name:       opDeleteInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteInstanceInput{}
	}

	output = &DeleteInstanceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteInstance API operation for AWS OpsWorks.
//
// Deletes a specified instance, which terminates the associated Amazon EC2
// instance. You must stop an instance before you can delete it.
//
// For more information, see Deleting Instances (https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-delete.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation DeleteInstance for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DeleteInstance
func (c *OpsWorks) DeleteInstance(input *DeleteInstanceInput) (*DeleteInstanceOutput, error) {
	req, out := c.DeleteInstanceRequest(input)
	return out, req.Send()
}

// DeleteInstanceWithContext is the same as DeleteInstance with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) DeleteInstanceWithContext(ctx aws.Context, input *DeleteInstanceInput, opts ...request.Option) (*DeleteInstanceOutput, error) {
	req, out := c.DeleteInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLayer = "DeleteLayer"

// DeleteLayerRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLayer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLayer for more information on using the DeleteLayer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteLayerRequest method.
//    req, resp := client.DeleteLayerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DeleteLayer
func (c *OpsWorks) DeleteLayerRequest(input *DeleteLayerInput) (req *request.Request, output *DeleteLayerOutput) {
	op := &request.Operation{
		Name:       opDeleteLayer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLayerInput{}
	}

	output = &DeleteLayerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteLayer API operation for AWS OpsWorks.
//
// Deletes a specified layer. You must first stop and then delete all associated
// instances or unassign registered instances. For more information, see How
// to Delete a Layer (https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-delete.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation DeleteLayer for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DeleteLayer
func (c *OpsWorks) DeleteLayer(input *DeleteLayerInput) (*DeleteLayerOutput, error) {
	req, out := c.DeleteLayerRequest(input)
	return out, req.Send()
}

// DeleteLayerWithContext is the same as DeleteLayer with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLayer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) DeleteLayerWithContext(ctx aws.Context, input *DeleteLayerInput, opts ...request.Option) (*DeleteLayerOutput, error) {
	req, out := c.DeleteLayerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteStack = "DeleteStack"

// DeleteStackRequest generates a "aws/request.Request" representing the
// client's request for the DeleteStack operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteStack for more information on using the DeleteStack
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteStackRequest method.
//    req, resp := client.DeleteStackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DeleteStack
func (c *OpsWorks) DeleteStackRequest(input *DeleteStackInput) (req *request.Request, output *DeleteStackOutput) {
	op := &request.Operation{
		Name:       opDeleteStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteStackInput{}
	}

	output = &DeleteStackOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteStack API operation for AWS OpsWorks.
//
// Deletes a specified stack. You must first delete all instances, layers, and
// apps or deregister registered instances. For more information, see Shut Down
// a Stack (https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-shutting.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation DeleteStack for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DeleteStack
func (c *OpsWorks) DeleteStack(input *DeleteStackInput) (*DeleteStackOutput, error) {
	req, out := c.DeleteStackRequest(input)
	return out, req.Send()
}

// DeleteStackWithContext is the same as DeleteStack with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteStack for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) DeleteStackWithContext(ctx aws.Context, input *DeleteStackInput, opts ...request.Option) (*DeleteStackOutput, error) {
	req, out := c.DeleteStackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUserProfile = "DeleteUserProfile"

// DeleteUserProfileRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUserProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUserProfile for more information on using the DeleteUserProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteUserProfileRequest method.
//    req, resp := client.DeleteUserProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DeleteUserProfile
func (c *OpsWorks) DeleteUserProfileRequest(input *DeleteUserProfileInput) (req *request.Request, output *DeleteUserProfileOutput) {
	op := &request.Operation{
		Name:       opDeleteUserProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteUserProfileInput{}
	}

	output = &DeleteUserProfileOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteUserProfile API operation for AWS OpsWorks.
//
// Deletes a user profile.
//
// Required Permissions: To use this action, an IAM user must have an attached
// policy that explicitly grants permissions. For more information about user
// permissions, see Managing User Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation DeleteUserProfile for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DeleteUserProfile
func (c *OpsWorks) DeleteUserProfile(input *DeleteUserProfileInput) (*DeleteUserProfileOutput, error) {
	req, out := c.DeleteUserProfileRequest(input)
	return out, req.Send()
}

// DeleteUserProfileWithContext is the same as DeleteUserProfile with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUserProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) DeleteUserProfileWithContext(ctx aws.Context, input *DeleteUserProfileInput, opts ...request.Option) (*DeleteUserProfileOutput, error) {
	req, out := c.DeleteUserProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterEcsCluster = "DeregisterEcsCluster"

// DeregisterEcsClusterRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterEcsCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterEcsCluster for more information on using the DeregisterEcsCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeregisterEcsClusterRequest method.
//    req, resp := client.DeregisterEcsClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DeregisterEcsCluster
func (c *OpsWorks) DeregisterEcsClusterRequest(input *DeregisterEcsClusterInput) (req *request.Request, output *DeregisterEcsClusterOutput) {
	op := &request.Operation{
		Name:       opDeregisterEcsCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterEcsClusterInput{}
	}

	output = &DeregisterEcsClusterOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeregisterEcsCluster API operation for AWS OpsWorks.
//
// Deregisters a specified Amazon ECS cluster from a stack. For more information,
// see Resource Management (https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-ecscluster.html#workinglayers-ecscluster-delete).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack or an attached policy that explicitly grants
// permissions. For more information on user permissions, see https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html
// (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation DeregisterEcsCluster for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DeregisterEcsCluster
func (c *OpsWorks) DeregisterEcsCluster(input *DeregisterEcsClusterInput) (*DeregisterEcsClusterOutput, error) {
	req, out := c.DeregisterEcsClusterRequest(input)
	return out, req.Send()
}

// DeregisterEcsClusterWithContext is the same as DeregisterEcsCluster with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterEcsCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) DeregisterEcsClusterWithContext(ctx aws.Context, input *DeregisterEcsClusterInput, opts ...request.Option) (*DeregisterEcsClusterOutput, error) {
	req, out := c.DeregisterEcsClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterElasticIp = "DeregisterElasticIp"

// DeregisterElasticIpRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterElasticIp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterElasticIp for more information on using the DeregisterElasticIp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeregisterElasticIpRequest method.
//    req, resp := client.DeregisterElasticIpRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DeregisterElasticIp
func (c *OpsWorks) DeregisterElasticIpRequest(input *DeregisterElasticIpInput) (req *request.Request, output *DeregisterElasticIpOutput) {
	op := &request.Operation{
		Name:       opDeregisterElasticIp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterElasticIpInput{}
	}

	output = &DeregisterElasticIpOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeregisterElasticIp API operation for AWS OpsWorks.
//
// Deregisters a specified Elastic IP address. The address can then be registered
// by another stack. For more information, see Resource Management (https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation DeregisterElasticIp for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DeregisterElasticIp
func (c *OpsWorks) DeregisterElasticIp(input *DeregisterElasticIpInput) (*DeregisterElasticIpOutput, error) {
	req, out := c.DeregisterElasticIpRequest(input)
	return out, req.Send()
}

// DeregisterElasticIpWithContext is the same as DeregisterElasticIp with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterElasticIp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) DeregisterElasticIpWithContext(ctx aws.Context, input *DeregisterElasticIpInput, opts ...request.Option) (*DeregisterElasticIpOutput, error) {
	req, out := c.DeregisterElasticIpRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterInstance = "DeregisterInstance"

// DeregisterInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterInstance for more information on using the DeregisterInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeregisterInstanceRequest method.
//    req, resp := client.DeregisterInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DeregisterInstance
func (c *OpsWorks) DeregisterInstanceRequest(input *DeregisterInstanceInput) (req *request.Request, output *DeregisterInstanceOutput) {
	op := &request.Operation{
		Name:       opDeregisterInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterInstanceInput{}
	}

	output = &DeregisterInstanceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeregisterInstance API operation for AWS OpsWorks.
//
// Deregister a registered Amazon EC2 or on-premises instance. This action removes
// the instance from the stack and returns it to your control. This action cannot
// be used with instances that were created with AWS OpsWorks Stacks.
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation DeregisterInstance for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DeregisterInstance
func (c *OpsWorks) DeregisterInstance(input *DeregisterInstanceInput) (*DeregisterInstanceOutput, error) {
	req, out := c.DeregisterInstanceRequest(input)
	return out, req.Send()
}

// DeregisterInstanceWithContext is the same as DeregisterInstance with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) DeregisterInstanceWithContext(ctx aws.Context, input *DeregisterInstanceInput, opts ...request.Option) (*DeregisterInstanceOutput, error) {
	req, out := c.DeregisterInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterRdsDbInstance = "DeregisterRdsDbInstance"

// DeregisterRdsDbInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterRdsDbInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterRdsDbInstance for more information on using the DeregisterRdsDbInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeregisterRdsDbInstanceRequest method.
//    req, resp := client.DeregisterRdsDbInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DeregisterRdsDbInstance
func (c *OpsWorks) DeregisterRdsDbInstanceRequest(input *DeregisterRdsDbInstanceInput) (req *request.Request, output *DeregisterRdsDbInstanceOutput) {
	op := &request.Operation{
		Name:       opDeregisterRdsDbInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterRdsDbInstanceInput{}
	}

	output = &DeregisterRdsDbInstanceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeregisterRdsDbInstance API operation for AWS OpsWorks.
//
// Deregisters an Amazon RDS instance.
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation DeregisterRdsDbInstance for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DeregisterRdsDbInstance
func (c *OpsWorks) DeregisterRdsDbInstance(input *DeregisterRdsDbInstanceInput) (*DeregisterRdsDbInstanceOutput, error) {
	req, out := c.DeregisterRdsDbInstanceRequest(input)
	return out, req.Send()
}

// DeregisterRdsDbInstanceWithContext is the same as DeregisterRdsDbInstance with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterRdsDbInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) DeregisterRdsDbInstanceWithContext(ctx aws.Context, input *DeregisterRdsDbInstanceInput, opts ...request.Option) (*DeregisterRdsDbInstanceOutput, error) {
	req, out := c.DeregisterRdsDbInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterVolume = "DeregisterVolume"

// DeregisterVolumeRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterVolume operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterVolume for more information on using the DeregisterVolume
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeregisterVolumeRequest method.
//    req, resp := client.DeregisterVolumeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DeregisterVolume
func (c *OpsWorks) DeregisterVolumeRequest(input *DeregisterVolumeInput) (req *request.Request, output *DeregisterVolumeOutput) {
	op := &request.Operation{
		Name:       opDeregisterVolume,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterVolumeInput{}
	}

	output = &DeregisterVolumeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeregisterVolume API operation for AWS OpsWorks.
//
// Deregisters an Amazon EBS volume. The volume can then be registered by another
// stack. For more information, see Resource Management (https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation DeregisterVolume for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DeregisterVolume
func (c *OpsWorks) DeregisterVolume(input *DeregisterVolumeInput) (*DeregisterVolumeOutput, error) {
	req, out := c.DeregisterVolumeRequest(input)
	return out, req.Send()
}

// DeregisterVolumeWithContext is the same as DeregisterVolume with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterVolume for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) DeregisterVolumeWithContext(ctx aws.Context, input *DeregisterVolumeInput, opts ...request.Option) (*DeregisterVolumeOutput, error) {
	req, out := c.DeregisterVolumeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAgentVersions = "DescribeAgentVersions"

// DescribeAgentVersionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAgentVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAgentVersions for more information on using the DescribeAgentVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAgentVersionsRequest method.
//    req, resp := client.DescribeAgentVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeAgentVersions
func (c *OpsWorks) DescribeAgentVersionsRequest(input *DescribeAgentVersionsInput) (req *request.Request, output *DescribeAgentVersionsOutput) {
	op := &request.Operation{
		Name:       opDescribeAgentVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAgentVersionsInput{}
	}

	output = &DescribeAgentVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAgentVersions API operation for AWS OpsWorks.
//
// Describes the available AWS OpsWorks Stacks agent versions. You must specify
// a stack ID or a configuration manager. DescribeAgentVersions returns a list
// of available agent versions for the specified stack or configuration manager.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation DescribeAgentVersions for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeAgentVersions
func (c *OpsWorks) DescribeAgentVersions(input *DescribeAgentVersionsInput) (*DescribeAgentVersionsOutput, error) {
	req, out := c.DescribeAgentVersionsRequest(input)
	return out, req.Send()
}

// DescribeAgentVersionsWithContext is the same as DescribeAgentVersions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAgentVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) DescribeAgentVersionsWithContext(ctx aws.Context, input *DescribeAgentVersionsInput, opts ...request.Option) (*DescribeAgentVersionsOutput, error) {
	req, out := c.DescribeAgentVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeApps = "DescribeApps"

// DescribeAppsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeApps operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeApps for more information on using the DescribeApps
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAppsRequest method.
//    req, resp := client.DescribeAppsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeApps
func (c *OpsWorks) DescribeAppsRequest(input *DescribeAppsInput) (req *request.Request, output *DescribeAppsOutput) {
	op := &request.Operation{
		Name:       opDescribeApps,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAppsInput{}
	}

	output = &DescribeAppsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeApps API operation for AWS OpsWorks.
//
// Requests a description of a specified set of apps.
//
// This call accepts only one resource-identifying parameter.
//
// Required Permissions: To use this action, an IAM user must have a Show, Deploy,
// or Manage permissions level for the stack, or an attached policy that explicitly
// grants permissions. For more information about user permissions, see Managing
// User Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation DescribeApps for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeApps
func (c *OpsWorks) DescribeApps(input *DescribeAppsInput) (*DescribeAppsOutput, error) {
	req, out := c.DescribeAppsRequest(input)
	return out, req.Send()
}

// DescribeAppsWithContext is the same as DescribeApps with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeApps for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) DescribeAppsWithContext(ctx aws.Context, input *DescribeAppsInput, opts ...request.Option) (*DescribeAppsOutput, error) {
	req, out := c.DescribeAppsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCommands = "DescribeCommands"

// DescribeCommandsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCommands operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCommands for more information on using the DescribeCommands
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeCommandsRequest method.
//    req, resp := client.DescribeCommandsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeCommands
func (c *OpsWorks) DescribeCommandsRequest(input *DescribeCommandsInput) (req *request.Request, output *DescribeCommandsOutput) {
	op := &request.Operation{
		Name:       opDescribeCommands,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCommandsInput{}
	}

	output = &DescribeCommandsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCommands API operation for AWS OpsWorks.
//
// Describes the results of specified commands.
//
// This call accepts only one resource-identifying parameter.
//
// Required Permissions: To use this action, an IAM user must have a Show, Deploy,
// or Manage permissions level for the stack, or an attached policy that explicitly
// grants permissions. For more information about user permissions, see Managing
// User Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation DescribeCommands for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeCommands
func (c *OpsWorks) DescribeCommands(input *DescribeCommandsInput) (*DescribeCommandsOutput, error) {
	req, out := c.DescribeCommandsRequest(input)
	return out, req.Send()
}

// DescribeCommandsWithContext is the same as DescribeCommands with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCommands for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) DescribeCommandsWithContext(ctx aws.Context, input *DescribeCommandsInput, opts ...request.Option) (*DescribeCommandsOutput, error) {
	req, out := c.DescribeCommandsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDeployments = "DescribeDeployments"

// DescribeDeploymentsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDeployments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDeployments for more information on using the DescribeDeployments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDeploymentsRequest method.
//    req, resp := client.DescribeDeploymentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeDeployments
func (c *OpsWorks) DescribeDeploymentsRequest(input *DescribeDeploymentsInput) (req *request.Request, output *DescribeDeploymentsOutput) {
	op := &request.Operation{
		Name:       opDescribeDeployments,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDeploymentsInput{}
	}

	output = &DescribeDeploymentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDeployments API operation for AWS OpsWorks.
//
// Requests a description of a specified set of deployments.
//
// This call accepts only one resource-identifying parameter.
//
// Required Permissions: To use this action, an IAM user must have a Show, Deploy,
// or Manage permissions level for the stack, or an attached policy that explicitly
// grants permissions. For more information about user permissions, see Managing
// User Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation DescribeDeployments for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeDeployments
func (c *OpsWorks) DescribeDeployments(input *DescribeDeploymentsInput) (*DescribeDeploymentsOutput, error) {
	req, out := c.DescribeDeploymentsRequest(input)
	return out, req.Send()
}

// DescribeDeploymentsWithContext is the same as DescribeDeployments with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDeployments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) DescribeDeploymentsWithContext(ctx aws.Context, input *DescribeDeploymentsInput, opts ...request.Option) (*DescribeDeploymentsOutput, error) {
	req, out := c.DescribeDeploymentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEcsClusters = "DescribeEcsClusters"

// DescribeEcsClustersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEcsClusters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEcsClusters for more information on using the DescribeEcsClusters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEcsClustersRequest method.
//    req, resp := client.DescribeEcsClustersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeEcsClusters
func (c *OpsWorks) DescribeEcsClustersRequest(input *DescribeEcsClustersInput) (req *request.Request, output *DescribeEcsClustersOutput) {
	op := &request.Operation{
		Name:       opDescribeEcsClusters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEcsClustersInput{}
	}

	output = &DescribeEcsClustersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEcsClusters API operation for AWS OpsWorks.
//
// Describes Amazon ECS clusters that are registered with a stack. If you specify
// only a stack ID, you can use the MaxResults and NextToken parameters to paginate
// the response. However, AWS OpsWorks Stacks currently supports only one cluster
// per layer, so the result set has a maximum of one element.
//
// Required Permissions: To use this action, an IAM user must have a Show, Deploy,
// or Manage permissions level for the stack or an attached policy that explicitly
// grants permission. For more information about user permissions, see Managing
// User Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// This call accepts only one resource-identifying parameter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation DescribeEcsClusters for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeEcsClusters
func (c *OpsWorks) DescribeEcsClusters(input *DescribeEcsClustersInput) (*DescribeEcsClustersOutput, error) {
	req, out := c.DescribeEcsClustersRequest(input)
	return out, req.Send()
}

// DescribeEcsClustersWithContext is the same as DescribeEcsClusters with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEcsClusters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) DescribeEcsClustersWithContext(ctx aws.Context, input *DescribeEcsClustersInput, opts ...request.Option) (*DescribeEcsClustersOutput, error) {
	req, out := c.DescribeEcsClustersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeEcsClustersPages iterates over the pages of a DescribeEcsClusters operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeEcsClusters method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeEcsClusters operation.
//    pageNum := 0
//    err := client.DescribeEcsClustersPages(params,
//        func(page *opsworks.DescribeEcsClustersOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *OpsWorks) DescribeEcsClustersPages(input *DescribeEcsClustersInput, fn func(*DescribeEcsClustersOutput, bool) bool) error {
	return c.DescribeEcsClustersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeEcsClustersPagesWithContext same as DescribeEcsClustersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) DescribeEcsClustersPagesWithContext(ctx aws.Context, input *DescribeEcsClustersInput, fn func(*DescribeEcsClustersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeEcsClustersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeEcsClustersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeEcsClustersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeElasticIps = "DescribeElasticIps"

// DescribeElasticIpsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeElasticIps operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeElasticIps for more information on using the DescribeElasticIps
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeElasticIpsRequest method.
//    req, resp := client.DescribeElasticIpsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeElasticIps
func (c *OpsWorks) DescribeElasticIpsRequest(input *DescribeElasticIpsInput) (req *request.Request, output *DescribeElasticIpsOutput) {
	op := &request.Operation{
		Name:       opDescribeElasticIps,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeElasticIpsInput{}
	}

	output = &DescribeElasticIpsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeElasticIps API operation for AWS OpsWorks.
//
// Describes Elastic IP addresses (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html).
//
// This call accepts only one resource-identifying parameter.
//
// Required Permissions: To use this action, an IAM user must have a Show, Deploy,
// or Manage permissions level for the stack, or an attached policy that explicitly
// grants permissions. For more information about user permissions, see Managing
// User Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation DescribeElasticIps for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeElasticIps
func (c *OpsWorks) DescribeElasticIps(input *DescribeElasticIpsInput) (*DescribeElasticIpsOutput, error) {
	req, out := c.DescribeElasticIpsRequest(input)
	return out, req.Send()
}

// DescribeElasticIpsWithContext is the same as DescribeElasticIps with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeElasticIps for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) DescribeElasticIpsWithContext(ctx aws.Context, input *DescribeElasticIpsInput, opts ...request.Option) (*DescribeElasticIpsOutput, error) {
	req, out := c.DescribeElasticIpsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeElasticLoadBalancers = "DescribeElasticLoadBalancers"

// DescribeElasticLoadBalancersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeElasticLoadBalancers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeElasticLoadBalancers for more information on using the DescribeElasticLoadBalancers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeElasticLoadBalancersRequest method.
//    req, resp := client.DescribeElasticLoadBalancersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeElasticLoadBalancers
func (c *OpsWorks) DescribeElasticLoadBalancersRequest(input *DescribeElasticLoadBalancersInput) (req *request.Request, output *DescribeElasticLoadBalancersOutput) {
	op := &request.Operation{
		Name:       opDescribeElasticLoadBalancers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeElasticLoadBalancersInput{}
	}

	output = &DescribeElasticLoadBalancersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeElasticLoadBalancers API operation for AWS OpsWorks.
//
// Describes a stack's Elastic Load Balancing instances.
//
// This call accepts only one resource-identifying parameter.
//
// Required Permissions: To use this action, an IAM user must have a Show, Deploy,
// or Manage permissions level for the stack, or an attached policy that explicitly
// grants permissions. For more information about user permissions, see Managing
// User Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation DescribeElasticLoadBalancers for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeElasticLoadBalancers
func (c *OpsWorks) DescribeElasticLoadBalancers(input *DescribeElasticLoadBalancersInput) (*DescribeElasticLoadBalancersOutput, error) {
	req, out := c.DescribeElasticLoadBalancersRequest(input)
	return out, req.Send()
}

// DescribeElasticLoadBalancersWithContext is the same as DescribeElasticLoadBalancers with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeElasticLoadBalancers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) DescribeElasticLoadBalancersWithContext(ctx aws.Context, input *DescribeElasticLoadBalancersInput, opts ...request.Option) (*DescribeElasticLoadBalancersOutput, error) {
	req, out := c.DescribeElasticLoadBalancersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeInstances = "DescribeInstances"

// DescribeInstancesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInstances for more information on using the DescribeInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeInstancesRequest method.
//    req, resp := client.DescribeInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeInstances
func (c *OpsWorks) DescribeInstancesRequest(input *DescribeInstancesInput) (req *request.Request, output *DescribeInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeInstancesInput{}
	}

	output = &DescribeInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInstances API operation for AWS OpsWorks.
//
// Requests a description of a set of instances.
//
// This call accepts only one resource-identifying parameter.
//
// Required Permissions: To use this action, an IAM user must have a Show, Deploy,
// or Manage permissions level for the stack, or an attached policy that explicitly
// grants permissions. For more information about user permissions, see Managing
// User Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation DescribeInstances for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeInstances
func (c *OpsWorks) DescribeInstances(input *DescribeInstancesInput) (*DescribeInstancesOutput, error) {
	req, out := c.DescribeInstancesRequest(input)
	return out, req.Send()
}

// DescribeInstancesWithContext is the same as DescribeInstances with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) DescribeInstancesWithContext(ctx aws.Context, input *DescribeInstancesInput, opts ...request.Option) (*DescribeInstancesOutput, error) {
	req, out := c.DescribeInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeLayers = "DescribeLayers"

// DescribeLayersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLayers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLayers for more information on using the DescribeLayers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeLayersRequest method.
//    req, resp := client.DescribeLayersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeLayers
func (c *OpsWorks) DescribeLayersRequest(input *DescribeLayersInput) (req *request.Request, output *DescribeLayersOutput) {
	op := &request.Operation{
		Name:       opDescribeLayers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLayersInput{}
	}

	output = &DescribeLayersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLayers API operation for AWS OpsWorks.
//
// Requests a description of one or more layers in a specified stack.
//
// This call accepts only one resource-identifying parameter.
//
// Required Permissions: To use this action, an IAM user must have a Show, Deploy,
// or Manage permissions level for the stack, or an attached policy that explicitly
// grants permissions. For more information about user permissions, see Managing
// User Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation DescribeLayers for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeLayers
func (c *OpsWorks) DescribeLayers(input *DescribeLayersInput) (*DescribeLayersOutput, error) {
	req, out := c.DescribeLayersRequest(input)
	return out, req.Send()
}

// DescribeLayersWithContext is the same as DescribeLayers with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLayers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) DescribeLayersWithContext(ctx aws.Context, input *DescribeLayersInput, opts ...request.Option) (*DescribeLayersOutput, error) {
	req, out := c.DescribeLayersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeLoadBasedAutoScaling = "DescribeLoadBasedAutoScaling"

// DescribeLoadBasedAutoScalingRequest generates a "aws/request.Request" representing the
// client's request for the DescribeLoadBasedAutoScaling operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeLoadBasedAutoScaling for more information on using the DescribeLoadBasedAutoScaling
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeLoadBasedAutoScalingRequest method.
//    req, resp := client.DescribeLoadBasedAutoScalingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeLoadBasedAutoScaling
func (c *OpsWorks) DescribeLoadBasedAutoScalingRequest(input *DescribeLoadBasedAutoScalingInput) (req *request.Request, output *DescribeLoadBasedAutoScalingOutput) {
	op := &request.Operation{
		Name:       opDescribeLoadBasedAutoScaling,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLoadBasedAutoScalingInput{}
	}

	output = &DescribeLoadBasedAutoScalingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeLoadBasedAutoScaling API operation for AWS OpsWorks.
//
// Describes load-based auto scaling configurations for specified layers.
//
// You must specify at least one of the parameters.
//
// Required Permissions: To use this action, an IAM user must have a Show, Deploy,
// or Manage permissions level for the stack, or an attached policy that explicitly
// grants permissions. For more information about user permissions, see Managing
// User Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation DescribeLoadBasedAutoScaling for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeLoadBasedAutoScaling
func (c *OpsWorks) DescribeLoadBasedAutoScaling(input *DescribeLoadBasedAutoScalingInput) (*DescribeLoadBasedAutoScalingOutput, error) {
	req, out := c.DescribeLoadBasedAutoScalingRequest(input)
	return out, req.Send()
}

// DescribeLoadBasedAutoScalingWithContext is the same as DescribeLoadBasedAutoScaling with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeLoadBasedAutoScaling for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) DescribeLoadBasedAutoScalingWithContext(ctx aws.Context, input *DescribeLoadBasedAutoScalingInput, opts ...request.Option) (*DescribeLoadBasedAutoScalingOutput, error) {
	req, out := c.DescribeLoadBasedAutoScalingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeMyUserProfile = "DescribeMyUserProfile"

// DescribeMyUserProfileRequest generates a "aws/request.Request" representing the
// client's request for the DescribeMyUserProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeMyUserProfile for more information on using the DescribeMyUserProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeMyUserProfileRequest method.
//    req, resp := client.DescribeMyUserProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeMyUserProfile
func (c *OpsWorks) DescribeMyUserProfileRequest(input *DescribeMyUserProfileInput) (req *request.Request, output *DescribeMyUserProfileOutput) {
	op := &request.Operation{
		Name:       opDescribeMyUserProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeMyUserProfileInput{}
	}

	output = &DescribeMyUserProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeMyUserProfile API operation for AWS OpsWorks.
//
// Describes a user's SSH information.
//
// Required Permissions: To use this action, an IAM user must have self-management
// enabled or an attached policy that explicitly grants permissions. For more
// information about user permissions, see Managing User Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation DescribeMyUserProfile for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeMyUserProfile
func (c *OpsWorks) DescribeMyUserProfile(input *DescribeMyUserProfileInput) (*DescribeMyUserProfileOutput, error) {
	req, out := c.DescribeMyUserProfileRequest(input)
	return out, req.Send()
}

// DescribeMyUserProfileWithContext is the same as DescribeMyUserProfile with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeMyUserProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) DescribeMyUserProfileWithContext(ctx aws.Context, input *DescribeMyUserProfileInput, opts ...request.Option) (*DescribeMyUserProfileOutput, error) {
	req, out := c.DescribeMyUserProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeOperatingSystems = "DescribeOperatingSystems"

// DescribeOperatingSystemsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeOperatingSystems operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeOperatingSystems for more information on using the DescribeOperatingSystems
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeOperatingSystemsRequest method.
//    req, resp := client.DescribeOperatingSystemsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeOperatingSystems
func (c *OpsWorks) DescribeOperatingSystemsRequest(input *DescribeOperatingSystemsInput) (req *request.Request, output *DescribeOperatingSystemsOutput) {
	op := &request.Operation{
		Name:       opDescribeOperatingSystems,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeOperatingSystemsInput{}
	}

	output = &DescribeOperatingSystemsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeOperatingSystems API operation for AWS OpsWorks.
//
// Describes the operating systems that are supported by AWS OpsWorks Stacks.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation DescribeOperatingSystems for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeOperatingSystems
func (c *OpsWorks) DescribeOperatingSystems(input *DescribeOperatingSystemsInput) (*DescribeOperatingSystemsOutput, error) {
	req, out := c.DescribeOperatingSystemsRequest(input)
	return out, req.Send()
}

// DescribeOperatingSystemsWithContext is the same as DescribeOperatingSystems with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeOperatingSystems for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) DescribeOperatingSystemsWithContext(ctx aws.Context, input *DescribeOperatingSystemsInput, opts ...request.Option) (*DescribeOperatingSystemsOutput, error) {
	req, out := c.DescribeOperatingSystemsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribePermissions = "DescribePermissions"

// DescribePermissionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribePermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePermissions for more information on using the DescribePermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribePermissionsRequest method.
//    req, resp := client.DescribePermissionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribePermissions
func (c *OpsWorks) DescribePermissionsRequest(input *DescribePermissionsInput) (req *request.Request, output *DescribePermissionsOutput) {
	op := &request.Operation{
		Name:       opDescribePermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribePermissionsInput{}
	}

	output = &DescribePermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePermissions API operation for AWS OpsWorks.
//
// Describes the permissions for a specified stack.
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation DescribePermissions for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribePermissions
func (c *OpsWorks) DescribePermissions(input *DescribePermissionsInput) (*DescribePermissionsOutput, error) {
	req, out := c.DescribePermissionsRequest(input)
	return out, req.Send()
}

// DescribePermissionsWithContext is the same as DescribePermissions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) DescribePermissionsWithContext(ctx aws.Context, input *DescribePermissionsInput, opts ...request.Option) (*DescribePermissionsOutput, error) {
	req, out := c.DescribePermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeRaidArrays = "DescribeRaidArrays"

// DescribeRaidArraysRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRaidArrays operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRaidArrays for more information on using the DescribeRaidArrays
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeRaidArraysRequest method.
//    req, resp := client.DescribeRaidArraysRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeRaidArrays
func (c *OpsWorks) DescribeRaidArraysRequest(input *DescribeRaidArraysInput) (req *request.Request, output *DescribeRaidArraysOutput) {
	op := &request.Operation{
		Name:       opDescribeRaidArrays,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeRaidArraysInput{}
	}

	output = &DescribeRaidArraysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRaidArrays API operation for AWS OpsWorks.
//
// Describe an instance's RAID arrays.
//
// This call accepts only one resource-identifying parameter.
//
// Required Permissions: To use this action, an IAM user must have a Show, Deploy,
// or Manage permissions level for the stack, or an attached policy that explicitly
// grants permissions. For more information about user permissions, see Managing
// User Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation DescribeRaidArrays for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeRaidArrays
func (c *OpsWorks) DescribeRaidArrays(input *DescribeRaidArraysInput) (*DescribeRaidArraysOutput, error) {
	req, out := c.DescribeRaidArraysRequest(input)
	return out, req.Send()
}

// DescribeRaidArraysWithContext is the same as DescribeRaidArrays with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRaidArrays for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) DescribeRaidArraysWithContext(ctx aws.Context, input *DescribeRaidArraysInput, opts ...request.Option) (*DescribeRaidArraysOutput, error) {
	req, out := c.DescribeRaidArraysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeRdsDbInstances = "DescribeRdsDbInstances"

// DescribeRdsDbInstancesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRdsDbInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRdsDbInstances for more information on using the DescribeRdsDbInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeRdsDbInstancesRequest method.
//    req, resp := client.DescribeRdsDbInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeRdsDbInstances
func (c *OpsWorks) DescribeRdsDbInstancesRequest(input *DescribeRdsDbInstancesInput) (req *request.Request, output *DescribeRdsDbInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeRdsDbInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeRdsDbInstancesInput{}
	}

	output = &DescribeRdsDbInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRdsDbInstances API operation for AWS OpsWorks.
//
// Describes Amazon RDS instances.
//
// Required Permissions: To use this action, an IAM user must have a Show, Deploy,
// or Manage permissions level for the stack, or an attached policy that explicitly
// grants permissions. For more information about user permissions, see Managing
// User Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// This call accepts only one resource-identifying parameter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation DescribeRdsDbInstances for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeRdsDbInstances
func (c *OpsWorks) DescribeRdsDbInstances(input *DescribeRdsDbInstancesInput) (*DescribeRdsDbInstancesOutput, error) {
	req, out := c.DescribeRdsDbInstancesRequest(input)
	return out, req.Send()
}

// DescribeRdsDbInstancesWithContext is the same as DescribeRdsDbInstances with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRdsDbInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) DescribeRdsDbInstancesWithContext(ctx aws.Context, input *DescribeRdsDbInstancesInput, opts ...request.Option) (*DescribeRdsDbInstancesOutput, error) {
	req, out := c.DescribeRdsDbInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeServiceErrors = "DescribeServiceErrors"

// DescribeServiceErrorsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeServiceErrors operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeServiceErrors for more information on using the DescribeServiceErrors
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeServiceErrorsRequest method.
//    req, resp := client.DescribeServiceErrorsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeServiceErrors
func (c *OpsWorks) DescribeServiceErrorsRequest(input *DescribeServiceErrorsInput) (req *request.Request, output *DescribeServiceErrorsOutput) {
	op := &request.Operation{
		Name:       opDescribeServiceErrors,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeServiceErrorsInput{}
	}

	output = &DescribeServiceErrorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeServiceErrors API operation for AWS OpsWorks.
//
// Describes AWS OpsWorks Stacks service errors.
//
// Required Permissions: To use this action, an IAM user must have a Show, Deploy,
// or Manage permissions level for the stack, or an attached policy that explicitly
// grants permissions. For more information about user permissions, see Managing
// User Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// This call accepts only one resource-identifying parameter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation DescribeServiceErrors for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeServiceErrors
func (c *OpsWorks) DescribeServiceErrors(input *DescribeServiceErrorsInput) (*DescribeServiceErrorsOutput, error) {
	req, out := c.DescribeServiceErrorsRequest(input)
	return out, req.Send()
}

// DescribeServiceErrorsWithContext is the same as DescribeServiceErrors with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeServiceErrors for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) DescribeServiceErrorsWithContext(ctx aws.Context, input *DescribeServiceErrorsInput, opts ...request.Option) (*DescribeServiceErrorsOutput, error) {
	req, out := c.DescribeServiceErrorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeStackProvisioningParameters = "DescribeStackProvisioningParameters"

// DescribeStackProvisioningParametersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStackProvisioningParameters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeStackProvisioningParameters for more information on using the DescribeStackProvisioningParameters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeStackProvisioningParametersRequest method.
//    req, resp := client.DescribeStackProvisioningParametersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeStackProvisioningParameters
func (c *OpsWorks) DescribeStackProvisioningParametersRequest(input *DescribeStackProvisioningParametersInput) (req *request.Request, output *DescribeStackProvisioningParametersOutput) {
	op := &request.Operation{
		Name:       opDescribeStackProvisioningParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStackProvisioningParametersInput{}
	}

	output = &DescribeStackProvisioningParametersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStackProvisioningParameters API operation for AWS OpsWorks.
//
// Requests a description of a stack's provisioning parameters.
//
// Required Permissions: To use this action, an IAM user must have a Show, Deploy,
// or Manage permissions level for the stack or an attached policy that explicitly
// grants permissions. For more information about user permissions, see Managing
// User Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation DescribeStackProvisioningParameters for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeStackProvisioningParameters
func (c *OpsWorks) DescribeStackProvisioningParameters(input *DescribeStackProvisioningParametersInput) (*DescribeStackProvisioningParametersOutput, error) {
	req, out := c.DescribeStackProvisioningParametersRequest(input)
	return out, req.Send()
}

// DescribeStackProvisioningParametersWithContext is the same as DescribeStackProvisioningParameters with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStackProvisioningParameters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) DescribeStackProvisioningParametersWithContext(ctx aws.Context, input *DescribeStackProvisioningParametersInput, opts ...request.Option) (*DescribeStackProvisioningParametersOutput, error) {
	req, out := c.DescribeStackProvisioningParametersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeStackSummary = "DescribeStackSummary"

// DescribeStackSummaryRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStackSummary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeStackSummary for more information on using the DescribeStackSummary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeStackSummaryRequest method.
//    req, resp := client.DescribeStackSummaryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeStackSummary
func (c *OpsWorks) DescribeStackSummaryRequest(input *DescribeStackSummaryInput) (req *request.Request, output *DescribeStackSummaryOutput) {
	op := &request.Operation{
		Name:       opDescribeStackSummary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStackSummaryInput{}
	}

	output = &DescribeStackSummaryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStackSummary API operation for AWS OpsWorks.
//
// Describes the number of layers and apps in a specified stack, and the number
// of instances in each state, such as running_setup or online.
//
// Required Permissions: To use this action, an IAM user must have a Show, Deploy,
// or Manage permissions level for the stack, or an attached policy that explicitly
// grants permissions. For more information about user permissions, see Managing
// User Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation DescribeStackSummary for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeStackSummary
func (c *OpsWorks) DescribeStackSummary(input *DescribeStackSummaryInput) (*DescribeStackSummaryOutput, error) {
	req, out := c.DescribeStackSummaryRequest(input)
	return out, req.Send()
}

// DescribeStackSummaryWithContext is the same as DescribeStackSummary with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStackSummary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) DescribeStackSummaryWithContext(ctx aws.Context, input *DescribeStackSummaryInput, opts ...request.Option) (*DescribeStackSummaryOutput, error) {
	req, out := c.DescribeStackSummaryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeStacks = "DescribeStacks"

// DescribeStacksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeStacks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeStacks for more information on using the DescribeStacks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeStacksRequest method.
//    req, resp := client.DescribeStacksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeStacks
func (c *OpsWorks) DescribeStacksRequest(input *DescribeStacksInput) (req *request.Request, output *DescribeStacksOutput) {
	op := &request.Operation{
		Name:       opDescribeStacks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStacksInput{}
	}

	output = &DescribeStacksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeStacks API operation for AWS OpsWorks.
//
// Requests a description of one or more stacks.
//
// Required Permissions: To use this action, an IAM user must have a Show, Deploy,
// or Manage permissions level for the stack, or an attached policy that explicitly
// grants permissions. For more information about user permissions, see Managing
// User Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation DescribeStacks for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeStacks
func (c *OpsWorks) DescribeStacks(input *DescribeStacksInput) (*DescribeStacksOutput, error) {
	req, out := c.DescribeStacksRequest(input)
	return out, req.Send()
}

// DescribeStacksWithContext is the same as DescribeStacks with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeStacks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) DescribeStacksWithContext(ctx aws.Context, input *DescribeStacksInput, opts ...request.Option) (*DescribeStacksOutput, error) {
	req, out := c.DescribeStacksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTimeBasedAutoScaling = "DescribeTimeBasedAutoScaling"

// DescribeTimeBasedAutoScalingRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTimeBasedAutoScaling operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTimeBasedAutoScaling for more information on using the DescribeTimeBasedAutoScaling
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTimeBasedAutoScalingRequest method.
//    req, resp := client.DescribeTimeBasedAutoScalingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeTimeBasedAutoScaling
func (c *OpsWorks) DescribeTimeBasedAutoScalingRequest(input *DescribeTimeBasedAutoScalingInput) (req *request.Request, output *DescribeTimeBasedAutoScalingOutput) {
	op := &request.Operation{
		Name:       opDescribeTimeBasedAutoScaling,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTimeBasedAutoScalingInput{}
	}

	output = &DescribeTimeBasedAutoScalingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTimeBasedAutoScaling API operation for AWS OpsWorks.
//
// Describes time-based auto scaling configurations for specified instances.
//
// You must specify at least one of the parameters.
//
// Required Permissions: To use this action, an IAM user must have a Show, Deploy,
// or Manage permissions level for the stack, or an attached policy that explicitly
// grants permissions. For more information about user permissions, see Managing
// User Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation DescribeTimeBasedAutoScaling for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeTimeBasedAutoScaling
func (c *OpsWorks) DescribeTimeBasedAutoScaling(input *DescribeTimeBasedAutoScalingInput) (*DescribeTimeBasedAutoScalingOutput, error) {
	req, out := c.DescribeTimeBasedAutoScalingRequest(input)
	return out, req.Send()
}

// DescribeTimeBasedAutoScalingWithContext is the same as DescribeTimeBasedAutoScaling with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTimeBasedAutoScaling for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) DescribeTimeBasedAutoScalingWithContext(ctx aws.Context, input *DescribeTimeBasedAutoScalingInput, opts ...request.Option) (*DescribeTimeBasedAutoScalingOutput, error) {
	req, out := c.DescribeTimeBasedAutoScalingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeUserProfiles = "DescribeUserProfiles"

// DescribeUserProfilesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeUserProfiles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeUserProfiles for more information on using the DescribeUserProfiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeUserProfilesRequest method.
//    req, resp := client.DescribeUserProfilesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeUserProfiles
func (c *OpsWorks) DescribeUserProfilesRequest(input *DescribeUserProfilesInput) (req *request.Request, output *DescribeUserProfilesOutput) {
	op := &request.Operation{
		Name:       opDescribeUserProfiles,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeUserProfilesInput{}
	}

	output = &DescribeUserProfilesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeUserProfiles API operation for AWS OpsWorks.
//
// Describe specified users.
//
// Required Permissions: To use this action, an IAM user must have an attached
// policy that explicitly grants permissions. For more information about user
// permissions, see Managing User Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation DescribeUserProfiles for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeUserProfiles
func (c *OpsWorks) DescribeUserProfiles(input *DescribeUserProfilesInput) (*DescribeUserProfilesOutput, error) {
	req, out := c.DescribeUserProfilesRequest(input)
	return out, req.Send()
}

// DescribeUserProfilesWithContext is the same as DescribeUserProfiles with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeUserProfiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) DescribeUserProfilesWithContext(ctx aws.Context, input *DescribeUserProfilesInput, opts ...request.Option) (*DescribeUserProfilesOutput, error) {
	req, out := c.DescribeUserProfilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeVolumes = "DescribeVolumes"

// DescribeVolumesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeVolumes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeVolumes for more information on using the DescribeVolumes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeVolumesRequest method.
//    req, resp := client.DescribeVolumesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeVolumes
func (c *OpsWorks) DescribeVolumesRequest(input *DescribeVolumesInput) (req *request.Request, output *DescribeVolumesOutput) {
	op := &request.Operation{
		Name:       opDescribeVolumes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeVolumesInput{}
	}

	output = &DescribeVolumesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeVolumes API operation for AWS OpsWorks.
//
// Describes an instance's Amazon EBS volumes.
//
// This call accepts only one resource-identifying parameter.
//
// Required Permissions: To use this action, an IAM user must have a Show, Deploy,
// or Manage permissions level for the stack, or an attached policy that explicitly
// grants permissions. For more information about user permissions, see Managing
// User Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation DescribeVolumes for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DescribeVolumes
func (c *OpsWorks) DescribeVolumes(input *DescribeVolumesInput) (*DescribeVolumesOutput, error) {
	req, out := c.DescribeVolumesRequest(input)
	return out, req.Send()
}

// DescribeVolumesWithContext is the same as DescribeVolumes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeVolumes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) DescribeVolumesWithContext(ctx aws.Context, input *DescribeVolumesInput, opts ...request.Option) (*DescribeVolumesOutput, error) {
	req, out := c.DescribeVolumesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetachElasticLoadBalancer = "DetachElasticLoadBalancer"

// DetachElasticLoadBalancerRequest generates a "aws/request.Request" representing the
// client's request for the DetachElasticLoadBalancer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetachElasticLoadBalancer for more information on using the DetachElasticLoadBalancer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetachElasticLoadBalancerRequest method.
//    req, resp := client.DetachElasticLoadBalancerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DetachElasticLoadBalancer
func (c *OpsWorks) DetachElasticLoadBalancerRequest(input *DetachElasticLoadBalancerInput) (req *request.Request, output *DetachElasticLoadBalancerOutput) {
	op := &request.Operation{
		Name:       opDetachElasticLoadBalancer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetachElasticLoadBalancerInput{}
	}

	output = &DetachElasticLoadBalancerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DetachElasticLoadBalancer API operation for AWS OpsWorks.
//
// Detaches a specified Elastic Load Balancing instance from its layer.
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation DetachElasticLoadBalancer for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DetachElasticLoadBalancer
func (c *OpsWorks) DetachElasticLoadBalancer(input *DetachElasticLoadBalancerInput) (*DetachElasticLoadBalancerOutput, error) {
	req, out := c.DetachElasticLoadBalancerRequest(input)
	return out, req.Send()
}

// DetachElasticLoadBalancerWithContext is the same as DetachElasticLoadBalancer with the addition of
// the ability to pass a context and additional request options.
//
// See DetachElasticLoadBalancer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) DetachElasticLoadBalancerWithContext(ctx aws.Context, input *DetachElasticLoadBalancerInput, opts ...request.Option) (*DetachElasticLoadBalancerOutput, error) {
	req, out := c.DetachElasticLoadBalancerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateElasticIp = "DisassociateElasticIp"

// DisassociateElasticIpRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateElasticIp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateElasticIp for more information on using the DisassociateElasticIp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateElasticIpRequest method.
//    req, resp := client.DisassociateElasticIpRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DisassociateElasticIp
func (c *OpsWorks) DisassociateElasticIpRequest(input *DisassociateElasticIpInput) (req *request.Request, output *DisassociateElasticIpOutput) {
	op := &request.Operation{
		Name:       opDisassociateElasticIp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateElasticIpInput{}
	}

	output = &DisassociateElasticIpOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateElasticIp API operation for AWS OpsWorks.
//
// Disassociates an Elastic IP address from its instance. The address remains
// registered with the stack. For more information, see Resource Management
// (https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation DisassociateElasticIp for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DisassociateElasticIp
func (c *OpsWorks) DisassociateElasticIp(input *DisassociateElasticIpInput) (*DisassociateElasticIpOutput, error) {
	req, out := c.DisassociateElasticIpRequest(input)
	return out, req.Send()
}

// DisassociateElasticIpWithContext is the same as DisassociateElasticIp with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateElasticIp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) DisassociateElasticIpWithContext(ctx aws.Context, input *DisassociateElasticIpInput, opts ...request.Option) (*DisassociateElasticIpOutput, error) {
	req, out := c.DisassociateElasticIpRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetHostnameSuggestion = "GetHostnameSuggestion"

// GetHostnameSuggestionRequest generates a "aws/request.Request" representing the
// client's request for the GetHostnameSuggestion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetHostnameSuggestion for more information on using the GetHostnameSuggestion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetHostnameSuggestionRequest method.
//    req, resp := client.GetHostnameSuggestionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/GetHostnameSuggestion
func (c *OpsWorks) GetHostnameSuggestionRequest(input *GetHostnameSuggestionInput) (req *request.Request, output *GetHostnameSuggestionOutput) {
	op := &request.Operation{
		Name:       opGetHostnameSuggestion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetHostnameSuggestionInput{}
	}

	output = &GetHostnameSuggestionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetHostnameSuggestion API operation for AWS OpsWorks.
//
// Gets a generated host name for the specified layer, based on the current
// host name theme.
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation GetHostnameSuggestion for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/GetHostnameSuggestion
func (c *OpsWorks) GetHostnameSuggestion(input *GetHostnameSuggestionInput) (*GetHostnameSuggestionOutput, error) {
	req, out := c.GetHostnameSuggestionRequest(input)
	return out, req.Send()
}

// GetHostnameSuggestionWithContext is the same as GetHostnameSuggestion with the addition of
// the ability to pass a context and additional request options.
//
// See GetHostnameSuggestion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) GetHostnameSuggestionWithContext(ctx aws.Context, input *GetHostnameSuggestionInput, opts ...request.Option) (*GetHostnameSuggestionOutput, error) {
	req, out := c.GetHostnameSuggestionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGrantAccess = "GrantAccess"

// GrantAccessRequest generates a "aws/request.Request" representing the
// client's request for the GrantAccess operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GrantAccess for more information on using the GrantAccess
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GrantAccessRequest method.
//    req, resp := client.GrantAccessRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/GrantAccess
func (c *OpsWorks) GrantAccessRequest(input *GrantAccessInput) (req *request.Request, output *GrantAccessOutput) {
	op := &request.Operation{
		Name:       opGrantAccess,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GrantAccessInput{}
	}

	output = &GrantAccessOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GrantAccess API operation for AWS OpsWorks.
//
//
// This action can be used only with Windows stacks.
//
// Grants RDP access to a Windows instance for a specified time period.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation GrantAccess for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/GrantAccess
func (c *OpsWorks) GrantAccess(input *GrantAccessInput) (*GrantAccessOutput, error) {
	req, out := c.GrantAccessRequest(input)
	return out, req.Send()
}

// GrantAccessWithContext is the same as GrantAccess with the addition of
// the ability to pass a context and additional request options.
//
// See GrantAccess for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) GrantAccessWithContext(ctx aws.Context, input *GrantAccessInput, opts ...request.Option) (*GrantAccessOutput, error) {
	req, out := c.GrantAccessRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTags = "ListTags"

// ListTagsRequest generates a "aws/request.Request" representing the
// client's request for the ListTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTags for more information on using the ListTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsRequest method.
//    req, resp := client.ListTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/ListTags
func (c *OpsWorks) ListTagsRequest(input *ListTagsInput) (req *request.Request, output *ListTagsOutput) {
	op := &request.Operation{
		Name:       opListTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsInput{}
	}

	output = &ListTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTags API operation for AWS OpsWorks.
//
// Returns a list of tags that are applied to the specified stack or layer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation ListTags for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/ListTags
func (c *OpsWorks) ListTags(input *ListTagsInput) (*ListTagsOutput, error) {
	req, out := c.ListTagsRequest(input)
	return out, req.Send()
}

// ListTagsWithContext is the same as ListTags with the addition of
// the ability to pass a context and additional request options.
//
// See ListTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) ListTagsWithContext(ctx aws.Context, input *ListTagsInput, opts ...request.Option) (*ListTagsOutput, error) {
	req, out := c.ListTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRebootInstance = "RebootInstance"

// RebootInstanceRequest generates a "aws/request.Request" representing the
// client's request for the RebootInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RebootInstance for more information on using the RebootInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RebootInstanceRequest method.
//    req, resp := client.RebootInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/RebootInstance
func (c *OpsWorks) RebootInstanceRequest(input *RebootInstanceInput) (req *request.Request, output *RebootInstanceOutput) {
	op := &request.Operation{
		Name:       opRebootInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RebootInstanceInput{}
	}

	output = &RebootInstanceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RebootInstance API operation for AWS OpsWorks.
//
// Reboots a specified instance. For more information, see Starting, Stopping,
// and Rebooting Instances (https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-starting.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation RebootInstance for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/RebootInstance
func (c *OpsWorks) RebootInstance(input *RebootInstanceInput) (*RebootInstanceOutput, error) {
	req, out := c.RebootInstanceRequest(input)
	return out, req.Send()
}

// RebootInstanceWithContext is the same as RebootInstance with the addition of
// the ability to pass a context and additional request options.
//
// See RebootInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) RebootInstanceWithContext(ctx aws.Context, input *RebootInstanceInput, opts ...request.Option) (*RebootInstanceOutput, error) {
	req, out := c.RebootInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterEcsCluster = "RegisterEcsCluster"

// RegisterEcsClusterRequest generates a "aws/request.Request" representing the
// client's request for the RegisterEcsCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterEcsCluster for more information on using the RegisterEcsCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RegisterEcsClusterRequest method.
//    req, resp := client.RegisterEcsClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/RegisterEcsCluster
func (c *OpsWorks) RegisterEcsClusterRequest(input *RegisterEcsClusterInput) (req *request.Request, output *RegisterEcsClusterOutput) {
	op := &request.Operation{
		Name:       opRegisterEcsCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterEcsClusterInput{}
	}

	output = &RegisterEcsClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterEcsCluster API operation for AWS OpsWorks.
//
// Registers a specified Amazon ECS cluster with a stack. You can register only
// one cluster with a stack. A cluster can be registered with only one stack.
// For more information, see Resource Management (https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-ecscluster.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation RegisterEcsCluster for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/RegisterEcsCluster
func (c *OpsWorks) RegisterEcsCluster(input *RegisterEcsClusterInput) (*RegisterEcsClusterOutput, error) {
	req, out := c.RegisterEcsClusterRequest(input)
	return out, req.Send()
}

// RegisterEcsClusterWithContext is the same as RegisterEcsCluster with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterEcsCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) RegisterEcsClusterWithContext(ctx aws.Context, input *RegisterEcsClusterInput, opts ...request.Option) (*RegisterEcsClusterOutput, error) {
	req, out := c.RegisterEcsClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterElasticIp = "RegisterElasticIp"

// RegisterElasticIpRequest generates a "aws/request.Request" representing the
// client's request for the RegisterElasticIp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterElasticIp for more information on using the RegisterElasticIp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RegisterElasticIpRequest method.
//    req, resp := client.RegisterElasticIpRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/RegisterElasticIp
func (c *OpsWorks) RegisterElasticIpRequest(input *RegisterElasticIpInput) (req *request.Request, output *RegisterElasticIpOutput) {
	op := &request.Operation{
		Name:       opRegisterElasticIp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterElasticIpInput{}
	}

	output = &RegisterElasticIpOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterElasticIp API operation for AWS OpsWorks.
//
// Registers an Elastic IP address with a specified stack. An address can be
// registered with only one stack at a time. If the address is already registered,
// you must first deregister it by calling DeregisterElasticIp. For more information,
// see Resource Management (https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation RegisterElasticIp for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/RegisterElasticIp
func (c *OpsWorks) RegisterElasticIp(input *RegisterElasticIpInput) (*RegisterElasticIpOutput, error) {
	req, out := c.RegisterElasticIpRequest(input)
	return out, req.Send()
}

// RegisterElasticIpWithContext is the same as RegisterElasticIp with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterElasticIp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) RegisterElasticIpWithContext(ctx aws.Context, input *RegisterElasticIpInput, opts ...request.Option) (*RegisterElasticIpOutput, error) {
	req, out := c.RegisterElasticIpRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterInstance = "RegisterInstance"

// RegisterInstanceRequest generates a "aws/request.Request" representing the
// client's request for the RegisterInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterInstance for more information on using the RegisterInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RegisterInstanceRequest method.
//    req, resp := client.RegisterInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/RegisterInstance
func (c *OpsWorks) RegisterInstanceRequest(input *RegisterInstanceInput) (req *request.Request, output *RegisterInstanceOutput) {
	op := &request.Operation{
		Name:       opRegisterInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterInstanceInput{}
	}

	output = &RegisterInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterInstance API operation for AWS OpsWorks.
//
// Registers instances that were created outside of AWS OpsWorks Stacks with
// a specified stack.
//
// We do not recommend using this action to register instances. The complete
// registration operation includes two tasks: installing the AWS OpsWorks Stacks
// agent on the instance, and registering the instance with the stack. RegisterInstance
// handles only the second step. You should instead use the AWS CLI register
// command, which performs the entire registration operation. For more information,
// see Registering an Instance with an AWS OpsWorks Stacks Stack (https://docs.aws.amazon.com/opsworks/latest/userguide/registered-instances-register.html).
//
// Registered instances have the same requirements as instances that are created
// by using the CreateInstance API. For example, registered instances must be
// running a supported Linux-based operating system, and they must have a supported
// instance type. For more information about requirements for instances that
// you want to register, see Preparing the Instance (https://docs.aws.amazon.com/opsworks/latest/userguide/registered-instances-register-registering-preparer.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation RegisterInstance for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/RegisterInstance
func (c *OpsWorks) RegisterInstance(input *RegisterInstanceInput) (*RegisterInstanceOutput, error) {
	req, out := c.RegisterInstanceRequest(input)
	return out, req.Send()
}

// RegisterInstanceWithContext is the same as RegisterInstance with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) RegisterInstanceWithContext(ctx aws.Context, input *RegisterInstanceInput, opts ...request.Option) (*RegisterInstanceOutput, error) {
	req, out := c.RegisterInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterRdsDbInstance = "RegisterRdsDbInstance"

// RegisterRdsDbInstanceRequest generates a "aws/request.Request" representing the
// client's request for the RegisterRdsDbInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterRdsDbInstance for more information on using the RegisterRdsDbInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RegisterRdsDbInstanceRequest method.
//    req, resp := client.RegisterRdsDbInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/RegisterRdsDbInstance
func (c *OpsWorks) RegisterRdsDbInstanceRequest(input *RegisterRdsDbInstanceInput) (req *request.Request, output *RegisterRdsDbInstanceOutput) {
	op := &request.Operation{
		Name:       opRegisterRdsDbInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterRdsDbInstanceInput{}
	}

	output = &RegisterRdsDbInstanceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RegisterRdsDbInstance API operation for AWS OpsWorks.
//
// Registers an Amazon RDS instance with a stack.
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation RegisterRdsDbInstance for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/RegisterRdsDbInstance
func (c *OpsWorks) RegisterRdsDbInstance(input *RegisterRdsDbInstanceInput) (*RegisterRdsDbInstanceOutput, error) {
	req, out := c.RegisterRdsDbInstanceRequest(input)
	return out, req.Send()
}

// RegisterRdsDbInstanceWithContext is the same as RegisterRdsDbInstance with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterRdsDbInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) RegisterRdsDbInstanceWithContext(ctx aws.Context, input *RegisterRdsDbInstanceInput, opts ...request.Option) (*RegisterRdsDbInstanceOutput, error) {
	req, out := c.RegisterRdsDbInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterVolume = "RegisterVolume"

// RegisterVolumeRequest generates a "aws/request.Request" representing the
// client's request for the RegisterVolume operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterVolume for more information on using the RegisterVolume
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RegisterVolumeRequest method.
//    req, resp := client.RegisterVolumeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/RegisterVolume
func (c *OpsWorks) RegisterVolumeRequest(input *RegisterVolumeInput) (req *request.Request, output *RegisterVolumeOutput) {
	op := &request.Operation{
		Name:       opRegisterVolume,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterVolumeInput{}
	}

	output = &RegisterVolumeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterVolume API operation for AWS OpsWorks.
//
// Registers an Amazon EBS volume with a specified stack. A volume can be registered
// with only one stack at a time. If the volume is already registered, you must
// first deregister it by calling DeregisterVolume. For more information, see
// Resource Management (https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation RegisterVolume for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/RegisterVolume
func (c *OpsWorks) RegisterVolume(input *RegisterVolumeInput) (*RegisterVolumeOutput, error) {
	req, out := c.RegisterVolumeRequest(input)
	return out, req.Send()
}

// RegisterVolumeWithContext is the same as RegisterVolume with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterVolume for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) RegisterVolumeWithContext(ctx aws.Context, input *RegisterVolumeInput, opts ...request.Option) (*RegisterVolumeOutput, error) {
	req, out := c.RegisterVolumeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetLoadBasedAutoScaling = "SetLoadBasedAutoScaling"

// SetLoadBasedAutoScalingRequest generates a "aws/request.Request" representing the
// client's request for the SetLoadBasedAutoScaling operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetLoadBasedAutoScaling for more information on using the SetLoadBasedAutoScaling
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SetLoadBasedAutoScalingRequest method.
//    req, resp := client.SetLoadBasedAutoScalingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/SetLoadBasedAutoScaling
func (c *OpsWorks) SetLoadBasedAutoScalingRequest(input *SetLoadBasedAutoScalingInput) (req *request.Request, output *SetLoadBasedAutoScalingOutput) {
	op := &request.Operation{
		Name:       opSetLoadBasedAutoScaling,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetLoadBasedAutoScalingInput{}
	}

	output = &SetLoadBasedAutoScalingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SetLoadBasedAutoScaling API operation for AWS OpsWorks.
//
// Specify the load-based auto scaling configuration for a specified layer.
// For more information, see Managing Load with Time-based and Load-based Instances
// (https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-autoscaling.html).
//
// To use load-based auto scaling, you must create a set of load-based auto
// scaling instances. Load-based auto scaling operates only on the instances
// from that set, so you must ensure that you have created enough instances
// to handle the maximum anticipated load.
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation SetLoadBasedAutoScaling for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/SetLoadBasedAutoScaling
func (c *OpsWorks) SetLoadBasedAutoScaling(input *SetLoadBasedAutoScalingInput) (*SetLoadBasedAutoScalingOutput, error) {
	req, out := c.SetLoadBasedAutoScalingRequest(input)
	return out, req.Send()
}

// SetLoadBasedAutoScalingWithContext is the same as SetLoadBasedAutoScaling with the addition of
// the ability to pass a context and additional request options.
//
// See SetLoadBasedAutoScaling for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) SetLoadBasedAutoScalingWithContext(ctx aws.Context, input *SetLoadBasedAutoScalingInput, opts ...request.Option) (*SetLoadBasedAutoScalingOutput, error) {
	req, out := c.SetLoadBasedAutoScalingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetPermission = "SetPermission"

// SetPermissionRequest generates a "aws/request.Request" representing the
// client's request for the SetPermission operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetPermission for more information on using the SetPermission
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SetPermissionRequest method.
//    req, resp := client.SetPermissionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/SetPermission
func (c *OpsWorks) SetPermissionRequest(input *SetPermissionInput) (req *request.Request, output *SetPermissionOutput) {
	op := &request.Operation{
		Name:       opSetPermission,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetPermissionInput{}
	}

	output = &SetPermissionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SetPermission API operation for AWS OpsWorks.
//
// Specifies a user's permissions. For more information, see Security and Permissions
// (https://docs.aws.amazon.com/opsworks/latest/userguide/workingsecurity.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation SetPermission for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/SetPermission
func (c *OpsWorks) SetPermission(input *SetPermissionInput) (*SetPermissionOutput, error) {
	req, out := c.SetPermissionRequest(input)
	return out, req.Send()
}

// SetPermissionWithContext is the same as SetPermission with the addition of
// the ability to pass a context and additional request options.
//
// See SetPermission for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) SetPermissionWithContext(ctx aws.Context, input *SetPermissionInput, opts ...request.Option) (*SetPermissionOutput, error) {
	req, out := c.SetPermissionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSetTimeBasedAutoScaling = "SetTimeBasedAutoScaling"

// SetTimeBasedAutoScalingRequest generates a "aws/request.Request" representing the
// client's request for the SetTimeBasedAutoScaling operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SetTimeBasedAutoScaling for more information on using the SetTimeBasedAutoScaling
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SetTimeBasedAutoScalingRequest method.
//    req, resp := client.SetTimeBasedAutoScalingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/SetTimeBasedAutoScaling
func (c *OpsWorks) SetTimeBasedAutoScalingRequest(input *SetTimeBasedAutoScalingInput) (req *request.Request, output *SetTimeBasedAutoScalingOutput) {
	op := &request.Operation{
		Name:       opSetTimeBasedAutoScaling,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetTimeBasedAutoScalingInput{}
	}

	output = &SetTimeBasedAutoScalingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SetTimeBasedAutoScaling API operation for AWS OpsWorks.
//
// Specify the time-based auto scaling configuration for a specified instance.
// For more information, see Managing Load with Time-based and Load-based Instances
// (https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-autoscaling.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation SetTimeBasedAutoScaling for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/SetTimeBasedAutoScaling
func (c *OpsWorks) SetTimeBasedAutoScaling(input *SetTimeBasedAutoScalingInput) (*SetTimeBasedAutoScalingOutput, error) {
	req, out := c.SetTimeBasedAutoScalingRequest(input)
	return out, req.Send()
}

// SetTimeBasedAutoScalingWithContext is the same as SetTimeBasedAutoScaling with the addition of
// the ability to pass a context and additional request options.
//
// See SetTimeBasedAutoScaling for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) SetTimeBasedAutoScalingWithContext(ctx aws.Context, input *SetTimeBasedAutoScalingInput, opts ...request.Option) (*SetTimeBasedAutoScalingOutput, error) {
	req, out := c.SetTimeBasedAutoScalingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartInstance = "StartInstance"

// StartInstanceRequest generates a "aws/request.Request" representing the
// client's request for the StartInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartInstance for more information on using the StartInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartInstanceRequest method.
//    req, resp := client.StartInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/StartInstance
func (c *OpsWorks) StartInstanceRequest(input *StartInstanceInput) (req *request.Request, output *StartInstanceOutput) {
	op := &request.Operation{
		Name:       opStartInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartInstanceInput{}
	}

	output = &StartInstanceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartInstance API operation for AWS OpsWorks.
//
// Starts a specified instance. For more information, see Starting, Stopping,
// and Rebooting Instances (https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-starting.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation StartInstance for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/StartInstance
func (c *OpsWorks) StartInstance(input *StartInstanceInput) (*StartInstanceOutput, error) {
	req, out := c.StartInstanceRequest(input)
	return out, req.Send()
}

// StartInstanceWithContext is the same as StartInstance with the addition of
// the ability to pass a context and additional request options.
//
// See StartInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) StartInstanceWithContext(ctx aws.Context, input *StartInstanceInput, opts ...request.Option) (*StartInstanceOutput, error) {
	req, out := c.StartInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartStack = "StartStack"

// StartStackRequest generates a "aws/request.Request" representing the
// client's request for the StartStack operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartStack for more information on using the StartStack
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartStackRequest method.
//    req, resp := client.StartStackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/StartStack
func (c *OpsWorks) StartStackRequest(input *StartStackInput) (req *request.Request, output *StartStackOutput) {
	op := &request.Operation{
		Name:       opStartStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartStackInput{}
	}

	output = &StartStackOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartStack API operation for AWS OpsWorks.
//
// Starts a stack's instances.
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation StartStack for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/StartStack
func (c *OpsWorks) StartStack(input *StartStackInput) (*StartStackOutput, error) {
	req, out := c.StartStackRequest(input)
	return out, req.Send()
}

// StartStackWithContext is the same as StartStack with the addition of
// the ability to pass a context and additional request options.
//
// See StartStack for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) StartStackWithContext(ctx aws.Context, input *StartStackInput, opts ...request.Option) (*StartStackOutput, error) {
	req, out := c.StartStackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopInstance = "StopInstance"

// StopInstanceRequest generates a "aws/request.Request" representing the
// client's request for the StopInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopInstance for more information on using the StopInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopInstanceRequest method.
//    req, resp := client.StopInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/StopInstance
func (c *OpsWorks) StopInstanceRequest(input *StopInstanceInput) (req *request.Request, output *StopInstanceOutput) {
	op := &request.Operation{
		Name:       opStopInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopInstanceInput{}
	}

	output = &StopInstanceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopInstance API operation for AWS OpsWorks.
//
// Stops a specified instance. When you stop a standard instance, the data disappears
// and must be reinstalled when you restart the instance. You can stop an Amazon
// EBS-backed instance without losing data. For more information, see Starting,
// Stopping, and Rebooting Instances (https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-starting.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation StopInstance for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/StopInstance
func (c *OpsWorks) StopInstance(input *StopInstanceInput) (*StopInstanceOutput, error) {
	req, out := c.StopInstanceRequest(input)
	return out, req.Send()
}

// StopInstanceWithContext is the same as StopInstance with the addition of
// the ability to pass a context and additional request options.
//
// See StopInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) StopInstanceWithContext(ctx aws.Context, input *StopInstanceInput, opts ...request.Option) (*StopInstanceOutput, error) {
	req, out := c.StopInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopStack = "StopStack"

// StopStackRequest generates a "aws/request.Request" representing the
// client's request for the StopStack operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopStack for more information on using the StopStack
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopStackRequest method.
//    req, resp := client.StopStackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/StopStack
func (c *OpsWorks) StopStackRequest(input *StopStackInput) (req *request.Request, output *StopStackOutput) {
	op := &request.Operation{
		Name:       opStopStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopStackInput{}
	}

	output = &StopStackOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopStack API operation for AWS OpsWorks.
//
// Stops a specified stack.
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation StopStack for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/StopStack
func (c *OpsWorks) StopStack(input *StopStackInput) (*StopStackOutput, error) {
	req, out := c.StopStackRequest(input)
	return out, req.Send()
}

// StopStackWithContext is the same as StopStack with the addition of
// the ability to pass a context and additional request options.
//
// See StopStack for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) StopStackWithContext(ctx aws.Context, input *StopStackInput, opts ...request.Option) (*StopStackOutput, error) {
	req, out := c.StopStackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/TagResource
func (c *OpsWorks) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS OpsWorks.
//
// Apply cost-allocation tags to a specified stack or layer in AWS OpsWorks
// Stacks. For more information about how tagging works, see Tags (https://docs.aws.amazon.com/opsworks/latest/userguide/tagging.html)
// in the AWS OpsWorks User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/TagResource
func (c *OpsWorks) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUnassignInstance = "UnassignInstance"

// UnassignInstanceRequest generates a "aws/request.Request" representing the
// client's request for the UnassignInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UnassignInstance for more information on using the UnassignInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UnassignInstanceRequest method.
//    req, resp := client.UnassignInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/UnassignInstance
func (c *OpsWorks) UnassignInstanceRequest(input *UnassignInstanceInput) (req *request.Request, output *UnassignInstanceOutput) {
	op := &request.Operation{
		Name:       opUnassignInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UnassignInstanceInput{}
	}

	output = &UnassignInstanceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UnassignInstance API operation for AWS OpsWorks.
//
// Unassigns a registered instance from all layers that are using the instance.
// The instance remains in the stack as an unassigned instance, and can be assigned
// to another layer as needed. You cannot use this action with instances that
// were created with AWS OpsWorks Stacks.
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack or an attached policy that explicitly grants
// permissions. For more information about user permissions, see Managing User
// Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation UnassignInstance for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/UnassignInstance
func (c *OpsWorks) UnassignInstance(input *UnassignInstanceInput) (*UnassignInstanceOutput, error) {
	req, out := c.UnassignInstanceRequest(input)
	return out, req.Send()
}

// UnassignInstanceWithContext is the same as UnassignInstance with the addition of
// the ability to pass a context and additional request options.
//
// See UnassignInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) UnassignInstanceWithContext(ctx aws.Context, input *UnassignInstanceInput, opts ...request.Option) (*UnassignInstanceOutput, error) {
	req, out := c.UnassignInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUnassignVolume = "UnassignVolume"

// UnassignVolumeRequest generates a "aws/request.Request" representing the
// client's request for the UnassignVolume operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UnassignVolume for more information on using the UnassignVolume
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UnassignVolumeRequest method.
//    req, resp := client.UnassignVolumeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/UnassignVolume
func (c *OpsWorks) UnassignVolumeRequest(input *UnassignVolumeInput) (req *request.Request, output *UnassignVolumeOutput) {
	op := &request.Operation{
		Name:       opUnassignVolume,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UnassignVolumeInput{}
	}

	output = &UnassignVolumeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UnassignVolume API operation for AWS OpsWorks.
//
// Unassigns an assigned Amazon EBS volume. The volume remains registered with
// the stack. For more information, see Resource Management (https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation UnassignVolume for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/UnassignVolume
func (c *OpsWorks) UnassignVolume(input *UnassignVolumeInput) (*UnassignVolumeOutput, error) {
	req, out := c.UnassignVolumeRequest(input)
	return out, req.Send()
}

// UnassignVolumeWithContext is the same as UnassignVolume with the addition of
// the ability to pass a context and additional request options.
//
// See UnassignVolume for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) UnassignVolumeWithContext(ctx aws.Context, input *UnassignVolumeInput, opts ...request.Option) (*UnassignVolumeOutput, error) {
	req, out := c.UnassignVolumeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/UntagResource
func (c *OpsWorks) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS OpsWorks.
//
// Removes tags from a specified stack or layer.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/UntagResource
func (c *OpsWorks) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateApp = "UpdateApp"

// UpdateAppRequest generates a "aws/request.Request" representing the
// client's request for the UpdateApp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateApp for more information on using the UpdateApp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAppRequest method.
//    req, resp := client.UpdateAppRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/UpdateApp
func (c *OpsWorks) UpdateAppRequest(input *UpdateAppInput) (req *request.Request, output *UpdateAppOutput) {
	op := &request.Operation{
		Name:       opUpdateApp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateAppInput{}
	}

	output = &UpdateAppOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateApp API operation for AWS OpsWorks.
//
// Updates a specified app.
//
// Required Permissions: To use this action, an IAM user must have a Deploy
// or Manage permissions level for the stack, or an attached policy that explicitly
// grants permissions. For more information on user permissions, see Managing
// User Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation UpdateApp for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/UpdateApp
func (c *OpsWorks) UpdateApp(input *UpdateAppInput) (*UpdateAppOutput, error) {
	req, out := c.UpdateAppRequest(input)
	return out, req.Send()
}

// UpdateAppWithContext is the same as UpdateApp with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateApp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) UpdateAppWithContext(ctx aws.Context, input *UpdateAppInput, opts ...request.Option) (*UpdateAppOutput, error) {
	req, out := c.UpdateAppRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateElasticIp = "UpdateElasticIp"

// UpdateElasticIpRequest generates a "aws/request.Request" representing the
// client's request for the UpdateElasticIp operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateElasticIp for more information on using the UpdateElasticIp
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateElasticIpRequest method.
//    req, resp := client.UpdateElasticIpRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/UpdateElasticIp
func (c *OpsWorks) UpdateElasticIpRequest(input *UpdateElasticIpInput) (req *request.Request, output *UpdateElasticIpOutput) {
	op := &request.Operation{
		Name:       opUpdateElasticIp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateElasticIpInput{}
	}

	output = &UpdateElasticIpOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateElasticIp API operation for AWS OpsWorks.
//
// Updates a registered Elastic IP address's name. For more information, see
// Resource Management (https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation UpdateElasticIp for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/UpdateElasticIp
func (c *OpsWorks) UpdateElasticIp(input *UpdateElasticIpInput) (*UpdateElasticIpOutput, error) {
	req, out := c.UpdateElasticIpRequest(input)
	return out, req.Send()
}

// UpdateElasticIpWithContext is the same as UpdateElasticIp with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateElasticIp for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) UpdateElasticIpWithContext(ctx aws.Context, input *UpdateElasticIpInput, opts ...request.Option) (*UpdateElasticIpOutput, error) {
	req, out := c.UpdateElasticIpRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateInstance = "UpdateInstance"

// UpdateInstanceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateInstance for more information on using the UpdateInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateInstanceRequest method.
//    req, resp := client.UpdateInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/UpdateInstance
func (c *OpsWorks) UpdateInstanceRequest(input *UpdateInstanceInput) (req *request.Request, output *UpdateInstanceOutput) {
	op := &request.Operation{
		Name:       opUpdateInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateInstanceInput{}
	}

	output = &UpdateInstanceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateInstance API operation for AWS OpsWorks.
//
// Updates a specified instance.
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation UpdateInstance for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/UpdateInstance
func (c *OpsWorks) UpdateInstance(input *UpdateInstanceInput) (*UpdateInstanceOutput, error) {
	req, out := c.UpdateInstanceRequest(input)
	return out, req.Send()
}

// UpdateInstanceWithContext is the same as UpdateInstance with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) UpdateInstanceWithContext(ctx aws.Context, input *UpdateInstanceInput, opts ...request.Option) (*UpdateInstanceOutput, error) {
	req, out := c.UpdateInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateLayer = "UpdateLayer"

// UpdateLayerRequest generates a "aws/request.Request" representing the
// client's request for the UpdateLayer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateLayer for more information on using the UpdateLayer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateLayerRequest method.
//    req, resp := client.UpdateLayerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/UpdateLayer
func (c *OpsWorks) UpdateLayerRequest(input *UpdateLayerInput) (req *request.Request, output *UpdateLayerOutput) {
	op := &request.Operation{
		Name:       opUpdateLayer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateLayerInput{}
	}

	output = &UpdateLayerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateLayer API operation for AWS OpsWorks.
//
// Updates a specified layer.
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation UpdateLayer for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/UpdateLayer
func (c *OpsWorks) UpdateLayer(input *UpdateLayerInput) (*UpdateLayerOutput, error) {
	req, out := c.UpdateLayerRequest(input)
	return out, req.Send()
}

// UpdateLayerWithContext is the same as UpdateLayer with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateLayer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) UpdateLayerWithContext(ctx aws.Context, input *UpdateLayerInput, opts ...request.Option) (*UpdateLayerOutput, error) {
	req, out := c.UpdateLayerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateMyUserProfile = "UpdateMyUserProfile"

// UpdateMyUserProfileRequest generates a "aws/request.Request" representing the
// client's request for the UpdateMyUserProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateMyUserProfile for more information on using the UpdateMyUserProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateMyUserProfileRequest method.
//    req, resp := client.UpdateMyUserProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/UpdateMyUserProfile
func (c *OpsWorks) UpdateMyUserProfileRequest(input *UpdateMyUserProfileInput) (req *request.Request, output *UpdateMyUserProfileOutput) {
	op := &request.Operation{
		Name:       opUpdateMyUserProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateMyUserProfileInput{}
	}

	output = &UpdateMyUserProfileOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateMyUserProfile API operation for AWS OpsWorks.
//
// Updates a user's SSH public key.
//
// Required Permissions: To use this action, an IAM user must have self-management
// enabled or an attached policy that explicitly grants permissions. For more
// information about user permissions, see Managing User Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation UpdateMyUserProfile for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/UpdateMyUserProfile
func (c *OpsWorks) UpdateMyUserProfile(input *UpdateMyUserProfileInput) (*UpdateMyUserProfileOutput, error) {
	req, out := c.UpdateMyUserProfileRequest(input)
	return out, req.Send()
}

// UpdateMyUserProfileWithContext is the same as UpdateMyUserProfile with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateMyUserProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) UpdateMyUserProfileWithContext(ctx aws.Context, input *UpdateMyUserProfileInput, opts ...request.Option) (*UpdateMyUserProfileOutput, error) {
	req, out := c.UpdateMyUserProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRdsDbInstance = "UpdateRdsDbInstance"

// UpdateRdsDbInstanceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRdsDbInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRdsDbInstance for more information on using the UpdateRdsDbInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRdsDbInstanceRequest method.
//    req, resp := client.UpdateRdsDbInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/UpdateRdsDbInstance
func (c *OpsWorks) UpdateRdsDbInstanceRequest(input *UpdateRdsDbInstanceInput) (req *request.Request, output *UpdateRdsDbInstanceOutput) {
	op := &request.Operation{
		Name:       opUpdateRdsDbInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRdsDbInstanceInput{}
	}

	output = &UpdateRdsDbInstanceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateRdsDbInstance API operation for AWS OpsWorks.
//
// Updates an Amazon RDS instance.
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation UpdateRdsDbInstance for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/UpdateRdsDbInstance
func (c *OpsWorks) UpdateRdsDbInstance(input *UpdateRdsDbInstanceInput) (*UpdateRdsDbInstanceOutput, error) {
	req, out := c.UpdateRdsDbInstanceRequest(input)
	return out, req.Send()
}

// UpdateRdsDbInstanceWithContext is the same as UpdateRdsDbInstance with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRdsDbInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) UpdateRdsDbInstanceWithContext(ctx aws.Context, input *UpdateRdsDbInstanceInput, opts ...request.Option) (*UpdateRdsDbInstanceOutput, error) {
	req, out := c.UpdateRdsDbInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateStack = "UpdateStack"

// UpdateStackRequest generates a "aws/request.Request" representing the
// client's request for the UpdateStack operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateStack for more information on using the UpdateStack
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateStackRequest method.
//    req, resp := client.UpdateStackRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/UpdateStack
func (c *OpsWorks) UpdateStackRequest(input *UpdateStackInput) (req *request.Request, output *UpdateStackOutput) {
	op := &request.Operation{
		Name:       opUpdateStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateStackInput{}
	}

	output = &UpdateStackOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateStack API operation for AWS OpsWorks.
//
// Updates a specified stack.
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation UpdateStack for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/UpdateStack
func (c *OpsWorks) UpdateStack(input *UpdateStackInput) (*UpdateStackOutput, error) {
	req, out := c.UpdateStackRequest(input)
	return out, req.Send()
}

// UpdateStackWithContext is the same as UpdateStack with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateStack for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) UpdateStackWithContext(ctx aws.Context, input *UpdateStackInput, opts ...request.Option) (*UpdateStackOutput, error) {
	req, out := c.UpdateStackRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUserProfile = "UpdateUserProfile"

// UpdateUserProfileRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUserProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUserProfile for more information on using the UpdateUserProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateUserProfileRequest method.
//    req, resp := client.UpdateUserProfileRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/UpdateUserProfile
func (c *OpsWorks) UpdateUserProfileRequest(input *UpdateUserProfileInput) (req *request.Request, output *UpdateUserProfileOutput) {
	op := &request.Operation{
		Name:       opUpdateUserProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateUserProfileInput{}
	}

	output = &UpdateUserProfileOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateUserProfile API operation for AWS OpsWorks.
//
// Updates a specified user profile.
//
// Required Permissions: To use this action, an IAM user must have an attached
// policy that explicitly grants permissions. For more information about user
// permissions, see Managing User Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation UpdateUserProfile for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/UpdateUserProfile
func (c *OpsWorks) UpdateUserProfile(input *UpdateUserProfileInput) (*UpdateUserProfileOutput, error) {
	req, out := c.UpdateUserProfileRequest(input)
	return out, req.Send()
}

// UpdateUserProfileWithContext is the same as UpdateUserProfile with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUserProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) UpdateUserProfileWithContext(ctx aws.Context, input *UpdateUserProfileInput, opts ...request.Option) (*UpdateUserProfileOutput, error) {
	req, out := c.UpdateUserProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateVolume = "UpdateVolume"

// UpdateVolumeRequest generates a "aws/request.Request" representing the
// client's request for the UpdateVolume operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateVolume for more information on using the UpdateVolume
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateVolumeRequest method.
//    req, resp := client.UpdateVolumeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/UpdateVolume
func (c *OpsWorks) UpdateVolumeRequest(input *UpdateVolumeInput) (req *request.Request, output *UpdateVolumeOutput) {
	op := &request.Operation{
		Name:       opUpdateVolume,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateVolumeInput{}
	}

	output = &UpdateVolumeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateVolume API operation for AWS OpsWorks.
//
// Updates an Amazon EBS volume's name or mount point. For more information,
// see Resource Management (https://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks's
// API operation UpdateVolume for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Indicates that a request was not valid.
//
//   * ResourceNotFoundException
//   Indicates that a resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/UpdateVolume
func (c *OpsWorks) UpdateVolume(input *UpdateVolumeInput) (*UpdateVolumeOutput, error) {
	req, out := c.UpdateVolumeRequest(input)
	return out, req.Send()
}

// UpdateVolumeWithContext is the same as UpdateVolume with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateVolume for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorks) UpdateVolumeWithContext(ctx aws.Context, input *UpdateVolumeInput, opts ...request.Option) (*UpdateVolumeOutput, error) {
	req, out := c.UpdateVolumeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Describes an agent version.
type AgentVersion struct {
	_ struct{} `type:"structure"`

	// The configuration manager.
	ConfigurationManager *StackConfigurationManager `type:"structure"`

	// The agent version.
	Version *string `type:"string"`
}

// String returns the string representation
func (s AgentVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AgentVersion) GoString() string {
	return s.String()
}

// SetConfigurationManager sets the ConfigurationManager field's value.
func (s *AgentVersion) SetConfigurationManager(v *StackConfigurationManager) *AgentVersion {
	s.ConfigurationManager = v
	return s
}

// SetVersion sets the Version field's value.
func (s *AgentVersion) SetVersion(v string) *AgentVersion {
	s.Version = &v
	return s
}

// A description of the app.
type App struct {
	_ struct{} `type:"structure"`

	// The app ID.
	AppId *string `type:"string"`

	// A Source object that describes the app repository.
	AppSource *Source `type:"structure"`

	// The stack attributes.
	Attributes map[string]*string `type:"map"`

	// When the app was created.
	CreatedAt *string `type:"string"`

	// The app's data sources.
	DataSources []*DataSource `type:"list"`

	// A description of the app.
	Description *string `type:"string"`

	// The app vhost settings with multiple domains separated by commas. For example:
	// 'www.example.com, example.com'
	Domains []*string `type:"list"`

	// Whether to enable SSL for the app.
	EnableSsl *bool `type:"boolean"`

	// An array of EnvironmentVariable objects that specify environment variables
	// to be associated with the app. After you deploy the app, these variables
	// are defined on the associated app server instances. For more information,
	// see Environment Variables (https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment).
	//
	// There is no specific limit on the number of environment variables. However,
	// the size of the associated data structure - which includes the variable names,
	// values, and protected flag values - cannot exceed 20 KB. This limit should
	// accommodate most if not all use cases, but if you do exceed it, you will
	// cause an exception (API) with an "Environment: is too large (maximum is 20
	// KB)" message.
	Environment []*EnvironmentVariable `type:"list"`

	// The app name.
	Name *string `type:"string"`

	// The app's short name.
	Shortname *string `type:"string"`

	// An SslConfiguration object with the SSL configuration.
	SslConfiguration *SslConfiguration `type:"structure"`

	// The app stack ID.
	StackId *string `type:"string"`

	// The app type.
	Type *string `type:"string" enum:"AppType"`
}

// String returns the string representation
func (s App) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s App) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *App) SetAppId(v string) *App {
	s.AppId = &v
	return s
}

// SetAppSource sets the AppSource field's value.
func (s *App) SetAppSource(v *Source) *App {
	s.AppSource = v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *App) SetAttributes(v map[string]*string) *App {
	s.Attributes = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *App) SetCreatedAt(v string) *App {
	s.CreatedAt = &v
	return s
}

// SetDataSources sets the DataSources field's value.
func (s *App) SetDataSources(v []*DataSource) *App {
	s.DataSources = v
	return s
}

// SetDescription sets the Description field's value.
func (s *App) SetDescription(v string) *App {
	s.Description = &v
	return s
}

// SetDomains sets the Domains field's value.
func (s *App) SetDomains(v []*string) *App {
	s.Domains = v
	return s
}

// SetEnableSsl sets the EnableSsl field's value.
func (s *App) SetEnableSsl(v bool) *App {
	s.EnableSsl = &v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *App) SetEnvironment(v []*EnvironmentVariable) *App {
	s.Environment = v
	return s
}

// SetName sets the Name field's value.
func (s *App) SetName(v string) *App {
	s.Name = &v
	return s
}

// SetShortname sets the Shortname field's value.
func (s *App) SetShortname(v string) *App {
	s.Shortname = &v
	return s
}

// SetSslConfiguration sets the SslConfiguration field's value.
func (s *App) SetSslConfiguration(v *SslConfiguration) *App {
	s.SslConfiguration = v
	return s
}

// SetStackId sets the StackId field's value.
func (s *App) SetStackId(v string) *App {
	s.StackId = &v
	return s
}

// SetType sets the Type field's value.
func (s *App) SetType(v string) *App {
	s.Type = &v
	return s
}

type AssignInstanceInput struct {
	_ struct{} `type:"structure"`

	// The instance ID.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`

	// The layer ID, which must correspond to a custom layer. You cannot assign
	// a registered instance to a built-in layer.
	//
	// LayerIds is a required field
	LayerIds []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s AssignInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssignInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssignInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssignInstanceInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.LayerIds == nil {
		invalidParams.Add(request.NewErrParamRequired("LayerIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *AssignInstanceInput) SetInstanceId(v string) *AssignInstanceInput {
	s.InstanceId = &v
	return s
}

// SetLayerIds sets the LayerIds field's value.
func (s *AssignInstanceInput) SetLayerIds(v []*string) *AssignInstanceInput {
	s.LayerIds = v
	return s
}

type AssignInstanceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssignInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssignInstanceOutput) GoString() string {
	return s.String()
}

type AssignVolumeInput struct {
	_ struct{} `type:"structure"`

	// The instance ID.
	InstanceId *string `type:"string"`

	// The volume ID.
	//
	// VolumeId is a required field
	VolumeId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AssignVolumeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssignVolumeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssignVolumeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssignVolumeInput"}
	if s.VolumeId == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *AssignVolumeInput) SetInstanceId(v string) *AssignVolumeInput {
	s.InstanceId = &v
	return s
}

// SetVolumeId sets the VolumeId field's value.
func (s *AssignVolumeInput) SetVolumeId(v string) *AssignVolumeInput {
	s.VolumeId = &v
	return s
}

type AssignVolumeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssignVolumeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssignVolumeOutput) GoString() string {
	return s.String()
}

type AssociateElasticIpInput struct {
	_ struct{} `type:"structure"`

	// The Elastic IP address.
	//
	// ElasticIp is a required field
	ElasticIp *string `type:"string" required:"true"`

	// The instance ID.
	InstanceId *string `type:"string"`
}

// String returns the string representation
func (s AssociateElasticIpInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateElasticIpInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateElasticIpInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateElasticIpInput"}
	if s.ElasticIp == nil {
		invalidParams.Add(request.NewErrParamRequired("ElasticIp"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetElasticIp sets the ElasticIp field's value.
func (s *AssociateElasticIpInput) SetElasticIp(v string) *AssociateElasticIpInput {
	s.ElasticIp = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *AssociateElasticIpInput) SetInstanceId(v string) *AssociateElasticIpInput {
	s.InstanceId = &v
	return s
}

type AssociateElasticIpOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateElasticIpOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateElasticIpOutput) GoString() string {
	return s.String()
}

type AttachElasticLoadBalancerInput struct {
	_ struct{} `type:"structure"`

	// The Elastic Load Balancing instance's name.
	//
	// ElasticLoadBalancerName is a required field
	ElasticLoadBalancerName *string `type:"string" required:"true"`

	// The ID of the layer to which the Elastic Load Balancing instance is to be
	// attached.
	//
	// LayerId is a required field
	LayerId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s AttachElasticLoadBalancerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachElasticLoadBalancerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachElasticLoadBalancerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AttachElasticLoadBalancerInput"}
	if s.ElasticLoadBalancerName == nil {
		invalidParams.Add(request.NewErrParamRequired("ElasticLoadBalancerName"))
	}
	if s.LayerId == nil {
		invalidParams.Add(request.NewErrParamRequired("LayerId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetElasticLoadBalancerName sets the ElasticLoadBalancerName field's value.
func (s *AttachElasticLoadBalancerInput) SetElasticLoadBalancerName(v string) *AttachElasticLoadBalancerInput {
	s.ElasticLoadBalancerName = &v
	return s
}

// SetLayerId sets the LayerId field's value.
func (s *AttachElasticLoadBalancerInput) SetLayerId(v string) *AttachElasticLoadBalancerInput {
	s.LayerId = &v
	return s
}

type AttachElasticLoadBalancerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AttachElasticLoadBalancerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AttachElasticLoadBalancerOutput) GoString() string {
	return s.String()
}

// Describes a load-based auto scaling upscaling or downscaling threshold configuration,
// which specifies when AWS OpsWorks Stacks starts or stops load-based instances.
type AutoScalingThresholds struct {
	_ struct{} `type:"structure"`

	// Custom Cloudwatch auto scaling alarms, to be used as thresholds. This parameter
	// takes a list of up to five alarm names, which are case sensitive and must
	// be in the same region as the stack.
	//
	// To use custom alarms, you must update your service role to allow cloudwatch:DescribeAlarms.
	// You can either have AWS OpsWorks Stacks update the role for you when you
	// first use this feature or you can edit the role manually. For more information,
	// see Allowing AWS OpsWorks Stacks to Act on Your Behalf (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-servicerole.html).
	Alarms []*string `type:"list"`

	// The CPU utilization threshold, as a percent of the available CPU. A value
	// of -1 disables the threshold.
	CpuThreshold *float64 `type:"double"`

	// The amount of time (in minutes) after a scaling event occurs that AWS OpsWorks
	// Stacks should ignore metrics and suppress additional scaling events. For
	// example, AWS OpsWorks Stacks adds new instances following an upscaling event
	// but the instances won't start reducing the load until they have been booted
	// and configured. There is no point in raising additional scaling events during
	// that operation, which typically takes several minutes. IgnoreMetricsTime
	// allows you to direct AWS OpsWorks Stacks to suppress scaling events long
	// enough to get the new instances online.
	IgnoreMetricsTime *int64 `min:"1" type:"integer"`

	// The number of instances to add or remove when the load exceeds a threshold.
	InstanceCount *int64 `type:"integer"`

	// The load threshold. A value of -1 disables the threshold. For more information
	// about how load is computed, see Load (computing) (http://en.wikipedia.org/wiki/Load_%28computing%29).
	LoadThreshold *float64 `type:"double"`

	// The memory utilization threshold, as a percent of the available memory. A
	// value of -1 disables the threshold.
	MemoryThreshold *float64 `type:"double"`

	// The amount of time, in minutes, that the load must exceed a threshold before
	// more instances are added or removed.
	ThresholdsWaitTime *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s AutoScalingThresholds) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoScalingThresholds) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AutoScalingThresholds) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AutoScalingThresholds"}
	if s.IgnoreMetricsTime != nil && *s.IgnoreMetricsTime < 1 {
		invalidParams.Add(request.NewErrParamMinValue("IgnoreMetricsTime", 1))
	}
	if s.ThresholdsWaitTime != nil && *s.ThresholdsWaitTime < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ThresholdsWaitTime", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlarms sets the Alarms field's value.
func (s *AutoScalingThresholds) SetAlarms(v []*string) *AutoScalingThresholds {
	s.Alarms = v
	return s
}

// SetCpuThreshold sets the CpuThreshold field's value.
func (s *AutoScalingThresholds) SetCpuThreshold(v float64) *AutoScalingThresholds {
	s.CpuThreshold = &v
	return s
}

// SetIgnoreMetricsTime sets the IgnoreMetricsTime field's value.
func (s *AutoScalingThresholds) SetIgnoreMetricsTime(v int64) *AutoScalingThresholds {
	s.IgnoreMetricsTime = &v
	return s
}

// SetInstanceCount sets the InstanceCount field's value.
func (s *AutoScalingThresholds) SetInstanceCount(v int64) *AutoScalingThresholds {
	s.InstanceCount = &v
	return s
}

// SetLoadThreshold sets the LoadThreshold field's value.
func (s *AutoScalingThresholds) SetLoadThreshold(v float64) *AutoScalingThresholds {
	s.LoadThreshold = &v
	return s
}

// SetMemoryThreshold sets the MemoryThreshold field's value.
func (s *AutoScalingThresholds) SetMemoryThreshold(v float64) *AutoScalingThresholds {
	s.MemoryThreshold = &v
	return s
}

// SetThresholdsWaitTime sets the ThresholdsWaitTime field's value.
func (s *AutoScalingThresholds) SetThresholdsWaitTime(v int64) *AutoScalingThresholds {
	s.ThresholdsWaitTime = &v
	return s
}

// Describes a block device mapping. This data type maps directly to the Amazon
// EC2 BlockDeviceMapping (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_BlockDeviceMapping.html)
// data type.
type BlockDeviceMapping struct {
	_ struct{} `type:"structure"`

	// The device name that is exposed to the instance, such as /dev/sdh. For the
	// root device, you can use the explicit device name or you can set this parameter
	// to ROOT_DEVICE and AWS OpsWorks Stacks will provide the correct device name.
	DeviceName *string `type:"string"`

	// An EBSBlockDevice that defines how to configure an Amazon EBS volume when
	// the instance is launched.
	Ebs *EbsBlockDevice `type:"structure"`

	// Suppresses the specified device included in the AMI's block device mapping.
	NoDevice *string `type:"string"`

	// The virtual device name. For more information, see BlockDeviceMapping (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_BlockDeviceMapping.html).
	VirtualName *string `type:"string"`
}

// String returns the string representation
func (s BlockDeviceMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BlockDeviceMapping) GoString() string {
	return s.String()
}

// SetDeviceName sets the DeviceName field's value.
func (s *BlockDeviceMapping) SetDeviceName(v string) *BlockDeviceMapping {
	s.DeviceName = &v
	return s
}

// SetEbs sets the Ebs field's value.
func (s *BlockDeviceMapping) SetEbs(v *EbsBlockDevice) *BlockDeviceMapping {
	s.Ebs = v
	return s
}

// SetNoDevice sets the NoDevice field's value.
func (s *BlockDeviceMapping) SetNoDevice(v string) *BlockDeviceMapping {
	s.NoDevice = &v
	return s
}

// SetVirtualName sets the VirtualName field's value.
func (s *BlockDeviceMapping) SetVirtualName(v string) *BlockDeviceMapping {
	s.VirtualName = &v
	return s
}

// Describes the Chef configuration.
type ChefConfiguration struct {
	_ struct{} `type:"structure"`

	// The Berkshelf version.
	BerkshelfVersion *string `type:"string"`

	// Whether to enable Berkshelf.
	ManageBerkshelf *bool `type:"boolean"`
}

// String returns the string representation
func (s ChefConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChefConfiguration) GoString() string {
	return s.String()
}

// SetBerkshelfVersion sets the BerkshelfVersion field's value.
func (s *ChefConfiguration) SetBerkshelfVersion(v string) *ChefConfiguration {
	s.BerkshelfVersion = &v
	return s
}

// SetManageBerkshelf sets the ManageBerkshelf field's value.
func (s *ChefConfiguration) SetManageBerkshelf(v bool) *ChefConfiguration {
	s.ManageBerkshelf = &v
	return s
}

type CloneStackInput struct {
	_ struct{} `type:"structure"`

	// The default AWS OpsWorks Stacks agent version. You have the following options:
	//
	//    * Auto-update - Set this parameter to LATEST. AWS OpsWorks Stacks automatically
	//    installs new agent versions on the stack's instances as soon as they are
	//    available.
	//
	//    * Fixed version - Set this parameter to your preferred agent version.
	//    To update the agent version, you must edit the stack configuration and
	//    specify a new version. AWS OpsWorks Stacks then automatically installs
	//    that version on the stack's instances.
	//
	// The default setting is LATEST. To specify an agent version, you must use
	// the complete version number, not the abbreviated number shown on the console.
	// For a list of available agent version numbers, call DescribeAgentVersions.
	// AgentVersion cannot be set to Chef 12.2.
	//
	// You can also specify an agent version when you create or update an instance,
	// which overrides the stack's default setting.
	AgentVersion *string `type:"string"`

	// A list of stack attributes and values as key/value pairs to be added to the
	// cloned stack.
	Attributes map[string]*string `type:"map"`

	// A ChefConfiguration object that specifies whether to enable Berkshelf and
	// the Berkshelf version on Chef 11.10 stacks. For more information, see Create
	// a New Stack (https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html).
	ChefConfiguration *ChefConfiguration `type:"structure"`

	// A list of source stack app IDs to be included in the cloned stack.
	CloneAppIds []*string `type:"list"`

	// Whether to clone the source stack's permissions.
	ClonePermissions *bool `type:"boolean"`

	// The configuration manager. When you clone a stack we recommend that you use
	// the configuration manager to specify the Chef version: 12, 11.10, or 11.4
	// for Linux stacks, or 12.2 for Windows stacks. The default value for Linux
	// stacks is currently 12.
	ConfigurationManager *StackConfigurationManager `type:"structure"`

	// Contains the information required to retrieve an app or cookbook from a repository.
	// For more information, see Adding Apps (https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html)
	// or Cookbooks and Recipes (https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html).
	CustomCookbooksSource *Source `type:"structure"`

	// A string that contains user-defined, custom JSON. It is used to override
	// the corresponding default stack configuration JSON values. The string should
	// be in the following format:
	//
	// "{\"key1\": \"value1\", \"key2\": \"value2\",...}"
	//
	// For more information about custom JSON, see Use Custom JSON to Modify the
	// Stack Configuration Attributes (https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html)
	CustomJson *string `type:"string"`

	// The cloned stack's default Availability Zone, which must be in the specified
	// region. For more information, see Regions and Endpoints (https://docs.aws.amazon.com/general/latest/gr/rande.html).
	// If you also specify a value for DefaultSubnetId, the subnet must be in the
	// same zone. For more information, see the VpcId parameter description.
	DefaultAvailabilityZone *string `type:"string"`

	// The Amazon Resource Name (ARN) of an IAM profile that is the default profile
	// for all of the stack's EC2 instances. For more information about IAM ARNs,
	// see Using Identifiers (https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html).
	DefaultInstanceProfileArn *string `type:"string"`

	// The stack's operating system, which must be set to one of the following.
	//
	//    * A supported Linux operating system: An Amazon Linux version, such as
	//    Amazon Linux 2018.03, Amazon Linux 2017.09, Amazon Linux 2017.03, Amazon
	//    Linux 2016.09, Amazon Linux 2016.03, Amazon Linux 2015.09, or Amazon Linux
	//    2015.03.
	//
	//    * A supported Ubuntu operating system, such as Ubuntu 16.04 LTS, Ubuntu
	//    14.04 LTS, or Ubuntu 12.04 LTS.
	//
	//    * CentOS Linux 7
	//
	//    * Red Hat Enterprise Linux 7
	//
	//    * Microsoft Windows Server 2012 R2 Base, Microsoft Windows Server 2012
	//    R2 with SQL Server Express, Microsoft Windows Server 2012 R2 with SQL
	//    Server Standard, or Microsoft Windows Server 2012 R2 with SQL Server Web.
	//
	//    * A custom AMI: Custom. You specify the custom AMI you want to use when
	//    you create instances. For more information about how to use custom AMIs
	//    with OpsWorks, see Using Custom AMIs (https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html).
	//
	// The default option is the parent stack's operating system. For more information
	// about supported operating systems, see AWS OpsWorks Stacks Operating Systems
	// (https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html).
	//
	// You can specify a different Linux operating system for the cloned stack,
	// but you cannot change from Linux to Windows or Windows to Linux.
	DefaultOs *string `type:"string"`

	// The default root device type. This value is used by default for all instances
	// in the cloned stack, but you can override it when you create an instance.
	// For more information, see Storage for the Root Device (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device).
	DefaultRootDeviceType *string `type:"string" enum:"RootDeviceType"`

	// A default Amazon EC2 key pair name. The default value is none. If you specify
	// a key pair name, AWS OpsWorks installs the public key on the instance and
	// you can use the private key with an SSH client to log in to the instance.
	// For more information, see Using SSH to Communicate with an Instance (https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-ssh.html)
	// and Managing SSH Access (https://docs.aws.amazon.com/opsworks/latest/userguide/security-ssh-access.html).
	// You can override this setting by specifying a different key pair, or no key
	// pair, when you create an instance (https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-add.html).
	DefaultSshKeyName *string `type:"string"`

	// The stack's default VPC subnet ID. This parameter is required if you specify
	// a value for the VpcId parameter. All instances are launched into this subnet
	// unless you specify otherwise when you create the instance. If you also specify
	// a value for DefaultAvailabilityZone, the subnet must be in that zone. For
	// information on default values and when this parameter is required, see the
	// VpcId parameter description.
	DefaultSubnetId *string `type:"string"`

	// The stack's host name theme, with spaces are replaced by underscores. The
	// theme is used to generate host names for the stack's instances. By default,
	// HostnameTheme is set to Layer_Dependent, which creates host names by appending
	// integers to the layer's short name. The other themes are:
	//
	//    * Baked_Goods
	//
	//    * Clouds
	//
	//    * Europe_Cities
	//
	//    * Fruits
	//
	//    * Greek_Deities_and_Titans
	//
	//    * Legendary_creatures_from_Japan
	//
	//    * Planets_and_Moons
	//
	//    * Roman_Deities
	//
	//    * Scottish_Islands
	//
	//    * US_Cities
	//
	//    * Wild_Cats
	//
	// To obtain a generated host name, call GetHostNameSuggestion, which returns
	// a host name based on the current theme.
	HostnameTheme *string `type:"string"`

	// The cloned stack name.
	Name *string `type:"string"`

	// The cloned stack AWS region, such as "ap-northeast-2". For more information
	// about AWS regions, see Regions and Endpoints (https://docs.aws.amazon.com/general/latest/gr/rande.html).
	Region *string `type:"string"`

	// The stack AWS Identity and Access Management (IAM) role, which allows AWS
	// OpsWorks Stacks to work with AWS resources on your behalf. You must set this
	// parameter to the Amazon Resource Name (ARN) for an existing IAM role. If
	// you create a stack by using the AWS OpsWorks Stacks console, it creates the
	// role for you. You can obtain an existing stack's IAM ARN programmatically
	// by calling DescribePermissions. For more information about IAM ARNs, see
	// Using Identifiers (https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html).
	//
	// You must set this parameter to a valid service role ARN or the action will
	// fail; there is no default value. You can specify the source stack's service
	// role ARN, if you prefer, but you must do so explicitly.
	//
	// ServiceRoleArn is a required field
	ServiceRoleArn *string `type:"string" required:"true"`

	// The source stack ID.
	//
	// SourceStackId is a required field
	SourceStackId *string `type:"string" required:"true"`

	// Whether to use custom cookbooks.
	UseCustomCookbooks *bool `type:"boolean"`

	// Whether to associate the AWS OpsWorks Stacks built-in security groups with
	// the stack's layers.
	//
	// AWS OpsWorks Stacks provides a standard set of built-in security groups,
	// one for each layer, which are associated with layers by default. With UseOpsworksSecurityGroups
	// you can instead provide your own custom security groups. UseOpsworksSecurityGroups
	// has the following settings:
	//
	//    * True - AWS OpsWorks Stacks automatically associates the appropriate
	//    built-in security group with each layer (default setting). You can associate
	//    additional security groups with a layer after you create it but you cannot
	//    delete the built-in security group.
	//
	//    * False - AWS OpsWorks Stacks does not associate built-in security groups
	//    with layers. You must create appropriate Amazon Elastic Compute Cloud
	//    (Amazon EC2) security groups and associate a security group with each
	//    layer that you create. However, you can still manually associate a built-in
	//    security group with a layer on creation; custom security groups are required
	//    only for those layers that need custom settings.
	//
	// For more information, see Create a New Stack (https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html).
	UseOpsworksSecurityGroups *bool `type:"boolean"`

	// The ID of the VPC that the cloned stack is to be launched into. It must be
	// in the specified region. All instances are launched into this VPC, and you
	// cannot change the ID later.
	//
	//    * If your account supports EC2 Classic, the default value is no VPC.
	//
	//    * If your account does not support EC2 Classic, the default value is the
	//    default VPC for the specified region.
	//
	// If the VPC ID corresponds to a default VPC and you have specified either
	// the DefaultAvailabilityZone or the DefaultSubnetId parameter only, AWS OpsWorks
	// Stacks infers the value of the other parameter. If you specify neither parameter,
	// AWS OpsWorks Stacks sets these parameters to the first valid Availability
	// Zone for the specified region and the corresponding default VPC subnet ID,
	// respectively.
	//
	// If you specify a nondefault VPC ID, note the following:
	//
	//    * It must belong to a VPC in your account that is in the specified region.
	//
	//    * You must specify a value for DefaultSubnetId.
	//
	// For more information about how to use AWS OpsWorks Stacks with a VPC, see
	// Running a Stack in a VPC (https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-vpc.html).
	// For more information about default VPC and EC2 Classic, see Supported Platforms
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html).
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s CloneStackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloneStackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloneStackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloneStackInput"}
	if s.ServiceRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceRoleArn"))
	}
	if s.SourceStackId == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceStackId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *CloneStackInput) SetAgentVersion(v string) *CloneStackInput {
	s.AgentVersion = &v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *CloneStackInput) SetAttributes(v map[string]*string) *CloneStackInput {
	s.Attributes = v
	return s
}

// SetChefConfiguration sets the ChefConfiguration field's value.
func (s *CloneStackInput) SetChefConfiguration(v *ChefConfiguration) *CloneStackInput {
	s.ChefConfiguration = v
	return s
}

// SetCloneAppIds sets the CloneAppIds field's value.
func (s *CloneStackInput) SetCloneAppIds(v []*string) *CloneStackInput {
	s.CloneAppIds = v
	return s
}

// SetClonePermissions sets the ClonePermissions field's value.
func (s *CloneStackInput) SetClonePermissions(v bool) *CloneStackInput {
	s.ClonePermissions = &v
	return s
}

// SetConfigurationManager sets the ConfigurationManager field's value.
func (s *CloneStackInput) SetConfigurationManager(v *StackConfigurationManager) *CloneStackInput {
	s.ConfigurationManager = v
	return s
}

// SetCustomCookbooksSource sets the CustomCookbooksSource field's value.
func (s *CloneStackInput) SetCustomCookbooksSource(v *Source) *CloneStackInput {
	s.CustomCookbooksSource = v
	return s
}

// SetCustomJson sets the CustomJson field's value.
func (s *CloneStackInput) SetCustomJson(v string) *CloneStackInput {
	s.CustomJson = &v
	return s
}

// SetDefaultAvailabilityZone sets the DefaultAvailabilityZone field's value.
func (s *CloneStackInput) SetDefaultAvailabilityZone(v string) *CloneStackInput {
	s.DefaultAvailabilityZone = &v
	return s
}

// SetDefaultInstanceProfileArn sets the DefaultInstanceProfileArn field's value.
func (s *CloneStackInput) SetDefaultInstanceProfileArn(v string) *CloneStackInput {
	s.DefaultInstanceProfileArn = &v
	return s
}

// SetDefaultOs sets the DefaultOs field's value.
func (s *CloneStackInput) SetDefaultOs(v string) *CloneStackInput {
	s.DefaultOs = &v
	return s
}

// SetDefaultRootDeviceType sets the DefaultRootDeviceType field's value.
func (s *CloneStackInput) SetDefaultRootDeviceType(v string) *CloneStackInput {
	s.DefaultRootDeviceType = &v
	return s
}

// SetDefaultSshKeyName sets the DefaultSshKeyName field's value.
func (s *CloneStackInput) SetDefaultSshKeyName(v string) *CloneStackInput {
	s.DefaultSshKeyName = &v
	return s
}

// SetDefaultSubnetId sets the DefaultSubnetId field's value.
func (s *CloneStackInput) SetDefaultSubnetId(v string) *CloneStackInput {
	s.DefaultSubnetId = &v
	return s
}

// SetHostnameTheme sets the HostnameTheme field's value.
func (s *CloneStackInput) SetHostnameTheme(v string) *CloneStackInput {
	s.HostnameTheme = &v
	return s
}

// SetName sets the Name field's value.
func (s *CloneStackInput) SetName(v string) *CloneStackInput {
	s.Name = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *CloneStackInput) SetRegion(v string) *CloneStackInput {
	s.Region = &v
	return s
}

// SetServiceRoleArn sets the ServiceRoleArn field's value.
func (s *CloneStackInput) SetServiceRoleArn(v string) *CloneStackInput {
	s.ServiceRoleArn = &v
	return s
}

// SetSourceStackId sets the SourceStackId field's value.
func (s *CloneStackInput) SetSourceStackId(v string) *CloneStackInput {
	s.SourceStackId = &v
	return s
}

// SetUseCustomCookbooks sets the UseCustomCookbooks field's value.
func (s *CloneStackInput) SetUseCustomCookbooks(v bool) *CloneStackInput {
	s.UseCustomCookbooks = &v
	return s
}

// SetUseOpsworksSecurityGroups sets the UseOpsworksSecurityGroups field's value.
func (s *CloneStackInput) SetUseOpsworksSecurityGroups(v bool) *CloneStackInput {
	s.UseOpsworksSecurityGroups = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *CloneStackInput) SetVpcId(v string) *CloneStackInput {
	s.VpcId = &v
	return s
}

// Contains the response to a CloneStack request.
type CloneStackOutput struct {
	_ struct{} `type:"structure"`

	// The cloned stack ID.
	StackId *string `type:"string"`
}

// String returns the string representation
func (s CloneStackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloneStackOutput) GoString() string {
	return s.String()
}

// SetStackId sets the StackId field's value.
func (s *CloneStackOutput) SetStackId(v string) *CloneStackOutput {
	s.StackId = &v
	return s
}

// Describes the Amazon CloudWatch logs configuration for a layer.
type CloudWatchLogsConfiguration struct {
	_ struct{} `type:"structure"`

	// Whether CloudWatch Logs is enabled for a layer.
	Enabled *bool `type:"boolean"`

	// A list of configuration options for CloudWatch Logs.
	LogStreams []*CloudWatchLogsLogStream `type:"list"`
}

// String returns the string representation
func (s CloudWatchLogsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloudWatchLogsConfiguration) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *CloudWatchLogsConfiguration) SetEnabled(v bool) *CloudWatchLogsConfiguration {
	s.Enabled = &v
	return s
}

// SetLogStreams sets the LogStreams field's value.
func (s *CloudWatchLogsConfiguration) SetLogStreams(v []*CloudWatchLogsLogStream) *CloudWatchLogsConfiguration {
	s.LogStreams = v
	return s
}

// Describes the Amazon CloudWatch logs configuration for a layer. For detailed
// information about members of this data type, see the CloudWatch Logs Agent
// Reference (https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AgentReference.html).
type CloudWatchLogsLogStream struct {
	_ struct{} `type:"structure"`

	// Specifies the max number of log events in a batch, up to 10000. The default
	// value is 1000.
	BatchCount *int64 `type:"integer"`

	// Specifies the maximum size of log events in a batch, in bytes, up to 1048576
	// bytes. The default value is 32768 bytes. This size is calculated as the sum
	// of all event messages in UTF-8, plus 26 bytes for each log event.
	BatchSize *int64 `type:"integer"`

	// Specifies the time duration for the batching of log events. The minimum value
	// is 5000ms and default value is 5000ms.
	BufferDuration *int64 `type:"integer"`

	// Specifies how the time stamp is extracted from logs. For more information,
	// see the CloudWatch Logs Agent Reference (https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AgentReference.html).
	DatetimeFormat *string `type:"string"`

	// Specifies the encoding of the log file so that the file can be read correctly.
	// The default is utf_8. Encodings supported by Python codecs.decode() can be
	// used here.
	Encoding *string `type:"string" enum:"CloudWatchLogsEncoding"`

	// Specifies log files that you want to push to CloudWatch Logs.
	//
	// File can point to a specific file or multiple files (by using wild card characters
	// such as /var/log/system.log*). Only the latest file is pushed to CloudWatch
	// Logs, based on file modification time. We recommend that you use wild card
	// characters to specify a series of files of the same type, such as access_log.2014-06-01-01,
	// access_log.2014-06-01-02, and so on by using a pattern like access_log.*.
	// Don't use a wildcard to match multiple file types, such as access_log_80
	// and access_log_443. To specify multiple, different file types, add another
	// log stream entry to the configuration file, so that each log file type is
	// stored in a different log group.
	//
	// Zipped files are not supported.
	File *string `type:"string"`

	// Specifies the range of lines for identifying a file. The valid values are
	// one number, or two dash-delimited numbers, such as '1', '2-5'. The default
	// value is '1', meaning the first line is used to calculate the fingerprint.
	// Fingerprint lines are not sent to CloudWatch Logs unless all specified lines
	// are available.
	FileFingerprintLines *string `type:"string"`

	// Specifies where to start to read data (start_of_file or end_of_file). The
	// default is start_of_file. This setting is only used if there is no state
	// persisted for that log stream.
	InitialPosition *string `type:"string" enum:"CloudWatchLogsInitialPosition"`

	// Specifies the destination log group. A log group is created automatically
	// if it doesn't already exist. Log group names can be between 1 and 512 characters
	// long. Allowed characters include a-z, A-Z, 0-9, '_' (underscore), '-' (hyphen),
	// '/' (forward slash), and '.' (period).
	LogGroupName *string `type:"string"`

	// Specifies the pattern for identifying the start of a log message.
	MultiLineStartPattern *string `type:"string"`

	// Specifies the time zone of log event time stamps.
	TimeZone *string `type:"string" enum:"CloudWatchLogsTimeZone"`
}

// String returns the string representation
func (s CloudWatchLogsLogStream) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CloudWatchLogsLogStream) GoString() string {
	return s.String()
}

// SetBatchCount sets the BatchCount field's value.
func (s *CloudWatchLogsLogStream) SetBatchCount(v int64) *CloudWatchLogsLogStream {
	s.BatchCount = &v
	return s
}

// SetBatchSize sets the BatchSize field's value.
func (s *CloudWatchLogsLogStream) SetBatchSize(v int64) *CloudWatchLogsLogStream {
	s.BatchSize = &v
	return s
}

// SetBufferDuration sets the BufferDuration field's value.
func (s *CloudWatchLogsLogStream) SetBufferDuration(v int64) *CloudWatchLogsLogStream {
	s.BufferDuration = &v
	return s
}

// SetDatetimeFormat sets the DatetimeFormat field's value.
func (s *CloudWatchLogsLogStream) SetDatetimeFormat(v string) *CloudWatchLogsLogStream {
	s.DatetimeFormat = &v
	return s
}

// SetEncoding sets the Encoding field's value.
func (s *CloudWatchLogsLogStream) SetEncoding(v string) *CloudWatchLogsLogStream {
	s.Encoding = &v
	return s
}

// SetFile sets the File field's value.
func (s *CloudWatchLogsLogStream) SetFile(v string) *CloudWatchLogsLogStream {
	s.File = &v
	return s
}

// SetFileFingerprintLines sets the FileFingerprintLines field's value.
func (s *CloudWatchLogsLogStream) SetFileFingerprintLines(v string) *CloudWatchLogsLogStream {
	s.FileFingerprintLines = &v
	return s
}

// SetInitialPosition sets the InitialPosition field's value.
func (s *CloudWatchLogsLogStream) SetInitialPosition(v string) *CloudWatchLogsLogStream {
	s.InitialPosition = &v
	return s
}

// SetLogGroupName sets the LogGroupName field's value.
func (s *CloudWatchLogsLogStream) SetLogGroupName(v string) *CloudWatchLogsLogStream {
	s.LogGroupName = &v
	return s
}

// SetMultiLineStartPattern sets the MultiLineStartPattern field's value.
func (s *CloudWatchLogsLogStream) SetMultiLineStartPattern(v string) *CloudWatchLogsLogStream {
	s.MultiLineStartPattern = &v
	return s
}

// SetTimeZone sets the TimeZone field's value.
func (s *CloudWatchLogsLogStream) SetTimeZone(v string) *CloudWatchLogsLogStream {
	s.TimeZone = &v
	return s
}

// Describes a command.
type Command struct {
	_ struct{} `type:"structure"`

	// Date and time when the command was acknowledged.
	AcknowledgedAt *string `type:"string"`

	// The command ID.
	CommandId *string `type:"string"`

	// Date when the command completed.
	CompletedAt *string `type:"string"`

	// Date and time when the command was run.
	CreatedAt *string `type:"string"`

	// The command deployment ID.
	DeploymentId *string `type:"string"`

	// The command exit code.
	ExitCode *int64 `type:"integer"`

	// The ID of the instance where the command was executed.
	InstanceId *string `type:"string"`

	// The URL of the command log.
	LogUrl *string `type:"string"`

	// The command status:
	//
	//    * failed
	//
	//    * successful
	//
	//    * skipped
	//
	//    * pending
	Status *string `type:"string"`

	// The command type:
	//
	//    * configure
	//
	//    * deploy
	//
	//    * execute_recipes
	//
	//    * install_dependencies
	//
	//    * restart
	//
	//    * rollback
	//
	//    * setup
	//
	//    * start
	//
	//    * stop
	//
	//    * undeploy
	//
	//    * update_custom_cookbooks
	//
	//    * update_dependencies
	Type *string `type:"string"`
}

// String returns the string representation
func (s Command) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Command) GoString() string {
	return s.String()
}

// SetAcknowledgedAt sets the AcknowledgedAt field's value.
func (s *Command) SetAcknowledgedAt(v string) *Command {
	s.AcknowledgedAt = &v
	return s
}

// SetCommandId sets the CommandId field's value.
func (s *Command) SetCommandId(v string) *Command {
	s.CommandId = &v
	return s
}

// SetCompletedAt sets the CompletedAt field's value.
func (s *Command) SetCompletedAt(v string) *Command {
	s.CompletedAt = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Command) SetCreatedAt(v string) *Command {
	s.CreatedAt = &v
	return s
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *Command) SetDeploymentId(v string) *Command {
	s.DeploymentId = &v
	return s
}

// SetExitCode sets the ExitCode field's value.
func (s *Command) SetExitCode(v int64) *Command {
	s.ExitCode = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *Command) SetInstanceId(v string) *Command {
	s.InstanceId = &v
	return s
}

// SetLogUrl sets the LogUrl field's value.
func (s *Command) SetLogUrl(v string) *Command {
	s.LogUrl = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Command) SetStatus(v string) *Command {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *Command) SetType(v string) *Command {
	s.Type = &v
	return s
}

type CreateAppInput struct {
	_ struct{} `type:"structure"`

	// A Source object that specifies the app repository.
	AppSource *Source `type:"structure"`

	// One or more user-defined key/value pairs to be added to the stack attributes.
	Attributes map[string]*string `type:"map"`

	// The app's data source.
	DataSources []*DataSource `type:"list"`

	// A description of the app.
	Description *string `type:"string"`

	// The app virtual host settings, with multiple domains separated by commas.
	// For example: 'www.example.com, example.com'
	Domains []*string `type:"list"`

	// Whether to enable SSL for the app.
	EnableSsl *bool `type:"boolean"`

	// An array of EnvironmentVariable objects that specify environment variables
	// to be associated with the app. After you deploy the app, these variables
	// are defined on the associated app server instance. For more information,
	// see Environment Variables (https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment).
	//
	// There is no specific limit on the number of environment variables. However,
	// the size of the associated data structure - which includes the variables'
	// names, values, and protected flag values - cannot exceed 20 KB. This limit
	// should accommodate most if not all use cases. Exceeding it will cause an
	// exception with the message, "Environment: is too large (maximum is 20KB)."
	//
	// If you have specified one or more environment variables, you cannot modify
	// the stack's Chef version.
	Environment []*EnvironmentVariable `type:"list"`

	// The app name.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The app's short name.
	Shortname *string `type:"string"`

	// An SslConfiguration object with the SSL configuration.
	SslConfiguration *SslConfiguration `type:"structure"`

	// The stack ID.
	//
	// StackId is a required field
	StackId *string `type:"string" required:"true"`

	// The app type. Each supported type is associated with a particular layer.
	// For example, PHP applications are associated with a PHP layer. AWS OpsWorks
	// Stacks deploys an application to those instances that are members of the
	// corresponding layer. If your app isn't one of the standard types, or you
	// prefer to implement your own Deploy recipes, specify other.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"AppType"`
}

// String returns the string representation
func (s CreateAppInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAppInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAppInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAppInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.StackId == nil {
		invalidParams.Add(request.NewErrParamRequired("StackId"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Environment != nil {
		for i, v := range s.Environment {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Environment", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SslConfiguration != nil {
		if err := s.SslConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SslConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppSource sets the AppSource field's value.
func (s *CreateAppInput) SetAppSource(v *Source) *CreateAppInput {
	s.AppSource = v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *CreateAppInput) SetAttributes(v map[string]*string) *CreateAppInput {
	s.Attributes = v
	return s
}

// SetDataSources sets the DataSources field's value.
func (s *CreateAppInput) SetDataSources(v []*DataSource) *CreateAppInput {
	s.DataSources = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateAppInput) SetDescription(v string) *CreateAppInput {
	s.Description = &v
	return s
}

// SetDomains sets the Domains field's value.
func (s *CreateAppInput) SetDomains(v []*string) *CreateAppInput {
	s.Domains = v
	return s
}

// SetEnableSsl sets the EnableSsl field's value.
func (s *CreateAppInput) SetEnableSsl(v bool) *CreateAppInput {
	s.EnableSsl = &v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *CreateAppInput) SetEnvironment(v []*EnvironmentVariable) *CreateAppInput {
	s.Environment = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAppInput) SetName(v string) *CreateAppInput {
	s.Name = &v
	return s
}

// SetShortname sets the Shortname field's value.
func (s *CreateAppInput) SetShortname(v string) *CreateAppInput {
	s.Shortname = &v
	return s
}

// SetSslConfiguration sets the SslConfiguration field's value.
func (s *CreateAppInput) SetSslConfiguration(v *SslConfiguration) *CreateAppInput {
	s.SslConfiguration = v
	return s
}

// SetStackId sets the StackId field's value.
func (s *CreateAppInput) SetStackId(v string) *CreateAppInput {
	s.StackId = &v
	return s
}

// SetType sets the Type field's value.
func (s *CreateAppInput) SetType(v string) *CreateAppInput {
	s.Type = &v
	return s
}

// Contains the response to a CreateApp request.
type CreateAppOutput struct {
	_ struct{} `type:"structure"`

	// The app ID.
	AppId *string `type:"string"`
}

// String returns the string representation
func (s CreateAppOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAppOutput) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *CreateAppOutput) SetAppId(v string) *CreateAppOutput {
	s.AppId = &v
	return s
}

type CreateDeploymentInput struct {
	_ struct{} `type:"structure"`

	// The app ID. This parameter is required for app deployments, but not for other
	// deployment commands.
	AppId *string `type:"string"`

	// A DeploymentCommand object that specifies the deployment command and any
	// associated arguments.
	//
	// Command is a required field
	Command *DeploymentCommand `type:"structure" required:"true"`

	// A user-defined comment.
	Comment *string `type:"string"`

	// A string that contains user-defined, custom JSON. You can use this parameter
	// to override some corresponding default stack configuration JSON values. The
	// string should be in the following format:
	//
	// "{\"key1\": \"value1\", \"key2\": \"value2\",...}"
	//
	// For more information about custom JSON, see Use Custom JSON to Modify the
	// Stack Configuration Attributes (https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html)
	// and Overriding Attributes With Custom JSON (https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook-json-override.html).
	CustomJson *string `type:"string"`

	// The instance IDs for the deployment targets.
	InstanceIds []*string `type:"list"`

	// The layer IDs for the deployment targets.
	LayerIds []*string `type:"list"`

	// The stack ID.
	//
	// StackId is a required field
	StackId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateDeploymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDeploymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDeploymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDeploymentInput"}
	if s.Command == nil {
		invalidParams.Add(request.NewErrParamRequired("Command"))
	}
	if s.StackId == nil {
		invalidParams.Add(request.NewErrParamRequired("StackId"))
	}
	if s.Command != nil {
		if err := s.Command.Validate(); err != nil {
			invalidParams.AddNested("Command", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *CreateDeploymentInput) SetAppId(v string) *CreateDeploymentInput {
	s.AppId = &v
	return s
}

// SetCommand sets the Command field's value.
func (s *CreateDeploymentInput) SetCommand(v *DeploymentCommand) *CreateDeploymentInput {
	s.Command = v
	return s
}

// SetComment sets the Comment field's value.
func (s *CreateDeploymentInput) SetComment(v string) *CreateDeploymentInput {
	s.Comment = &v
	return s
}

// SetCustomJson sets the CustomJson field's value.
func (s *CreateDeploymentInput) SetCustomJson(v string) *CreateDeploymentInput {
	s.CustomJson = &v
	return s
}

// SetInstanceIds sets the InstanceIds field's value.
func (s *CreateDeploymentInput) SetInstanceIds(v []*string) *CreateDeploymentInput {
	s.InstanceIds = v
	return s
}

// SetLayerIds sets the LayerIds field's value.
func (s *CreateDeploymentInput) SetLayerIds(v []*string) *CreateDeploymentInput {
	s.LayerIds = v
	return s
}

// SetStackId sets the StackId field's value.
func (s *CreateDeploymentInput) SetStackId(v string) *CreateDeploymentInput {
	s.StackId = &v
	return s
}

// Contains the response to a CreateDeployment request.
type CreateDeploymentOutput struct {
	_ struct{} `type:"structure"`

	// The deployment ID, which can be used with other requests to identify the
	// deployment.
	DeploymentId *string `type:"string"`
}

// String returns the string representation
func (s CreateDeploymentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDeploymentOutput) GoString() string {
	return s.String()
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *CreateDeploymentOutput) SetDeploymentId(v string) *CreateDeploymentOutput {
	s.DeploymentId = &v
	return s
}

type CreateInstanceInput struct {
	_ struct{} `type:"structure"`

	// The default AWS OpsWorks Stacks agent version. You have the following options:
	//
	//    * INHERIT - Use the stack's default agent version setting.
	//
	//    * version_number - Use the specified agent version. This value overrides
	//    the stack's default setting. To update the agent version, edit the instance
	//    configuration and specify a new version. AWS OpsWorks Stacks then automatically
	//    installs that version on the instance.
	//
	// The default setting is INHERIT. To specify an agent version, you must use
	// the complete version number, not the abbreviated number shown on the console.
	// For a list of available agent version numbers, call DescribeAgentVersions.
	// AgentVersion cannot be set to Chef 12.2.
	AgentVersion *string `type:"string"`

	// A custom AMI ID to be used to create the instance. The AMI should be based
	// on one of the supported operating systems. For more information, see Using
	// Custom AMIs (https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html).
	//
	// If you specify a custom AMI, you must set Os to Custom.
	AmiId *string `type:"string"`

	// The instance architecture. The default option is x86_64. Instance types do
	// not necessarily support both architectures. For a list of the architectures
	// that are supported by the different instance types, see Instance Families
	// and Types (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html).
	Architecture *string `type:"string" enum:"Architecture"`

	// For load-based or time-based instances, the type. Windows stacks can use
	// only time-based instances.
	AutoScalingType *string `type:"string" enum:"AutoScalingType"`

	// The instance Availability Zone. For more information, see Regions and Endpoints
	// (https://docs.aws.amazon.com/general/latest/gr/rande.html).
	AvailabilityZone *string `type:"string"`

	// An array of BlockDeviceMapping objects that specify the instance's block
	// devices. For more information, see Block Device Mapping (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html).
	// Note that block device mappings are not supported for custom AMIs.
	BlockDeviceMappings []*BlockDeviceMapping `type:"list"`

	// Whether to create an Amazon EBS-optimized instance.
	EbsOptimized *bool `type:"boolean"`

	// The instance host name.
	Hostname *string `type:"string"`

	// Whether to install operating system and package updates when the instance
	// boots. The default value is true. To control when updates are installed,
	// set this value to false. You must then update your instances manually by
	// using CreateDeployment to run the update_dependencies stack command or by
	// manually running yum (Amazon Linux) or apt-get (Ubuntu) on the instances.
	//
	// We strongly recommend using the default value of true to ensure that your
	// instances have the latest security updates.
	InstallUpdatesOnBoot *bool `type:"boolean"`

	// The instance type, such as t2.micro. For a list of supported instance types,
	// open the stack in the console, choose Instances, and choose + Instance. The
	// Size list contains the currently supported types. For more information, see
	// Instance Families and Types (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html).
	// The parameter values that you use to specify the various types are in the
	// API Name column of the Available Instance Types table.
	//
	// InstanceType is a required field
	InstanceType *string `type:"string" required:"true"`

	// An array that contains the instance's layer IDs.
	//
	// LayerIds is a required field
	LayerIds []*string `type:"list" required:"true"`

	// The instance's operating system, which must be set to one of the following.
	//
	//    * A supported Linux operating system: An Amazon Linux version, such as
	//    Amazon Linux 2018.03, Amazon Linux 2017.09, Amazon Linux 2017.03, Amazon
	//    Linux 2016.09, Amazon Linux 2016.03, Amazon Linux 2015.09, or Amazon Linux
	//    2015.03.
	//
	//    * A supported Ubuntu operating system, such as Ubuntu 16.04 LTS, Ubuntu
	//    14.04 LTS, or Ubuntu 12.04 LTS.
	//
	//    * CentOS Linux 7
	//
	//    * Red Hat Enterprise Linux 7
	//
	//    * A supported Windows operating system, such as Microsoft Windows Server
	//    2012 R2 Base, Microsoft Windows Server 2012 R2 with SQL Server Express,
	//    Microsoft Windows Server 2012 R2 with SQL Server Standard, or Microsoft
	//    Windows Server 2012 R2 with SQL Server Web.
	//
	//    * A custom AMI: Custom.
	//
	// For more information about the supported operating systems, see AWS OpsWorks
	// Stacks Operating Systems (https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html).
	//
	// The default option is the current Amazon Linux version. If you set this parameter
	// to Custom, you must use the CreateInstance action's AmiId parameter to specify
	// the custom AMI that you want to use. Block device mappings are not supported
	// if the value is Custom. For more information about supported operating systems,
	// see Operating Systems (https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html)For
	// more information about how to use custom AMIs with AWS OpsWorks Stacks, see
	// Using Custom AMIs (https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html).
	Os *string `type:"string"`

	// The instance root device type. For more information, see Storage for the
	// Root Device (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device).
	RootDeviceType *string `type:"string" enum:"RootDeviceType"`

	// The instance's Amazon EC2 key-pair name.
	SshKeyName *string `type:"string"`

	// The stack ID.
	//
	// StackId is a required field
	StackId *string `type:"string" required:"true"`

	// The ID of the instance's subnet. If the stack is running in a VPC, you can
	// use this parameter to override the stack's default subnet ID value and direct
	// AWS OpsWorks Stacks to launch the instance in a different subnet.
	SubnetId *string `type:"string"`

	// The instance's tenancy option. The default option is no tenancy, or if the
	// instance is running in a VPC, inherit tenancy settings from the VPC. The
	// following are valid values for this parameter: dedicated, default, or host.
	// Because there are costs associated with changes in tenancy options, we recommend
	// that you research tenancy options before choosing them for your instances.
	// For more information about dedicated hosts, see Dedicated Hosts Overview
	// (http://aws.amazon.com/ec2/dedicated-hosts/) and Amazon EC2 Dedicated Hosts
	// (http://aws.amazon.com/ec2/dedicated-hosts/). For more information about
	// dedicated instances, see Dedicated Instances (https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/dedicated-instance.html)
	// and Amazon EC2 Dedicated Instances (http://aws.amazon.com/ec2/purchasing-options/dedicated-instances/).
	Tenancy *string `type:"string"`

	// The instance's virtualization type, paravirtual or hvm.
	VirtualizationType *string `type:"string"`
}

// String returns the string representation
func (s CreateInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateInstanceInput"}
	if s.InstanceType == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceType"))
	}
	if s.LayerIds == nil {
		invalidParams.Add(request.NewErrParamRequired("LayerIds"))
	}
	if s.StackId == nil {
		invalidParams.Add(request.NewErrParamRequired("StackId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *CreateInstanceInput) SetAgentVersion(v string) *CreateInstanceInput {
	s.AgentVersion = &v
	return s
}

// SetAmiId sets the AmiId field's value.
func (s *CreateInstanceInput) SetAmiId(v string) *CreateInstanceInput {
	s.AmiId = &v
	return s
}

// SetArchitecture sets the Architecture field's value.
func (s *CreateInstanceInput) SetArchitecture(v string) *CreateInstanceInput {
	s.Architecture = &v
	return s
}

// SetAutoScalingType sets the AutoScalingType field's value.
func (s *CreateInstanceInput) SetAutoScalingType(v string) *CreateInstanceInput {
	s.AutoScalingType = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *CreateInstanceInput) SetAvailabilityZone(v string) *CreateInstanceInput {
	s.AvailabilityZone = &v
	return s
}

// SetBlockDeviceMappings sets the BlockDeviceMappings field's value.
func (s *CreateInstanceInput) SetBlockDeviceMappings(v []*BlockDeviceMapping) *CreateInstanceInput {
	s.BlockDeviceMappings = v
	return s
}

// SetEbsOptimized sets the EbsOptimized field's value.
func (s *CreateInstanceInput) SetEbsOptimized(v bool) *CreateInstanceInput {
	s.EbsOptimized = &v
	return s
}

// SetHostname sets the Hostname field's value.
func (s *CreateInstanceInput) SetHostname(v string) *CreateInstanceInput {
	s.Hostname = &v
	return s
}

// SetInstallUpdatesOnBoot sets the InstallUpdatesOnBoot field's value.
func (s *CreateInstanceInput) SetInstallUpdatesOnBoot(v bool) *CreateInstanceInput {
	s.InstallUpdatesOnBoot = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *CreateInstanceInput) SetInstanceType(v string) *CreateInstanceInput {
	s.InstanceType = &v
	return s
}

// SetLayerIds sets the LayerIds field's value.
func (s *CreateInstanceInput) SetLayerIds(v []*string) *CreateInstanceInput {
	s.LayerIds = v
	return s
}

// SetOs sets the Os field's value.
func (s *CreateInstanceInput) SetOs(v string) *CreateInstanceInput {
	s.Os = &v
	return s
}

// SetRootDeviceType sets the RootDeviceType field's value.
func (s *CreateInstanceInput) SetRootDeviceType(v string) *CreateInstanceInput {
	s.RootDeviceType = &v
	return s
}

// SetSshKeyName sets the SshKeyName field's value.
func (s *CreateInstanceInput) SetSshKeyName(v string) *CreateInstanceInput {
	s.SshKeyName = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *CreateInstanceInput) SetStackId(v string) *CreateInstanceInput {
	s.StackId = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *CreateInstanceInput) SetSubnetId(v string) *CreateInstanceInput {
	s.SubnetId = &v
	return s
}

// SetTenancy sets the Tenancy field's value.
func (s *CreateInstanceInput) SetTenancy(v string) *CreateInstanceInput {
	s.Tenancy = &v
	return s
}

// SetVirtualizationType sets the VirtualizationType field's value.
func (s *CreateInstanceInput) SetVirtualizationType(v string) *CreateInstanceInput {
	s.VirtualizationType = &v
	return s
}

// Contains the response to a CreateInstance request.
type CreateInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The instance ID.
	InstanceId *string `type:"string"`
}

// String returns the string representation
func (s CreateInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInstanceOutput) GoString() string {
	return s.String()
}

// SetInstanceId sets the InstanceId field's value.
func (s *CreateInstanceOutput) SetInstanceId(v string) *CreateInstanceOutput {
	s.InstanceId = &v
	return s
}

type CreateLayerInput struct {
	_ struct{} `type:"structure"`

	// One or more user-defined key-value pairs to be added to the stack attributes.
	//
	// To create a cluster layer, set the EcsClusterArn attribute to the cluster's
	// ARN.
	Attributes map[string]*string `type:"map"`

	// Whether to automatically assign an Elastic IP address (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html)
	// to the layer's instances. For more information, see How to Edit a Layer (https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html).
	AutoAssignElasticIps *bool `type:"boolean"`

	// For stacks that are running in a VPC, whether to automatically assign a public
	// IP address to the layer's instances. For more information, see How to Edit
	// a Layer (https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html).
	AutoAssignPublicIps *bool `type:"boolean"`

	// Specifies CloudWatch Logs configuration options for the layer. For more information,
	// see CloudWatchLogsLogStream.
	CloudWatchLogsConfiguration *CloudWatchLogsConfiguration `type:"structure"`

	// The ARN of an IAM profile to be used for the layer's EC2 instances. For more
	// information about IAM ARNs, see Using Identifiers (https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html).
	CustomInstanceProfileArn *string `type:"string"`

	// A JSON-formatted string containing custom stack configuration and deployment
	// attributes to be installed on the layer's instances. For more information,
	// see Using Custom JSON (https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook-json-override.html).
	// This feature is supported as of version 1.7.42 of the AWS CLI.
	CustomJson *string `type:"string"`

	// A LayerCustomRecipes object that specifies the layer custom recipes.
	CustomRecipes *Recipes `type:"structure"`

	// An array containing the layer custom security group IDs.
	CustomSecurityGroupIds []*string `type:"list"`

	// Whether to disable auto healing for the layer.
	EnableAutoHealing *bool `type:"boolean"`

	// Whether to install operating system and package updates when the instance
	// boots. The default value is true. To control when updates are installed,
	// set this value to false. You must then update your instances manually by
	// using CreateDeployment to run the update_dependencies stack command or by
	// manually running yum (Amazon Linux) or apt-get (Ubuntu) on the instances.
	//
	// To ensure that your instances have the latest security updates, we strongly
	// recommend using the default value of true.
	InstallUpdatesOnBoot *bool `type:"boolean"`

	// A LifeCycleEventConfiguration object that you can use to configure the Shutdown
	// event to specify an execution timeout and enable or disable Elastic Load
	// Balancer connection draining.
	LifecycleEventConfiguration *LifecycleEventConfiguration `type:"structure"`

	// The layer name, which is used by the console.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// An array of Package objects that describes the layer packages.
	Packages []*string `type:"list"`

	// For custom layers only, use this parameter to specify the layer's short name,
	// which is used internally by AWS OpsWorks Stacks and by Chef recipes. The
	// short name is also used as the name for the directory where your app files
	// are installed. It can have a maximum of 200 characters, which are limited
	// to the alphanumeric characters, '-', '_', and '.'.
	//
	// The built-in layers' short names are defined by AWS OpsWorks Stacks. For
	// more information, see the Layer Reference (https://docs.aws.amazon.com/opsworks/latest/userguide/layers.html).
	//
	// Shortname is a required field
	Shortname *string `type:"string" required:"true"`

	// The layer stack ID.
	//
	// StackId is a required field
	StackId *string `type:"string" required:"true"`

	// The layer type. A stack cannot have more than one built-in layer of the same
	// type. It can have any number of custom layers. Built-in layers are not available
	// in Chef 12 stacks.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"LayerType"`

	// Whether to use Amazon EBS-optimized instances.
	UseEbsOptimizedInstances *bool `type:"boolean"`

	// A VolumeConfigurations object that describes the layer's Amazon EBS volumes.
	VolumeConfigurations []*VolumeConfiguration `type:"list"`
}

// String returns the string representation
func (s CreateLayerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLayerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLayerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLayerInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Shortname == nil {
		invalidParams.Add(request.NewErrParamRequired("Shortname"))
	}
	if s.StackId == nil {
		invalidParams.Add(request.NewErrParamRequired("StackId"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.VolumeConfigurations != nil {
		for i, v := range s.VolumeConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "VolumeConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *CreateLayerInput) SetAttributes(v map[string]*string) *CreateLayerInput {
	s.Attributes = v
	return s
}

// SetAutoAssignElasticIps sets the AutoAssignElasticIps field's value.
func (s *CreateLayerInput) SetAutoAssignElasticIps(v bool) *CreateLayerInput {
	s.AutoAssignElasticIps = &v
	return s
}

// SetAutoAssignPublicIps sets the AutoAssignPublicIps field's value.
func (s *CreateLayerInput) SetAutoAssignPublicIps(v bool) *CreateLayerInput {
	s.AutoAssignPublicIps = &v
	return s
}

// SetCloudWatchLogsConfiguration sets the CloudWatchLogsConfiguration field's value.
func (s *CreateLayerInput) SetCloudWatchLogsConfiguration(v *CloudWatchLogsConfiguration) *CreateLayerInput {
	s.CloudWatchLogsConfiguration = v
	return s
}

// SetCustomInstanceProfileArn sets the CustomInstanceProfileArn field's value.
func (s *CreateLayerInput) SetCustomInstanceProfileArn(v string) *CreateLayerInput {
	s.CustomInstanceProfileArn = &v
	return s
}

// SetCustomJson sets the CustomJson field's value.
func (s *CreateLayerInput) SetCustomJson(v string) *CreateLayerInput {
	s.CustomJson = &v
	return s
}

// SetCustomRecipes sets the CustomRecipes field's value.
func (s *CreateLayerInput) SetCustomRecipes(v *Recipes) *CreateLayerInput {
	s.CustomRecipes = v
	return s
}

// SetCustomSecurityGroupIds sets the CustomSecurityGroupIds field's value.
func (s *CreateLayerInput) SetCustomSecurityGroupIds(v []*string) *CreateLayerInput {
	s.CustomSecurityGroupIds = v
	return s
}

// SetEnableAutoHealing sets the EnableAutoHealing field's value.
func (s *CreateLayerInput) SetEnableAutoHealing(v bool) *CreateLayerInput {
	s.EnableAutoHealing = &v
	return s
}

// SetInstallUpdatesOnBoot sets the InstallUpdatesOnBoot field's value.
func (s *CreateLayerInput) SetInstallUpdatesOnBoot(v bool) *CreateLayerInput {
	s.InstallUpdatesOnBoot = &v
	return s
}

// SetLifecycleEventConfiguration sets the LifecycleEventConfiguration field's value.
func (s *CreateLayerInput) SetLifecycleEventConfiguration(v *LifecycleEventConfiguration) *CreateLayerInput {
	s.LifecycleEventConfiguration = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateLayerInput) SetName(v string) *CreateLayerInput {
	s.Name = &v
	return s
}

// SetPackages sets the Packages field's value.
func (s *CreateLayerInput) SetPackages(v []*string) *CreateLayerInput {
	s.Packages = v
	return s
}

// SetShortname sets the Shortname field's value.
func (s *CreateLayerInput) SetShortname(v string) *CreateLayerInput {
	s.Shortname = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *CreateLayerInput) SetStackId(v string) *CreateLayerInput {
	s.StackId = &v
	return s
}

// SetType sets the Type field's value.
func (s *CreateLayerInput) SetType(v string) *CreateLayerInput {
	s.Type = &v
	return s
}

// SetUseEbsOptimizedInstances sets the UseEbsOptimizedInstances field's value.
func (s *CreateLayerInput) SetUseEbsOptimizedInstances(v bool) *CreateLayerInput {
	s.UseEbsOptimizedInstances = &v
	return s
}

// SetVolumeConfigurations sets the VolumeConfigurations field's value.
func (s *CreateLayerInput) SetVolumeConfigurations(v []*VolumeConfiguration) *CreateLayerInput {
	s.VolumeConfigurations = v
	return s
}

// Contains the response to a CreateLayer request.
type CreateLayerOutput struct {
	_ struct{} `type:"structure"`

	// The layer ID.
	LayerId *string `type:"string"`
}

// String returns the string representation
func (s CreateLayerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateLayerOutput) GoString() string {
	return s.String()
}

// SetLayerId sets the LayerId field's value.
func (s *CreateLayerOutput) SetLayerId(v string) *CreateLayerOutput {
	s.LayerId = &v
	return s
}

type CreateStackInput struct {
	_ struct{} `type:"structure"`

	// The default AWS OpsWorks Stacks agent version. You have the following options:
	//
	//    * Auto-update - Set this parameter to LATEST. AWS OpsWorks Stacks automatically
	//    installs new agent versions on the stack's instances as soon as they are
	//    available.
	//
	//    * Fixed version - Set this parameter to your preferred agent version.
	//    To update the agent version, you must edit the stack configuration and
	//    specify a new version. AWS OpsWorks Stacks then automatically installs
	//    that version on the stack's instances.
	//
	// The default setting is the most recent release of the agent. To specify an
	// agent version, you must use the complete version number, not the abbreviated
	// number shown on the console. For a list of available agent version numbers,
	// call DescribeAgentVersions. AgentVersion cannot be set to Chef 12.2.
	//
	// You can also specify an agent version when you create or update an instance,
	// which overrides the stack's default setting.
	AgentVersion *string `type:"string"`

	// One or more user-defined key-value pairs to be added to the stack attributes.
	Attributes map[string]*string `type:"map"`

	// A ChefConfiguration object that specifies whether to enable Berkshelf and
	// the Berkshelf version on Chef 11.10 stacks. For more information, see Create
	// a New Stack (https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html).
	ChefConfiguration *ChefConfiguration `type:"structure"`

	// The configuration manager. When you create a stack we recommend that you
	// use the configuration manager to specify the Chef version: 12, 11.10, or
	// 11.4 for Linux stacks, or 12.2 for Windows stacks. The default value for
	// Linux stacks is currently 12.
	ConfigurationManager *StackConfigurationManager `type:"structure"`

	// Contains the information required to retrieve an app or cookbook from a repository.
	// For more information, see Adding Apps (https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html)
	// or Cookbooks and Recipes (https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html).
	CustomCookbooksSource *Source `type:"structure"`

	// A string that contains user-defined, custom JSON. It can be used to override
	// the corresponding default stack configuration attribute values or to pass
	// data to recipes. The string should be in the following format:
	//
	// "{\"key1\": \"value1\", \"key2\": \"value2\",...}"
	//
	// For more information about custom JSON, see Use Custom JSON to Modify the
	// Stack Configuration Attributes (https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html).
	CustomJson *string `type:"string"`

	// The stack's default Availability Zone, which must be in the specified region.
	// For more information, see Regions and Endpoints (https://docs.aws.amazon.com/general/latest/gr/rande.html).
	// If you also specify a value for DefaultSubnetId, the subnet must be in the
	// same zone. For more information, see the VpcId parameter description.
	DefaultAvailabilityZone *string `type:"string"`

	// The Amazon Resource Name (ARN) of an IAM profile that is the default profile
	// for all of the stack's EC2 instances. For more information about IAM ARNs,
	// see Using Identifiers (https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html).
	//
	// DefaultInstanceProfileArn is a required field
	DefaultInstanceProfileArn *string `type:"string" required:"true"`

	// The stack's default operating system, which is installed on every instance
	// unless you specify a different operating system when you create the instance.
	// You can specify one of the following.
	//
	//    * A supported Linux operating system: An Amazon Linux version, such as
	//    Amazon Linux 2018.03, Amazon Linux 2017.09, Amazon Linux 2017.03, Amazon
	//    Linux 2016.09, Amazon Linux 2016.03, Amazon Linux 2015.09, or Amazon Linux
	//    2015.03.
	//
	//    * A supported Ubuntu operating system, such as Ubuntu 16.04 LTS, Ubuntu
	//    14.04 LTS, or Ubuntu 12.04 LTS.
	//
	//    * CentOS Linux 7
	//
	//    * Red Hat Enterprise Linux 7
	//
	//    * A supported Windows operating system, such as Microsoft Windows Server
	//    2012 R2 Base, Microsoft Windows Server 2012 R2 with SQL Server Express,
	//    Microsoft Windows Server 2012 R2 with SQL Server Standard, or Microsoft
	//    Windows Server 2012 R2 with SQL Server Web.
	//
	//    * A custom AMI: Custom. You specify the custom AMI you want to use when
	//    you create instances. For more information, see Using Custom AMIs (https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html).
	//
	// The default option is the current Amazon Linux version. For more information
	// about supported operating systems, see AWS OpsWorks Stacks Operating Systems
	// (https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html).
	DefaultOs *string `type:"string"`

	// The default root device type. This value is the default for all instances
	// in the stack, but you can override it when you create an instance. The default
	// option is instance-store. For more information, see Storage for the Root
	// Device (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device).
	DefaultRootDeviceType *string `type:"string" enum:"RootDeviceType"`

	// A default Amazon EC2 key pair name. The default value is none. If you specify
	// a key pair name, AWS OpsWorks installs the public key on the instance and
	// you can use the private key with an SSH client to log in to the instance.
	// For more information, see Using SSH to Communicate with an Instance (https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-ssh.html)
	// and Managing SSH Access (https://docs.aws.amazon.com/opsworks/latest/userguide/security-ssh-access.html).
	// You can override this setting by specifying a different key pair, or no key
	// pair, when you create an instance (https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-add.html).
	DefaultSshKeyName *string `type:"string"`

	// The stack's default VPC subnet ID. This parameter is required if you specify
	// a value for the VpcId parameter. All instances are launched into this subnet
	// unless you specify otherwise when you create the instance. If you also specify
	// a value for DefaultAvailabilityZone, the subnet must be in that zone. For
	// information on default values and when this parameter is required, see the
	// VpcId parameter description.
	DefaultSubnetId *string `type:"string"`

	// The stack's host name theme, with spaces replaced by underscores. The theme
	// is used to generate host names for the stack's instances. By default, HostnameTheme
	// is set to Layer_Dependent, which creates host names by appending integers
	// to the layer's short name. The other themes are:
	//
	//    * Baked_Goods
	//
	//    * Clouds
	//
	//    * Europe_Cities
	//
	//    * Fruits
	//
	//    * Greek_Deities_and_Titans
	//
	//    * Legendary_creatures_from_Japan
	//
	//    * Planets_and_Moons
	//
	//    * Roman_Deities
	//
	//    * Scottish_Islands
	//
	//    * US_Cities
	//
	//    * Wild_Cats
	//
	// To obtain a generated host name, call GetHostNameSuggestion, which returns
	// a host name based on the current theme.
	HostnameTheme *string `type:"string"`

	// The stack name.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The stack's AWS region, such as ap-south-1. For more information about Amazon
	// regions, see Regions and Endpoints (https://docs.aws.amazon.com/general/latest/gr/rande.html).
	//
	// In the AWS CLI, this API maps to the --stack-region parameter. If the --stack-region
	// parameter and the AWS CLI common parameter --region are set to the same value,
	// the stack uses a regional endpoint. If the --stack-region parameter is not
	// set, but the AWS CLI --region parameter is, this also results in a stack
	// with a regional endpoint. However, if the --region parameter is set to us-east-1,
	// and the --stack-region parameter is set to one of the following, then the
	// stack uses a legacy or classic region: us-west-1, us-west-2, sa-east-1, eu-central-1,
	// eu-west-1, ap-northeast-1, ap-southeast-1, ap-southeast-2. In this case,
	// the actual API endpoint of the stack is in us-east-1. Only the preceding
	// regions are supported as classic regions in the us-east-1 API endpoint. Because
	// it is a best practice to choose the regional endpoint that is closest to
	// where you manage AWS, we recommend that you use regional endpoints for new
	// stacks. The AWS CLI common --region parameter always specifies a regional
	// API endpoint; it cannot be used to specify a classic AWS OpsWorks Stacks
	// region.
	//
	// Region is a required field
	Region *string `type:"string" required:"true"`

	// The stack's AWS Identity and Access Management (IAM) role, which allows AWS
	// OpsWorks Stacks to work with AWS resources on your behalf. You must set this
	// parameter to the Amazon Resource Name (ARN) for an existing IAM role. For
	// more information about IAM ARNs, see Using Identifiers (https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html).
	//
	// ServiceRoleArn is a required field
	ServiceRoleArn *string `type:"string" required:"true"`

	// Whether the stack uses custom cookbooks.
	UseCustomCookbooks *bool `type:"boolean"`

	// Whether to associate the AWS OpsWorks Stacks built-in security groups with
	// the stack's layers.
	//
	// AWS OpsWorks Stacks provides a standard set of built-in security groups,
	// one for each layer, which are associated with layers by default. With UseOpsworksSecurityGroups
	// you can instead provide your own custom security groups. UseOpsworksSecurityGroups
	// has the following settings:
	//
	//    * True - AWS OpsWorks Stacks automatically associates the appropriate
	//    built-in security group with each layer (default setting). You can associate
	//    additional security groups with a layer after you create it, but you cannot
	//    delete the built-in security group.
	//
	//    * False - AWS OpsWorks Stacks does not associate built-in security groups
	//    with layers. You must create appropriate EC2 security groups and associate
	//    a security group with each layer that you create. However, you can still
	//    manually associate a built-in security group with a layer on creation;
	//    custom security groups are required only for those layers that need custom
	//    settings.
	//
	// For more information, see Create a New Stack (https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html).
	UseOpsworksSecurityGroups *bool `type:"boolean"`

	// The ID of the VPC that the stack is to be launched into. The VPC must be
	// in the stack's region. All instances are launched into this VPC. You cannot
	// change the ID later.
	//
	//    * If your account supports EC2-Classic, the default value is no VPC.
	//
	//    * If your account does not support EC2-Classic, the default value is the
	//    default VPC for the specified region.
	//
	// If the VPC ID corresponds to a default VPC and you have specified either
	// the DefaultAvailabilityZone or the DefaultSubnetId parameter only, AWS OpsWorks
	// Stacks infers the value of the other parameter. If you specify neither parameter,
	// AWS OpsWorks Stacks sets these parameters to the first valid Availability
	// Zone for the specified region and the corresponding default VPC subnet ID,
	// respectively.
	//
	// If you specify a nondefault VPC ID, note the following:
	//
	//    * It must belong to a VPC in your account that is in the specified region.
	//
	//    * You must specify a value for DefaultSubnetId.
	//
	// For more information about how to use AWS OpsWorks Stacks with a VPC, see
	// Running a Stack in a VPC (https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-vpc.html).
	// For more information about default VPC and EC2-Classic, see Supported Platforms
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html).
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s CreateStackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateStackInput"}
	if s.DefaultInstanceProfileArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DefaultInstanceProfileArn"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Region == nil {
		invalidParams.Add(request.NewErrParamRequired("Region"))
	}
	if s.ServiceRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceRoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *CreateStackInput) SetAgentVersion(v string) *CreateStackInput {
	s.AgentVersion = &v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *CreateStackInput) SetAttributes(v map[string]*string) *CreateStackInput {
	s.Attributes = v
	return s
}

// SetChefConfiguration sets the ChefConfiguration field's value.
func (s *CreateStackInput) SetChefConfiguration(v *ChefConfiguration) *CreateStackInput {
	s.ChefConfiguration = v
	return s
}

// SetConfigurationManager sets the ConfigurationManager field's value.
func (s *CreateStackInput) SetConfigurationManager(v *StackConfigurationManager) *CreateStackInput {
	s.ConfigurationManager = v
	return s
}

// SetCustomCookbooksSource sets the CustomCookbooksSource field's value.
func (s *CreateStackInput) SetCustomCookbooksSource(v *Source) *CreateStackInput {
	s.CustomCookbooksSource = v
	return s
}

// SetCustomJson sets the CustomJson field's value.
func (s *CreateStackInput) SetCustomJson(v string) *CreateStackInput {
	s.CustomJson = &v
	return s
}

// SetDefaultAvailabilityZone sets the DefaultAvailabilityZone field's value.
func (s *CreateStackInput) SetDefaultAvailabilityZone(v string) *CreateStackInput {
	s.DefaultAvailabilityZone = &v
	return s
}

// SetDefaultInstanceProfileArn sets the DefaultInstanceProfileArn field's value.
func (s *CreateStackInput) SetDefaultInstanceProfileArn(v string) *CreateStackInput {
	s.DefaultInstanceProfileArn = &v
	return s
}

// SetDefaultOs sets the DefaultOs field's value.
func (s *CreateStackInput) SetDefaultOs(v string) *CreateStackInput {
	s.DefaultOs = &v
	return s
}

// SetDefaultRootDeviceType sets the DefaultRootDeviceType field's value.
func (s *CreateStackInput) SetDefaultRootDeviceType(v string) *CreateStackInput {
	s.DefaultRootDeviceType = &v
	return s
}

// SetDefaultSshKeyName sets the DefaultSshKeyName field's value.
func (s *CreateStackInput) SetDefaultSshKeyName(v string) *CreateStackInput {
	s.DefaultSshKeyName = &v
	return s
}

// SetDefaultSubnetId sets the DefaultSubnetId field's value.
func (s *CreateStackInput) SetDefaultSubnetId(v string) *CreateStackInput {
	s.DefaultSubnetId = &v
	return s
}

// SetHostnameTheme sets the HostnameTheme field's value.
func (s *CreateStackInput) SetHostnameTheme(v string) *CreateStackInput {
	s.HostnameTheme = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateStackInput) SetName(v string) *CreateStackInput {
	s.Name = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *CreateStackInput) SetRegion(v string) *CreateStackInput {
	s.Region = &v
	return s
}

// SetServiceRoleArn sets the ServiceRoleArn field's value.
func (s *CreateStackInput) SetServiceRoleArn(v string) *CreateStackInput {
	s.ServiceRoleArn = &v
	return s
}

// SetUseCustomCookbooks sets the UseCustomCookbooks field's value.
func (s *CreateStackInput) SetUseCustomCookbooks(v bool) *CreateStackInput {
	s.UseCustomCookbooks = &v
	return s
}

// SetUseOpsworksSecurityGroups sets the UseOpsworksSecurityGroups field's value.
func (s *CreateStackInput) SetUseOpsworksSecurityGroups(v bool) *CreateStackInput {
	s.UseOpsworksSecurityGroups = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *CreateStackInput) SetVpcId(v string) *CreateStackInput {
	s.VpcId = &v
	return s
}

// Contains the response to a CreateStack request.
type CreateStackOutput struct {
	_ struct{} `type:"structure"`

	// The stack ID, which is an opaque string that you use to identify the stack
	// when performing actions such as DescribeStacks.
	StackId *string `type:"string"`
}

// String returns the string representation
func (s CreateStackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStackOutput) GoString() string {
	return s.String()
}

// SetStackId sets the StackId field's value.
func (s *CreateStackOutput) SetStackId(v string) *CreateStackOutput {
	s.StackId = &v
	return s
}

type CreateUserProfileInput struct {
	_ struct{} `type:"structure"`

	// Whether users can specify their own SSH public key through the My Settings
	// page. For more information, see Setting an IAM User's Public SSH Key (https://docs.aws.amazon.com/opsworks/latest/userguide/security-settingsshkey.html).
	AllowSelfManagement *bool `type:"boolean"`

	// The user's IAM ARN; this can also be a federated user's ARN.
	//
	// IamUserArn is a required field
	IamUserArn *string `type:"string" required:"true"`

	// The user's public SSH key.
	SshPublicKey *string `type:"string"`

	// The user's SSH user name. The allowable characters are [a-z], [A-Z], [0-9],
	// '-', and '_'. If the specified name includes other punctuation marks, AWS
	// OpsWorks Stacks removes them. For example, my.name will be changed to myname.
	// If you do not specify an SSH user name, AWS OpsWorks Stacks generates one
	// from the IAM user name.
	SshUsername *string `type:"string"`
}

// String returns the string representation
func (s CreateUserProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUserProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateUserProfileInput"}
	if s.IamUserArn == nil {
		invalidParams.Add(request.NewErrParamRequired("IamUserArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowSelfManagement sets the AllowSelfManagement field's value.
func (s *CreateUserProfileInput) SetAllowSelfManagement(v bool) *CreateUserProfileInput {
	s.AllowSelfManagement = &v
	return s
}

// SetIamUserArn sets the IamUserArn field's value.
func (s *CreateUserProfileInput) SetIamUserArn(v string) *CreateUserProfileInput {
	s.IamUserArn = &v
	return s
}

// SetSshPublicKey sets the SshPublicKey field's value.
func (s *CreateUserProfileInput) SetSshPublicKey(v string) *CreateUserProfileInput {
	s.SshPublicKey = &v
	return s
}

// SetSshUsername sets the SshUsername field's value.
func (s *CreateUserProfileInput) SetSshUsername(v string) *CreateUserProfileInput {
	s.SshUsername = &v
	return s
}

// Contains the response to a CreateUserProfile request.
type CreateUserProfileOutput struct {
	_ struct{} `type:"structure"`

	// The user's IAM ARN.
	IamUserArn *string `type:"string"`
}

// String returns the string representation
func (s CreateUserProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserProfileOutput) GoString() string {
	return s.String()
}

// SetIamUserArn sets the IamUserArn field's value.
func (s *CreateUserProfileOutput) SetIamUserArn(v string) *CreateUserProfileOutput {
	s.IamUserArn = &v
	return s
}

// Describes an app's data source.
type DataSource struct {
	_ struct{} `type:"structure"`

	// The data source's ARN.
	Arn *string `type:"string"`

	// The database name.
	DatabaseName *string `type:"string"`

	// The data source's type, AutoSelectOpsworksMysqlInstance, OpsworksMysqlInstance,
	// RdsDbInstance, or None.
	Type *string `type:"string"`
}

// String returns the string representation
func (s DataSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataSource) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DataSource) SetArn(v string) *DataSource {
	s.Arn = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *DataSource) SetDatabaseName(v string) *DataSource {
	s.DatabaseName = &v
	return s
}

// SetType sets the Type field's value.
func (s *DataSource) SetType(v string) *DataSource {
	s.Type = &v
	return s
}

type DeleteAppInput struct {
	_ struct{} `type:"structure"`

	// The app ID.
	//
	// AppId is a required field
	AppId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAppInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAppInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAppInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAppInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *DeleteAppInput) SetAppId(v string) *DeleteAppInput {
	s.AppId = &v
	return s
}

type DeleteAppOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAppOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteAppOutput) GoString() string {
	return s.String()
}

type DeleteInstanceInput struct {
	_ struct{} `type:"structure"`

	// Whether to delete the instance Elastic IP address.
	DeleteElasticIp *bool `type:"boolean"`

	// Whether to delete the instance's Amazon EBS volumes.
	DeleteVolumes *bool `type:"boolean"`

	// The instance ID.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteInstanceInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeleteElasticIp sets the DeleteElasticIp field's value.
func (s *DeleteInstanceInput) SetDeleteElasticIp(v bool) *DeleteInstanceInput {
	s.DeleteElasticIp = &v
	return s
}

// SetDeleteVolumes sets the DeleteVolumes field's value.
func (s *DeleteInstanceInput) SetDeleteVolumes(v bool) *DeleteInstanceInput {
	s.DeleteVolumes = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *DeleteInstanceInput) SetInstanceId(v string) *DeleteInstanceInput {
	s.InstanceId = &v
	return s
}

type DeleteInstanceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInstanceOutput) GoString() string {
	return s.String()
}

type DeleteLayerInput struct {
	_ struct{} `type:"structure"`

	// The layer ID.
	//
	// LayerId is a required field
	LayerId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteLayerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLayerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLayerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLayerInput"}
	if s.LayerId == nil {
		invalidParams.Add(request.NewErrParamRequired("LayerId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLayerId sets the LayerId field's value.
func (s *DeleteLayerInput) SetLayerId(v string) *DeleteLayerInput {
	s.LayerId = &v
	return s
}

type DeleteLayerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteLayerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLayerOutput) GoString() string {
	return s.String()
}

type DeleteStackInput struct {
	_ struct{} `type:"structure"`

	// The stack ID.
	//
	// StackId is a required field
	StackId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteStackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteStackInput"}
	if s.StackId == nil {
		invalidParams.Add(request.NewErrParamRequired("StackId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStackId sets the StackId field's value.
func (s *DeleteStackInput) SetStackId(v string) *DeleteStackInput {
	s.StackId = &v
	return s
}

type DeleteStackOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteStackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStackOutput) GoString() string {
	return s.String()
}

type DeleteUserProfileInput struct {
	_ struct{} `type:"structure"`

	// The user's IAM ARN. This can also be a federated user's ARN.
	//
	// IamUserArn is a required field
	IamUserArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteUserProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUserProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUserProfileInput"}
	if s.IamUserArn == nil {
		invalidParams.Add(request.NewErrParamRequired("IamUserArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIamUserArn sets the IamUserArn field's value.
func (s *DeleteUserProfileInput) SetIamUserArn(v string) *DeleteUserProfileInput {
	s.IamUserArn = &v
	return s
}

type DeleteUserProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteUserProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteUserProfileOutput) GoString() string {
	return s.String()
}

// Describes a deployment of a stack or app.
type Deployment struct {
	_ struct{} `type:"structure"`

	// The app ID.
	AppId *string `type:"string"`

	// Used to specify a stack or deployment command.
	Command *DeploymentCommand `type:"structure"`

	// A user-defined comment.
	Comment *string `type:"string"`

	// Date when the deployment completed.
	CompletedAt *string `type:"string"`

	// Date when the deployment was created.
	CreatedAt *string `type:"string"`

	// A string that contains user-defined custom JSON. It can be used to override
	// the corresponding default stack configuration attribute values for stack
	// or to pass data to recipes. The string should be in the following format:
	//
	// "{\"key1\": \"value1\", \"key2\": \"value2\",...}"
	//
	// For more information on custom JSON, see Use Custom JSON to Modify the Stack
	// Configuration Attributes (https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html).
	CustomJson *string `type:"string"`

	// The deployment ID.
	DeploymentId *string `type:"string"`

	// The deployment duration.
	Duration *int64 `type:"integer"`

	// The user's IAM ARN.
	IamUserArn *string `type:"string"`

	// The IDs of the target instances.
	InstanceIds []*string `type:"list"`

	// The stack ID.
	StackId *string `type:"string"`

	// The deployment status:
	//
	//    * running
	//
	//    * successful
	//
	//    * failed
	Status *string `type:"string"`
}

// String returns the string representation
func (s Deployment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Deployment) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *Deployment) SetAppId(v string) *Deployment {
	s.AppId = &v
	return s
}

// SetCommand sets the Command field's value.
func (s *Deployment) SetCommand(v *DeploymentCommand) *Deployment {
	s.Command = v
	return s
}

// SetComment sets the Comment field's value.
func (s *Deployment) SetComment(v string) *Deployment {
	s.Comment = &v
	return s
}

// SetCompletedAt sets the CompletedAt field's value.
func (s *Deployment) SetCompletedAt(v string) *Deployment {
	s.CompletedAt = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Deployment) SetCreatedAt(v string) *Deployment {
	s.CreatedAt = &v
	return s
}

// SetCustomJson sets the CustomJson field's value.
func (s *Deployment) SetCustomJson(v string) *Deployment {
	s.CustomJson = &v
	return s
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *Deployment) SetDeploymentId(v string) *Deployment {
	s.DeploymentId = &v
	return s
}

// SetDuration sets the Duration field's value.
func (s *Deployment) SetDuration(v int64) *Deployment {
	s.Duration = &v
	return s
}

// SetIamUserArn sets the IamUserArn field's value.
func (s *Deployment) SetIamUserArn(v string) *Deployment {
	s.IamUserArn = &v
	return s
}

// SetInstanceIds sets the InstanceIds field's value.
func (s *Deployment) SetInstanceIds(v []*string) *Deployment {
	s.InstanceIds = v
	return s
}

// SetStackId sets the StackId field's value.
func (s *Deployment) SetStackId(v string) *Deployment {
	s.StackId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Deployment) SetStatus(v string) *Deployment {
	s.Status = &v
	return s
}

// Used to specify a stack or deployment command.
type DeploymentCommand struct {
	_ struct{} `type:"structure"`

	// The arguments of those commands that take arguments. It should be set to
	// a JSON object with the following format:
	//
	// {"arg_name1" : ["value1", "value2", ...], "arg_name2" : ["value1", "value2",
	// ...], ...}
	//
	// The update_dependencies command takes two arguments:
	//
	//    * upgrade_os_to - Specifies the desired Amazon Linux version for instances
	//    whose OS you want to upgrade, such as Amazon Linux 2016.09. You must also
	//    set the allow_reboot argument to true.
	//
	//    * allow_reboot - Specifies whether to allow AWS OpsWorks Stacks to reboot
	//    the instances if necessary, after installing the updates. This argument
	//    can be set to either true or false. The default value is false.
	//
	// For example, to upgrade an instance to Amazon Linux 2016.09, set Args to
	// the following.
	//
	// { "upgrade_os_to":["Amazon Linux 2016.09"], "allow_reboot":["true"] }
	Args map[string][]*string `type:"map"`

	// Specifies the operation. You can specify only one command.
	//
	// For stacks, the following commands are available:
	//
	//    * execute_recipes: Execute one or more recipes. To specify the recipes,
	//    set an Args parameter named recipes to the list of recipes to be executed.
	//    For example, to execute phpapp::appsetup, set Args to {"recipes":["phpapp::appsetup"]}.
	//
	//    * install_dependencies: Install the stack's dependencies.
	//
	//    * update_custom_cookbooks: Update the stack's custom cookbooks.
	//
	//    * update_dependencies: Update the stack's dependencies.
	//
	// The update_dependencies and install_dependencies commands are supported only
	// for Linux instances. You can run the commands successfully on Windows instances,
	// but they do nothing.
	//
	// For apps, the following commands are available:
	//
	//    * deploy: Deploy an app. Ruby on Rails apps have an optional Args parameter
	//    named migrate. Set Args to {"migrate":["true"]} to migrate the database.
	//    The default setting is {"migrate":["false"]}.
	//
	//    * rollback Roll the app back to the previous version. When you update
	//    an app, AWS OpsWorks Stacks stores the previous version, up to a maximum
	//    of five versions. You can use this command to roll an app back as many
	//    as four versions.
	//
	//    * start: Start the app's web or application server.
	//
	//    * stop: Stop the app's web or application server.
	//
	//    * restart: Restart the app's web or application server.
	//
	//    * undeploy: Undeploy the app.
	//
	// Name is a required field
	Name *string `type:"string" required:"true" enum:"DeploymentCommandName"`
}

// String returns the string representation
func (s DeploymentCommand) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeploymentCommand) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeploymentCommand) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeploymentCommand"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArgs sets the Args field's value.
func (s *DeploymentCommand) SetArgs(v map[string][]*string) *DeploymentCommand {
	s.Args = v
	return s
}

// SetName sets the Name field's value.
func (s *DeploymentCommand) SetName(v string) *DeploymentCommand {
	s.Name = &v
	return s
}

type DeregisterEcsClusterInput struct {
	_ struct{} `type:"structure"`

	// The cluster's Amazon Resource Number (ARN).
	//
	// EcsClusterArn is a required field
	EcsClusterArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeregisterEcsClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterEcsClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterEcsClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeregisterEcsClusterInput"}
	if s.EcsClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EcsClusterArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEcsClusterArn sets the EcsClusterArn field's value.
func (s *DeregisterEcsClusterInput) SetEcsClusterArn(v string) *DeregisterEcsClusterInput {
	s.EcsClusterArn = &v
	return s
}

type DeregisterEcsClusterOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeregisterEcsClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterEcsClusterOutput) GoString() string {
	return s.String()
}

type DeregisterElasticIpInput struct {
	_ struct{} `type:"structure"`

	// The Elastic IP address.
	//
	// ElasticIp is a required field
	ElasticIp *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeregisterElasticIpInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterElasticIpInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterElasticIpInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeregisterElasticIpInput"}
	if s.ElasticIp == nil {
		invalidParams.Add(request.NewErrParamRequired("ElasticIp"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetElasticIp sets the ElasticIp field's value.
func (s *DeregisterElasticIpInput) SetElasticIp(v string) *DeregisterElasticIpInput {
	s.ElasticIp = &v
	return s
}

type DeregisterElasticIpOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeregisterElasticIpOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterElasticIpOutput) GoString() string {
	return s.String()
}

type DeregisterInstanceInput struct {
	_ struct{} `type:"structure"`

	// The instance ID.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeregisterInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeregisterInstanceInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *DeregisterInstanceInput) SetInstanceId(v string) *DeregisterInstanceInput {
	s.InstanceId = &v
	return s
}

type DeregisterInstanceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeregisterInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterInstanceOutput) GoString() string {
	return s.String()
}

type DeregisterRdsDbInstanceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon RDS instance's ARN.
	//
	// RdsDbInstanceArn is a required field
	RdsDbInstanceArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeregisterRdsDbInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterRdsDbInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterRdsDbInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeregisterRdsDbInstanceInput"}
	if s.RdsDbInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RdsDbInstanceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRdsDbInstanceArn sets the RdsDbInstanceArn field's value.
func (s *DeregisterRdsDbInstanceInput) SetRdsDbInstanceArn(v string) *DeregisterRdsDbInstanceInput {
	s.RdsDbInstanceArn = &v
	return s
}

type DeregisterRdsDbInstanceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeregisterRdsDbInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterRdsDbInstanceOutput) GoString() string {
	return s.String()
}

type DeregisterVolumeInput struct {
	_ struct{} `type:"structure"`

	// The AWS OpsWorks Stacks volume ID, which is the GUID that AWS OpsWorks Stacks
	// assigned to the instance when you registered the volume with the stack, not
	// the Amazon EC2 volume ID.
	//
	// VolumeId is a required field
	VolumeId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeregisterVolumeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterVolumeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterVolumeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeregisterVolumeInput"}
	if s.VolumeId == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVolumeId sets the VolumeId field's value.
func (s *DeregisterVolumeInput) SetVolumeId(v string) *DeregisterVolumeInput {
	s.VolumeId = &v
	return s
}

type DeregisterVolumeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeregisterVolumeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterVolumeOutput) GoString() string {
	return s.String()
}

type DescribeAgentVersionsInput struct {
	_ struct{} `type:"structure"`

	// The configuration manager.
	ConfigurationManager *StackConfigurationManager `type:"structure"`

	// The stack ID.
	StackId *string `type:"string"`
}

// String returns the string representation
func (s DescribeAgentVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAgentVersionsInput) GoString() string {
	return s.String()
}

// SetConfigurationManager sets the ConfigurationManager field's value.
func (s *DescribeAgentVersionsInput) SetConfigurationManager(v *StackConfigurationManager) *DescribeAgentVersionsInput {
	s.ConfigurationManager = v
	return s
}

// SetStackId sets the StackId field's value.
func (s *DescribeAgentVersionsInput) SetStackId(v string) *DescribeAgentVersionsInput {
	s.StackId = &v
	return s
}

// Contains the response to a DescribeAgentVersions request.
type DescribeAgentVersionsOutput struct {
	_ struct{} `type:"structure"`

	// The agent versions for the specified stack or configuration manager. Note
	// that this value is the complete version number, not the abbreviated number
	// used by the console.
	AgentVersions []*AgentVersion `type:"list"`
}

// String returns the string representation
func (s DescribeAgentVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAgentVersionsOutput) GoString() string {
	return s.String()
}

// SetAgentVersions sets the AgentVersions field's value.
func (s *DescribeAgentVersionsOutput) SetAgentVersions(v []*AgentVersion) *DescribeAgentVersionsOutput {
	s.AgentVersions = v
	return s
}

type DescribeAppsInput struct {
	_ struct{} `type:"structure"`

	// An array of app IDs for the apps to be described. If you use this parameter,
	// DescribeApps returns a description of the specified apps. Otherwise, it returns
	// a description of every app.
	AppIds []*string `type:"list"`

	// The app stack ID. If you use this parameter, DescribeApps returns a description
	// of the apps in the specified stack.
	StackId *string `type:"string"`
}

// String returns the string representation
func (s DescribeAppsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAppsInput) GoString() string {
	return s.String()
}

// SetAppIds sets the AppIds field's value.
func (s *DescribeAppsInput) SetAppIds(v []*string) *DescribeAppsInput {
	s.AppIds = v
	return s
}

// SetStackId sets the StackId field's value.
func (s *DescribeAppsInput) SetStackId(v string) *DescribeAppsInput {
	s.StackId = &v
	return s
}

// Contains the response to a DescribeApps request.
type DescribeAppsOutput struct {
	_ struct{} `type:"structure"`

	// An array of App objects that describe the specified apps.
	Apps []*App `type:"list"`
}

// String returns the string representation
func (s DescribeAppsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAppsOutput) GoString() string {
	return s.String()
}

// SetApps sets the Apps field's value.
func (s *DescribeAppsOutput) SetApps(v []*App) *DescribeAppsOutput {
	s.Apps = v
	return s
}

type DescribeCommandsInput struct {
	_ struct{} `type:"structure"`

	// An array of command IDs. If you include this parameter, DescribeCommands
	// returns a description of the specified commands. Otherwise, it returns a
	// description of every command.
	CommandIds []*string `type:"list"`

	// The deployment ID. If you include this parameter, DescribeCommands returns
	// a description of the commands associated with the specified deployment.
	DeploymentId *string `type:"string"`

	// The instance ID. If you include this parameter, DescribeCommands returns
	// a description of the commands associated with the specified instance.
	InstanceId *string `type:"string"`
}

// String returns the string representation
func (s DescribeCommandsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCommandsInput) GoString() string {
	return s.String()
}

// SetCommandIds sets the CommandIds field's value.
func (s *DescribeCommandsInput) SetCommandIds(v []*string) *DescribeCommandsInput {
	s.CommandIds = v
	return s
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *DescribeCommandsInput) SetDeploymentId(v string) *DescribeCommandsInput {
	s.DeploymentId = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *DescribeCommandsInput) SetInstanceId(v string) *DescribeCommandsInput {
	s.InstanceId = &v
	return s
}

// Contains the response to a DescribeCommands request.
type DescribeCommandsOutput struct {
	_ struct{} `type:"structure"`

	// An array of Command objects that describe each of the specified commands.
	Commands []*Command `type:"list"`
}

// String returns the string representation
func (s DescribeCommandsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCommandsOutput) GoString() string {
	return s.String()
}

// SetCommands sets the Commands field's value.
func (s *DescribeCommandsOutput) SetCommands(v []*Command) *DescribeCommandsOutput {
	s.Commands = v
	return s
}

type DescribeDeploymentsInput struct {
	_ struct{} `type:"structure"`

	// The app ID. If you include this parameter, the command returns a description
	// of the commands associated with the specified app.
	AppId *string `type:"string"`

	// An array of deployment IDs to be described. If you include this parameter,
	// the command returns a description of the specified deployments. Otherwise,
	// it returns a description of every deployment.
	DeploymentIds []*string `type:"list"`

	// The stack ID. If you include this parameter, the command returns a description
	// of the commands associated with the specified stack.
	StackId *string `type:"string"`
}

// String returns the string representation
func (s DescribeDeploymentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDeploymentsInput) GoString() string {
	return s.String()
}

// SetAppId sets the AppId field's value.
func (s *DescribeDeploymentsInput) SetAppId(v string) *DescribeDeploymentsInput {
	s.AppId = &v
	return s
}

// SetDeploymentIds sets the DeploymentIds field's value.
func (s *DescribeDeploymentsInput) SetDeploymentIds(v []*string) *DescribeDeploymentsInput {
	s.DeploymentIds = v
	return s
}

// SetStackId sets the StackId field's value.
func (s *DescribeDeploymentsInput) SetStackId(v string) *DescribeDeploymentsInput {
	s.StackId = &v
	return s
}

// Contains the response to a DescribeDeployments request.
type DescribeDeploymentsOutput struct {
	_ struct{} `type:"structure"`

	// An array of Deployment objects that describe the deployments.
	Deployments []*Deployment `type:"list"`
}

// String returns the string representation
func (s DescribeDeploymentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDeploymentsOutput) GoString() string {
	return s.String()
}

// SetDeployments sets the Deployments field's value.
func (s *DescribeDeploymentsOutput) SetDeployments(v []*Deployment) *DescribeDeploymentsOutput {
	s.Deployments = v
	return s
}

type DescribeEcsClustersInput struct {
	_ struct{} `type:"structure"`

	// A list of ARNs, one for each cluster to be described.
	EcsClusterArns []*string `type:"list"`

	// To receive a paginated response, use this parameter to specify the maximum
	// number of results to be returned with a single call. If the number of available
	// results exceeds this maximum, the response includes a NextToken value that
	// you can assign to the NextToken request parameter to get the next set of
	// results.
	MaxResults *int64 `type:"integer"`

	// If the previous paginated request did not return all of the remaining results,
	// the response object'sNextToken parameter value is set to a token. To retrieve
	// the next set of results, call DescribeEcsClusters again and assign that token
	// to the request object's NextToken parameter. If there are no remaining results,
	// the previous response object's NextToken parameter is set to null.
	NextToken *string `type:"string"`

	// A stack ID. DescribeEcsClusters returns a description of the cluster that
	// is registered with the stack.
	StackId *string `type:"string"`
}

// String returns the string representation
func (s DescribeEcsClustersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEcsClustersInput) GoString() string {
	return s.String()
}

// SetEcsClusterArns sets the EcsClusterArns field's value.
func (s *DescribeEcsClustersInput) SetEcsClusterArns(v []*string) *DescribeEcsClustersInput {
	s.EcsClusterArns = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeEcsClustersInput) SetMaxResults(v int64) *DescribeEcsClustersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeEcsClustersInput) SetNextToken(v string) *DescribeEcsClustersInput {
	s.NextToken = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *DescribeEcsClustersInput) SetStackId(v string) *DescribeEcsClustersInput {
	s.StackId = &v
	return s
}

// Contains the response to a DescribeEcsClusters request.
type DescribeEcsClustersOutput struct {
	_ struct{} `type:"structure"`

	// A list of EcsCluster objects containing the cluster descriptions.
	EcsClusters []*EcsCluster `type:"list"`

	// If a paginated request does not return all of the remaining results, this
	// parameter is set to a token that you can assign to the request object's NextToken
	// parameter to retrieve the next set of results. If the previous paginated
	// request returned all of the remaining results, this parameter is set to null.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeEcsClustersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEcsClustersOutput) GoString() string {
	return s.String()
}

// SetEcsClusters sets the EcsClusters field's value.
func (s *DescribeEcsClustersOutput) SetEcsClusters(v []*EcsCluster) *DescribeEcsClustersOutput {
	s.EcsClusters = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeEcsClustersOutput) SetNextToken(v string) *DescribeEcsClustersOutput {
	s.NextToken = &v
	return s
}

type DescribeElasticIpsInput struct {
	_ struct{} `type:"structure"`

	// The instance ID. If you include this parameter, DescribeElasticIps returns
	// a description of the Elastic IP addresses associated with the specified instance.
	InstanceId *string `type:"string"`

	// An array of Elastic IP addresses to be described. If you include this parameter,
	// DescribeElasticIps returns a description of the specified Elastic IP addresses.
	// Otherwise, it returns a description of every Elastic IP address.
	Ips []*string `type:"list"`

	// A stack ID. If you include this parameter, DescribeElasticIps returns a description
	// of the Elastic IP addresses that are registered with the specified stack.
	StackId *string `type:"string"`
}

// String returns the string representation
func (s DescribeElasticIpsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeElasticIpsInput) GoString() string {
	return s.String()
}

// SetInstanceId sets the InstanceId field's value.
func (s *DescribeElasticIpsInput) SetInstanceId(v string) *DescribeElasticIpsInput {
	s.InstanceId = &v
	return s
}

// SetIps sets the Ips field's value.
func (s *DescribeElasticIpsInput) SetIps(v []*string) *DescribeElasticIpsInput {
	s.Ips = v
	return s
}

// SetStackId sets the StackId field's value.
func (s *DescribeElasticIpsInput) SetStackId(v string) *DescribeElasticIpsInput {
	s.StackId = &v
	return s
}

// Contains the response to a DescribeElasticIps request.
type DescribeElasticIpsOutput struct {
	_ struct{} `type:"structure"`

	// An ElasticIps object that describes the specified Elastic IP addresses.
	ElasticIps []*ElasticIp `type:"list"`
}

// String returns the string representation
func (s DescribeElasticIpsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeElasticIpsOutput) GoString() string {
	return s.String()
}

// SetElasticIps sets the ElasticIps field's value.
func (s *DescribeElasticIpsOutput) SetElasticIps(v []*ElasticIp) *DescribeElasticIpsOutput {
	s.ElasticIps = v
	return s
}

type DescribeElasticLoadBalancersInput struct {
	_ struct{} `type:"structure"`

	// A list of layer IDs. The action describes the Elastic Load Balancing instances
	// for the specified layers.
	LayerIds []*string `type:"list"`

	// A stack ID. The action describes the stack's Elastic Load Balancing instances.
	StackId *string `type:"string"`
}

// String returns the string representation
func (s DescribeElasticLoadBalancersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeElasticLoadBalancersInput) GoString() string {
	return s.String()
}

// SetLayerIds sets the LayerIds field's value.
func (s *DescribeElasticLoadBalancersInput) SetLayerIds(v []*string) *DescribeElasticLoadBalancersInput {
	s.LayerIds = v
	return s
}

// SetStackId sets the StackId field's value.
func (s *DescribeElasticLoadBalancersInput) SetStackId(v string) *DescribeElasticLoadBalancersInput {
	s.StackId = &v
	return s
}

// Contains the response to a DescribeElasticLoadBalancers request.
type DescribeElasticLoadBalancersOutput struct {
	_ struct{} `type:"structure"`

	// A list of ElasticLoadBalancer objects that describe the specified Elastic
	// Load Balancing instances.
	ElasticLoadBalancers []*ElasticLoadBalancer `type:"list"`
}

// String returns the string representation
func (s DescribeElasticLoadBalancersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeElasticLoadBalancersOutput) GoString() string {
	return s.String()
}

// SetElasticLoadBalancers sets the ElasticLoadBalancers field's value.
func (s *DescribeElasticLoadBalancersOutput) SetElasticLoadBalancers(v []*ElasticLoadBalancer) *DescribeElasticLoadBalancersOutput {
	s.ElasticLoadBalancers = v
	return s
}

type DescribeInstancesInput struct {
	_ struct{} `type:"structure"`

	// An array of instance IDs to be described. If you use this parameter, DescribeInstances
	// returns a description of the specified instances. Otherwise, it returns a
	// description of every instance.
	InstanceIds []*string `type:"list"`

	// A layer ID. If you use this parameter, DescribeInstances returns descriptions
	// of the instances associated with the specified layer.
	LayerId *string `type:"string"`

	// A stack ID. If you use this parameter, DescribeInstances returns descriptions
	// of the instances associated with the specified stack.
	StackId *string `type:"string"`
}

// String returns the string representation
func (s DescribeInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInstancesInput) GoString() string {
	return s.String()
}

// SetInstanceIds sets the InstanceIds field's value.
func (s *DescribeInstancesInput) SetInstanceIds(v []*string) *DescribeInstancesInput {
	s.InstanceIds = v
	return s
}

// SetLayerId sets the LayerId field's value.
func (s *DescribeInstancesInput) SetLayerId(v string) *DescribeInstancesInput {
	s.LayerId = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *DescribeInstancesInput) SetStackId(v string) *DescribeInstancesInput {
	s.StackId = &v
	return s
}

// Contains the response to a DescribeInstances request.
type DescribeInstancesOutput struct {
	_ struct{} `type:"structure"`

	// An array of Instance objects that describe the instances.
	Instances []*Instance `type:"list"`
}

// String returns the string representation
func (s DescribeInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInstancesOutput) GoString() string {
	return s.String()
}

// SetInstances sets the Instances field's value.
func (s *DescribeInstancesOutput) SetInstances(v []*Instance) *DescribeInstancesOutput {
	s.Instances = v
	return s
}

type DescribeLayersInput struct {
	_ struct{} `type:"structure"`

	// An array of layer IDs that specify the layers to be described. If you omit
	// this parameter, DescribeLayers returns a description of every layer in the
	// specified stack.
	LayerIds []*string `type:"list"`

	// The stack ID.
	StackId *string `type:"string"`
}

// String returns the string representation
func (s DescribeLayersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLayersInput) GoString() string {
	return s.String()
}

// SetLayerIds sets the LayerIds field's value.
func (s *DescribeLayersInput) SetLayerIds(v []*string) *DescribeLayersInput {
	s.LayerIds = v
	return s
}

// SetStackId sets the StackId field's value.
func (s *DescribeLayersInput) SetStackId(v string) *DescribeLayersInput {
	s.StackId = &v
	return s
}

// Contains the response to a DescribeLayers request.
type DescribeLayersOutput struct {
	_ struct{} `type:"structure"`

	// An array of Layer objects that describe the layers.
	Layers []*Layer `type:"list"`
}

// String returns the string representation
func (s DescribeLayersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLayersOutput) GoString() string {
	return s.String()
}

// SetLayers sets the Layers field's value.
func (s *DescribeLayersOutput) SetLayers(v []*Layer) *DescribeLayersOutput {
	s.Layers = v
	return s
}

type DescribeLoadBasedAutoScalingInput struct {
	_ struct{} `type:"structure"`

	// An array of layer IDs.
	//
	// LayerIds is a required field
	LayerIds []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeLoadBasedAutoScalingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLoadBasedAutoScalingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeLoadBasedAutoScalingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeLoadBasedAutoScalingInput"}
	if s.LayerIds == nil {
		invalidParams.Add(request.NewErrParamRequired("LayerIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLayerIds sets the LayerIds field's value.
func (s *DescribeLoadBasedAutoScalingInput) SetLayerIds(v []*string) *DescribeLoadBasedAutoScalingInput {
	s.LayerIds = v
	return s
}

// Contains the response to a DescribeLoadBasedAutoScaling request.
type DescribeLoadBasedAutoScalingOutput struct {
	_ struct{} `type:"structure"`

	// An array of LoadBasedAutoScalingConfiguration objects that describe each
	// layer's configuration.
	LoadBasedAutoScalingConfigurations []*LoadBasedAutoScalingConfiguration `type:"list"`
}

// String returns the string representation
func (s DescribeLoadBasedAutoScalingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLoadBasedAutoScalingOutput) GoString() string {
	return s.String()
}

// SetLoadBasedAutoScalingConfigurations sets the LoadBasedAutoScalingConfigurations field's value.
func (s *DescribeLoadBasedAutoScalingOutput) SetLoadBasedAutoScalingConfigurations(v []*LoadBasedAutoScalingConfiguration) *DescribeLoadBasedAutoScalingOutput {
	s.LoadBasedAutoScalingConfigurations = v
	return s
}

type DescribeMyUserProfileInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeMyUserProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMyUserProfileInput) GoString() string {
	return s.String()
}

// Contains the response to a DescribeMyUserProfile request.
type DescribeMyUserProfileOutput struct {
	_ struct{} `type:"structure"`

	// A UserProfile object that describes the user's SSH information.
	UserProfile *SelfUserProfile `type:"structure"`
}

// String returns the string representation
func (s DescribeMyUserProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeMyUserProfileOutput) GoString() string {
	return s.String()
}

// SetUserProfile sets the UserProfile field's value.
func (s *DescribeMyUserProfileOutput) SetUserProfile(v *SelfUserProfile) *DescribeMyUserProfileOutput {
	s.UserProfile = v
	return s
}

type DescribeOperatingSystemsInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeOperatingSystemsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOperatingSystemsInput) GoString() string {
	return s.String()
}

// The response to a DescribeOperatingSystems request.
type DescribeOperatingSystemsOutput struct {
	_ struct{} `type:"structure"`

	// Contains information in response to a DescribeOperatingSystems request.
	OperatingSystems []*OperatingSystem `type:"list"`
}

// String returns the string representation
func (s DescribeOperatingSystemsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOperatingSystemsOutput) GoString() string {
	return s.String()
}

// SetOperatingSystems sets the OperatingSystems field's value.
func (s *DescribeOperatingSystemsOutput) SetOperatingSystems(v []*OperatingSystem) *DescribeOperatingSystemsOutput {
	s.OperatingSystems = v
	return s
}

type DescribePermissionsInput struct {
	_ struct{} `type:"structure"`

	// The user's IAM ARN. This can also be a federated user's ARN. For more information
	// about IAM ARNs, see Using Identifiers (https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html).
	IamUserArn *string `type:"string"`

	// The stack ID.
	StackId *string `type:"string"`
}

// String returns the string representation
func (s DescribePermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePermissionsInput) GoString() string {
	return s.String()
}

// SetIamUserArn sets the IamUserArn field's value.
func (s *DescribePermissionsInput) SetIamUserArn(v string) *DescribePermissionsInput {
	s.IamUserArn = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *DescribePermissionsInput) SetStackId(v string) *DescribePermissionsInput {
	s.StackId = &v
	return s
}

// Contains the response to a DescribePermissions request.
type DescribePermissionsOutput struct {
	_ struct{} `type:"structure"`

	// An array of Permission objects that describe the stack permissions.
	//
	//    * If the request object contains only a stack ID, the array contains a
	//    Permission object with permissions for each of the stack IAM ARNs.
	//
	//    * If the request object contains only an IAM ARN, the array contains a
	//    Permission object with permissions for each of the user's stack IDs.
	//
	//    * If the request contains a stack ID and an IAM ARN, the array contains
	//    a single Permission object with permissions for the specified stack and
	//    IAM ARN.
	Permissions []*Permission `type:"list"`
}

// String returns the string representation
func (s DescribePermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePermissionsOutput) GoString() string {
	return s.String()
}

// SetPermissions sets the Permissions field's value.
func (s *DescribePermissionsOutput) SetPermissions(v []*Permission) *DescribePermissionsOutput {
	s.Permissions = v
	return s
}

type DescribeRaidArraysInput struct {
	_ struct{} `type:"structure"`

	// The instance ID. If you use this parameter, DescribeRaidArrays returns descriptions
	// of the RAID arrays associated with the specified instance.
	InstanceId *string `type:"string"`

	// An array of RAID array IDs. If you use this parameter, DescribeRaidArrays
	// returns descriptions of the specified arrays. Otherwise, it returns a description
	// of every array.
	RaidArrayIds []*string `type:"list"`

	// The stack ID.
	StackId *string `type:"string"`
}

// String returns the string representation
func (s DescribeRaidArraysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRaidArraysInput) GoString() string {
	return s.String()
}

// SetInstanceId sets the InstanceId field's value.
func (s *DescribeRaidArraysInput) SetInstanceId(v string) *DescribeRaidArraysInput {
	s.InstanceId = &v
	return s
}

// SetRaidArrayIds sets the RaidArrayIds field's value.
func (s *DescribeRaidArraysInput) SetRaidArrayIds(v []*string) *DescribeRaidArraysInput {
	s.RaidArrayIds = v
	return s
}

// SetStackId sets the StackId field's value.
func (s *DescribeRaidArraysInput) SetStackId(v string) *DescribeRaidArraysInput {
	s.StackId = &v
	return s
}

// Contains the response to a DescribeRaidArrays request.
type DescribeRaidArraysOutput struct {
	_ struct{} `type:"structure"`

	// A RaidArrays object that describes the specified RAID arrays.
	RaidArrays []*RaidArray `type:"list"`
}

// String returns the string representation
func (s DescribeRaidArraysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRaidArraysOutput) GoString() string {
	return s.String()
}

// SetRaidArrays sets the RaidArrays field's value.
func (s *DescribeRaidArraysOutput) SetRaidArrays(v []*RaidArray) *DescribeRaidArraysOutput {
	s.RaidArrays = v
	return s
}

type DescribeRdsDbInstancesInput struct {
	_ struct{} `type:"structure"`

	// An array containing the ARNs of the instances to be described.
	RdsDbInstanceArns []*string `type:"list"`

	// The ID of the stack with which the instances are registered. The operation
	// returns descriptions of all registered Amazon RDS instances.
	//
	// StackId is a required field
	StackId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeRdsDbInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRdsDbInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRdsDbInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRdsDbInstancesInput"}
	if s.StackId == nil {
		invalidParams.Add(request.NewErrParamRequired("StackId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRdsDbInstanceArns sets the RdsDbInstanceArns field's value.
func (s *DescribeRdsDbInstancesInput) SetRdsDbInstanceArns(v []*string) *DescribeRdsDbInstancesInput {
	s.RdsDbInstanceArns = v
	return s
}

// SetStackId sets the StackId field's value.
func (s *DescribeRdsDbInstancesInput) SetStackId(v string) *DescribeRdsDbInstancesInput {
	s.StackId = &v
	return s
}

// Contains the response to a DescribeRdsDbInstances request.
type DescribeRdsDbInstancesOutput struct {
	_ struct{} `type:"structure"`

	// An a array of RdsDbInstance objects that describe the instances.
	RdsDbInstances []*RdsDbInstance `type:"list"`
}

// String returns the string representation
func (s DescribeRdsDbInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRdsDbInstancesOutput) GoString() string {
	return s.String()
}

// SetRdsDbInstances sets the RdsDbInstances field's value.
func (s *DescribeRdsDbInstancesOutput) SetRdsDbInstances(v []*RdsDbInstance) *DescribeRdsDbInstancesOutput {
	s.RdsDbInstances = v
	return s
}

type DescribeServiceErrorsInput struct {
	_ struct{} `type:"structure"`

	// The instance ID. If you use this parameter, DescribeServiceErrors returns
	// descriptions of the errors associated with the specified instance.
	InstanceId *string `type:"string"`

	// An array of service error IDs. If you use this parameter, DescribeServiceErrors
	// returns descriptions of the specified errors. Otherwise, it returns a description
	// of every error.
	ServiceErrorIds []*string `type:"list"`

	// The stack ID. If you use this parameter, DescribeServiceErrors returns descriptions
	// of the errors associated with the specified stack.
	StackId *string `type:"string"`
}

// String returns the string representation
func (s DescribeServiceErrorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeServiceErrorsInput) GoString() string {
	return s.String()
}

// SetInstanceId sets the InstanceId field's value.
func (s *DescribeServiceErrorsInput) SetInstanceId(v string) *DescribeServiceErrorsInput {
	s.InstanceId = &v
	return s
}

// SetServiceErrorIds sets the ServiceErrorIds field's value.
func (s *DescribeServiceErrorsInput) SetServiceErrorIds(v []*string) *DescribeServiceErrorsInput {
	s.ServiceErrorIds = v
	return s
}

// SetStackId sets the StackId field's value.
func (s *DescribeServiceErrorsInput) SetStackId(v string) *DescribeServiceErrorsInput {
	s.StackId = &v
	return s
}

// Contains the response to a DescribeServiceErrors request.
type DescribeServiceErrorsOutput struct {
	_ struct{} `type:"structure"`

	// An array of ServiceError objects that describe the specified service errors.
	ServiceErrors []*ServiceError `type:"list"`
}

// String returns the string representation
func (s DescribeServiceErrorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeServiceErrorsOutput) GoString() string {
	return s.String()
}

// SetServiceErrors sets the ServiceErrors field's value.
func (s *DescribeServiceErrorsOutput) SetServiceErrors(v []*ServiceError) *DescribeServiceErrorsOutput {
	s.ServiceErrors = v
	return s
}

type DescribeStackProvisioningParametersInput struct {
	_ struct{} `type:"structure"`

	// The stack ID.
	//
	// StackId is a required field
	StackId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeStackProvisioningParametersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackProvisioningParametersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStackProvisioningParametersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeStackProvisioningParametersInput"}
	if s.StackId == nil {
		invalidParams.Add(request.NewErrParamRequired("StackId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStackId sets the StackId field's value.
func (s *DescribeStackProvisioningParametersInput) SetStackId(v string) *DescribeStackProvisioningParametersInput {
	s.StackId = &v
	return s
}

// Contains the response to a DescribeStackProvisioningParameters request.
type DescribeStackProvisioningParametersOutput struct {
	_ struct{} `type:"structure"`

	// The AWS OpsWorks Stacks agent installer's URL.
	AgentInstallerUrl *string `type:"string"`

	// An embedded object that contains the provisioning parameters.
	Parameters map[string]*string `type:"map"`
}

// String returns the string representation
func (s DescribeStackProvisioningParametersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackProvisioningParametersOutput) GoString() string {
	return s.String()
}

// SetAgentInstallerUrl sets the AgentInstallerUrl field's value.
func (s *DescribeStackProvisioningParametersOutput) SetAgentInstallerUrl(v string) *DescribeStackProvisioningParametersOutput {
	s.AgentInstallerUrl = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *DescribeStackProvisioningParametersOutput) SetParameters(v map[string]*string) *DescribeStackProvisioningParametersOutput {
	s.Parameters = v
	return s
}

type DescribeStackSummaryInput struct {
	_ struct{} `type:"structure"`

	// The stack ID.
	//
	// StackId is a required field
	StackId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeStackSummaryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackSummaryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeStackSummaryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeStackSummaryInput"}
	if s.StackId == nil {
		invalidParams.Add(request.NewErrParamRequired("StackId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStackId sets the StackId field's value.
func (s *DescribeStackSummaryInput) SetStackId(v string) *DescribeStackSummaryInput {
	s.StackId = &v
	return s
}

// Contains the response to a DescribeStackSummary request.
type DescribeStackSummaryOutput struct {
	_ struct{} `type:"structure"`

	// A StackSummary object that contains the results.
	StackSummary *StackSummary `type:"structure"`
}

// String returns the string representation
func (s DescribeStackSummaryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackSummaryOutput) GoString() string {
	return s.String()
}

// SetStackSummary sets the StackSummary field's value.
func (s *DescribeStackSummaryOutput) SetStackSummary(v *StackSummary) *DescribeStackSummaryOutput {
	s.StackSummary = v
	return s
}

type DescribeStacksInput struct {
	_ struct{} `type:"structure"`

	// An array of stack IDs that specify the stacks to be described. If you omit
	// this parameter, DescribeStacks returns a description of every stack.
	StackIds []*string `type:"list"`
}

// String returns the string representation
func (s DescribeStacksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStacksInput) GoString() string {
	return s.String()
}

// SetStackIds sets the StackIds field's value.
func (s *DescribeStacksInput) SetStackIds(v []*string) *DescribeStacksInput {
	s.StackIds = v
	return s
}

// Contains the response to a DescribeStacks request.
type DescribeStacksOutput struct {
	_ struct{} `type:"structure"`

	// An array of Stack objects that describe the stacks.
	Stacks []*Stack `type:"list"`
}

// String returns the string representation
func (s DescribeStacksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStacksOutput) GoString() string {
	return s.String()
}

// SetStacks sets the Stacks field's value.
func (s *DescribeStacksOutput) SetStacks(v []*Stack) *DescribeStacksOutput {
	s.Stacks = v
	return s
}

type DescribeTimeBasedAutoScalingInput struct {
	_ struct{} `type:"structure"`

	// An array of instance IDs.
	//
	// InstanceIds is a required field
	InstanceIds []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeTimeBasedAutoScalingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTimeBasedAutoScalingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTimeBasedAutoScalingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTimeBasedAutoScalingInput"}
	if s.InstanceIds == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceIds sets the InstanceIds field's value.
func (s *DescribeTimeBasedAutoScalingInput) SetInstanceIds(v []*string) *DescribeTimeBasedAutoScalingInput {
	s.InstanceIds = v
	return s
}

// Contains the response to a DescribeTimeBasedAutoScaling request.
type DescribeTimeBasedAutoScalingOutput struct {
	_ struct{} `type:"structure"`

	// An array of TimeBasedAutoScalingConfiguration objects that describe the configuration
	// for the specified instances.
	TimeBasedAutoScalingConfigurations []*TimeBasedAutoScalingConfiguration `type:"list"`
}

// String returns the string representation
func (s DescribeTimeBasedAutoScalingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTimeBasedAutoScalingOutput) GoString() string {
	return s.String()
}

// SetTimeBasedAutoScalingConfigurations sets the TimeBasedAutoScalingConfigurations field's value.
func (s *DescribeTimeBasedAutoScalingOutput) SetTimeBasedAutoScalingConfigurations(v []*TimeBasedAutoScalingConfiguration) *DescribeTimeBasedAutoScalingOutput {
	s.TimeBasedAutoScalingConfigurations = v
	return s
}

type DescribeUserProfilesInput struct {
	_ struct{} `type:"structure"`

	// An array of IAM or federated user ARNs that identify the users to be described.
	IamUserArns []*string `type:"list"`
}

// String returns the string representation
func (s DescribeUserProfilesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUserProfilesInput) GoString() string {
	return s.String()
}

// SetIamUserArns sets the IamUserArns field's value.
func (s *DescribeUserProfilesInput) SetIamUserArns(v []*string) *DescribeUserProfilesInput {
	s.IamUserArns = v
	return s
}

// Contains the response to a DescribeUserProfiles request.
type DescribeUserProfilesOutput struct {
	_ struct{} `type:"structure"`

	// A Users object that describes the specified users.
	UserProfiles []*UserProfile `type:"list"`
}

// String returns the string representation
func (s DescribeUserProfilesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeUserProfilesOutput) GoString() string {
	return s.String()
}

// SetUserProfiles sets the UserProfiles field's value.
func (s *DescribeUserProfilesOutput) SetUserProfiles(v []*UserProfile) *DescribeUserProfilesOutput {
	s.UserProfiles = v
	return s
}

type DescribeVolumesInput struct {
	_ struct{} `type:"structure"`

	// The instance ID. If you use this parameter, DescribeVolumes returns descriptions
	// of the volumes associated with the specified instance.
	InstanceId *string `type:"string"`

	// The RAID array ID. If you use this parameter, DescribeVolumes returns descriptions
	// of the volumes associated with the specified RAID array.
	RaidArrayId *string `type:"string"`

	// A stack ID. The action describes the stack's registered Amazon EBS volumes.
	StackId *string `type:"string"`

	// Am array of volume IDs. If you use this parameter, DescribeVolumes returns
	// descriptions of the specified volumes. Otherwise, it returns a description
	// of every volume.
	VolumeIds []*string `type:"list"`
}

// String returns the string representation
func (s DescribeVolumesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVolumesInput) GoString() string {
	return s.String()
}

// SetInstanceId sets the InstanceId field's value.
func (s *DescribeVolumesInput) SetInstanceId(v string) *DescribeVolumesInput {
	s.InstanceId = &v
	return s
}

// SetRaidArrayId sets the RaidArrayId field's value.
func (s *DescribeVolumesInput) SetRaidArrayId(v string) *DescribeVolumesInput {
	s.RaidArrayId = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *DescribeVolumesInput) SetStackId(v string) *DescribeVolumesInput {
	s.StackId = &v
	return s
}

// SetVolumeIds sets the VolumeIds field's value.
func (s *DescribeVolumesInput) SetVolumeIds(v []*string) *DescribeVolumesInput {
	s.VolumeIds = v
	return s
}

// Contains the response to a DescribeVolumes request.
type DescribeVolumesOutput struct {
	_ struct{} `type:"structure"`

	// An array of volume IDs.
	Volumes []*Volume `type:"list"`
}

// String returns the string representation
func (s DescribeVolumesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVolumesOutput) GoString() string {
	return s.String()
}

// SetVolumes sets the Volumes field's value.
func (s *DescribeVolumesOutput) SetVolumes(v []*Volume) *DescribeVolumesOutput {
	s.Volumes = v
	return s
}

type DetachElasticLoadBalancerInput struct {
	_ struct{} `type:"structure"`

	// The Elastic Load Balancing instance's name.
	//
	// ElasticLoadBalancerName is a required field
	ElasticLoadBalancerName *string `type:"string" required:"true"`

	// The ID of the layer that the Elastic Load Balancing instance is attached
	// to.
	//
	// LayerId is a required field
	LayerId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DetachElasticLoadBalancerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachElasticLoadBalancerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetachElasticLoadBalancerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetachElasticLoadBalancerInput"}
	if s.ElasticLoadBalancerName == nil {
		invalidParams.Add(request.NewErrParamRequired("ElasticLoadBalancerName"))
	}
	if s.LayerId == nil {
		invalidParams.Add(request.NewErrParamRequired("LayerId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetElasticLoadBalancerName sets the ElasticLoadBalancerName field's value.
func (s *DetachElasticLoadBalancerInput) SetElasticLoadBalancerName(v string) *DetachElasticLoadBalancerInput {
	s.ElasticLoadBalancerName = &v
	return s
}

// SetLayerId sets the LayerId field's value.
func (s *DetachElasticLoadBalancerInput) SetLayerId(v string) *DetachElasticLoadBalancerInput {
	s.LayerId = &v
	return s
}

type DetachElasticLoadBalancerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DetachElasticLoadBalancerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetachElasticLoadBalancerOutput) GoString() string {
	return s.String()
}

type DisassociateElasticIpInput struct {
	_ struct{} `type:"structure"`

	// The Elastic IP address.
	//
	// ElasticIp is a required field
	ElasticIp *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateElasticIpInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateElasticIpInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateElasticIpInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateElasticIpInput"}
	if s.ElasticIp == nil {
		invalidParams.Add(request.NewErrParamRequired("ElasticIp"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetElasticIp sets the ElasticIp field's value.
func (s *DisassociateElasticIpInput) SetElasticIp(v string) *DisassociateElasticIpInput {
	s.ElasticIp = &v
	return s
}

type DisassociateElasticIpOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateElasticIpOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateElasticIpOutput) GoString() string {
	return s.String()
}

// Describes an Amazon EBS volume. This data type maps directly to the Amazon
// EC2 EbsBlockDevice (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EbsBlockDevice.html)
// data type.
type EbsBlockDevice struct {
	_ struct{} `type:"structure"`

	// Whether the volume is deleted on instance termination.
	DeleteOnTermination *bool `type:"boolean"`

	// The number of I/O operations per second (IOPS) that the volume supports.
	// For more information, see EbsBlockDevice (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EbsBlockDevice.html).
	Iops *int64 `type:"integer"`

	// The snapshot ID.
	SnapshotId *string `type:"string"`

	// The volume size, in GiB. For more information, see EbsBlockDevice (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EbsBlockDevice.html).
	VolumeSize *int64 `type:"integer"`

	// The volume type. gp2 for General Purpose (SSD) volumes, io1 for Provisioned
	// IOPS (SSD) volumes, st1 for Throughput Optimized hard disk drives (HDD),
	// sc1 for Cold HDD,and standard for Magnetic volumes.
	//
	// If you specify the io1 volume type, you must also specify a value for the
	// Iops attribute. The maximum ratio of provisioned IOPS to requested volume
	// size (in GiB) is 50:1. AWS uses the default volume size (in GiB) specified
	// in the AMI attributes to set IOPS to 50 x (volume size).
	VolumeType *string `type:"string" enum:"VolumeType"`
}

// String returns the string representation
func (s EbsBlockDevice) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EbsBlockDevice) GoString() string {
	return s.String()
}

// SetDeleteOnTermination sets the DeleteOnTermination field's value.
func (s *EbsBlockDevice) SetDeleteOnTermination(v bool) *EbsBlockDevice {
	s.DeleteOnTermination = &v
	return s
}

// SetIops sets the Iops field's value.
func (s *EbsBlockDevice) SetIops(v int64) *EbsBlockDevice {
	s.Iops = &v
	return s
}

// SetSnapshotId sets the SnapshotId field's value.
func (s *EbsBlockDevice) SetSnapshotId(v string) *EbsBlockDevice {
	s.SnapshotId = &v
	return s
}

// SetVolumeSize sets the VolumeSize field's value.
func (s *EbsBlockDevice) SetVolumeSize(v int64) *EbsBlockDevice {
	s.VolumeSize = &v
	return s
}

// SetVolumeType sets the VolumeType field's value.
func (s *EbsBlockDevice) SetVolumeType(v string) *EbsBlockDevice {
	s.VolumeType = &v
	return s
}

// Describes a registered Amazon ECS cluster.
type EcsCluster struct {
	_ struct{} `type:"structure"`

	// The cluster's ARN.
	EcsClusterArn *string `type:"string"`

	// The cluster name.
	EcsClusterName *string `type:"string"`

	// The time and date that the cluster was registered with the stack.
	RegisteredAt *string `type:"string"`

	// The stack ID.
	StackId *string `type:"string"`
}

// String returns the string representation
func (s EcsCluster) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EcsCluster) GoString() string {
	return s.String()
}

// SetEcsClusterArn sets the EcsClusterArn field's value.
func (s *EcsCluster) SetEcsClusterArn(v string) *EcsCluster {
	s.EcsClusterArn = &v
	return s
}

// SetEcsClusterName sets the EcsClusterName field's value.
func (s *EcsCluster) SetEcsClusterName(v string) *EcsCluster {
	s.EcsClusterName = &v
	return s
}

// SetRegisteredAt sets the RegisteredAt field's value.
func (s *EcsCluster) SetRegisteredAt(v string) *EcsCluster {
	s.RegisteredAt = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *EcsCluster) SetStackId(v string) *EcsCluster {
	s.StackId = &v
	return s
}

// Describes an Elastic IP address.
type ElasticIp struct {
	_ struct{} `type:"structure"`

	// The domain.
	Domain *string `type:"string"`

	// The ID of the instance that the address is attached to.
	InstanceId *string `type:"string"`

	// The IP address.
	Ip *string `type:"string"`

	// The name.
	Name *string `type:"string"`

	// The AWS region. For more information, see Regions and Endpoints (https://docs.aws.amazon.com/general/latest/gr/rande.html).
	Region *string `type:"string"`
}

// String returns the string representation
func (s ElasticIp) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ElasticIp) GoString() string {
	return s.String()
}

// SetDomain sets the Domain field's value.
func (s *ElasticIp) SetDomain(v string) *ElasticIp {
	s.Domain = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *ElasticIp) SetInstanceId(v string) *ElasticIp {
	s.InstanceId = &v
	return s
}

// SetIp sets the Ip field's value.
func (s *ElasticIp) SetIp(v string) *ElasticIp {
	s.Ip = &v
	return s
}

// SetName sets the Name field's value.
func (s *ElasticIp) SetName(v string) *ElasticIp {
	s.Name = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *ElasticIp) SetRegion(v string) *ElasticIp {
	s.Region = &v
	return s
}

// Describes an Elastic Load Balancing instance.
type ElasticLoadBalancer struct {
	_ struct{} `type:"structure"`

	// A list of Availability Zones.
	AvailabilityZones []*string `type:"list"`

	// The instance's public DNS name.
	DnsName *string `type:"string"`

	// A list of the EC2 instances that the Elastic Load Balancing instance is managing
	// traffic for.
	Ec2InstanceIds []*string `type:"list"`

	// The Elastic Load Balancing instance's name.
	ElasticLoadBalancerName *string `type:"string"`

	// The ID of the layer that the instance is attached to.
	LayerId *string `type:"string"`

	// The instance's AWS region.
	Region *string `type:"string"`

	// The ID of the stack that the instance is associated with.
	StackId *string `type:"string"`

	// A list of subnet IDs, if the stack is running in a VPC.
	SubnetIds []*string `type:"list"`

	// The VPC ID.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s ElasticLoadBalancer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ElasticLoadBalancer) GoString() string {
	return s.String()
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *ElasticLoadBalancer) SetAvailabilityZones(v []*string) *ElasticLoadBalancer {
	s.AvailabilityZones = v
	return s
}

// SetDnsName sets the DnsName field's value.
func (s *ElasticLoadBalancer) SetDnsName(v string) *ElasticLoadBalancer {
	s.DnsName = &v
	return s
}

// SetEc2InstanceIds sets the Ec2InstanceIds field's value.
func (s *ElasticLoadBalancer) SetEc2InstanceIds(v []*string) *ElasticLoadBalancer {
	s.Ec2InstanceIds = v
	return s
}

// SetElasticLoadBalancerName sets the ElasticLoadBalancerName field's value.
func (s *ElasticLoadBalancer) SetElasticLoadBalancerName(v string) *ElasticLoadBalancer {
	s.ElasticLoadBalancerName = &v
	return s
}

// SetLayerId sets the LayerId field's value.
func (s *ElasticLoadBalancer) SetLayerId(v string) *ElasticLoadBalancer {
	s.LayerId = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *ElasticLoadBalancer) SetRegion(v string) *ElasticLoadBalancer {
	s.Region = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *ElasticLoadBalancer) SetStackId(v string) *ElasticLoadBalancer {
	s.StackId = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *ElasticLoadBalancer) SetSubnetIds(v []*string) *ElasticLoadBalancer {
	s.SubnetIds = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *ElasticLoadBalancer) SetVpcId(v string) *ElasticLoadBalancer {
	s.VpcId = &v
	return s
}

// Represents an app's environment variable.
type EnvironmentVariable struct {
	_ struct{} `type:"structure"`

	// (Required) The environment variable's name, which can consist of up to 64
	// characters and must be specified. The name can contain upper- and lowercase
	// letters, numbers, and underscores (_), but it must start with a letter or
	// underscore.
	//
	// Key is a required field
	Key *string `type:"string" required:"true"`

	// (Optional) Whether the variable's value will be returned by the DescribeApps
	// action. To conceal an environment variable's value, set Secure to true. DescribeApps
	// then returns *****FILTERED***** instead of the actual value. The default
	// value for Secure is false.
	Secure *bool `type:"boolean"`

	// (Optional) The environment variable's value, which can be left empty. If
	// you specify a value, it can contain up to 256 characters, which must all
	// be printable.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s EnvironmentVariable) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnvironmentVariable) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnvironmentVariable) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnvironmentVariable"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *EnvironmentVariable) SetKey(v string) *EnvironmentVariable {
	s.Key = &v
	return s
}

// SetSecure sets the Secure field's value.
func (s *EnvironmentVariable) SetSecure(v bool) *EnvironmentVariable {
	s.Secure = &v
	return s
}

// SetValue sets the Value field's value.
func (s *EnvironmentVariable) SetValue(v string) *EnvironmentVariable {
	s.Value = &v
	return s
}

type GetHostnameSuggestionInput struct {
	_ struct{} `type:"structure"`

	// The layer ID.
	//
	// LayerId is a required field
	LayerId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetHostnameSuggestionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHostnameSuggestionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetHostnameSuggestionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetHostnameSuggestionInput"}
	if s.LayerId == nil {
		invalidParams.Add(request.NewErrParamRequired("LayerId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLayerId sets the LayerId field's value.
func (s *GetHostnameSuggestionInput) SetLayerId(v string) *GetHostnameSuggestionInput {
	s.LayerId = &v
	return s
}

// Contains the response to a GetHostnameSuggestion request.
type GetHostnameSuggestionOutput struct {
	_ struct{} `type:"structure"`

	// The generated host name.
	Hostname *string `type:"string"`

	// The layer ID.
	LayerId *string `type:"string"`
}

// String returns the string representation
func (s GetHostnameSuggestionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHostnameSuggestionOutput) GoString() string {
	return s.String()
}

// SetHostname sets the Hostname field's value.
func (s *GetHostnameSuggestionOutput) SetHostname(v string) *GetHostnameSuggestionOutput {
	s.Hostname = &v
	return s
}

// SetLayerId sets the LayerId field's value.
func (s *GetHostnameSuggestionOutput) SetLayerId(v string) *GetHostnameSuggestionOutput {
	s.LayerId = &v
	return s
}

type GrantAccessInput struct {
	_ struct{} `type:"structure"`

	// The instance's AWS OpsWorks Stacks ID.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`

	// The length of time (in minutes) that the grant is valid. When the grant expires
	// at the end of this period, the user will no longer be able to use the credentials
	// to log in. If the user is logged in at the time, he or she automatically
	// will be logged out.
	ValidForInMinutes *int64 `min:"60" type:"integer"`
}

// String returns the string representation
func (s GrantAccessInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GrantAccessInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GrantAccessInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GrantAccessInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.ValidForInMinutes != nil && *s.ValidForInMinutes < 60 {
		invalidParams.Add(request.NewErrParamMinValue("ValidForInMinutes", 60))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *GrantAccessInput) SetInstanceId(v string) *GrantAccessInput {
	s.InstanceId = &v
	return s
}

// SetValidForInMinutes sets the ValidForInMinutes field's value.
func (s *GrantAccessInput) SetValidForInMinutes(v int64) *GrantAccessInput {
	s.ValidForInMinutes = &v
	return s
}

// Contains the response to a GrantAccess request.
type GrantAccessOutput struct {
	_ struct{} `type:"structure"`

	// A TemporaryCredential object that contains the data needed to log in to the
	// instance by RDP clients, such as the Microsoft Remote Desktop Connection.
	TemporaryCredential *TemporaryCredential `type:"structure"`
}

// String returns the string representation
func (s GrantAccessOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GrantAccessOutput) GoString() string {
	return s.String()
}

// SetTemporaryCredential sets the TemporaryCredential field's value.
func (s *GrantAccessOutput) SetTemporaryCredential(v *TemporaryCredential) *GrantAccessOutput {
	s.TemporaryCredential = v
	return s
}

// Describes an instance.
type Instance struct {
	_ struct{} `type:"structure"`

	// The agent version. This parameter is set to INHERIT if the instance inherits
	// the default stack setting or to a a version number for a fixed agent version.
	AgentVersion *string `type:"string"`

	// A custom AMI ID to be used to create the instance. For more information,
	// see Instances (https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html)
	AmiId *string `type:"string"`

	// The instance architecture: "i386" or "x86_64".
	Architecture *string `type:"string" enum:"Architecture"`

	// The instance's Amazon Resource Number (ARN).
	Arn *string `type:"string"`

	// For load-based or time-based instances, the type.
	AutoScalingType *string `type:"string" enum:"AutoScalingType"`

	// The instance Availability Zone. For more information, see Regions and Endpoints
	// (https://docs.aws.amazon.com/general/latest/gr/rande.html).
	AvailabilityZone *string `type:"string"`

	// An array of BlockDeviceMapping objects that specify the instance's block
	// device mappings.
	BlockDeviceMappings []*BlockDeviceMapping `type:"list"`

	// The time that the instance was created.
	CreatedAt *string `type:"string"`

	// Whether this is an Amazon EBS-optimized instance.
	EbsOptimized *bool `type:"boolean"`

	// The ID of the associated Amazon EC2 instance.
	Ec2InstanceId *string `type:"string"`

	// For container instances, the Amazon ECS cluster's ARN.
	EcsClusterArn *string `type:"string"`

	// For container instances, the instance's ARN.
	EcsContainerInstanceArn *string `type:"string"`

	// The instance Elastic IP address (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html).
	ElasticIp *string `type:"string"`

	// The instance host name.
	Hostname *string `type:"string"`

	// For registered instances, the infrastructure class: ec2 or on-premises.
	InfrastructureClass *string `type:"string"`

	// Whether to install operating system and package updates when the instance
	// boots. The default value is true. If this value is set to false, you must
	// then update your instances manually by using CreateDeployment to run the
	// update_dependencies stack command or by manually running yum (Amazon Linux)
	// or apt-get (Ubuntu) on the instances.
	//
	// We strongly recommend using the default value of true, to ensure that your
	// instances have the latest security updates.
	InstallUpdatesOnBoot *bool `type:"boolean"`

	// The instance ID.
	InstanceId *string `type:"string"`

	// The ARN of the instance's IAM profile. For more information about IAM ARNs,
	// see Using Identifiers (https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html).
	InstanceProfileArn *string `type:"string"`

	// The instance type, such as t2.micro.
	InstanceType *string `type:"string"`

	// The ID of the last service error. For more information, call DescribeServiceErrors.
	LastServiceErrorId *string `type:"string"`

	// An array containing the instance layer IDs.
	LayerIds []*string `type:"list"`

	// The instance's operating system.
	Os *string `type:"string"`

	// The instance's platform.
	Platform *string `type:"string"`

	// The instance's private DNS name.
	PrivateDns *string `type:"string"`

	// The instance's private IP address.
	PrivateIp *string `type:"string"`

	// The instance public DNS name.
	PublicDns *string `type:"string"`

	// The instance public IP address.
	PublicIp *string `type:"string"`

	// For registered instances, who performed the registration.
	RegisteredBy *string `type:"string"`

	// The instance's reported AWS OpsWorks Stacks agent version.
	ReportedAgentVersion *string `type:"string"`

	// For registered instances, the reported operating system.
	ReportedOs *ReportedOs `type:"structure"`

	// The instance's root device type. For more information, see Storage for the
	// Root Device (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device).
	RootDeviceType *string `type:"string" enum:"RootDeviceType"`

	// The root device volume ID.
	RootDeviceVolumeId *string `type:"string"`

	// An array containing the instance security group IDs.
	SecurityGroupIds []*string `type:"list"`

	// The SSH key's Deep Security Agent (DSA) fingerprint.
	SshHostDsaKeyFingerprint *string `type:"string"`

	// The SSH key's RSA fingerprint.
	SshHostRsaKeyFingerprint *string `type:"string"`

	// The instance's Amazon EC2 key-pair name.
	SshKeyName *string `type:"string"`

	// The stack ID.
	StackId *string `type:"string"`

	// The instance status:
	//
	//    * booting
	//
	//    * connection_lost
	//
	//    * online
	//
	//    * pending
	//
	//    * rebooting
	//
	//    * requested
	//
	//    * running_setup
	//
	//    * setup_failed
	//
	//    * shutting_down
	//
	//    * start_failed
	//
	//    * stop_failed
	//
	//    * stopped
	//
	//    * stopping
	//
	//    * terminated
	//
	//    * terminating
	Status *string `type:"string"`

	// The instance's subnet ID; applicable only if the stack is running in a VPC.
	SubnetId *string `type:"string"`

	// The instance's tenancy option, such as dedicated or host.
	Tenancy *string `type:"string"`

	// The instance's virtualization type: paravirtual or hvm.
	VirtualizationType *string `type:"string" enum:"VirtualizationType"`
}

// String returns the string representation
func (s Instance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Instance) GoString() string {
	return s.String()
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *Instance) SetAgentVersion(v string) *Instance {
	s.AgentVersion = &v
	return s
}

// SetAmiId sets the AmiId field's value.
func (s *Instance) SetAmiId(v string) *Instance {
	s.AmiId = &v
	return s
}

// SetArchitecture sets the Architecture field's value.
func (s *Instance) SetArchitecture(v string) *Instance {
	s.Architecture = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *Instance) SetArn(v string) *Instance {
	s.Arn = &v
	return s
}

// SetAutoScalingType sets the AutoScalingType field's value.
func (s *Instance) SetAutoScalingType(v string) *Instance {
	s.AutoScalingType = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *Instance) SetAvailabilityZone(v string) *Instance {
	s.AvailabilityZone = &v
	return s
}

// SetBlockDeviceMappings sets the BlockDeviceMappings field's value.
func (s *Instance) SetBlockDeviceMappings(v []*BlockDeviceMapping) *Instance {
	s.BlockDeviceMappings = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Instance) SetCreatedAt(v string) *Instance {
	s.CreatedAt = &v
	return s
}

// SetEbsOptimized sets the EbsOptimized field's value.
func (s *Instance) SetEbsOptimized(v bool) *Instance {
	s.EbsOptimized = &v
	return s
}

// SetEc2InstanceId sets the Ec2InstanceId field's value.
func (s *Instance) SetEc2InstanceId(v string) *Instance {
	s.Ec2InstanceId = &v
	return s
}

// SetEcsClusterArn sets the EcsClusterArn field's value.
func (s *Instance) SetEcsClusterArn(v string) *Instance {
	s.EcsClusterArn = &v
	return s
}

// SetEcsContainerInstanceArn sets the EcsContainerInstanceArn field's value.
func (s *Instance) SetEcsContainerInstanceArn(v string) *Instance {
	s.EcsContainerInstanceArn = &v
	return s
}

// SetElasticIp sets the ElasticIp field's value.
func (s *Instance) SetElasticIp(v string) *Instance {
	s.ElasticIp = &v
	return s
}

// SetHostname sets the Hostname field's value.
func (s *Instance) SetHostname(v string) *Instance {
	s.Hostname = &v
	return s
}

// SetInfrastructureClass sets the InfrastructureClass field's value.
func (s *Instance) SetInfrastructureClass(v string) *Instance {
	s.InfrastructureClass = &v
	return s
}

// SetInstallUpdatesOnBoot sets the InstallUpdatesOnBoot field's value.
func (s *Instance) SetInstallUpdatesOnBoot(v bool) *Instance {
	s.InstallUpdatesOnBoot = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *Instance) SetInstanceId(v string) *Instance {
	s.InstanceId = &v
	return s
}

// SetInstanceProfileArn sets the InstanceProfileArn field's value.
func (s *Instance) SetInstanceProfileArn(v string) *Instance {
	s.InstanceProfileArn = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *Instance) SetInstanceType(v string) *Instance {
	s.InstanceType = &v
	return s
}

// SetLastServiceErrorId sets the LastServiceErrorId field's value.
func (s *Instance) SetLastServiceErrorId(v string) *Instance {
	s.LastServiceErrorId = &v
	return s
}

// SetLayerIds sets the LayerIds field's value.
func (s *Instance) SetLayerIds(v []*string) *Instance {
	s.LayerIds = v
	return s
}

// SetOs sets the Os field's value.
func (s *Instance) SetOs(v string) *Instance {
	s.Os = &v
	return s
}

// SetPlatform sets the Platform field's value.
func (s *Instance) SetPlatform(v string) *Instance {
	s.Platform = &v
	return s
}

// SetPrivateDns sets the PrivateDns field's value.
func (s *Instance) SetPrivateDns(v string) *Instance {
	s.PrivateDns = &v
	return s
}

// SetPrivateIp sets the PrivateIp field's value.
func (s *Instance) SetPrivateIp(v string) *Instance {
	s.PrivateIp = &v
	return s
}

// SetPublicDns sets the PublicDns field's value.
func (s *Instance) SetPublicDns(v string) *Instance {
	s.PublicDns = &v
	return s
}

// SetPublicIp sets the PublicIp field's value.
func (s *Instance) SetPublicIp(v string) *Instance {
	s.PublicIp = &v
	return s
}

// SetRegisteredBy sets the RegisteredBy field's value.
func (s *Instance) SetRegisteredBy(v string) *Instance {
	s.RegisteredBy = &v
	return s
}

// SetReportedAgentVersion sets the ReportedAgentVersion field's value.
func (s *Instance) SetReportedAgentVersion(v string) *Instance {
	s.ReportedAgentVersion = &v
	return s
}

// SetReportedOs sets the ReportedOs field's value.
func (s *Instance) SetReportedOs(v *ReportedOs) *Instance {
	s.ReportedOs = v
	return s
}

// SetRootDeviceType sets the RootDeviceType field's value.
func (s *Instance) SetRootDeviceType(v string) *Instance {
	s.RootDeviceType = &v
	return s
}

// SetRootDeviceVolumeId sets the RootDeviceVolumeId field's value.
func (s *Instance) SetRootDeviceVolumeId(v string) *Instance {
	s.RootDeviceVolumeId = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *Instance) SetSecurityGroupIds(v []*string) *Instance {
	s.SecurityGroupIds = v
	return s
}

// SetSshHostDsaKeyFingerprint sets the SshHostDsaKeyFingerprint field's value.
func (s *Instance) SetSshHostDsaKeyFingerprint(v string) *Instance {
	s.SshHostDsaKeyFingerprint = &v
	return s
}

// SetSshHostRsaKeyFingerprint sets the SshHostRsaKeyFingerprint field's value.
func (s *Instance) SetSshHostRsaKeyFingerprint(v string) *Instance {
	s.SshHostRsaKeyFingerprint = &v
	return s
}

// SetSshKeyName sets the SshKeyName field's value.
func (s *Instance) SetSshKeyName(v string) *Instance {
	s.SshKeyName = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *Instance) SetStackId(v string) *Instance {
	s.StackId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Instance) SetStatus(v string) *Instance {
	s.Status = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *Instance) SetSubnetId(v string) *Instance {
	s.SubnetId = &v
	return s
}

// SetTenancy sets the Tenancy field's value.
func (s *Instance) SetTenancy(v string) *Instance {
	s.Tenancy = &v
	return s
}

// SetVirtualizationType sets the VirtualizationType field's value.
func (s *Instance) SetVirtualizationType(v string) *Instance {
	s.VirtualizationType = &v
	return s
}

// Contains a description of an Amazon EC2 instance from the Amazon EC2 metadata
// service. For more information, see Instance Metadata and User Data (https://docs.aws.amazon.com/sdkfornet/latest/apidocs/Index.html).
type InstanceIdentity struct {
	_ struct{} `type:"structure"`

	// A JSON document that contains the metadata.
	Document *string `type:"string"`

	// A signature that can be used to verify the document's accuracy and authenticity.
	Signature *string `type:"string"`
}

// String returns the string representation
func (s InstanceIdentity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceIdentity) GoString() string {
	return s.String()
}

// SetDocument sets the Document field's value.
func (s *InstanceIdentity) SetDocument(v string) *InstanceIdentity {
	s.Document = &v
	return s
}

// SetSignature sets the Signature field's value.
func (s *InstanceIdentity) SetSignature(v string) *InstanceIdentity {
	s.Signature = &v
	return s
}

// Describes how many instances a stack has for each status.
type InstancesCount struct {
	_ struct{} `type:"structure"`

	// The number of instances in the Assigning state.
	Assigning *int64 `type:"integer"`

	// The number of instances with booting status.
	Booting *int64 `type:"integer"`

	// The number of instances with connection_lost status.
	ConnectionLost *int64 `type:"integer"`

	// The number of instances in the Deregistering state.
	Deregistering *int64 `type:"integer"`

	// The number of instances with online status.
	Online *int64 `type:"integer"`

	// The number of instances with pending status.
	Pending *int64 `type:"integer"`

	// The number of instances with rebooting status.
	Rebooting *int64 `type:"integer"`

	// The number of instances in the Registered state.
	Registered *int64 `type:"integer"`

	// The number of instances in the Registering state.
	Registering *int64 `type:"integer"`

	// The number of instances with requested status.
	Requested *int64 `type:"integer"`

	// The number of instances with running_setup status.
	RunningSetup *int64 `type:"integer"`

	// The number of instances with setup_failed status.
	SetupFailed *int64 `type:"integer"`

	// The number of instances with shutting_down status.
	ShuttingDown *int64 `type:"integer"`

	// The number of instances with start_failed status.
	StartFailed *int64 `type:"integer"`

	// The number of instances with stop_failed status.
	StopFailed *int64 `type:"integer"`

	// The number of instances with stopped status.
	Stopped *int64 `type:"integer"`

	// The number of instances with stopping status.
	Stopping *int64 `type:"integer"`

	// The number of instances with terminated status.
	Terminated *int64 `type:"integer"`

	// The number of instances with terminating status.
	Terminating *int64 `type:"integer"`

	// The number of instances in the Unassigning state.
	Unassigning *int64 `type:"integer"`
}

// String returns the string representation
func (s InstancesCount) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstancesCount) GoString() string {
	return s.String()
}

// SetAssigning sets the Assigning field's value.
func (s *InstancesCount) SetAssigning(v int64) *InstancesCount {
	s.Assigning = &v
	return s
}

// SetBooting sets the Booting field's value.
func (s *InstancesCount) SetBooting(v int64) *InstancesCount {
	s.Booting = &v
	return s
}

// SetConnectionLost sets the ConnectionLost field's value.
func (s *InstancesCount) SetConnectionLost(v int64) *InstancesCount {
	s.ConnectionLost = &v
	return s
}

// SetDeregistering sets the Deregistering field's value.
func (s *InstancesCount) SetDeregistering(v int64) *InstancesCount {
	s.Deregistering = &v
	return s
}

// SetOnline sets the Online field's value.
func (s *InstancesCount) SetOnline(v int64) *InstancesCount {
	s.Online = &v
	return s
}

// SetPending sets the Pending field's value.
func (s *InstancesCount) SetPending(v int64) *InstancesCount {
	s.Pending = &v
	return s
}

// SetRebooting sets the Rebooting field's value.
func (s *InstancesCount) SetRebooting(v int64) *InstancesCount {
	s.Rebooting = &v
	return s
}

// SetRegistered sets the Registered field's value.
func (s *InstancesCount) SetRegistered(v int64) *InstancesCount {
	s.Registered = &v
	return s
}

// SetRegistering sets the Registering field's value.
func (s *InstancesCount) SetRegistering(v int64) *InstancesCount {
	s.Registering = &v
	return s
}

// SetRequested sets the Requested field's value.
func (s *InstancesCount) SetRequested(v int64) *InstancesCount {
	s.Requested = &v
	return s
}

// SetRunningSetup sets the RunningSetup field's value.
func (s *InstancesCount) SetRunningSetup(v int64) *InstancesCount {
	s.RunningSetup = &v
	return s
}

// SetSetupFailed sets the SetupFailed field's value.
func (s *InstancesCount) SetSetupFailed(v int64) *InstancesCount {
	s.SetupFailed = &v
	return s
}

// SetShuttingDown sets the ShuttingDown field's value.
func (s *InstancesCount) SetShuttingDown(v int64) *InstancesCount {
	s.ShuttingDown = &v
	return s
}

// SetStartFailed sets the StartFailed field's value.
func (s *InstancesCount) SetStartFailed(v int64) *InstancesCount {
	s.StartFailed = &v
	return s
}

// SetStopFailed sets the StopFailed field's value.
func (s *InstancesCount) SetStopFailed(v int64) *InstancesCount {
	s.StopFailed = &v
	return s
}

// SetStopped sets the Stopped field's value.
func (s *InstancesCount) SetStopped(v int64) *InstancesCount {
	s.Stopped = &v
	return s
}

// SetStopping sets the Stopping field's value.
func (s *InstancesCount) SetStopping(v int64) *InstancesCount {
	s.Stopping = &v
	return s
}

// SetTerminated sets the Terminated field's value.
func (s *InstancesCount) SetTerminated(v int64) *InstancesCount {
	s.Terminated = &v
	return s
}

// SetTerminating sets the Terminating field's value.
func (s *InstancesCount) SetTerminating(v int64) *InstancesCount {
	s.Terminating = &v
	return s
}

// SetUnassigning sets the Unassigning field's value.
func (s *InstancesCount) SetUnassigning(v int64) *InstancesCount {
	s.Unassigning = &v
	return s
}

// Describes a layer.
type Layer struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Number (ARN) of a layer.
	Arn *string `type:"string"`

	// The layer attributes.
	//
	// For the HaproxyStatsPassword, MysqlRootPassword, and GangliaPassword attributes,
	// AWS OpsWorks Stacks returns *****FILTERED***** instead of the actual value
	//
	// For an ECS Cluster layer, AWS OpsWorks Stacks the EcsClusterArn attribute
	// is set to the cluster's ARN.
	Attributes map[string]*string `type:"map"`

	// Whether to automatically assign an Elastic IP address (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html)
	// to the layer's instances. For more information, see How to Edit a Layer (https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html).
	AutoAssignElasticIps *bool `type:"boolean"`

	// For stacks that are running in a VPC, whether to automatically assign a public
	// IP address to the layer's instances. For more information, see How to Edit
	// a Layer (https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html).
	AutoAssignPublicIps *bool `type:"boolean"`

	// The Amazon CloudWatch Logs configuration settings for the layer.
	CloudWatchLogsConfiguration *CloudWatchLogsConfiguration `type:"structure"`

	// Date when the layer was created.
	CreatedAt *string `type:"string"`

	// The ARN of the default IAM profile to be used for the layer's EC2 instances.
	// For more information about IAM ARNs, see Using Identifiers (https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html).
	CustomInstanceProfileArn *string `type:"string"`

	// A JSON formatted string containing the layer's custom stack configuration
	// and deployment attributes.
	CustomJson *string `type:"string"`

	// A LayerCustomRecipes object that specifies the layer's custom recipes.
	CustomRecipes *Recipes `type:"structure"`

	// An array containing the layer's custom security group IDs.
	CustomSecurityGroupIds []*string `type:"list"`

	// AWS OpsWorks Stacks supports five lifecycle events: setup, configuration,
	// deploy, undeploy, and shutdown. For each layer, AWS OpsWorks Stacks runs
	// a set of standard recipes for each event. You can also provide custom recipes
	// for any or all layers and events. AWS OpsWorks Stacks runs custom event recipes
	// after the standard recipes. LayerCustomRecipes specifies the custom recipes
	// for a particular layer to be run in response to each of the five events.
	//
	// To specify a recipe, use the cookbook's directory name in the repository
	// followed by two colons and the recipe name, which is the recipe's file name
	// without the .rb extension. For example: phpapp2::dbsetup specifies the dbsetup.rb
	// recipe in the repository's phpapp2 folder.
	DefaultRecipes *Recipes `type:"structure"`

	// An array containing the layer's security group names.
	DefaultSecurityGroupNames []*string `type:"list"`

	// Whether auto healing is disabled for the layer.
	EnableAutoHealing *bool `type:"boolean"`

	// Whether to install operating system and package updates when the instance
	// boots. The default value is true. If this value is set to false, you must
	// then update your instances manually by using CreateDeployment to run the
	// update_dependencies stack command or manually running yum (Amazon Linux)
	// or apt-get (Ubuntu) on the instances.
	//
	// We strongly recommend using the default value of true, to ensure that your
	// instances have the latest security updates.
	InstallUpdatesOnBoot *bool `type:"boolean"`

	// The layer ID.
	LayerId *string `type:"string"`

	// A LifeCycleEventConfiguration object that specifies the Shutdown event configuration.
	LifecycleEventConfiguration *LifecycleEventConfiguration `type:"structure"`

	// The layer name.
	Name *string `type:"string"`

	// An array of Package objects that describe the layer's packages.
	Packages []*string `type:"list"`

	// The layer short name.
	Shortname *string `type:"string"`

	// The layer stack ID.
	StackId *string `type:"string"`

	// The layer type.
	Type *string `type:"string" enum:"LayerType"`

	// Whether the layer uses Amazon EBS-optimized instances.
	UseEbsOptimizedInstances *bool `type:"boolean"`

	// A VolumeConfigurations object that describes the layer's Amazon EBS volumes.
	VolumeConfigurations []*VolumeConfiguration `type:"list"`
}

// String returns the string representation
func (s Layer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Layer) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Layer) SetArn(v string) *Layer {
	s.Arn = &v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *Layer) SetAttributes(v map[string]*string) *Layer {
	s.Attributes = v
	return s
}

// SetAutoAssignElasticIps sets the AutoAssignElasticIps field's value.
func (s *Layer) SetAutoAssignElasticIps(v bool) *Layer {
	s.AutoAssignElasticIps = &v
	return s
}

// SetAutoAssignPublicIps sets the AutoAssignPublicIps field's value.
func (s *Layer) SetAutoAssignPublicIps(v bool) *Layer {
	s.AutoAssignPublicIps = &v
	return s
}

// SetCloudWatchLogsConfiguration sets the CloudWatchLogsConfiguration field's value.
func (s *Layer) SetCloudWatchLogsConfiguration(v *CloudWatchLogsConfiguration) *Layer {
	s.CloudWatchLogsConfiguration = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Layer) SetCreatedAt(v string) *Layer {
	s.CreatedAt = &v
	return s
}

// SetCustomInstanceProfileArn sets the CustomInstanceProfileArn field's value.
func (s *Layer) SetCustomInstanceProfileArn(v string) *Layer {
	s.CustomInstanceProfileArn = &v
	return s
}

// SetCustomJson sets the CustomJson field's value.
func (s *Layer) SetCustomJson(v string) *Layer {
	s.CustomJson = &v
	return s
}

// SetCustomRecipes sets the CustomRecipes field's value.
func (s *Layer) SetCustomRecipes(v *Recipes) *Layer {
	s.CustomRecipes = v
	return s
}

// SetCustomSecurityGroupIds sets the CustomSecurityGroupIds field's value.
func (s *Layer) SetCustomSecurityGroupIds(v []*string) *Layer {
	s.CustomSecurityGroupIds = v
	return s
}

// SetDefaultRecipes sets the DefaultRecipes field's value.
func (s *Layer) SetDefaultRecipes(v *Recipes) *Layer {
	s.DefaultRecipes = v
	return s
}

// SetDefaultSecurityGroupNames sets the DefaultSecurityGroupNames field's value.
func (s *Layer) SetDefaultSecurityGroupNames(v []*string) *Layer {
	s.DefaultSecurityGroupNames = v
	return s
}

// SetEnableAutoHealing sets the EnableAutoHealing field's value.
func (s *Layer) SetEnableAutoHealing(v bool) *Layer {
	s.EnableAutoHealing = &v
	return s
}

// SetInstallUpdatesOnBoot sets the InstallUpdatesOnBoot field's value.
func (s *Layer) SetInstallUpdatesOnBoot(v bool) *Layer {
	s.InstallUpdatesOnBoot = &v
	return s
}

// SetLayerId sets the LayerId field's value.
func (s *Layer) SetLayerId(v string) *Layer {
	s.LayerId = &v
	return s
}

// SetLifecycleEventConfiguration sets the LifecycleEventConfiguration field's value.
func (s *Layer) SetLifecycleEventConfiguration(v *LifecycleEventConfiguration) *Layer {
	s.LifecycleEventConfiguration = v
	return s
}

// SetName sets the Name field's value.
func (s *Layer) SetName(v string) *Layer {
	s.Name = &v
	return s
}

// SetPackages sets the Packages field's value.
func (s *Layer) SetPackages(v []*string) *Layer {
	s.Packages = v
	return s
}

// SetShortname sets the Shortname field's value.
func (s *Layer) SetShortname(v string) *Layer {
	s.Shortname = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *Layer) SetStackId(v string) *Layer {
	s.StackId = &v
	return s
}

// SetType sets the Type field's value.
func (s *Layer) SetType(v string) *Layer {
	s.Type = &v
	return s
}

// SetUseEbsOptimizedInstances sets the UseEbsOptimizedInstances field's value.
func (s *Layer) SetUseEbsOptimizedInstances(v bool) *Layer {
	s.UseEbsOptimizedInstances = &v
	return s
}

// SetVolumeConfigurations sets the VolumeConfigurations field's value.
func (s *Layer) SetVolumeConfigurations(v []*VolumeConfiguration) *Layer {
	s.VolumeConfigurations = v
	return s
}

// Specifies the lifecycle event configuration
type LifecycleEventConfiguration struct {
	_ struct{} `type:"structure"`

	// A ShutdownEventConfiguration object that specifies the Shutdown event configuration.
	Shutdown *ShutdownEventConfiguration `type:"structure"`
}

// String returns the string representation
func (s LifecycleEventConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LifecycleEventConfiguration) GoString() string {
	return s.String()
}

// SetShutdown sets the Shutdown field's value.
func (s *LifecycleEventConfiguration) SetShutdown(v *ShutdownEventConfiguration) *LifecycleEventConfiguration {
	s.Shutdown = v
	return s
}

type ListTagsInput struct {
	_ struct{} `type:"structure"`

	// Do not use. A validation exception occurs if you add a MaxResults parameter
	// to a ListTagsRequest call.
	MaxResults *int64 `type:"integer"`

	// Do not use. A validation exception occurs if you add a NextToken parameter
	// to a ListTagsRequest call.
	NextToken *string `type:"string"`

	// The stack or layer's Amazon Resource Number (ARN).
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTagsInput) SetMaxResults(v int64) *ListTagsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsInput) SetNextToken(v string) *ListTagsInput {
	s.NextToken = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsInput) SetResourceArn(v string) *ListTagsInput {
	s.ResourceArn = &v
	return s
}

// Contains the response to a ListTags request.
type ListTagsOutput struct {
	_ struct{} `type:"structure"`

	// If a paginated request does not return all of the remaining results, this
	// parameter is set to a token that you can assign to the request object's NextToken
	// parameter to get the next set of results. If the previous paginated request
	// returned all of the remaining results, this parameter is set to null.
	NextToken *string `type:"string"`

	// A set of key-value pairs that contain tag keys and tag values that are attached
	// to a stack or layer.
	Tags map[string]*string `type:"map"`
}

// String returns the string representation
func (s ListTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsOutput) SetNextToken(v string) *ListTagsOutput {
	s.NextToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsOutput) SetTags(v map[string]*string) *ListTagsOutput {
	s.Tags = v
	return s
}

// Describes a layer's load-based auto scaling configuration.
type LoadBasedAutoScalingConfiguration struct {
	_ struct{} `type:"structure"`

	// An AutoScalingThresholds object that describes the downscaling configuration,
	// which defines how and when AWS OpsWorks Stacks reduces the number of instances.
	DownScaling *AutoScalingThresholds `type:"structure"`

	// Whether load-based auto scaling is enabled for the layer.
	Enable *bool `type:"boolean"`

	// The layer ID.
	LayerId *string `type:"string"`

	// An AutoScalingThresholds object that describes the upscaling configuration,
	// which defines how and when AWS OpsWorks Stacks increases the number of instances.
	UpScaling *AutoScalingThresholds `type:"structure"`
}

// String returns the string representation
func (s LoadBasedAutoScalingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoadBasedAutoScalingConfiguration) GoString() string {
	return s.String()
}

// SetDownScaling sets the DownScaling field's value.
func (s *LoadBasedAutoScalingConfiguration) SetDownScaling(v *AutoScalingThresholds) *LoadBasedAutoScalingConfiguration {
	s.DownScaling = v
	return s
}

// SetEnable sets the Enable field's value.
func (s *LoadBasedAutoScalingConfiguration) SetEnable(v bool) *LoadBasedAutoScalingConfiguration {
	s.Enable = &v
	return s
}

// SetLayerId sets the LayerId field's value.
func (s *LoadBasedAutoScalingConfiguration) SetLayerId(v string) *LoadBasedAutoScalingConfiguration {
	s.LayerId = &v
	return s
}

// SetUpScaling sets the UpScaling field's value.
func (s *LoadBasedAutoScalingConfiguration) SetUpScaling(v *AutoScalingThresholds) *LoadBasedAutoScalingConfiguration {
	s.UpScaling = v
	return s
}

// Describes supported operating systems in AWS OpsWorks Stacks.
type OperatingSystem struct {
	_ struct{} `type:"structure"`

	// Supported configuration manager name and versions for an AWS OpsWorks Stacks
	// operating system.
	ConfigurationManagers []*OperatingSystemConfigurationManager `type:"list"`

	// The ID of a supported operating system, such as Amazon Linux 2018.03.
	Id *string `type:"string"`

	// The name of the operating system, such as Amazon Linux 2018.03.
	Name *string `type:"string"`

	// A short name for the operating system manufacturer.
	ReportedName *string `type:"string"`

	// The version of the operating system, including the release and edition, if
	// applicable.
	ReportedVersion *string `type:"string"`

	// Indicates that an operating system is not supported for new instances.
	Supported *bool `type:"boolean"`

	// The type of a supported operating system, either Linux or Windows.
	Type *string `type:"string"`
}

// String returns the string representation
func (s OperatingSystem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OperatingSystem) GoString() string {
	return s.String()
}

// SetConfigurationManagers sets the ConfigurationManagers field's value.
func (s *OperatingSystem) SetConfigurationManagers(v []*OperatingSystemConfigurationManager) *OperatingSystem {
	s.ConfigurationManagers = v
	return s
}

// SetId sets the Id field's value.
func (s *OperatingSystem) SetId(v string) *OperatingSystem {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *OperatingSystem) SetName(v string) *OperatingSystem {
	s.Name = &v
	return s
}

// SetReportedName sets the ReportedName field's value.
func (s *OperatingSystem) SetReportedName(v string) *OperatingSystem {
	s.ReportedName = &v
	return s
}

// SetReportedVersion sets the ReportedVersion field's value.
func (s *OperatingSystem) SetReportedVersion(v string) *OperatingSystem {
	s.ReportedVersion = &v
	return s
}

// SetSupported sets the Supported field's value.
func (s *OperatingSystem) SetSupported(v bool) *OperatingSystem {
	s.Supported = &v
	return s
}

// SetType sets the Type field's value.
func (s *OperatingSystem) SetType(v string) *OperatingSystem {
	s.Type = &v
	return s
}

// A block that contains information about the configuration manager (Chef)
// and the versions of the configuration manager that are supported for an operating
// system.
type OperatingSystemConfigurationManager struct {
	_ struct{} `type:"structure"`

	// The name of the configuration manager, which is Chef.
	Name *string `type:"string"`

	// The versions of the configuration manager that are supported by an operating
	// system.
	Version *string `type:"string"`
}

// String returns the string representation
func (s OperatingSystemConfigurationManager) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OperatingSystemConfigurationManager) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *OperatingSystemConfigurationManager) SetName(v string) *OperatingSystemConfigurationManager {
	s.Name = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *OperatingSystemConfigurationManager) SetVersion(v string) *OperatingSystemConfigurationManager {
	s.Version = &v
	return s
}

// Describes stack or user permissions.
type Permission struct {
	_ struct{} `type:"structure"`

	// Whether the user can use SSH.
	AllowSsh *bool `type:"boolean"`

	// Whether the user can use sudo.
	AllowSudo *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) for an AWS Identity and Access Management
	// (IAM) role. For more information about IAM ARNs, see Using Identifiers (https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html).
	IamUserArn *string `type:"string"`

	// The user's permission level, which must be the following:
	//
	//    * deny
	//
	//    * show
	//
	//    * deploy
	//
	//    * manage
	//
	//    * iam_only
	//
	// For more information on the permissions associated with these levels, see
	// Managing User Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html)
	Level *string `type:"string"`

	// A stack ID.
	StackId *string `type:"string"`
}

// String returns the string representation
func (s Permission) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Permission) GoString() string {
	return s.String()
}

// SetAllowSsh sets the AllowSsh field's value.
func (s *Permission) SetAllowSsh(v bool) *Permission {
	s.AllowSsh = &v
	return s
}

// SetAllowSudo sets the AllowSudo field's value.
func (s *Permission) SetAllowSudo(v bool) *Permission {
	s.AllowSudo = &v
	return s
}

// SetIamUserArn sets the IamUserArn field's value.
func (s *Permission) SetIamUserArn(v string) *Permission {
	s.IamUserArn = &v
	return s
}

// SetLevel sets the Level field's value.
func (s *Permission) SetLevel(v string) *Permission {
	s.Level = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *Permission) SetStackId(v string) *Permission {
	s.StackId = &v
	return s
}

// Describes an instance's RAID array.
type RaidArray struct {
	_ struct{} `type:"structure"`

	// The array's Availability Zone. For more information, see Regions and Endpoints
	// (https://docs.aws.amazon.com/general/latest/gr/rande.html).
	AvailabilityZone *string `type:"string"`

	// When the RAID array was created.
	CreatedAt *string `type:"string"`

	// The array's Linux device. For example /dev/mdadm0.
	Device *string `type:"string"`

	// The instance ID.
	InstanceId *string `type:"string"`

	// For PIOPS volumes, the IOPS per disk.
	Iops *int64 `type:"integer"`

	// The array's mount point.
	MountPoint *string `type:"string"`

	// The array name.
	Name *string `type:"string"`

	// The number of disks in the array.
	NumberOfDisks *int64 `type:"integer"`

	// The array ID.
	RaidArrayId *string `type:"string"`

	// The RAID level (http://en.wikipedia.org/wiki/Standard_RAID_levels).
	RaidLevel *int64 `type:"integer"`

	// The array's size.
	Size *int64 `type:"integer"`

	// The stack ID.
	StackId *string `type:"string"`

	// The volume type, standard or PIOPS.
	VolumeType *string `type:"string"`
}

// String returns the string representation
func (s RaidArray) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RaidArray) GoString() string {
	return s.String()
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *RaidArray) SetAvailabilityZone(v string) *RaidArray {
	s.AvailabilityZone = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *RaidArray) SetCreatedAt(v string) *RaidArray {
	s.CreatedAt = &v
	return s
}

// SetDevice sets the Device field's value.
func (s *RaidArray) SetDevice(v string) *RaidArray {
	s.Device = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *RaidArray) SetInstanceId(v string) *RaidArray {
	s.InstanceId = &v
	return s
}

// SetIops sets the Iops field's value.
func (s *RaidArray) SetIops(v int64) *RaidArray {
	s.Iops = &v
	return s
}

// SetMountPoint sets the MountPoint field's value.
func (s *RaidArray) SetMountPoint(v string) *RaidArray {
	s.MountPoint = &v
	return s
}

// SetName sets the Name field's value.
func (s *RaidArray) SetName(v string) *RaidArray {
	s.Name = &v
	return s
}

// SetNumberOfDisks sets the NumberOfDisks field's value.
func (s *RaidArray) SetNumberOfDisks(v int64) *RaidArray {
	s.NumberOfDisks = &v
	return s
}

// SetRaidArrayId sets the RaidArrayId field's value.
func (s *RaidArray) SetRaidArrayId(v string) *RaidArray {
	s.RaidArrayId = &v
	return s
}

// SetRaidLevel sets the RaidLevel field's value.
func (s *RaidArray) SetRaidLevel(v int64) *RaidArray {
	s.RaidLevel = &v
	return s
}

// SetSize sets the Size field's value.
func (s *RaidArray) SetSize(v int64) *RaidArray {
	s.Size = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *RaidArray) SetStackId(v string) *RaidArray {
	s.StackId = &v
	return s
}

// SetVolumeType sets the VolumeType field's value.
func (s *RaidArray) SetVolumeType(v string) *RaidArray {
	s.VolumeType = &v
	return s
}

// Describes an Amazon RDS instance.
type RdsDbInstance struct {
	_ struct{} `type:"structure"`

	// The instance's address.
	Address *string `type:"string"`

	// The DB instance identifier.
	DbInstanceIdentifier *string `type:"string"`

	// AWS OpsWorks Stacks returns *****FILTERED***** instead of the actual value.
	DbPassword *string `type:"string"`

	// The master user name.
	DbUser *string `type:"string"`

	// The instance's database engine.
	Engine *string `type:"string"`

	// Set to true if AWS OpsWorks Stacks is unable to discover the Amazon RDS instance.
	// AWS OpsWorks Stacks attempts to discover the instance only once. If this
	// value is set to true, you must deregister the instance, and then register
	// it again.
	MissingOnRds *bool `type:"boolean"`

	// The instance's ARN.
	RdsDbInstanceArn *string `type:"string"`

	// The instance's AWS region.
	Region *string `type:"string"`

	// The ID of the stack with which the instance is registered.
	StackId *string `type:"string"`
}

// String returns the string representation
func (s RdsDbInstance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RdsDbInstance) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *RdsDbInstance) SetAddress(v string) *RdsDbInstance {
	s.Address = &v
	return s
}

// SetDbInstanceIdentifier sets the DbInstanceIdentifier field's value.
func (s *RdsDbInstance) SetDbInstanceIdentifier(v string) *RdsDbInstance {
	s.DbInstanceIdentifier = &v
	return s
}

// SetDbPassword sets the DbPassword field's value.
func (s *RdsDbInstance) SetDbPassword(v string) *RdsDbInstance {
	s.DbPassword = &v
	return s
}

// SetDbUser sets the DbUser field's value.
func (s *RdsDbInstance) SetDbUser(v string) *RdsDbInstance {
	s.DbUser = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *RdsDbInstance) SetEngine(v string) *RdsDbInstance {
	s.Engine = &v
	return s
}

// SetMissingOnRds sets the MissingOnRds field's value.
func (s *RdsDbInstance) SetMissingOnRds(v bool) *RdsDbInstance {
	s.MissingOnRds = &v
	return s
}

// SetRdsDbInstanceArn sets the RdsDbInstanceArn field's value.
func (s *RdsDbInstance) SetRdsDbInstanceArn(v string) *RdsDbInstance {
	s.RdsDbInstanceArn = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *RdsDbInstance) SetRegion(v string) *RdsDbInstance {
	s.Region = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *RdsDbInstance) SetStackId(v string) *RdsDbInstance {
	s.StackId = &v
	return s
}

type RebootInstanceInput struct {
	_ struct{} `type:"structure"`

	// The instance ID.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RebootInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebootInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RebootInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RebootInstanceInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *RebootInstanceInput) SetInstanceId(v string) *RebootInstanceInput {
	s.InstanceId = &v
	return s
}

type RebootInstanceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RebootInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebootInstanceOutput) GoString() string {
	return s.String()
}

// AWS OpsWorks Stacks supports five lifecycle events: setup, configuration,
// deploy, undeploy, and shutdown. For each layer, AWS OpsWorks Stacks runs
// a set of standard recipes for each event. In addition, you can provide custom
// recipes for any or all layers and events. AWS OpsWorks Stacks runs custom
// event recipes after the standard recipes. LayerCustomRecipes specifies the
// custom recipes for a particular layer to be run in response to each of the
// five events.
//
// To specify a recipe, use the cookbook's directory name in the repository
// followed by two colons and the recipe name, which is the recipe's file name
// without the .rb extension. For example: phpapp2::dbsetup specifies the dbsetup.rb
// recipe in the repository's phpapp2 folder.
type Recipes struct {
	_ struct{} `type:"structure"`

	// An array of custom recipe names to be run following a configure event.
	Configure []*string `type:"list"`

	// An array of custom recipe names to be run following a deploy event.
	Deploy []*string `type:"list"`

	// An array of custom recipe names to be run following a setup event.
	Setup []*string `type:"list"`

	// An array of custom recipe names to be run following a shutdown event.
	Shutdown []*string `type:"list"`

	// An array of custom recipe names to be run following a undeploy event.
	Undeploy []*string `type:"list"`
}

// String returns the string representation
func (s Recipes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Recipes) GoString() string {
	return s.String()
}

// SetConfigure sets the Configure field's value.
func (s *Recipes) SetConfigure(v []*string) *Recipes {
	s.Configure = v
	return s
}

// SetDeploy sets the Deploy field's value.
func (s *Recipes) SetDeploy(v []*string) *Recipes {
	s.Deploy = v
	return s
}

// SetSetup sets the Setup field's value.
func (s *Recipes) SetSetup(v []*string) *Recipes {
	s.Setup = v
	return s
}

// SetShutdown sets the Shutdown field's value.
func (s *Recipes) SetShutdown(v []*string) *Recipes {
	s.Shutdown = v
	return s
}

// SetUndeploy sets the Undeploy field's value.
func (s *Recipes) SetUndeploy(v []*string) *Recipes {
	s.Undeploy = v
	return s
}

type RegisterEcsClusterInput struct {
	_ struct{} `type:"structure"`

	// The cluster's ARN.
	//
	// EcsClusterArn is a required field
	EcsClusterArn *string `type:"string" required:"true"`

	// The stack ID.
	//
	// StackId is a required field
	StackId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RegisterEcsClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterEcsClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterEcsClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterEcsClusterInput"}
	if s.EcsClusterArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EcsClusterArn"))
	}
	if s.StackId == nil {
		invalidParams.Add(request.NewErrParamRequired("StackId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEcsClusterArn sets the EcsClusterArn field's value.
func (s *RegisterEcsClusterInput) SetEcsClusterArn(v string) *RegisterEcsClusterInput {
	s.EcsClusterArn = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *RegisterEcsClusterInput) SetStackId(v string) *RegisterEcsClusterInput {
	s.StackId = &v
	return s
}

// Contains the response to a RegisterEcsCluster request.
type RegisterEcsClusterOutput struct {
	_ struct{} `type:"structure"`

	// The cluster's ARN.
	EcsClusterArn *string `type:"string"`
}

// String returns the string representation
func (s RegisterEcsClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterEcsClusterOutput) GoString() string {
	return s.String()
}

// SetEcsClusterArn sets the EcsClusterArn field's value.
func (s *RegisterEcsClusterOutput) SetEcsClusterArn(v string) *RegisterEcsClusterOutput {
	s.EcsClusterArn = &v
	return s
}

type RegisterElasticIpInput struct {
	_ struct{} `type:"structure"`

	// The Elastic IP address.
	//
	// ElasticIp is a required field
	ElasticIp *string `type:"string" required:"true"`

	// The stack ID.
	//
	// StackId is a required field
	StackId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RegisterElasticIpInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterElasticIpInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterElasticIpInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterElasticIpInput"}
	if s.ElasticIp == nil {
		invalidParams.Add(request.NewErrParamRequired("ElasticIp"))
	}
	if s.StackId == nil {
		invalidParams.Add(request.NewErrParamRequired("StackId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetElasticIp sets the ElasticIp field's value.
func (s *RegisterElasticIpInput) SetElasticIp(v string) *RegisterElasticIpInput {
	s.ElasticIp = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *RegisterElasticIpInput) SetStackId(v string) *RegisterElasticIpInput {
	s.StackId = &v
	return s
}

// Contains the response to a RegisterElasticIp request.
type RegisterElasticIpOutput struct {
	_ struct{} `type:"structure"`

	// The Elastic IP address.
	ElasticIp *string `type:"string"`
}

// String returns the string representation
func (s RegisterElasticIpOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterElasticIpOutput) GoString() string {
	return s.String()
}

// SetElasticIp sets the ElasticIp field's value.
func (s *RegisterElasticIpOutput) SetElasticIp(v string) *RegisterElasticIpOutput {
	s.ElasticIp = &v
	return s
}

type RegisterInstanceInput struct {
	_ struct{} `type:"structure"`

	// The instance's hostname.
	Hostname *string `type:"string"`

	// An InstanceIdentity object that contains the instance's identity.
	InstanceIdentity *InstanceIdentity `type:"structure"`

	// The instance's private IP address.
	PrivateIp *string `type:"string"`

	// The instance's public IP address.
	PublicIp *string `type:"string"`

	// The instances public RSA key. This key is used to encrypt communication between
	// the instance and the service.
	RsaPublicKey *string `type:"string"`

	// The instances public RSA key fingerprint.
	RsaPublicKeyFingerprint *string `type:"string"`

	// The ID of the stack that the instance is to be registered with.
	//
	// StackId is a required field
	StackId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RegisterInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterInstanceInput"}
	if s.StackId == nil {
		invalidParams.Add(request.NewErrParamRequired("StackId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHostname sets the Hostname field's value.
func (s *RegisterInstanceInput) SetHostname(v string) *RegisterInstanceInput {
	s.Hostname = &v
	return s
}

// SetInstanceIdentity sets the InstanceIdentity field's value.
func (s *RegisterInstanceInput) SetInstanceIdentity(v *InstanceIdentity) *RegisterInstanceInput {
	s.InstanceIdentity = v
	return s
}

// SetPrivateIp sets the PrivateIp field's value.
func (s *RegisterInstanceInput) SetPrivateIp(v string) *RegisterInstanceInput {
	s.PrivateIp = &v
	return s
}

// SetPublicIp sets the PublicIp field's value.
func (s *RegisterInstanceInput) SetPublicIp(v string) *RegisterInstanceInput {
	s.PublicIp = &v
	return s
}

// SetRsaPublicKey sets the RsaPublicKey field's value.
func (s *RegisterInstanceInput) SetRsaPublicKey(v string) *RegisterInstanceInput {
	s.RsaPublicKey = &v
	return s
}

// SetRsaPublicKeyFingerprint sets the RsaPublicKeyFingerprint field's value.
func (s *RegisterInstanceInput) SetRsaPublicKeyFingerprint(v string) *RegisterInstanceInput {
	s.RsaPublicKeyFingerprint = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *RegisterInstanceInput) SetStackId(v string) *RegisterInstanceInput {
	s.StackId = &v
	return s
}

// Contains the response to a RegisterInstanceResult request.
type RegisterInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The registered instance's AWS OpsWorks Stacks ID.
	InstanceId *string `type:"string"`
}

// String returns the string representation
func (s RegisterInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterInstanceOutput) GoString() string {
	return s.String()
}

// SetInstanceId sets the InstanceId field's value.
func (s *RegisterInstanceOutput) SetInstanceId(v string) *RegisterInstanceOutput {
	s.InstanceId = &v
	return s
}

type RegisterRdsDbInstanceInput struct {
	_ struct{} `type:"structure"`

	// The database password.
	//
	// DbPassword is a required field
	DbPassword *string `type:"string" required:"true"`

	// The database's master user name.
	//
	// DbUser is a required field
	DbUser *string `type:"string" required:"true"`

	// The Amazon RDS instance's ARN.
	//
	// RdsDbInstanceArn is a required field
	RdsDbInstanceArn *string `type:"string" required:"true"`

	// The stack ID.
	//
	// StackId is a required field
	StackId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RegisterRdsDbInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterRdsDbInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterRdsDbInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterRdsDbInstanceInput"}
	if s.DbPassword == nil {
		invalidParams.Add(request.NewErrParamRequired("DbPassword"))
	}
	if s.DbUser == nil {
		invalidParams.Add(request.NewErrParamRequired("DbUser"))
	}
	if s.RdsDbInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RdsDbInstanceArn"))
	}
	if s.StackId == nil {
		invalidParams.Add(request.NewErrParamRequired("StackId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDbPassword sets the DbPassword field's value.
func (s *RegisterRdsDbInstanceInput) SetDbPassword(v string) *RegisterRdsDbInstanceInput {
	s.DbPassword = &v
	return s
}

// SetDbUser sets the DbUser field's value.
func (s *RegisterRdsDbInstanceInput) SetDbUser(v string) *RegisterRdsDbInstanceInput {
	s.DbUser = &v
	return s
}

// SetRdsDbInstanceArn sets the RdsDbInstanceArn field's value.
func (s *RegisterRdsDbInstanceInput) SetRdsDbInstanceArn(v string) *RegisterRdsDbInstanceInput {
	s.RdsDbInstanceArn = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *RegisterRdsDbInstanceInput) SetStackId(v string) *RegisterRdsDbInstanceInput {
	s.StackId = &v
	return s
}

type RegisterRdsDbInstanceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RegisterRdsDbInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterRdsDbInstanceOutput) GoString() string {
	return s.String()
}

type RegisterVolumeInput struct {
	_ struct{} `type:"structure"`

	// The Amazon EBS volume ID.
	Ec2VolumeId *string `type:"string"`

	// The stack ID.
	//
	// StackId is a required field
	StackId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RegisterVolumeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterVolumeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterVolumeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterVolumeInput"}
	if s.StackId == nil {
		invalidParams.Add(request.NewErrParamRequired("StackId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEc2VolumeId sets the Ec2VolumeId field's value.
func (s *RegisterVolumeInput) SetEc2VolumeId(v string) *RegisterVolumeInput {
	s.Ec2VolumeId = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *RegisterVolumeInput) SetStackId(v string) *RegisterVolumeInput {
	s.StackId = &v
	return s
}

// Contains the response to a RegisterVolume request.
type RegisterVolumeOutput struct {
	_ struct{} `type:"structure"`

	// The volume ID.
	VolumeId *string `type:"string"`
}

// String returns the string representation
func (s RegisterVolumeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterVolumeOutput) GoString() string {
	return s.String()
}

// SetVolumeId sets the VolumeId field's value.
func (s *RegisterVolumeOutput) SetVolumeId(v string) *RegisterVolumeOutput {
	s.VolumeId = &v
	return s
}

// A registered instance's reported operating system.
type ReportedOs struct {
	_ struct{} `type:"structure"`

	// The operating system family.
	Family *string `type:"string"`

	// The operating system name.
	Name *string `type:"string"`

	// The operating system version.
	Version *string `type:"string"`
}

// String returns the string representation
func (s ReportedOs) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReportedOs) GoString() string {
	return s.String()
}

// SetFamily sets the Family field's value.
func (s *ReportedOs) SetFamily(v string) *ReportedOs {
	s.Family = &v
	return s
}

// SetName sets the Name field's value.
func (s *ReportedOs) SetName(v string) *ReportedOs {
	s.Name = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *ReportedOs) SetVersion(v string) *ReportedOs {
	s.Version = &v
	return s
}

// Indicates that a resource was not found.
type ResourceNotFoundException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	// The exception message.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s ResourceNotFoundException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s ResourceNotFoundException) RequestID() string {
	return s.respMetadata.RequestID
}

// Describes a user's SSH information.
type SelfUserProfile struct {
	_ struct{} `type:"structure"`

	// The user's IAM ARN.
	IamUserArn *string `type:"string"`

	// The user's name.
	Name *string `type:"string"`

	// The user's SSH public key.
	SshPublicKey *string `type:"string"`

	// The user's SSH user name.
	SshUsername *string `type:"string"`
}

// String returns the string representation
func (s SelfUserProfile) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SelfUserProfile) GoString() string {
	return s.String()
}

// SetIamUserArn sets the IamUserArn field's value.
func (s *SelfUserProfile) SetIamUserArn(v string) *SelfUserProfile {
	s.IamUserArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *SelfUserProfile) SetName(v string) *SelfUserProfile {
	s.Name = &v
	return s
}

// SetSshPublicKey sets the SshPublicKey field's value.
func (s *SelfUserProfile) SetSshPublicKey(v string) *SelfUserProfile {
	s.SshPublicKey = &v
	return s
}

// SetSshUsername sets the SshUsername field's value.
func (s *SelfUserProfile) SetSshUsername(v string) *SelfUserProfile {
	s.SshUsername = &v
	return s
}

// Describes an AWS OpsWorks Stacks service error.
type ServiceError struct {
	_ struct{} `type:"structure"`

	// When the error occurred.
	CreatedAt *string `type:"string"`

	// The instance ID.
	InstanceId *string `type:"string"`

	// A message that describes the error.
	Message *string `type:"string"`

	// The error ID.
	ServiceErrorId *string `type:"string"`

	// The stack ID.
	StackId *string `type:"string"`

	// The error type.
	Type *string `type:"string"`
}

// String returns the string representation
func (s ServiceError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceError) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ServiceError) SetCreatedAt(v string) *ServiceError {
	s.CreatedAt = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *ServiceError) SetInstanceId(v string) *ServiceError {
	s.InstanceId = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *ServiceError) SetMessage(v string) *ServiceError {
	s.Message = &v
	return s
}

// SetServiceErrorId sets the ServiceErrorId field's value.
func (s *ServiceError) SetServiceErrorId(v string) *ServiceError {
	s.ServiceErrorId = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *ServiceError) SetStackId(v string) *ServiceError {
	s.StackId = &v
	return s
}

// SetType sets the Type field's value.
func (s *ServiceError) SetType(v string) *ServiceError {
	s.Type = &v
	return s
}

type SetLoadBasedAutoScalingInput struct {
	_ struct{} `type:"structure"`

	// An AutoScalingThresholds object with the downscaling threshold configuration.
	// If the load falls below these thresholds for a specified amount of time,
	// AWS OpsWorks Stacks stops a specified number of instances.
	DownScaling *AutoScalingThresholds `type:"structure"`

	// Enables load-based auto scaling for the layer.
	Enable *bool `type:"boolean"`

	// The layer ID.
	//
	// LayerId is a required field
	LayerId *string `type:"string" required:"true"`

	// An AutoScalingThresholds object with the upscaling threshold configuration.
	// If the load exceeds these thresholds for a specified amount of time, AWS
	// OpsWorks Stacks starts a specified number of instances.
	UpScaling *AutoScalingThresholds `type:"structure"`
}

// String returns the string representation
func (s SetLoadBasedAutoScalingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetLoadBasedAutoScalingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetLoadBasedAutoScalingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetLoadBasedAutoScalingInput"}
	if s.LayerId == nil {
		invalidParams.Add(request.NewErrParamRequired("LayerId"))
	}
	if s.DownScaling != nil {
		if err := s.DownScaling.Validate(); err != nil {
			invalidParams.AddNested("DownScaling", err.(request.ErrInvalidParams))
		}
	}
	if s.UpScaling != nil {
		if err := s.UpScaling.Validate(); err != nil {
			invalidParams.AddNested("UpScaling", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDownScaling sets the DownScaling field's value.
func (s *SetLoadBasedAutoScalingInput) SetDownScaling(v *AutoScalingThresholds) *SetLoadBasedAutoScalingInput {
	s.DownScaling = v
	return s
}

// SetEnable sets the Enable field's value.
func (s *SetLoadBasedAutoScalingInput) SetEnable(v bool) *SetLoadBasedAutoScalingInput {
	s.Enable = &v
	return s
}

// SetLayerId sets the LayerId field's value.
func (s *SetLoadBasedAutoScalingInput) SetLayerId(v string) *SetLoadBasedAutoScalingInput {
	s.LayerId = &v
	return s
}

// SetUpScaling sets the UpScaling field's value.
func (s *SetLoadBasedAutoScalingInput) SetUpScaling(v *AutoScalingThresholds) *SetLoadBasedAutoScalingInput {
	s.UpScaling = v
	return s
}

type SetLoadBasedAutoScalingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetLoadBasedAutoScalingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetLoadBasedAutoScalingOutput) GoString() string {
	return s.String()
}

type SetPermissionInput struct {
	_ struct{} `type:"structure"`

	// The user is allowed to use SSH to communicate with the instance.
	AllowSsh *bool `type:"boolean"`

	// The user is allowed to use sudo to elevate privileges.
	AllowSudo *bool `type:"boolean"`

	// The user's IAM ARN. This can also be a federated user's ARN.
	//
	// IamUserArn is a required field
	IamUserArn *string `type:"string" required:"true"`

	// The user's permission level, which must be set to one of the following strings.
	// You cannot set your own permissions level.
	//
	//    * deny
	//
	//    * show
	//
	//    * deploy
	//
	//    * manage
	//
	//    * iam_only
	//
	// For more information about the permissions associated with these levels,
	// see Managing User Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
	Level *string `type:"string"`

	// The stack ID.
	//
	// StackId is a required field
	StackId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SetPermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetPermissionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetPermissionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetPermissionInput"}
	if s.IamUserArn == nil {
		invalidParams.Add(request.NewErrParamRequired("IamUserArn"))
	}
	if s.StackId == nil {
		invalidParams.Add(request.NewErrParamRequired("StackId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowSsh sets the AllowSsh field's value.
func (s *SetPermissionInput) SetAllowSsh(v bool) *SetPermissionInput {
	s.AllowSsh = &v
	return s
}

// SetAllowSudo sets the AllowSudo field's value.
func (s *SetPermissionInput) SetAllowSudo(v bool) *SetPermissionInput {
	s.AllowSudo = &v
	return s
}

// SetIamUserArn sets the IamUserArn field's value.
func (s *SetPermissionInput) SetIamUserArn(v string) *SetPermissionInput {
	s.IamUserArn = &v
	return s
}

// SetLevel sets the Level field's value.
func (s *SetPermissionInput) SetLevel(v string) *SetPermissionInput {
	s.Level = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *SetPermissionInput) SetStackId(v string) *SetPermissionInput {
	s.StackId = &v
	return s
}

type SetPermissionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetPermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetPermissionOutput) GoString() string {
	return s.String()
}

type SetTimeBasedAutoScalingInput struct {
	_ struct{} `type:"structure"`

	// An AutoScalingSchedule with the instance schedule.
	AutoScalingSchedule *WeeklyAutoScalingSchedule `type:"structure"`

	// The instance ID.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SetTimeBasedAutoScalingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetTimeBasedAutoScalingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetTimeBasedAutoScalingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SetTimeBasedAutoScalingInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoScalingSchedule sets the AutoScalingSchedule field's value.
func (s *SetTimeBasedAutoScalingInput) SetAutoScalingSchedule(v *WeeklyAutoScalingSchedule) *SetTimeBasedAutoScalingInput {
	s.AutoScalingSchedule = v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *SetTimeBasedAutoScalingInput) SetInstanceId(v string) *SetTimeBasedAutoScalingInput {
	s.InstanceId = &v
	return s
}

type SetTimeBasedAutoScalingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetTimeBasedAutoScalingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetTimeBasedAutoScalingOutput) GoString() string {
	return s.String()
}

// The Shutdown event configuration.
type ShutdownEventConfiguration struct {
	_ struct{} `type:"structure"`

	// Whether to enable Elastic Load Balancing connection draining. For more information,
	// see Connection Draining (https://docs.aws.amazon.com/ElasticLoadBalancing/latest/DeveloperGuide/TerminologyandKeyConcepts.html#conn-drain)
	DelayUntilElbConnectionsDrained *bool `type:"boolean"`

	// The time, in seconds, that AWS OpsWorks Stacks will wait after triggering
	// a Shutdown event before shutting down an instance.
	ExecutionTimeout *int64 `type:"integer"`
}

// String returns the string representation
func (s ShutdownEventConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ShutdownEventConfiguration) GoString() string {
	return s.String()
}

// SetDelayUntilElbConnectionsDrained sets the DelayUntilElbConnectionsDrained field's value.
func (s *ShutdownEventConfiguration) SetDelayUntilElbConnectionsDrained(v bool) *ShutdownEventConfiguration {
	s.DelayUntilElbConnectionsDrained = &v
	return s
}

// SetExecutionTimeout sets the ExecutionTimeout field's value.
func (s *ShutdownEventConfiguration) SetExecutionTimeout(v int64) *ShutdownEventConfiguration {
	s.ExecutionTimeout = &v
	return s
}

// Contains the information required to retrieve an app or cookbook from a repository.
// For more information, see Creating Apps (https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html)
// or Custom Recipes and Cookbooks (https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html).
type Source struct {
	_ struct{} `type:"structure"`

	// When included in a request, the parameter depends on the repository type.
	//
	//    * For Amazon S3 bundles, set Password to the appropriate IAM secret access
	//    key.
	//
	//    * For HTTP bundles and Subversion repositories, set Password to the password.
	//
	// For more information on how to safely handle IAM credentials, see https://docs.aws.amazon.com/general/latest/gr/aws-access-keys-best-practices.html
	// (https://docs.aws.amazon.com/general/latest/gr/aws-access-keys-best-practices.html).
	//
	// In responses, AWS OpsWorks Stacks returns *****FILTERED***** instead of the
	// actual value.
	Password *string `type:"string"`

	// The application's version. AWS OpsWorks Stacks enables you to easily deploy
	// new versions of an application. One of the simplest approaches is to have
	// branches or revisions in your repository that represent different versions
	// that can potentially be deployed.
	Revision *string `type:"string"`

	// In requests, the repository's SSH key.
	//
	// In responses, AWS OpsWorks Stacks returns *****FILTERED***** instead of the
	// actual value.
	SshKey *string `type:"string"`

	// The repository type.
	Type *string `type:"string" enum:"SourceType"`

	// The source URL. The following is an example of an Amazon S3 source URL: https://s3.amazonaws.com/opsworks-demo-bucket/opsworks_cookbook_demo.tar.gz.
	Url *string `type:"string"`

	// This parameter depends on the repository type.
	//
	//    * For Amazon S3 bundles, set Username to the appropriate IAM access key
	//    ID.
	//
	//    * For HTTP bundles, Git repositories, and Subversion repositories, set
	//    Username to the user name.
	Username *string `type:"string"`
}

// String returns the string representation
func (s Source) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Source) GoString() string {
	return s.String()
}

// SetPassword sets the Password field's value.
func (s *Source) SetPassword(v string) *Source {
	s.Password = &v
	return s
}

// SetRevision sets the Revision field's value.
func (s *Source) SetRevision(v string) *Source {
	s.Revision = &v
	return s
}

// SetSshKey sets the SshKey field's value.
func (s *Source) SetSshKey(v string) *Source {
	s.SshKey = &v
	return s
}

// SetType sets the Type field's value.
func (s *Source) SetType(v string) *Source {
	s.Type = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *Source) SetUrl(v string) *Source {
	s.Url = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *Source) SetUsername(v string) *Source {
	s.Username = &v
	return s
}

// Describes an app's SSL configuration.
type SslConfiguration struct {
	_ struct{} `type:"structure"`

	// The contents of the certificate's domain.crt file.
	//
	// Certificate is a required field
	Certificate *string `type:"string" required:"true"`

	// Optional. Can be used to specify an intermediate certificate authority key
	// or client authentication.
	Chain *string `type:"string"`

	// The private key; the contents of the certificate's domain.kex file.
	//
	// PrivateKey is a required field
	PrivateKey *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SslConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SslConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SslConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SslConfiguration"}
	if s.Certificate == nil {
		invalidParams.Add(request.NewErrParamRequired("Certificate"))
	}
	if s.PrivateKey == nil {
		invalidParams.Add(request.NewErrParamRequired("PrivateKey"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificate sets the Certificate field's value.
func (s *SslConfiguration) SetCertificate(v string) *SslConfiguration {
	s.Certificate = &v
	return s
}

// SetChain sets the Chain field's value.
func (s *SslConfiguration) SetChain(v string) *SslConfiguration {
	s.Chain = &v
	return s
}

// SetPrivateKey sets the PrivateKey field's value.
func (s *SslConfiguration) SetPrivateKey(v string) *SslConfiguration {
	s.PrivateKey = &v
	return s
}

// Describes a stack.
type Stack struct {
	_ struct{} `type:"structure"`

	// The agent version. This parameter is set to LATEST for auto-update. or a
	// version number for a fixed agent version.
	AgentVersion *string `type:"string"`

	// The stack's ARN.
	Arn *string `type:"string"`

	// The stack's attributes.
	Attributes map[string]*string `type:"map"`

	// A ChefConfiguration object that specifies whether to enable Berkshelf and
	// the Berkshelf version. For more information, see Create a New Stack (https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html).
	ChefConfiguration *ChefConfiguration `type:"structure"`

	// The configuration manager.
	ConfigurationManager *StackConfigurationManager `type:"structure"`

	// The date when the stack was created.
	CreatedAt *string `type:"string"`

	// Contains the information required to retrieve an app or cookbook from a repository.
	// For more information, see Adding Apps (https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html)
	// or Cookbooks and Recipes (https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html).
	CustomCookbooksSource *Source `type:"structure"`

	// A JSON object that contains user-defined attributes to be added to the stack
	// configuration and deployment attributes. You can use custom JSON to override
	// the corresponding default stack configuration attribute values or to pass
	// data to recipes. The string should be in the following format:
	//
	// "{\"key1\": \"value1\", \"key2\": \"value2\",...}"
	//
	// For more information on custom JSON, see Use Custom JSON to Modify the Stack
	// Configuration Attributes (https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html).
	CustomJson *string `type:"string"`

	// The stack's default Availability Zone. For more information, see Regions
	// and Endpoints (https://docs.aws.amazon.com/general/latest/gr/rande.html).
	DefaultAvailabilityZone *string `type:"string"`

	// The ARN of an IAM profile that is the default profile for all of the stack's
	// EC2 instances. For more information about IAM ARNs, see Using Identifiers
	// (https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html).
	DefaultInstanceProfileArn *string `type:"string"`

	// The stack's default operating system.
	DefaultOs *string `type:"string"`

	// The default root device type. This value is used by default for all instances
	// in the stack, but you can override it when you create an instance. For more
	// information, see Storage for the Root Device (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device).
	DefaultRootDeviceType *string `type:"string" enum:"RootDeviceType"`

	// A default Amazon EC2 key pair for the stack's instances. You can override
	// this value when you create or update an instance.
	DefaultSshKeyName *string `type:"string"`

	// The default subnet ID; applicable only if the stack is running in a VPC.
	DefaultSubnetId *string `type:"string"`

	// The stack host name theme, with spaces replaced by underscores.
	HostnameTheme *string `type:"string"`

	// The stack name.
	Name *string `type:"string"`

	// The stack AWS region, such as "ap-northeast-2". For more information about
	// AWS regions, see Regions and Endpoints (https://docs.aws.amazon.com/general/latest/gr/rande.html).
	Region *string `type:"string"`

	// The stack AWS Identity and Access Management (IAM) role.
	ServiceRoleArn *string `type:"string"`

	// The stack ID.
	StackId *string `type:"string"`

	// Whether the stack uses custom cookbooks.
	UseCustomCookbooks *bool `type:"boolean"`

	// Whether the stack automatically associates the AWS OpsWorks Stacks built-in
	// security groups with the stack's layers.
	UseOpsworksSecurityGroups *bool `type:"boolean"`

	// The VPC ID; applicable only if the stack is running in a VPC.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s Stack) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Stack) GoString() string {
	return s.String()
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *Stack) SetAgentVersion(v string) *Stack {
	s.AgentVersion = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *Stack) SetArn(v string) *Stack {
	s.Arn = &v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *Stack) SetAttributes(v map[string]*string) *Stack {
	s.Attributes = v
	return s
}

// SetChefConfiguration sets the ChefConfiguration field's value.
func (s *Stack) SetChefConfiguration(v *ChefConfiguration) *Stack {
	s.ChefConfiguration = v
	return s
}

// SetConfigurationManager sets the ConfigurationManager field's value.
func (s *Stack) SetConfigurationManager(v *StackConfigurationManager) *Stack {
	s.ConfigurationManager = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Stack) SetCreatedAt(v string) *Stack {
	s.CreatedAt = &v
	return s
}

// SetCustomCookbooksSource sets the CustomCookbooksSource field's value.
func (s *Stack) SetCustomCookbooksSource(v *Source) *Stack {
	s.CustomCookbooksSource = v
	return s
}

// SetCustomJson sets the CustomJson field's value.
func (s *Stack) SetCustomJson(v string) *Stack {
	s.CustomJson = &v
	return s
}

// SetDefaultAvailabilityZone sets the DefaultAvailabilityZone field's value.
func (s *Stack) SetDefaultAvailabilityZone(v string) *Stack {
	s.DefaultAvailabilityZone = &v
	return s
}

// SetDefaultInstanceProfileArn sets the DefaultInstanceProfileArn field's value.
func (s *Stack) SetDefaultInstanceProfileArn(v string) *Stack {
	s.DefaultInstanceProfileArn = &v
	return s
}

// SetDefaultOs sets the DefaultOs field's value.
func (s *Stack) SetDefaultOs(v string) *Stack {
	s.DefaultOs = &v
	return s
}

// SetDefaultRootDeviceType sets the DefaultRootDeviceType field's value.
func (s *Stack) SetDefaultRootDeviceType(v string) *Stack {
	s.DefaultRootDeviceType = &v
	return s
}

// SetDefaultSshKeyName sets the DefaultSshKeyName field's value.
func (s *Stack) SetDefaultSshKeyName(v string) *Stack {
	s.DefaultSshKeyName = &v
	return s
}

// SetDefaultSubnetId sets the DefaultSubnetId field's value.
func (s *Stack) SetDefaultSubnetId(v string) *Stack {
	s.DefaultSubnetId = &v
	return s
}

// SetHostnameTheme sets the HostnameTheme field's value.
func (s *Stack) SetHostnameTheme(v string) *Stack {
	s.HostnameTheme = &v
	return s
}

// SetName sets the Name field's value.
func (s *Stack) SetName(v string) *Stack {
	s.Name = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *Stack) SetRegion(v string) *Stack {
	s.Region = &v
	return s
}

// SetServiceRoleArn sets the ServiceRoleArn field's value.
func (s *Stack) SetServiceRoleArn(v string) *Stack {
	s.ServiceRoleArn = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *Stack) SetStackId(v string) *Stack {
	s.StackId = &v
	return s
}

// SetUseCustomCookbooks sets the UseCustomCookbooks field's value.
func (s *Stack) SetUseCustomCookbooks(v bool) *Stack {
	s.UseCustomCookbooks = &v
	return s
}

// SetUseOpsworksSecurityGroups sets the UseOpsworksSecurityGroups field's value.
func (s *Stack) SetUseOpsworksSecurityGroups(v bool) *Stack {
	s.UseOpsworksSecurityGroups = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *Stack) SetVpcId(v string) *Stack {
	s.VpcId = &v
	return s
}

// Describes the configuration manager.
type StackConfigurationManager struct {
	_ struct{} `type:"structure"`

	// The name. This parameter must be set to "Chef".
	Name *string `type:"string"`

	// The Chef version. This parameter must be set to 12, 11.10, or 11.4 for Linux
	// stacks, and to 12.2 for Windows stacks. The default value for Linux stacks
	// is 11.4.
	Version *string `type:"string"`
}

// String returns the string representation
func (s StackConfigurationManager) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StackConfigurationManager) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *StackConfigurationManager) SetName(v string) *StackConfigurationManager {
	s.Name = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *StackConfigurationManager) SetVersion(v string) *StackConfigurationManager {
	s.Version = &v
	return s
}

// Summarizes the number of layers, instances, and apps in a stack.
type StackSummary struct {
	_ struct{} `type:"structure"`

	// The number of apps.
	AppsCount *int64 `type:"integer"`

	// The stack's ARN.
	Arn *string `type:"string"`

	// An InstancesCount object with the number of instances in each status.
	InstancesCount *InstancesCount `type:"structure"`

	// The number of layers.
	LayersCount *int64 `type:"integer"`

	// The stack name.
	Name *string `type:"string"`

	// The stack ID.
	StackId *string `type:"string"`
}

// String returns the string representation
func (s StackSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StackSummary) GoString() string {
	return s.String()
}

// SetAppsCount sets the AppsCount field's value.
func (s *StackSummary) SetAppsCount(v int64) *StackSummary {
	s.AppsCount = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *StackSummary) SetArn(v string) *StackSummary {
	s.Arn = &v
	return s
}

// SetInstancesCount sets the InstancesCount field's value.
func (s *StackSummary) SetInstancesCount(v *InstancesCount) *StackSummary {
	s.InstancesCount = v
	return s
}

// SetLayersCount sets the LayersCount field's value.
func (s *StackSummary) SetLayersCount(v int64) *StackSummary {
	s.LayersCount = &v
	return s
}

// SetName sets the Name field's value.
func (s *StackSummary) SetName(v string) *StackSummary {
	s.Name = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *StackSummary) SetStackId(v string) *StackSummary {
	s.StackId = &v
	return s
}

type StartInstanceInput struct {
	_ struct{} `type:"structure"`

	// The instance ID.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StartInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartInstanceInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *StartInstanceInput) SetInstanceId(v string) *StartInstanceInput {
	s.InstanceId = &v
	return s
}

type StartInstanceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StartInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartInstanceOutput) GoString() string {
	return s.String()
}

type StartStackInput struct {
	_ struct{} `type:"structure"`

	// The stack ID.
	//
	// StackId is a required field
	StackId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StartStackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartStackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartStackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartStackInput"}
	if s.StackId == nil {
		invalidParams.Add(request.NewErrParamRequired("StackId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStackId sets the StackId field's value.
func (s *StartStackInput) SetStackId(v string) *StartStackInput {
	s.StackId = &v
	return s
}

type StartStackOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StartStackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartStackOutput) GoString() string {
	return s.String()
}

type StopInstanceInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether to force an instance to stop. If the instance's root device
	// type is ebs, or EBS-backed, adding the Force parameter to the StopInstances
	// API call disassociates the AWS OpsWorks Stacks instance from EC2, and forces
	// deletion of only the OpsWorks Stacks instance. You must also delete the formerly-associated
	// instance in EC2 after troubleshooting and replacing the AWS OpsWorks Stacks
	// instance with a new one.
	Force *bool `type:"boolean"`

	// The instance ID.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StopInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopInstanceInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetForce sets the Force field's value.
func (s *StopInstanceInput) SetForce(v bool) *StopInstanceInput {
	s.Force = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *StopInstanceInput) SetInstanceId(v string) *StopInstanceInput {
	s.InstanceId = &v
	return s
}

type StopInstanceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopInstanceOutput) GoString() string {
	return s.String()
}

type StopStackInput struct {
	_ struct{} `type:"structure"`

	// The stack ID.
	//
	// StackId is a required field
	StackId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StopStackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopStackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopStackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopStackInput"}
	if s.StackId == nil {
		invalidParams.Add(request.NewErrParamRequired("StackId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStackId sets the StackId field's value.
func (s *StopStackInput) SetStackId(v string) *StopStackInput {
	s.StackId = &v
	return s
}

type StopStackOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopStackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopStackOutput) GoString() string {
	return s.String()
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The stack or layer's Amazon Resource Number (ARN).
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`

	// A map that contains tag keys and tag values that are attached to a stack
	// or layer.
	//
	//    * The key cannot be empty.
	//
	//    * The key can be a maximum of 127 characters, and can contain only Unicode
	//    letters, numbers, or separators, or the following special characters:
	//    + - = . _ : /
	//
	//    * The value can be a maximum 255 characters, and contain only Unicode
	//    letters, numbers, or separators, or the following special characters:
	//    + - = . _ : /
	//
	//    * Leading and trailing white spaces are trimmed from both the key and
	//    value.
	//
	//    * A maximum of 40 tags is allowed for any resource.
	//
	// Tags is a required field
	Tags map[string]*string `type:"map" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Contains the data needed by RDP clients such as the Microsoft Remote Desktop
// Connection to log in to the instance.
type TemporaryCredential struct {
	_ struct{} `type:"structure"`

	// The instance's AWS OpsWorks Stacks ID.
	InstanceId *string `type:"string"`

	// The password.
	Password *string `type:"string"`

	// The user name.
	Username *string `type:"string"`

	// The length of time (in minutes) that the grant is valid. When the grant expires,
	// at the end of this period, the user will no longer be able to use the credentials
	// to log in. If they are logged in at the time, they will be automatically
	// logged out.
	ValidForInMinutes *int64 `type:"integer"`
}

// String returns the string representation
func (s TemporaryCredential) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TemporaryCredential) GoString() string {
	return s.String()
}

// SetInstanceId sets the InstanceId field's value.
func (s *TemporaryCredential) SetInstanceId(v string) *TemporaryCredential {
	s.InstanceId = &v
	return s
}

// SetPassword sets the Password field's value.
func (s *TemporaryCredential) SetPassword(v string) *TemporaryCredential {
	s.Password = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *TemporaryCredential) SetUsername(v string) *TemporaryCredential {
	s.Username = &v
	return s
}

// SetValidForInMinutes sets the ValidForInMinutes field's value.
func (s *TemporaryCredential) SetValidForInMinutes(v int64) *TemporaryCredential {
	s.ValidForInMinutes = &v
	return s
}

// Describes an instance's time-based auto scaling configuration.
type TimeBasedAutoScalingConfiguration struct {
	_ struct{} `type:"structure"`

	// A WeeklyAutoScalingSchedule object with the instance schedule.
	AutoScalingSchedule *WeeklyAutoScalingSchedule `type:"structure"`

	// The instance ID.
	InstanceId *string `type:"string"`
}

// String returns the string representation
func (s TimeBasedAutoScalingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TimeBasedAutoScalingConfiguration) GoString() string {
	return s.String()
}

// SetAutoScalingSchedule sets the AutoScalingSchedule field's value.
func (s *TimeBasedAutoScalingConfiguration) SetAutoScalingSchedule(v *WeeklyAutoScalingSchedule) *TimeBasedAutoScalingConfiguration {
	s.AutoScalingSchedule = v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *TimeBasedAutoScalingConfiguration) SetInstanceId(v string) *TimeBasedAutoScalingConfiguration {
	s.InstanceId = &v
	return s
}

type UnassignInstanceInput struct {
	_ struct{} `type:"structure"`

	// The instance ID.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UnassignInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnassignInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UnassignInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UnassignInstanceInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *UnassignInstanceInput) SetInstanceId(v string) *UnassignInstanceInput {
	s.InstanceId = &v
	return s
}

type UnassignInstanceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UnassignInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnassignInstanceOutput) GoString() string {
	return s.String()
}

type UnassignVolumeInput struct {
	_ struct{} `type:"structure"`

	// The volume ID.
	//
	// VolumeId is a required field
	VolumeId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UnassignVolumeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnassignVolumeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UnassignVolumeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UnassignVolumeInput"}
	if s.VolumeId == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVolumeId sets the VolumeId field's value.
func (s *UnassignVolumeInput) SetVolumeId(v string) *UnassignVolumeInput {
	s.VolumeId = &v
	return s
}

type UnassignVolumeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UnassignVolumeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnassignVolumeOutput) GoString() string {
	return s.String()
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The stack or layer's Amazon Resource Number (ARN).
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`

	// A list of the keys of tags to be removed from a stack or layer.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateAppInput struct {
	_ struct{} `type:"structure"`

	// The app ID.
	//
	// AppId is a required field
	AppId *string `type:"string" required:"true"`

	// A Source object that specifies the app repository.
	AppSource *Source `type:"structure"`

	// One or more user-defined key/value pairs to be added to the stack attributes.
	Attributes map[string]*string `type:"map"`

	// The app's data sources.
	DataSources []*DataSource `type:"list"`

	// A description of the app.
	Description *string `type:"string"`

	// The app's virtual host settings, with multiple domains separated by commas.
	// For example: 'www.example.com, example.com'
	Domains []*string `type:"list"`

	// Whether SSL is enabled for the app.
	EnableSsl *bool `type:"boolean"`

	// An array of EnvironmentVariable objects that specify environment variables
	// to be associated with the app. After you deploy the app, these variables
	// are defined on the associated app server instances.For more information,
	// see Environment Variables (https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment).
	//
	// There is no specific limit on the number of environment variables. However,
	// the size of the associated data structure - which includes the variables'
	// names, values, and protected flag values - cannot exceed 20 KB. This limit
	// should accommodate most if not all use cases. Exceeding it will cause an
	// exception with the message, "Environment: is too large (maximum is 20 KB)."
	//
	// If you have specified one or more environment variables, you cannot modify
	// the stack's Chef version.
	Environment []*EnvironmentVariable `type:"list"`

	// The app name.
	Name *string `type:"string"`

	// An SslConfiguration object with the SSL configuration.
	SslConfiguration *SslConfiguration `type:"structure"`

	// The app type.
	Type *string `type:"string" enum:"AppType"`
}

// String returns the string representation
func (s UpdateAppInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAppInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAppInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAppInput"}
	if s.AppId == nil {
		invalidParams.Add(request.NewErrParamRequired("AppId"))
	}
	if s.Environment != nil {
		for i, v := range s.Environment {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Environment", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SslConfiguration != nil {
		if err := s.SslConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SslConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAppId sets the AppId field's value.
func (s *UpdateAppInput) SetAppId(v string) *UpdateAppInput {
	s.AppId = &v
	return s
}

// SetAppSource sets the AppSource field's value.
func (s *UpdateAppInput) SetAppSource(v *Source) *UpdateAppInput {
	s.AppSource = v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *UpdateAppInput) SetAttributes(v map[string]*string) *UpdateAppInput {
	s.Attributes = v
	return s
}

// SetDataSources sets the DataSources field's value.
func (s *UpdateAppInput) SetDataSources(v []*DataSource) *UpdateAppInput {
	s.DataSources = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateAppInput) SetDescription(v string) *UpdateAppInput {
	s.Description = &v
	return s
}

// SetDomains sets the Domains field's value.
func (s *UpdateAppInput) SetDomains(v []*string) *UpdateAppInput {
	s.Domains = v
	return s
}

// SetEnableSsl sets the EnableSsl field's value.
func (s *UpdateAppInput) SetEnableSsl(v bool) *UpdateAppInput {
	s.EnableSsl = &v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *UpdateAppInput) SetEnvironment(v []*EnvironmentVariable) *UpdateAppInput {
	s.Environment = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateAppInput) SetName(v string) *UpdateAppInput {
	s.Name = &v
	return s
}

// SetSslConfiguration sets the SslConfiguration field's value.
func (s *UpdateAppInput) SetSslConfiguration(v *SslConfiguration) *UpdateAppInput {
	s.SslConfiguration = v
	return s
}

// SetType sets the Type field's value.
func (s *UpdateAppInput) SetType(v string) *UpdateAppInput {
	s.Type = &v
	return s
}

type UpdateAppOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateAppOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateAppOutput) GoString() string {
	return s.String()
}

type UpdateElasticIpInput struct {
	_ struct{} `type:"structure"`

	// The IP address for which you want to update the name.
	//
	// ElasticIp is a required field
	ElasticIp *string `type:"string" required:"true"`

	// The new name.
	Name *string `type:"string"`
}

// String returns the string representation
func (s UpdateElasticIpInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateElasticIpInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateElasticIpInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateElasticIpInput"}
	if s.ElasticIp == nil {
		invalidParams.Add(request.NewErrParamRequired("ElasticIp"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetElasticIp sets the ElasticIp field's value.
func (s *UpdateElasticIpInput) SetElasticIp(v string) *UpdateElasticIpInput {
	s.ElasticIp = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateElasticIpInput) SetName(v string) *UpdateElasticIpInput {
	s.Name = &v
	return s
}

type UpdateElasticIpOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateElasticIpOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateElasticIpOutput) GoString() string {
	return s.String()
}

type UpdateInstanceInput struct {
	_ struct{} `type:"structure"`

	// The default AWS OpsWorks Stacks agent version. You have the following options:
	//
	//    * INHERIT - Use the stack's default agent version setting.
	//
	//    * version_number - Use the specified agent version. This value overrides
	//    the stack's default setting. To update the agent version, you must edit
	//    the instance configuration and specify a new version. AWS OpsWorks Stacks
	//    then automatically installs that version on the instance.
	//
	// The default setting is INHERIT. To specify an agent version, you must use
	// the complete version number, not the abbreviated number shown on the console.
	// For a list of available agent version numbers, call DescribeAgentVersions.
	//
	// AgentVersion cannot be set to Chef 12.2.
	AgentVersion *string `type:"string"`

	// The ID of the AMI that was used to create the instance. The value of this
	// parameter must be the same AMI ID that the instance is already using. You
	// cannot apply a new AMI to an instance by running UpdateInstance. UpdateInstance
	// does not work on instances that are using custom AMIs.
	AmiId *string `type:"string"`

	// The instance architecture. Instance types do not necessarily support both
	// architectures. For a list of the architectures that are supported by the
	// different instance types, see Instance Families and Types (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html).
	Architecture *string `type:"string" enum:"Architecture"`

	// For load-based or time-based instances, the type. Windows stacks can use
	// only time-based instances.
	AutoScalingType *string `type:"string" enum:"AutoScalingType"`

	// This property cannot be updated.
	EbsOptimized *bool `type:"boolean"`

	// The instance host name.
	Hostname *string `type:"string"`

	// Whether to install operating system and package updates when the instance
	// boots. The default value is true. To control when updates are installed,
	// set this value to false. You must then update your instances manually by
	// using CreateDeployment to run the update_dependencies stack command or by
	// manually running yum (Amazon Linux) or apt-get (Ubuntu) on the instances.
	//
	// We strongly recommend using the default value of true, to ensure that your
	// instances have the latest security updates.
	InstallUpdatesOnBoot *bool `type:"boolean"`

	// The instance ID.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`

	// The instance type, such as t2.micro. For a list of supported instance types,
	// open the stack in the console, choose Instances, and choose + Instance. The
	// Size list contains the currently supported types. For more information, see
	// Instance Families and Types (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html).
	// The parameter values that you use to specify the various types are in the
	// API Name column of the Available Instance Types table.
	InstanceType *string `type:"string"`

	// The instance's layer IDs.
	LayerIds []*string `type:"list"`

	// The instance's operating system, which must be set to one of the following.
	// You cannot update an instance that is using a custom AMI.
	//
	//    * A supported Linux operating system: An Amazon Linux version, such as
	//    Amazon Linux 2018.03, Amazon Linux 2017.09, Amazon Linux 2017.03, Amazon
	//    Linux 2016.09, Amazon Linux 2016.03, Amazon Linux 2015.09, or Amazon Linux
	//    2015.03.
	//
	//    * A supported Ubuntu operating system, such as Ubuntu 16.04 LTS, Ubuntu
	//    14.04 LTS, or Ubuntu 12.04 LTS.
	//
	//    * CentOS Linux 7
	//
	//    * Red Hat Enterprise Linux 7
	//
	//    * A supported Windows operating system, such as Microsoft Windows Server
	//    2012 R2 Base, Microsoft Windows Server 2012 R2 with SQL Server Express,
	//    Microsoft Windows Server 2012 R2 with SQL Server Standard, or Microsoft
	//    Windows Server 2012 R2 with SQL Server Web.
	//
	// For more information about supported operating systems, see AWS OpsWorks
	// Stacks Operating Systems (https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html).
	//
	// The default option is the current Amazon Linux version. If you set this parameter
	// to Custom, you must use the AmiId parameter to specify the custom AMI that
	// you want to use. For more information about supported operating systems,
	// see Operating Systems (https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html).
	// For more information about how to use custom AMIs with OpsWorks, see Using
	// Custom AMIs (https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html).
	//
	// You can specify a different Linux operating system for the updated stack,
	// but you cannot change from Linux to Windows or Windows to Linux.
	Os *string `type:"string"`

	// The instance's Amazon EC2 key name.
	SshKeyName *string `type:"string"`
}

// String returns the string representation
func (s UpdateInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateInstanceInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *UpdateInstanceInput) SetAgentVersion(v string) *UpdateInstanceInput {
	s.AgentVersion = &v
	return s
}

// SetAmiId sets the AmiId field's value.
func (s *UpdateInstanceInput) SetAmiId(v string) *UpdateInstanceInput {
	s.AmiId = &v
	return s
}

// SetArchitecture sets the Architecture field's value.
func (s *UpdateInstanceInput) SetArchitecture(v string) *UpdateInstanceInput {
	s.Architecture = &v
	return s
}

// SetAutoScalingType sets the AutoScalingType field's value.
func (s *UpdateInstanceInput) SetAutoScalingType(v string) *UpdateInstanceInput {
	s.AutoScalingType = &v
	return s
}

// SetEbsOptimized sets the EbsOptimized field's value.
func (s *UpdateInstanceInput) SetEbsOptimized(v bool) *UpdateInstanceInput {
	s.EbsOptimized = &v
	return s
}

// SetHostname sets the Hostname field's value.
func (s *UpdateInstanceInput) SetHostname(v string) *UpdateInstanceInput {
	s.Hostname = &v
	return s
}

// SetInstallUpdatesOnBoot sets the InstallUpdatesOnBoot field's value.
func (s *UpdateInstanceInput) SetInstallUpdatesOnBoot(v bool) *UpdateInstanceInput {
	s.InstallUpdatesOnBoot = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *UpdateInstanceInput) SetInstanceId(v string) *UpdateInstanceInput {
	s.InstanceId = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *UpdateInstanceInput) SetInstanceType(v string) *UpdateInstanceInput {
	s.InstanceType = &v
	return s
}

// SetLayerIds sets the LayerIds field's value.
func (s *UpdateInstanceInput) SetLayerIds(v []*string) *UpdateInstanceInput {
	s.LayerIds = v
	return s
}

// SetOs sets the Os field's value.
func (s *UpdateInstanceInput) SetOs(v string) *UpdateInstanceInput {
	s.Os = &v
	return s
}

// SetSshKeyName sets the SshKeyName field's value.
func (s *UpdateInstanceInput) SetSshKeyName(v string) *UpdateInstanceInput {
	s.SshKeyName = &v
	return s
}

type UpdateInstanceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateInstanceOutput) GoString() string {
	return s.String()
}

type UpdateLayerInput struct {
	_ struct{} `type:"structure"`

	// One or more user-defined key/value pairs to be added to the stack attributes.
	Attributes map[string]*string `type:"map"`

	// Whether to automatically assign an Elastic IP address (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html)
	// to the layer's instances. For more information, see How to Edit a Layer (https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html).
	AutoAssignElasticIps *bool `type:"boolean"`

	// For stacks that are running in a VPC, whether to automatically assign a public
	// IP address to the layer's instances. For more information, see How to Edit
	// a Layer (https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html).
	AutoAssignPublicIps *bool `type:"boolean"`

	// Specifies CloudWatch Logs configuration options for the layer. For more information,
	// see CloudWatchLogsLogStream.
	CloudWatchLogsConfiguration *CloudWatchLogsConfiguration `type:"structure"`

	// The ARN of an IAM profile to be used for all of the layer's EC2 instances.
	// For more information about IAM ARNs, see Using Identifiers (https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html).
	CustomInstanceProfileArn *string `type:"string"`

	// A JSON-formatted string containing custom stack configuration and deployment
	// attributes to be installed on the layer's instances. For more information,
	// see Using Custom JSON (https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook-json-override.html).
	CustomJson *string `type:"string"`

	// A LayerCustomRecipes object that specifies the layer's custom recipes.
	CustomRecipes *Recipes `type:"structure"`

	// An array containing the layer's custom security group IDs.
	CustomSecurityGroupIds []*string `type:"list"`

	// Whether to disable auto healing for the layer.
	EnableAutoHealing *bool `type:"boolean"`

	// Whether to install operating system and package updates when the instance
	// boots. The default value is true. To control when updates are installed,
	// set this value to false. You must then update your instances manually by
	// using CreateDeployment to run the update_dependencies stack command or manually
	// running yum (Amazon Linux) or apt-get (Ubuntu) on the instances.
	//
	// We strongly recommend using the default value of true, to ensure that your
	// instances have the latest security updates.
	InstallUpdatesOnBoot *bool `type:"boolean"`

	// The layer ID.
	//
	// LayerId is a required field
	LayerId *string `type:"string" required:"true"`

	// Specifies the lifecycle event configuration
	LifecycleEventConfiguration *LifecycleEventConfiguration `type:"structure"`

	// The layer name, which is used by the console.
	Name *string `type:"string"`

	// An array of Package objects that describe the layer's packages.
	Packages []*string `type:"list"`

	// For custom layers only, use this parameter to specify the layer's short name,
	// which is used internally by AWS OpsWorks Stacks and by Chef. The short name
	// is also used as the name for the directory where your app files are installed.
	// It can have a maximum of 200 characters and must be in the following format:
	// /\A[a-z0-9\-\_\.]+\Z/.
	//
	// The built-in layers' short names are defined by AWS OpsWorks Stacks. For
	// more information, see the Layer Reference (https://docs.aws.amazon.com/opsworks/latest/userguide/layers.html)
	Shortname *string `type:"string"`

	// Whether to use Amazon EBS-optimized instances.
	UseEbsOptimizedInstances *bool `type:"boolean"`

	// A VolumeConfigurations object that describes the layer's Amazon EBS volumes.
	VolumeConfigurations []*VolumeConfiguration `type:"list"`
}

// String returns the string representation
func (s UpdateLayerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateLayerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateLayerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateLayerInput"}
	if s.LayerId == nil {
		invalidParams.Add(request.NewErrParamRequired("LayerId"))
	}
	if s.VolumeConfigurations != nil {
		for i, v := range s.VolumeConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "VolumeConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *UpdateLayerInput) SetAttributes(v map[string]*string) *UpdateLayerInput {
	s.Attributes = v
	return s
}

// SetAutoAssignElasticIps sets the AutoAssignElasticIps field's value.
func (s *UpdateLayerInput) SetAutoAssignElasticIps(v bool) *UpdateLayerInput {
	s.AutoAssignElasticIps = &v
	return s
}

// SetAutoAssignPublicIps sets the AutoAssignPublicIps field's value.
func (s *UpdateLayerInput) SetAutoAssignPublicIps(v bool) *UpdateLayerInput {
	s.AutoAssignPublicIps = &v
	return s
}

// SetCloudWatchLogsConfiguration sets the CloudWatchLogsConfiguration field's value.
func (s *UpdateLayerInput) SetCloudWatchLogsConfiguration(v *CloudWatchLogsConfiguration) *UpdateLayerInput {
	s.CloudWatchLogsConfiguration = v
	return s
}

// SetCustomInstanceProfileArn sets the CustomInstanceProfileArn field's value.
func (s *UpdateLayerInput) SetCustomInstanceProfileArn(v string) *UpdateLayerInput {
	s.CustomInstanceProfileArn = &v
	return s
}

// SetCustomJson sets the CustomJson field's value.
func (s *UpdateLayerInput) SetCustomJson(v string) *UpdateLayerInput {
	s.CustomJson = &v
	return s
}

// SetCustomRecipes sets the CustomRecipes field's value.
func (s *UpdateLayerInput) SetCustomRecipes(v *Recipes) *UpdateLayerInput {
	s.CustomRecipes = v
	return s
}

// SetCustomSecurityGroupIds sets the CustomSecurityGroupIds field's value.
func (s *UpdateLayerInput) SetCustomSecurityGroupIds(v []*string) *UpdateLayerInput {
	s.CustomSecurityGroupIds = v
	return s
}

// SetEnableAutoHealing sets the EnableAutoHealing field's value.
func (s *UpdateLayerInput) SetEnableAutoHealing(v bool) *UpdateLayerInput {
	s.EnableAutoHealing = &v
	return s
}

// SetInstallUpdatesOnBoot sets the InstallUpdatesOnBoot field's value.
func (s *UpdateLayerInput) SetInstallUpdatesOnBoot(v bool) *UpdateLayerInput {
	s.InstallUpdatesOnBoot = &v
	return s
}

// SetLayerId sets the LayerId field's value.
func (s *UpdateLayerInput) SetLayerId(v string) *UpdateLayerInput {
	s.LayerId = &v
	return s
}

// SetLifecycleEventConfiguration sets the LifecycleEventConfiguration field's value.
func (s *UpdateLayerInput) SetLifecycleEventConfiguration(v *LifecycleEventConfiguration) *UpdateLayerInput {
	s.LifecycleEventConfiguration = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateLayerInput) SetName(v string) *UpdateLayerInput {
	s.Name = &v
	return s
}

// SetPackages sets the Packages field's value.
func (s *UpdateLayerInput) SetPackages(v []*string) *UpdateLayerInput {
	s.Packages = v
	return s
}

// SetShortname sets the Shortname field's value.
func (s *UpdateLayerInput) SetShortname(v string) *UpdateLayerInput {
	s.Shortname = &v
	return s
}

// SetUseEbsOptimizedInstances sets the UseEbsOptimizedInstances field's value.
func (s *UpdateLayerInput) SetUseEbsOptimizedInstances(v bool) *UpdateLayerInput {
	s.UseEbsOptimizedInstances = &v
	return s
}

// SetVolumeConfigurations sets the VolumeConfigurations field's value.
func (s *UpdateLayerInput) SetVolumeConfigurations(v []*VolumeConfiguration) *UpdateLayerInput {
	s.VolumeConfigurations = v
	return s
}

type UpdateLayerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateLayerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateLayerOutput) GoString() string {
	return s.String()
}

type UpdateMyUserProfileInput struct {
	_ struct{} `type:"structure"`

	// The user's SSH public key.
	SshPublicKey *string `type:"string"`
}

// String returns the string representation
func (s UpdateMyUserProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateMyUserProfileInput) GoString() string {
	return s.String()
}

// SetSshPublicKey sets the SshPublicKey field's value.
func (s *UpdateMyUserProfileInput) SetSshPublicKey(v string) *UpdateMyUserProfileInput {
	s.SshPublicKey = &v
	return s
}

type UpdateMyUserProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateMyUserProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateMyUserProfileOutput) GoString() string {
	return s.String()
}

type UpdateRdsDbInstanceInput struct {
	_ struct{} `type:"structure"`

	// The database password.
	DbPassword *string `type:"string"`

	// The master user name.
	DbUser *string `type:"string"`

	// The Amazon RDS instance's ARN.
	//
	// RdsDbInstanceArn is a required field
	RdsDbInstanceArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateRdsDbInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRdsDbInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRdsDbInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRdsDbInstanceInput"}
	if s.RdsDbInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RdsDbInstanceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDbPassword sets the DbPassword field's value.
func (s *UpdateRdsDbInstanceInput) SetDbPassword(v string) *UpdateRdsDbInstanceInput {
	s.DbPassword = &v
	return s
}

// SetDbUser sets the DbUser field's value.
func (s *UpdateRdsDbInstanceInput) SetDbUser(v string) *UpdateRdsDbInstanceInput {
	s.DbUser = &v
	return s
}

// SetRdsDbInstanceArn sets the RdsDbInstanceArn field's value.
func (s *UpdateRdsDbInstanceInput) SetRdsDbInstanceArn(v string) *UpdateRdsDbInstanceInput {
	s.RdsDbInstanceArn = &v
	return s
}

type UpdateRdsDbInstanceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateRdsDbInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRdsDbInstanceOutput) GoString() string {
	return s.String()
}

type UpdateStackInput struct {
	_ struct{} `type:"structure"`

	// The default AWS OpsWorks Stacks agent version. You have the following options:
	//
	//    * Auto-update - Set this parameter to LATEST. AWS OpsWorks Stacks automatically
	//    installs new agent versions on the stack's instances as soon as they are
	//    available.
	//
	//    * Fixed version - Set this parameter to your preferred agent version.
	//    To update the agent version, you must edit the stack configuration and
	//    specify a new version. AWS OpsWorks Stacks then automatically installs
	//    that version on the stack's instances.
	//
	// The default setting is LATEST. To specify an agent version, you must use
	// the complete version number, not the abbreviated number shown on the console.
	// For a list of available agent version numbers, call DescribeAgentVersions.
	// AgentVersion cannot be set to Chef 12.2.
	//
	// You can also specify an agent version when you create or update an instance,
	// which overrides the stack's default setting.
	AgentVersion *string `type:"string"`

	// One or more user-defined key-value pairs to be added to the stack attributes.
	Attributes map[string]*string `type:"map"`

	// A ChefConfiguration object that specifies whether to enable Berkshelf and
	// the Berkshelf version on Chef 11.10 stacks. For more information, see Create
	// a New Stack (https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html).
	ChefConfiguration *ChefConfiguration `type:"structure"`

	// The configuration manager. When you update a stack, we recommend that you
	// use the configuration manager to specify the Chef version: 12, 11.10, or
	// 11.4 for Linux stacks, or 12.2 for Windows stacks. The default value for
	// Linux stacks is currently 12.
	ConfigurationManager *StackConfigurationManager `type:"structure"`

	// Contains the information required to retrieve an app or cookbook from a repository.
	// For more information, see Adding Apps (https://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html)
	// or Cookbooks and Recipes (https://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook.html).
	CustomCookbooksSource *Source `type:"structure"`

	// A string that contains user-defined, custom JSON. It can be used to override
	// the corresponding default stack configuration JSON values or to pass data
	// to recipes. The string should be in the following format:
	//
	// "{\"key1\": \"value1\", \"key2\": \"value2\",...}"
	//
	// For more information about custom JSON, see Use Custom JSON to Modify the
	// Stack Configuration Attributes (https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html).
	CustomJson *string `type:"string"`

	// The stack's default Availability Zone, which must be in the stack's region.
	// For more information, see Regions and Endpoints (https://docs.aws.amazon.com/general/latest/gr/rande.html).
	// If you also specify a value for DefaultSubnetId, the subnet must be in the
	// same zone. For more information, see CreateStack.
	DefaultAvailabilityZone *string `type:"string"`

	// The ARN of an IAM profile that is the default profile for all of the stack's
	// EC2 instances. For more information about IAM ARNs, see Using Identifiers
	// (https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html).
	DefaultInstanceProfileArn *string `type:"string"`

	// The stack's operating system, which must be set to one of the following:
	//
	//    * A supported Linux operating system: An Amazon Linux version, such as
	//    Amazon Linux 2018.03, Amazon Linux 2017.09, Amazon Linux 2017.03, Amazon
	//    Linux 2016.09, Amazon Linux 2016.03, Amazon Linux 2015.09, or Amazon Linux
	//    2015.03.
	//
	//    * A supported Ubuntu operating system, such as Ubuntu 16.04 LTS, Ubuntu
	//    14.04 LTS, or Ubuntu 12.04 LTS.
	//
	//    * CentOS Linux 7
	//
	//    * Red Hat Enterprise Linux 7
	//
	//    * A supported Windows operating system, such as Microsoft Windows Server
	//    2012 R2 Base, Microsoft Windows Server 2012 R2 with SQL Server Express,
	//    Microsoft Windows Server 2012 R2 with SQL Server Standard, or Microsoft
	//    Windows Server 2012 R2 with SQL Server Web.
	//
	//    * A custom AMI: Custom. You specify the custom AMI you want to use when
	//    you create instances. For more information about how to use custom AMIs
	//    with OpsWorks, see Using Custom AMIs (https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html).
	//
	// The default option is the stack's current operating system. For more information
	// about supported operating systems, see AWS OpsWorks Stacks Operating Systems
	// (https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html).
	DefaultOs *string `type:"string"`

	// The default root device type. This value is used by default for all instances
	// in the stack, but you can override it when you create an instance. For more
	// information, see Storage for the Root Device (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device).
	DefaultRootDeviceType *string `type:"string" enum:"RootDeviceType"`

	// A default Amazon EC2 key-pair name. The default value is none. If you specify
	// a key-pair name, AWS OpsWorks Stacks installs the public key on the instance
	// and you can use the private key with an SSH client to log in to the instance.
	// For more information, see Using SSH to Communicate with an Instance (https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-ssh.html)
	// and Managing SSH Access (https://docs.aws.amazon.com/opsworks/latest/userguide/security-ssh-access.html).
	// You can override this setting by specifying a different key pair, or no key
	// pair, when you create an instance (https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-add.html).
	DefaultSshKeyName *string `type:"string"`

	// The stack's default VPC subnet ID. This parameter is required if you specify
	// a value for the VpcId parameter. All instances are launched into this subnet
	// unless you specify otherwise when you create the instance. If you also specify
	// a value for DefaultAvailabilityZone, the subnet must be in that zone. For
	// information on default values and when this parameter is required, see the
	// VpcId parameter description.
	DefaultSubnetId *string `type:"string"`

	// The stack's new host name theme, with spaces replaced by underscores. The
	// theme is used to generate host names for the stack's instances. By default,
	// HostnameTheme is set to Layer_Dependent, which creates host names by appending
	// integers to the layer's short name. The other themes are:
	//
	//    * Baked_Goods
	//
	//    * Clouds
	//
	//    * Europe_Cities
	//
	//    * Fruits
	//
	//    * Greek_Deities_and_Titans
	//
	//    * Legendary_creatures_from_Japan
	//
	//    * Planets_and_Moons
	//
	//    * Roman_Deities
	//
	//    * Scottish_Islands
	//
	//    * US_Cities
	//
	//    * Wild_Cats
	//
	// To obtain a generated host name, call GetHostNameSuggestion, which returns
	// a host name based on the current theme.
	HostnameTheme *string `type:"string"`

	// The stack's new name.
	Name *string `type:"string"`

	// Do not use this parameter. You cannot update a stack's service role.
	ServiceRoleArn *string `type:"string"`

	// The stack ID.
	//
	// StackId is a required field
	StackId *string `type:"string" required:"true"`

	// Whether the stack uses custom cookbooks.
	UseCustomCookbooks *bool `type:"boolean"`

	// Whether to associate the AWS OpsWorks Stacks built-in security groups with
	// the stack's layers.
	//
	// AWS OpsWorks Stacks provides a standard set of built-in security groups,
	// one for each layer, which are associated with layers by default. UseOpsworksSecurityGroups
	// allows you to provide your own custom security groups instead of using the
	// built-in groups. UseOpsworksSecurityGroups has the following settings:
	//
	//    * True - AWS OpsWorks Stacks automatically associates the appropriate
	//    built-in security group with each layer (default setting). You can associate
	//    additional security groups with a layer after you create it, but you cannot
	//    delete the built-in security group.
	//
	//    * False - AWS OpsWorks Stacks does not associate built-in security groups
	//    with layers. You must create appropriate EC2 security groups and associate
	//    a security group with each layer that you create. However, you can still
	//    manually associate a built-in security group with a layer on. Custom security
	//    groups are required only for those layers that need custom settings.
	//
	// For more information, see Create a New Stack (https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html).
	UseOpsworksSecurityGroups *bool `type:"boolean"`
}

// String returns the string representation
func (s UpdateStackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateStackInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateStackInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateStackInput"}
	if s.StackId == nil {
		invalidParams.Add(request.NewErrParamRequired("StackId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAgentVersion sets the AgentVersion field's value.
func (s *UpdateStackInput) SetAgentVersion(v string) *UpdateStackInput {
	s.AgentVersion = &v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *UpdateStackInput) SetAttributes(v map[string]*string) *UpdateStackInput {
	s.Attributes = v
	return s
}

// SetChefConfiguration sets the ChefConfiguration field's value.
func (s *UpdateStackInput) SetChefConfiguration(v *ChefConfiguration) *UpdateStackInput {
	s.ChefConfiguration = v
	return s
}

// SetConfigurationManager sets the ConfigurationManager field's value.
func (s *UpdateStackInput) SetConfigurationManager(v *StackConfigurationManager) *UpdateStackInput {
	s.ConfigurationManager = v
	return s
}

// SetCustomCookbooksSource sets the CustomCookbooksSource field's value.
func (s *UpdateStackInput) SetCustomCookbooksSource(v *Source) *UpdateStackInput {
	s.CustomCookbooksSource = v
	return s
}

// SetCustomJson sets the CustomJson field's value.
func (s *UpdateStackInput) SetCustomJson(v string) *UpdateStackInput {
	s.CustomJson = &v
	return s
}

// SetDefaultAvailabilityZone sets the DefaultAvailabilityZone field's value.
func (s *UpdateStackInput) SetDefaultAvailabilityZone(v string) *UpdateStackInput {
	s.DefaultAvailabilityZone = &v
	return s
}

// SetDefaultInstanceProfileArn sets the DefaultInstanceProfileArn field's value.
func (s *UpdateStackInput) SetDefaultInstanceProfileArn(v string) *UpdateStackInput {
	s.DefaultInstanceProfileArn = &v
	return s
}

// SetDefaultOs sets the DefaultOs field's value.
func (s *UpdateStackInput) SetDefaultOs(v string) *UpdateStackInput {
	s.DefaultOs = &v
	return s
}

// SetDefaultRootDeviceType sets the DefaultRootDeviceType field's value.
func (s *UpdateStackInput) SetDefaultRootDeviceType(v string) *UpdateStackInput {
	s.DefaultRootDeviceType = &v
	return s
}

// SetDefaultSshKeyName sets the DefaultSshKeyName field's value.
func (s *UpdateStackInput) SetDefaultSshKeyName(v string) *UpdateStackInput {
	s.DefaultSshKeyName = &v
	return s
}

// SetDefaultSubnetId sets the DefaultSubnetId field's value.
func (s *UpdateStackInput) SetDefaultSubnetId(v string) *UpdateStackInput {
	s.DefaultSubnetId = &v
	return s
}

// SetHostnameTheme sets the HostnameTheme field's value.
func (s *UpdateStackInput) SetHostnameTheme(v string) *UpdateStackInput {
	s.HostnameTheme = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateStackInput) SetName(v string) *UpdateStackInput {
	s.Name = &v
	return s
}

// SetServiceRoleArn sets the ServiceRoleArn field's value.
func (s *UpdateStackInput) SetServiceRoleArn(v string) *UpdateStackInput {
	s.ServiceRoleArn = &v
	return s
}

// SetStackId sets the StackId field's value.
func (s *UpdateStackInput) SetStackId(v string) *UpdateStackInput {
	s.StackId = &v
	return s
}

// SetUseCustomCookbooks sets the UseCustomCookbooks field's value.
func (s *UpdateStackInput) SetUseCustomCookbooks(v bool) *UpdateStackInput {
	s.UseCustomCookbooks = &v
	return s
}

// SetUseOpsworksSecurityGroups sets the UseOpsworksSecurityGroups field's value.
func (s *UpdateStackInput) SetUseOpsworksSecurityGroups(v bool) *UpdateStackInput {
	s.UseOpsworksSecurityGroups = &v
	return s
}

type UpdateStackOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateStackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateStackOutput) GoString() string {
	return s.String()
}

type UpdateUserProfileInput struct {
	_ struct{} `type:"structure"`

	// Whether users can specify their own SSH public key through the My Settings
	// page. For more information, see Managing User Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/security-settingsshkey.html).
	AllowSelfManagement *bool `type:"boolean"`

	// The user IAM ARN. This can also be a federated user's ARN.
	//
	// IamUserArn is a required field
	IamUserArn *string `type:"string" required:"true"`

	// The user's new SSH public key.
	SshPublicKey *string `type:"string"`

	// The user's SSH user name. The allowable characters are [a-z], [A-Z], [0-9],
	// '-', and '_'. If the specified name includes other punctuation marks, AWS
	// OpsWorks Stacks removes them. For example, my.name will be changed to myname.
	// If you do not specify an SSH user name, AWS OpsWorks Stacks generates one
	// from the IAM user name.
	SshUsername *string `type:"string"`
}

// String returns the string representation
func (s UpdateUserProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateUserProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateUserProfileInput"}
	if s.IamUserArn == nil {
		invalidParams.Add(request.NewErrParamRequired("IamUserArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowSelfManagement sets the AllowSelfManagement field's value.
func (s *UpdateUserProfileInput) SetAllowSelfManagement(v bool) *UpdateUserProfileInput {
	s.AllowSelfManagement = &v
	return s
}

// SetIamUserArn sets the IamUserArn field's value.
func (s *UpdateUserProfileInput) SetIamUserArn(v string) *UpdateUserProfileInput {
	s.IamUserArn = &v
	return s
}

// SetSshPublicKey sets the SshPublicKey field's value.
func (s *UpdateUserProfileInput) SetSshPublicKey(v string) *UpdateUserProfileInput {
	s.SshPublicKey = &v
	return s
}

// SetSshUsername sets the SshUsername field's value.
func (s *UpdateUserProfileInput) SetSshUsername(v string) *UpdateUserProfileInput {
	s.SshUsername = &v
	return s
}

type UpdateUserProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateUserProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateUserProfileOutput) GoString() string {
	return s.String()
}

type UpdateVolumeInput struct {
	_ struct{} `type:"structure"`

	// The new mount point.
	MountPoint *string `type:"string"`

	// The new name.
	Name *string `type:"string"`

	// The volume ID.
	//
	// VolumeId is a required field
	VolumeId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateVolumeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateVolumeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateVolumeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateVolumeInput"}
	if s.VolumeId == nil {
		invalidParams.Add(request.NewErrParamRequired("VolumeId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMountPoint sets the MountPoint field's value.
func (s *UpdateVolumeInput) SetMountPoint(v string) *UpdateVolumeInput {
	s.MountPoint = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateVolumeInput) SetName(v string) *UpdateVolumeInput {
	s.Name = &v
	return s
}

// SetVolumeId sets the VolumeId field's value.
func (s *UpdateVolumeInput) SetVolumeId(v string) *UpdateVolumeInput {
	s.VolumeId = &v
	return s
}

type UpdateVolumeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateVolumeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateVolumeOutput) GoString() string {
	return s.String()
}

// Describes a user's SSH information.
type UserProfile struct {
	_ struct{} `type:"structure"`

	// Whether users can specify their own SSH public key through the My Settings
	// page. For more information, see Managing User Permissions (https://docs.aws.amazon.com/opsworks/latest/userguide/security-settingsshkey.html).
	AllowSelfManagement *bool `type:"boolean"`

	// The user's IAM ARN.
	IamUserArn *string `type:"string"`

	// The user's name.
	Name *string `type:"string"`

	// The user's SSH public key.
	SshPublicKey *string `type:"string"`

	// The user's SSH user name.
	SshUsername *string `type:"string"`
}

// String returns the string representation
func (s UserProfile) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UserProfile) GoString() string {
	return s.String()
}

// SetAllowSelfManagement sets the AllowSelfManagement field's value.
func (s *UserProfile) SetAllowSelfManagement(v bool) *UserProfile {
	s.AllowSelfManagement = &v
	return s
}

// SetIamUserArn sets the IamUserArn field's value.
func (s *UserProfile) SetIamUserArn(v string) *UserProfile {
	s.IamUserArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *UserProfile) SetName(v string) *UserProfile {
	s.Name = &v
	return s
}

// SetSshPublicKey sets the SshPublicKey field's value.
func (s *UserProfile) SetSshPublicKey(v string) *UserProfile {
	s.SshPublicKey = &v
	return s
}

// SetSshUsername sets the SshUsername field's value.
func (s *UserProfile) SetSshUsername(v string) *UserProfile {
	s.SshUsername = &v
	return s
}

// Indicates that a request was not valid.
type ValidationException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	// The exception message.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s ValidationException) OrigErr() error {
	return nil
}

func (s ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s ValidationException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s ValidationException) RequestID() string {
	return s.respMetadata.RequestID
}

// Describes an instance's Amazon EBS volume.
type Volume struct {
	_ struct{} `type:"structure"`

	// The volume Availability Zone. For more information, see Regions and Endpoints
	// (https://docs.aws.amazon.com/general/latest/gr/rande.html).
	AvailabilityZone *string `type:"string"`

	// The device name.
	Device *string `type:"string"`

	// The Amazon EC2 volume ID.
	Ec2VolumeId *string `type:"string"`

	// Specifies whether an Amazon EBS volume is encrypted. For more information,
	// see Amazon EBS Encryption (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html).
	Encrypted *bool `type:"boolean"`

	// The instance ID.
	InstanceId *string `type:"string"`

	// For PIOPS volumes, the IOPS per disk.
	Iops *int64 `type:"integer"`

	// The volume mount point. For example, "/mnt/disk1".
	MountPoint *string `type:"string"`

	// The volume name.
	Name *string `type:"string"`

	// The RAID array ID.
	RaidArrayId *string `type:"string"`

	// The AWS region. For more information about AWS regions, see Regions and Endpoints
	// (https://docs.aws.amazon.com/general/latest/gr/rande.html).
	Region *string `type:"string"`

	// The volume size.
	Size *int64 `type:"integer"`

	// The value returned by DescribeVolumes (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeVolumes.html).
	Status *string `type:"string"`

	// The volume ID.
	VolumeId *string `type:"string"`

	// The volume type. For more information, see Amazon EBS Volume Types (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html).
	//
	//    * standard - Magnetic. Magnetic volumes must have a minimum size of 1
	//    GiB and a maximum size of 1024 GiB.
	//
	//    * io1 - Provisioned IOPS (SSD). PIOPS volumes must have a minimum size
	//    of 4 GiB and a maximum size of 16384 GiB.
	//
	//    * gp2 - General Purpose (SSD). General purpose volumes must have a minimum
	//    size of 1 GiB and a maximum size of 16384 GiB.
	//
	//    * st1 - Throughput Optimized hard disk drive (HDD). Throughput optimized
	//    HDD volumes must have a minimum size of 500 GiB and a maximum size of
	//    16384 GiB.
	//
	//    * sc1 - Cold HDD. Cold HDD volumes must have a minimum size of 500 GiB
	//    and a maximum size of 16384 GiB.
	VolumeType *string `type:"string"`
}

// String returns the string representation
func (s Volume) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Volume) GoString() string {
	return s.String()
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *Volume) SetAvailabilityZone(v string) *Volume {
	s.AvailabilityZone = &v
	return s
}

// SetDevice sets the Device field's value.
func (s *Volume) SetDevice(v string) *Volume {
	s.Device = &v
	return s
}

// SetEc2VolumeId sets the Ec2VolumeId field's value.
func (s *Volume) SetEc2VolumeId(v string) *Volume {
	s.Ec2VolumeId = &v
	return s
}

// SetEncrypted sets the Encrypted field's value.
func (s *Volume) SetEncrypted(v bool) *Volume {
	s.Encrypted = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *Volume) SetInstanceId(v string) *Volume {
	s.InstanceId = &v
	return s
}

// SetIops sets the Iops field's value.
func (s *Volume) SetIops(v int64) *Volume {
	s.Iops = &v
	return s
}

// SetMountPoint sets the MountPoint field's value.
func (s *Volume) SetMountPoint(v string) *Volume {
	s.MountPoint = &v
	return s
}

// SetName sets the Name field's value.
func (s *Volume) SetName(v string) *Volume {
	s.Name = &v
	return s
}

// SetRaidArrayId sets the RaidArrayId field's value.
func (s *Volume) SetRaidArrayId(v string) *Volume {
	s.RaidArrayId = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *Volume) SetRegion(v string) *Volume {
	s.Region = &v
	return s
}

// SetSize sets the Size field's value.
func (s *Volume) SetSize(v int64) *Volume {
	s.Size = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Volume) SetStatus(v string) *Volume {
	s.Status = &v
	return s
}

// SetVolumeId sets the VolumeId field's value.
func (s *Volume) SetVolumeId(v string) *Volume {
	s.VolumeId = &v
	return s
}

// SetVolumeType sets the VolumeType field's value.
func (s *Volume) SetVolumeType(v string) *Volume {
	s.VolumeType = &v
	return s
}

// Describes an Amazon EBS volume configuration.
type VolumeConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies whether an Amazon EBS volume is encrypted. For more information,
	// see Amazon EBS Encryption (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html).
	Encrypted *bool `type:"boolean"`

	// For PIOPS volumes, the IOPS per disk.
	Iops *int64 `type:"integer"`

	// The volume mount point. For example "/dev/sdh".
	//
	// MountPoint is a required field
	MountPoint *string `type:"string" required:"true"`

	// The number of disks in the volume.
	//
	// NumberOfDisks is a required field
	NumberOfDisks *int64 `type:"integer" required:"true"`

	// The volume RAID level (http://en.wikipedia.org/wiki/Standard_RAID_levels).
	RaidLevel *int64 `type:"integer"`

	// The volume size.
	//
	// Size is a required field
	Size *int64 `type:"integer" required:"true"`

	// The volume type. For more information, see Amazon EBS Volume Types (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html).
	//
	//    * standard - Magnetic. Magnetic volumes must have a minimum size of 1
	//    GiB and a maximum size of 1024 GiB.
	//
	//    * io1 - Provisioned IOPS (SSD). PIOPS volumes must have a minimum size
	//    of 4 GiB and a maximum size of 16384 GiB.
	//
	//    * gp2 - General Purpose (SSD). General purpose volumes must have a minimum
	//    size of 1 GiB and a maximum size of 16384 GiB.
	//
	//    * st1 - Throughput Optimized hard disk drive (HDD). Throughput optimized
	//    HDD volumes must have a minimum size of 500 GiB and a maximum size of
	//    16384 GiB.
	//
	//    * sc1 - Cold HDD. Cold HDD volumes must have a minimum size of 500 GiB
	//    and a maximum size of 16384 GiB.
	VolumeType *string `type:"string"`
}

// String returns the string representation
func (s VolumeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VolumeConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VolumeConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VolumeConfiguration"}
	if s.MountPoint == nil {
		invalidParams.Add(request.NewErrParamRequired("MountPoint"))
	}
	if s.NumberOfDisks == nil {
		invalidParams.Add(request.NewErrParamRequired("NumberOfDisks"))
	}
	if s.Size == nil {
		invalidParams.Add(request.NewErrParamRequired("Size"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEncrypted sets the Encrypted field's value.
func (s *VolumeConfiguration) SetEncrypted(v bool) *VolumeConfiguration {
	s.Encrypted = &v
	return s
}

// SetIops sets the Iops field's value.
func (s *VolumeConfiguration) SetIops(v int64) *VolumeConfiguration {
	s.Iops = &v
	return s
}

// SetMountPoint sets the MountPoint field's value.
func (s *VolumeConfiguration) SetMountPoint(v string) *VolumeConfiguration {
	s.MountPoint = &v
	return s
}

// SetNumberOfDisks sets the NumberOfDisks field's value.
func (s *VolumeConfiguration) SetNumberOfDisks(v int64) *VolumeConfiguration {
	s.NumberOfDisks = &v
	return s
}

// SetRaidLevel sets the RaidLevel field's value.
func (s *VolumeConfiguration) SetRaidLevel(v int64) *VolumeConfiguration {
	s.RaidLevel = &v
	return s
}

// SetSize sets the Size field's value.
func (s *VolumeConfiguration) SetSize(v int64) *VolumeConfiguration {
	s.Size = &v
	return s
}

// SetVolumeType sets the VolumeType field's value.
func (s *VolumeConfiguration) SetVolumeType(v string) *VolumeConfiguration {
	s.VolumeType = &v
	return s
}

// Describes a time-based instance's auto scaling schedule. The schedule consists
// of a set of key-value pairs.
//
//    * The key is the time period (a UTC hour) and must be an integer from
//    0 - 23.
//
//    * The value indicates whether the instance should be online or offline
//    for the specified period, and must be set to "on" or "off"
//
// The default setting for all time periods is off, so you use the following
// parameters primarily to specify the online periods. You don't have to explicitly
// specify offline periods unless you want to change an online period to an
// offline period.
//
// The following example specifies that the instance should be online for four
// hours, from UTC 1200 - 1600. It will be off for the remainder of the day.
//
// { "12":"on", "13":"on", "14":"on", "15":"on" }
type WeeklyAutoScalingSchedule struct {
	_ struct{} `type:"structure"`

	// The schedule for Friday.
	Friday map[string]*string `type:"map"`

	// The schedule for Monday.
	Monday map[string]*string `type:"map"`

	// The schedule for Saturday.
	Saturday map[string]*string `type:"map"`

	// The schedule for Sunday.
	Sunday map[string]*string `type:"map"`

	// The schedule for Thursday.
	Thursday map[string]*string `type:"map"`

	// The schedule for Tuesday.
	Tuesday map[string]*string `type:"map"`

	// The schedule for Wednesday.
	Wednesday map[string]*string `type:"map"`
}

// String returns the string representation
func (s WeeklyAutoScalingSchedule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WeeklyAutoScalingSchedule) GoString() string {
	return s.String()
}

// SetFriday sets the Friday field's value.
func (s *WeeklyAutoScalingSchedule) SetFriday(v map[string]*string) *WeeklyAutoScalingSchedule {
	s.Friday = v
	return s
}

// SetMonday sets the Monday field's value.
func (s *WeeklyAutoScalingSchedule) SetMonday(v map[string]*string) *WeeklyAutoScalingSchedule {
	s.Monday = v
	return s
}

// SetSaturday sets the Saturday field's value.
func (s *WeeklyAutoScalingSchedule) SetSaturday(v map[string]*string) *WeeklyAutoScalingSchedule {
	s.Saturday = v
	return s
}

// SetSunday sets the Sunday field's value.
func (s *WeeklyAutoScalingSchedule) SetSunday(v map[string]*string) *WeeklyAutoScalingSchedule {
	s.Sunday = v
	return s
}

// SetThursday sets the Thursday field's value.
func (s *WeeklyAutoScalingSchedule) SetThursday(v map[string]*string) *WeeklyAutoScalingSchedule {
	s.Thursday = v
	return s
}

// SetTuesday sets the Tuesday field's value.
func (s *WeeklyAutoScalingSchedule) SetTuesday(v map[string]*string) *WeeklyAutoScalingSchedule {
	s.Tuesday = v
	return s
}

// SetWednesday sets the Wednesday field's value.
func (s *WeeklyAutoScalingSchedule) SetWednesday(v map[string]*string) *WeeklyAutoScalingSchedule {
	s.Wednesday = v
	return s
}

const (
	// AppAttributesKeysDocumentRoot is a AppAttributesKeys enum value
	AppAttributesKeysDocumentRoot = "DocumentRoot"

	// AppAttributesKeysRailsEnv is a AppAttributesKeys enum value
	AppAttributesKeysRailsEnv = "RailsEnv"

	// AppAttributesKeysAutoBundleOnDeploy is a AppAttributesKeys enum value
	AppAttributesKeysAutoBundleOnDeploy = "AutoBundleOnDeploy"

	// AppAttributesKeysAwsFlowRubySettings is a AppAttributesKeys enum value
	AppAttributesKeysAwsFlowRubySettings = "AwsFlowRubySettings"
)

const (
	// AppTypeAwsFlowRuby is a AppType enum value
	AppTypeAwsFlowRuby = "aws-flow-ruby"

	// AppTypeJava is a AppType enum value
	AppTypeJava = "java"

	// AppTypeRails is a AppType enum value
	AppTypeRails = "rails"

	// AppTypePhp is a AppType enum value
	AppTypePhp = "php"

	// AppTypeNodejs is a AppType enum value
	AppTypeNodejs = "nodejs"

	// AppTypeStatic is a AppType enum value
	AppTypeStatic = "static"

	// AppTypeOther is a AppType enum value
	AppTypeOther = "other"
)

const (
	// ArchitectureX8664 is a Architecture enum value
	ArchitectureX8664 = "x86_64"

	// ArchitectureI386 is a Architecture enum value
	ArchitectureI386 = "i386"
)

const (
	// AutoScalingTypeLoad is a AutoScalingType enum value
	AutoScalingTypeLoad = "load"

	// AutoScalingTypeTimer is a AutoScalingType enum value
	AutoScalingTypeTimer = "timer"
)

// Specifies the encoding of the log file so that the file can be read correctly.
// The default is utf_8. Encodings supported by Python codecs.decode() can be
// used here.
const (
	// CloudWatchLogsEncodingAscii is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingAscii = "ascii"

	// CloudWatchLogsEncodingBig5 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingBig5 = "big5"

	// CloudWatchLogsEncodingBig5hkscs is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingBig5hkscs = "big5hkscs"

	// CloudWatchLogsEncodingCp037 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingCp037 = "cp037"

	// CloudWatchLogsEncodingCp424 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingCp424 = "cp424"

	// CloudWatchLogsEncodingCp437 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingCp437 = "cp437"

	// CloudWatchLogsEncodingCp500 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingCp500 = "cp500"

	// CloudWatchLogsEncodingCp720 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingCp720 = "cp720"

	// CloudWatchLogsEncodingCp737 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingCp737 = "cp737"

	// CloudWatchLogsEncodingCp775 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingCp775 = "cp775"

	// CloudWatchLogsEncodingCp850 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingCp850 = "cp850"

	// CloudWatchLogsEncodingCp852 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingCp852 = "cp852"

	// CloudWatchLogsEncodingCp855 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingCp855 = "cp855"

	// CloudWatchLogsEncodingCp856 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingCp856 = "cp856"

	// CloudWatchLogsEncodingCp857 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingCp857 = "cp857"

	// CloudWatchLogsEncodingCp858 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingCp858 = "cp858"

	// CloudWatchLogsEncodingCp860 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingCp860 = "cp860"

	// CloudWatchLogsEncodingCp861 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingCp861 = "cp861"

	// CloudWatchLogsEncodingCp862 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingCp862 = "cp862"

	// CloudWatchLogsEncodingCp863 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingCp863 = "cp863"

	// CloudWatchLogsEncodingCp864 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingCp864 = "cp864"

	// CloudWatchLogsEncodingCp865 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingCp865 = "cp865"

	// CloudWatchLogsEncodingCp866 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingCp866 = "cp866"

	// CloudWatchLogsEncodingCp869 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingCp869 = "cp869"

	// CloudWatchLogsEncodingCp874 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingCp874 = "cp874"

	// CloudWatchLogsEncodingCp875 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingCp875 = "cp875"

	// CloudWatchLogsEncodingCp932 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingCp932 = "cp932"

	// CloudWatchLogsEncodingCp949 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingCp949 = "cp949"

	// CloudWatchLogsEncodingCp950 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingCp950 = "cp950"

	// CloudWatchLogsEncodingCp1006 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingCp1006 = "cp1006"

	// CloudWatchLogsEncodingCp1026 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingCp1026 = "cp1026"

	// CloudWatchLogsEncodingCp1140 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingCp1140 = "cp1140"

	// CloudWatchLogsEncodingCp1250 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingCp1250 = "cp1250"

	// CloudWatchLogsEncodingCp1251 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingCp1251 = "cp1251"

	// CloudWatchLogsEncodingCp1252 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingCp1252 = "cp1252"

	// CloudWatchLogsEncodingCp1253 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingCp1253 = "cp1253"

	// CloudWatchLogsEncodingCp1254 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingCp1254 = "cp1254"

	// CloudWatchLogsEncodingCp1255 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingCp1255 = "cp1255"

	// CloudWatchLogsEncodingCp1256 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingCp1256 = "cp1256"

	// CloudWatchLogsEncodingCp1257 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingCp1257 = "cp1257"

	// CloudWatchLogsEncodingCp1258 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingCp1258 = "cp1258"

	// CloudWatchLogsEncodingEucJp is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingEucJp = "euc_jp"

	// CloudWatchLogsEncodingEucJis2004 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingEucJis2004 = "euc_jis_2004"

	// CloudWatchLogsEncodingEucJisx0213 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingEucJisx0213 = "euc_jisx0213"

	// CloudWatchLogsEncodingEucKr is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingEucKr = "euc_kr"

	// CloudWatchLogsEncodingGb2312 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingGb2312 = "gb2312"

	// CloudWatchLogsEncodingGbk is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingGbk = "gbk"

	// CloudWatchLogsEncodingGb18030 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingGb18030 = "gb18030"

	// CloudWatchLogsEncodingHz is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingHz = "hz"

	// CloudWatchLogsEncodingIso2022Jp is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingIso2022Jp = "iso2022_jp"

	// CloudWatchLogsEncodingIso2022Jp1 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingIso2022Jp1 = "iso2022_jp_1"

	// CloudWatchLogsEncodingIso2022Jp2 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingIso2022Jp2 = "iso2022_jp_2"

	// CloudWatchLogsEncodingIso2022Jp2004 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingIso2022Jp2004 = "iso2022_jp_2004"

	// CloudWatchLogsEncodingIso2022Jp3 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingIso2022Jp3 = "iso2022_jp_3"

	// CloudWatchLogsEncodingIso2022JpExt is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingIso2022JpExt = "iso2022_jp_ext"

	// CloudWatchLogsEncodingIso2022Kr is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingIso2022Kr = "iso2022_kr"

	// CloudWatchLogsEncodingLatin1 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingLatin1 = "latin_1"

	// CloudWatchLogsEncodingIso88592 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingIso88592 = "iso8859_2"

	// CloudWatchLogsEncodingIso88593 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingIso88593 = "iso8859_3"

	// CloudWatchLogsEncodingIso88594 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingIso88594 = "iso8859_4"

	// CloudWatchLogsEncodingIso88595 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingIso88595 = "iso8859_5"

	// CloudWatchLogsEncodingIso88596 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingIso88596 = "iso8859_6"

	// CloudWatchLogsEncodingIso88597 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingIso88597 = "iso8859_7"

	// CloudWatchLogsEncodingIso88598 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingIso88598 = "iso8859_8"

	// CloudWatchLogsEncodingIso88599 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingIso88599 = "iso8859_9"

	// CloudWatchLogsEncodingIso885910 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingIso885910 = "iso8859_10"

	// CloudWatchLogsEncodingIso885913 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingIso885913 = "iso8859_13"

	// CloudWatchLogsEncodingIso885914 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingIso885914 = "iso8859_14"

	// CloudWatchLogsEncodingIso885915 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingIso885915 = "iso8859_15"

	// CloudWatchLogsEncodingIso885916 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingIso885916 = "iso8859_16"

	// CloudWatchLogsEncodingJohab is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingJohab = "johab"

	// CloudWatchLogsEncodingKoi8R is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingKoi8R = "koi8_r"

	// CloudWatchLogsEncodingKoi8U is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingKoi8U = "koi8_u"

	// CloudWatchLogsEncodingMacCyrillic is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingMacCyrillic = "mac_cyrillic"

	// CloudWatchLogsEncodingMacGreek is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingMacGreek = "mac_greek"

	// CloudWatchLogsEncodingMacIceland is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingMacIceland = "mac_iceland"

	// CloudWatchLogsEncodingMacLatin2 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingMacLatin2 = "mac_latin2"

	// CloudWatchLogsEncodingMacRoman is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingMacRoman = "mac_roman"

	// CloudWatchLogsEncodingMacTurkish is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingMacTurkish = "mac_turkish"

	// CloudWatchLogsEncodingPtcp154 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingPtcp154 = "ptcp154"

	// CloudWatchLogsEncodingShiftJis is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingShiftJis = "shift_jis"

	// CloudWatchLogsEncodingShiftJis2004 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingShiftJis2004 = "shift_jis_2004"

	// CloudWatchLogsEncodingShiftJisx0213 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingShiftJisx0213 = "shift_jisx0213"

	// CloudWatchLogsEncodingUtf32 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingUtf32 = "utf_32"

	// CloudWatchLogsEncodingUtf32Be is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingUtf32Be = "utf_32_be"

	// CloudWatchLogsEncodingUtf32Le is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingUtf32Le = "utf_32_le"

	// CloudWatchLogsEncodingUtf16 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingUtf16 = "utf_16"

	// CloudWatchLogsEncodingUtf16Be is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingUtf16Be = "utf_16_be"

	// CloudWatchLogsEncodingUtf16Le is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingUtf16Le = "utf_16_le"

	// CloudWatchLogsEncodingUtf7 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingUtf7 = "utf_7"

	// CloudWatchLogsEncodingUtf8 is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingUtf8 = "utf_8"

	// CloudWatchLogsEncodingUtf8Sig is a CloudWatchLogsEncoding enum value
	CloudWatchLogsEncodingUtf8Sig = "utf_8_sig"
)

// Specifies where to start to read data (start_of_file or end_of_file). The
// default is start_of_file. It's only used if there is no state persisted for
// that log stream.
const (
	// CloudWatchLogsInitialPositionStartOfFile is a CloudWatchLogsInitialPosition enum value
	CloudWatchLogsInitialPositionStartOfFile = "start_of_file"

	// CloudWatchLogsInitialPositionEndOfFile is a CloudWatchLogsInitialPosition enum value
	CloudWatchLogsInitialPositionEndOfFile = "end_of_file"
)

// The preferred time zone for logs streamed to CloudWatch Logs. Valid values
// are LOCAL and UTC, for Coordinated Universal Time.
const (
	// CloudWatchLogsTimeZoneLocal is a CloudWatchLogsTimeZone enum value
	CloudWatchLogsTimeZoneLocal = "LOCAL"

	// CloudWatchLogsTimeZoneUtc is a CloudWatchLogsTimeZone enum value
	CloudWatchLogsTimeZoneUtc = "UTC"
)

const (
	// DeploymentCommandNameInstallDependencies is a DeploymentCommandName enum value
	DeploymentCommandNameInstallDependencies = "install_dependencies"

	// DeploymentCommandNameUpdateDependencies is a DeploymentCommandName enum value
	DeploymentCommandNameUpdateDependencies = "update_dependencies"

	// DeploymentCommandNameUpdateCustomCookbooks is a DeploymentCommandName enum value
	DeploymentCommandNameUpdateCustomCookbooks = "update_custom_cookbooks"

	// DeploymentCommandNameExecuteRecipes is a DeploymentCommandName enum value
	DeploymentCommandNameExecuteRecipes = "execute_recipes"

	// DeploymentCommandNameConfigure is a DeploymentCommandName enum value
	DeploymentCommandNameConfigure = "configure"

	// DeploymentCommandNameSetup is a DeploymentCommandName enum value
	DeploymentCommandNameSetup = "setup"

	// DeploymentCommandNameDeploy is a DeploymentCommandName enum value
	DeploymentCommandNameDeploy = "deploy"

	// DeploymentCommandNameRollback is a DeploymentCommandName enum value
	DeploymentCommandNameRollback = "rollback"

	// DeploymentCommandNameStart is a DeploymentCommandName enum value
	DeploymentCommandNameStart = "start"

	// DeploymentCommandNameStop is a DeploymentCommandName enum value
	DeploymentCommandNameStop = "stop"

	// DeploymentCommandNameRestart is a DeploymentCommandName enum value
	DeploymentCommandNameRestart = "restart"

	// DeploymentCommandNameUndeploy is a DeploymentCommandName enum value
	DeploymentCommandNameUndeploy = "undeploy"
)

const (
	// LayerAttributesKeysEcsClusterArn is a LayerAttributesKeys enum value
	LayerAttributesKeysEcsClusterArn = "EcsClusterArn"

	// LayerAttributesKeysEnableHaproxyStats is a LayerAttributesKeys enum value
	LayerAttributesKeysEnableHaproxyStats = "EnableHaproxyStats"

	// LayerAttributesKeysHaproxyStatsUrl is a LayerAttributesKeys enum value
	LayerAttributesKeysHaproxyStatsUrl = "HaproxyStatsUrl"

	// LayerAttributesKeysHaproxyStatsUser is a LayerAttributesKeys enum value
	LayerAttributesKeysHaproxyStatsUser = "HaproxyStatsUser"

	// LayerAttributesKeysHaproxyStatsPassword is a LayerAttributesKeys enum value
	LayerAttributesKeysHaproxyStatsPassword = "HaproxyStatsPassword"

	// LayerAttributesKeysHaproxyHealthCheckUrl is a LayerAttributesKeys enum value
	LayerAttributesKeysHaproxyHealthCheckUrl = "HaproxyHealthCheckUrl"

	// LayerAttributesKeysHaproxyHealthCheckMethod is a LayerAttributesKeys enum value
	LayerAttributesKeysHaproxyHealthCheckMethod = "HaproxyHealthCheckMethod"

	// LayerAttributesKeysMysqlRootPassword is a LayerAttributesKeys enum value
	LayerAttributesKeysMysqlRootPassword = "MysqlRootPassword"

	// LayerAttributesKeysMysqlRootPasswordUbiquitous is a LayerAttributesKeys enum value
	LayerAttributesKeysMysqlRootPasswordUbiquitous = "MysqlRootPasswordUbiquitous"

	// LayerAttributesKeysGangliaUrl is a LayerAttributesKeys enum value
	LayerAttributesKeysGangliaUrl = "GangliaUrl"

	// LayerAttributesKeysGangliaUser is a LayerAttributesKeys enum value
	LayerAttributesKeysGangliaUser = "GangliaUser"

	// LayerAttributesKeysGangliaPassword is a LayerAttributesKeys enum value
	LayerAttributesKeysGangliaPassword = "GangliaPassword"

	// LayerAttributesKeysMemcachedMemory is a LayerAttributesKeys enum value
	LayerAttributesKeysMemcachedMemory = "MemcachedMemory"

	// LayerAttributesKeysNodejsVersion is a LayerAttributesKeys enum value
	LayerAttributesKeysNodejsVersion = "NodejsVersion"

	// LayerAttributesKeysRubyVersion is a LayerAttributesKeys enum value
	LayerAttributesKeysRubyVersion = "RubyVersion"

	// LayerAttributesKeysRubygemsVersion is a LayerAttributesKeys enum value
	LayerAttributesKeysRubygemsVersion = "RubygemsVersion"

	// LayerAttributesKeysManageBundler is a LayerAttributesKeys enum value
	LayerAttributesKeysManageBundler = "ManageBundler"

	// LayerAttributesKeysBundlerVersion is a LayerAttributesKeys enum value
	LayerAttributesKeysBundlerVersion = "BundlerVersion"

	// LayerAttributesKeysRailsStack is a LayerAttributesKeys enum value
	LayerAttributesKeysRailsStack = "RailsStack"

	// LayerAttributesKeysPassengerVersion is a LayerAttributesKeys enum value
	LayerAttributesKeysPassengerVersion = "PassengerVersion"

	// LayerAttributesKeysJvm is a LayerAttributesKeys enum value
	LayerAttributesKeysJvm = "Jvm"

	// LayerAttributesKeysJvmVersion is a LayerAttributesKeys enum value
	LayerAttributesKeysJvmVersion = "JvmVersion"

	// LayerAttributesKeysJvmOptions is a LayerAttributesKeys enum value
	LayerAttributesKeysJvmOptions = "JvmOptions"

	// LayerAttributesKeysJavaAppServer is a LayerAttributesKeys enum value
	LayerAttributesKeysJavaAppServer = "JavaAppServer"

	// LayerAttributesKeysJavaAppServerVersion is a LayerAttributesKeys enum value
	LayerAttributesKeysJavaAppServerVersion = "JavaAppServerVersion"
)

const (
	// LayerTypeAwsFlowRuby is a LayerType enum value
	LayerTypeAwsFlowRuby = "aws-flow-ruby"

	// LayerTypeEcsCluster is a LayerType enum value
	LayerTypeEcsCluster = "ecs-cluster"

	// LayerTypeJavaApp is a LayerType enum value
	LayerTypeJavaApp = "java-app"

	// LayerTypeLb is a LayerType enum value
	LayerTypeLb = "lb"

	// LayerTypeWeb is a LayerType enum value
	LayerTypeWeb = "web"

	// LayerTypePhpApp is a LayerType enum value
	LayerTypePhpApp = "php-app"

	// LayerTypeRailsApp is a LayerType enum value
	LayerTypeRailsApp = "rails-app"

	// LayerTypeNodejsApp is a LayerType enum value
	LayerTypeNodejsApp = "nodejs-app"

	// LayerTypeMemcached is a LayerType enum value
	LayerTypeMemcached = "memcached"

	// LayerTypeDbMaster is a LayerType enum value
	LayerTypeDbMaster = "db-master"

	// LayerTypeMonitoringMaster is a LayerType enum value
	LayerTypeMonitoringMaster = "monitoring-master"

	// LayerTypeCustom is a LayerType enum value
	LayerTypeCustom = "custom"
)

const (
	// RootDeviceTypeEbs is a RootDeviceType enum value
	RootDeviceTypeEbs = "ebs"

	// RootDeviceTypeInstanceStore is a RootDeviceType enum value
	RootDeviceTypeInstanceStore = "instance-store"
)

const (
	// SourceTypeGit is a SourceType enum value
	SourceTypeGit = "git"

	// SourceTypeSvn is a SourceType enum value
	SourceTypeSvn = "svn"

	// SourceTypeArchive is a SourceType enum value
	SourceTypeArchive = "archive"

	// SourceTypeS3 is a SourceType enum value
	SourceTypeS3 = "s3"
)

const (
	// StackAttributesKeysColor is a StackAttributesKeys enum value
	StackAttributesKeysColor = "Color"
)

const (
	// VirtualizationTypeParavirtual is a VirtualizationType enum value
	VirtualizationTypeParavirtual = "paravirtual"

	// VirtualizationTypeHvm is a VirtualizationType enum value
	VirtualizationTypeHvm = "hvm"
)

const (
	// VolumeTypeGp2 is a VolumeType enum value
	VolumeTypeGp2 = "gp2"

	// VolumeTypeIo1 is a VolumeType enum value
	VolumeTypeIo1 = "io1"

	// VolumeTypeStandard is a VolumeType enum value
	VolumeTypeStandard = "standard"
)
