---
title: Resources
description: Velero Resources
id: resources
---
Here you will find external resources about Velero, such as videos, podcasts, and community articles.

## All community meetings

* Community Meetings Playlist
{{< youtube "videoseries?list=PL7bmigfV0EqQRysvqvqOtRNk4L5S7uqwM" >}}

* Velero Demo and Deep Dives Playlist
{{< youtube "videoseries?list=PL7bmigfV0EqT82eQaVCslWWM4k4d63KyK" >}}

## Podcast shows

* [vSpeaking Podcast Ep 124, with guests Carlisia Thompson, Myles Gray and Cormac Hogan](https://blogs.vmware.com/virtualblocks/2019/08/02/vspeaking-podcast-velero/)

* [Listen to the PodCTL podcast with Carlisia Thompson talking about Velero](<http://podcast.podctl.com/110399/986641-understanding-project-velero-formerly-ark>)

## Videos

* Kubecon NA 2019 - How to Backup and Restore Your Kubernetes Cluster - Annette Clewett & Dylan Murray, Red Hat:

    {{< youtube JyzgS-KKuoo >}}


* Kubernetes Back Up, Restore and Migration with Velero - A NewStack interview, with guests: Carlisia Thompson, Tom Spoonemore, and Efri Nattel-Shayo:

    {{< youtube 71NoY5CIcQ8 >}}


* How to migrate applications between Kubernetes clusters using Velero:

    {{< youtube IZlwKMoqBqE >}}


* TGIK 080: Velero 1.0:

    {{< youtube tj5Ey2bHsfM >}}


* Watch our recent webinar on backup and migration strategies:

    {{< youtube csrSPt3HFtg >}}


* Velero demo by Just me and Opensource - [ Kube 45 ] Velero - Backup & Restore Kubernetes Cluster:

    {{< youtube C9hzrexaIDA >}}

## Blog posts

* [How to Make Up for Kubernetes’ Disaster Recovery Shortfalls - by Carlisia Thompson](https://thenewstack.io/how-to-make-up-for-kubernetes-disaster-recovery-shortfalls/)


* [Project Velero 1.2 on OpenShift 3.11 - Backup and Restore (and backup to NFS) - by Rafael Brito](http://www.rafaelbrito.com/2019/11/project-velero-12-on-openshift-311.html)


* [Backing Up Your Kubernetes Applications with Velero v1.1 - by Joe Mann](https://mannimal.blog/2019/10/04/backing-up-your-kubernetes-applications-with-velero-v1-1/)


* [Using Velero for K8s Backup and Restore of CSI Volumes - by Myles Gray](https://blah.cloud/automation/using-velero-for-k8s-backup-and-restore-of-csi-volumes/)


* ["Kubernetes Backup: Improve already awesome Velero with OpenEBS" - by Harshita Sharma](https://blog.mayadata.io/openebs/suggesting-ways-to-improve-already-awesome-velero)


* [Cormac Hogan has written a series of blog posts on Velero](https://cormachogan.com/?s=velero)


* [Backup and Restore MariaDB Galera Deployments on Kubernetes - by Vikram Vaswani](https://docs.bitnami.com/tutorials/backup-restore-data-mariadb-galera-kubernetes/)


* Two great blog posts by community member Imran Pochi:
    * [Backup and Restore of Kubernetes Applications using Heptio’s Velero with Restic and Rook-Ceph as the storage provider](https://blog.kubernauts.io/backup-and-restore-of-kubernetes-applications-using-heptios-velero-with-restic-and-rook-ceph-as-2e8df15b1487)
    * [Backup and Restore PVCs using Velero with restic and OpenEBS from Baremetal cluster to AWS
    ](https://blog.kubernauts.io/backup-and-restore-pvcs-using-velero-with-restic-and-openebs-from-baremetal-cluster-to-aws-d3ac54386109)