/*
Copyright 2019 The Tekton Authors

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1alpha1

import (
	"context"
	"time"

	v1alpha1 "github.com/tektoncd/triggers/pkg/apis/triggers/v1alpha1"
	scheme "github.com/tektoncd/triggers/pkg/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// TriggerTemplatesGetter has a method to return a TriggerTemplateInterface.
// A group's client should implement this interface.
type TriggerTemplatesGetter interface {
	TriggerTemplates(namespace string) TriggerTemplateInterface
}

// TriggerTemplateInterface has methods to work with TriggerTemplate resources.
type TriggerTemplateInterface interface {
	Create(ctx context.Context, triggerTemplate *v1alpha1.TriggerTemplate, opts v1.CreateOptions) (*v1alpha1.TriggerTemplate, error)
	Update(ctx context.Context, triggerTemplate *v1alpha1.TriggerTemplate, opts v1.UpdateOptions) (*v1alpha1.TriggerTemplate, error)
	UpdateStatus(ctx context.Context, triggerTemplate *v1alpha1.TriggerTemplate, opts v1.UpdateOptions) (*v1alpha1.TriggerTemplate, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1alpha1.TriggerTemplate, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1alpha1.TriggerTemplateList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.TriggerTemplate, err error)
	TriggerTemplateExpansion
}

// triggerTemplates implements TriggerTemplateInterface
type triggerTemplates struct {
	client rest.Interface
	ns     string
}

// newTriggerTemplates returns a TriggerTemplates
func newTriggerTemplates(c *TriggersV1alpha1Client, namespace string) *triggerTemplates {
	return &triggerTemplates{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the triggerTemplate, and returns the corresponding triggerTemplate object, and an error if there is any.
func (c *triggerTemplates) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1alpha1.TriggerTemplate, err error) {
	result = &v1alpha1.TriggerTemplate{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("triggertemplates").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of TriggerTemplates that match those selectors.
func (c *triggerTemplates) List(ctx context.Context, opts v1.ListOptions) (result *v1alpha1.TriggerTemplateList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1alpha1.TriggerTemplateList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("triggertemplates").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested triggerTemplates.
func (c *triggerTemplates) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("triggertemplates").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a triggerTemplate and creates it.  Returns the server's representation of the triggerTemplate, and an error, if there is any.
func (c *triggerTemplates) Create(ctx context.Context, triggerTemplate *v1alpha1.TriggerTemplate, opts v1.CreateOptions) (result *v1alpha1.TriggerTemplate, err error) {
	result = &v1alpha1.TriggerTemplate{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("triggertemplates").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(triggerTemplate).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a triggerTemplate and updates it. Returns the server's representation of the triggerTemplate, and an error, if there is any.
func (c *triggerTemplates) Update(ctx context.Context, triggerTemplate *v1alpha1.TriggerTemplate, opts v1.UpdateOptions) (result *v1alpha1.TriggerTemplate, err error) {
	result = &v1alpha1.TriggerTemplate{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("triggertemplates").
		Name(triggerTemplate.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(triggerTemplate).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *triggerTemplates) UpdateStatus(ctx context.Context, triggerTemplate *v1alpha1.TriggerTemplate, opts v1.UpdateOptions) (result *v1alpha1.TriggerTemplate, err error) {
	result = &v1alpha1.TriggerTemplate{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("triggertemplates").
		Name(triggerTemplate.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(triggerTemplate).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the triggerTemplate and deletes it. Returns an error if one occurs.
func (c *triggerTemplates) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("triggertemplates").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *triggerTemplates) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("triggertemplates").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched triggerTemplate.
func (c *triggerTemplates) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1alpha1.TriggerTemplate, err error) {
	result = &v1alpha1.TriggerTemplate{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("triggertemplates").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
