// Package containerregistry implements the Azure ARM Containerregistry service API version 2019-08-15-preview.
//
// Metadata API definition for the Azure Container Registry runtime
package containerregistry

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
)

// BaseClient is the base client for Containerregistry.
type BaseClient struct {
	autorest.Client
	LoginURI string
}

// New creates an instance of the BaseClient client.
func New(loginURI string) BaseClient {
	return NewWithoutDefaults(loginURI)
}

// NewWithoutDefaults creates an instance of the BaseClient client.
func NewWithoutDefaults(loginURI string) BaseClient {
	return BaseClient{
		Client:   autorest.NewClientWithUserAgent(UserAgent()),
		LoginURI: loginURI,
	}
}
