// Code generated from specification version 7.0.0: DO NOT EDIT

package esapi

import (
	"context"
	"strings"
)

func newInfoFunc(t Transport) Info {
	return func(o ...func(*InfoRequest)) (*Response, error) {
		var r = InfoRequest{}
		for _, f := range o {
			f(&r)
		}
		return r.Do(r.ctx, t)
	}
}

// ----- API Definition -------------------------------------------------------

// Info returns basic information about the cluster.
//
// See full documentation at http://www.elastic.co/guide/.
//
type Info func(o ...func(*InfoRequest)) (*Response, error)

// InfoRequest configures the Info API request.
//
type InfoRequest struct {
	Pretty     bool
	Human      bool
	ErrorTrace bool
	FilterPath []string

	ctx context.Context
}

// Do executes the request and returns response or error.
//
func (r InfoRequest) Do(ctx context.Context, transport Transport) (*Response, error) {
	var (
		method string
		path   strings.Builder
		params map[string]string
	)

	method = "GET"

	path.Grow(len("/"))
	path.WriteString("/")

	params = make(map[string]string)

	if r.Pretty {
		params["pretty"] = "true"
	}

	if r.Human {
		params["human"] = "true"
	}

	if r.ErrorTrace {
		params["error_trace"] = "true"
	}

	if len(r.FilterPath) > 0 {
		params["filter_path"] = strings.Join(r.FilterPath, ",")
	}

	req, _ := newRequest(method, path.String(), nil)

	if len(params) > 0 {
		q := req.URL.Query()
		for k, v := range params {
			q.Set(k, v)
		}
		req.URL.RawQuery = q.Encode()
	}

	if ctx != nil {
		req = req.WithContext(ctx)
	}

	res, err := transport.Perform(req)
	if err != nil {
		return nil, err
	}

	response := Response{
		StatusCode: res.StatusCode,
		Body:       res.Body,
		Header:     res.Header,
	}

	return &response, nil
}

// WithContext sets the request context.
//
func (f Info) WithContext(v context.Context) func(*InfoRequest) {
	return func(r *InfoRequest) {
		r.ctx = v
	}
}

// WithHuman makes statistical values human-readable.
//
func (f Info) WithHuman() func(*InfoRequest) {
	return func(r *InfoRequest) {
		r.Human = true
	}
}

// WithErrorTrace includes the stack trace for errors in the response body.
//
func (f Info) WithErrorTrace() func(*InfoRequest) {
	return func(r *InfoRequest) {
		r.ErrorTrace = true
	}
}

// WithFilterPath filters the properties of the response body.
//
func (f Info) WithFilterPath(v ...string) func(*InfoRequest) {
	return func(r *InfoRequest) {
		r.FilterPath = v
	}
}
