// Copyright The OpenTelemetry Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by "cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "go run cmd/pdatagen/main.go".

package pdata

import (
	otlpmetrics "go.opentelemetry.io/collector/internal/data/opentelemetry-proto-gen/metrics/v1"
)

// ResourceMetricsSlice logically represents a slice of ResourceMetrics.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewResourceMetricsSlice function to create new instances.
// Important: zero-initialized instance is not valid for use.
type ResourceMetricsSlice struct {
	// orig points to the slice otlpmetrics.ResourceMetrics field contained somewhere else.
	// We use pointer-to-slice to be able to modify it in functions like Resize.
	orig *[]*otlpmetrics.ResourceMetrics
}

func newResourceMetricsSlice(orig *[]*otlpmetrics.ResourceMetrics) ResourceMetricsSlice {
	return ResourceMetricsSlice{orig}
}

// NewResourceMetricsSlice creates a ResourceMetricsSlice with 0 elements.
// Can use "Resize" to initialize with a given length.
func NewResourceMetricsSlice() ResourceMetricsSlice {
	orig := []*otlpmetrics.ResourceMetrics(nil)
	return ResourceMetricsSlice{&orig}
}

// Len returns the number of elements in the slice.
//
// Returns "0" for a newly instance created with "NewResourceMetricsSlice()".
func (es ResourceMetricsSlice) Len() int {
	return len(*es.orig)
}

// At returns the element at the given index.
//
// This function is used mostly for iterating over all the values in the slice:
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     ... // Do something with the element
// }
func (es ResourceMetricsSlice) At(ix int) ResourceMetrics {
	return newResourceMetrics(&(*es.orig)[ix])
}

// MoveAndAppendTo moves all elements from the current slice and appends them to the dest.
// The current slice will be cleared.
func (es ResourceMetricsSlice) MoveAndAppendTo(dest ResourceMetricsSlice) {
	if es.Len() == 0 {
		// Just to ensure that we always return a Slice with nil elements.
		*es.orig = nil
		return
	}
	if dest.Len() == 0 {
		*dest.orig = *es.orig
		*es.orig = nil
		return
	}
	*dest.orig = append(*dest.orig, *es.orig...)
	*es.orig = nil
	return
}

// CopyTo copies all elements from the current slice to the dest.
func (es ResourceMetricsSlice) CopyTo(dest ResourceMetricsSlice) {
	newLen := es.Len()
	if newLen == 0 {
		*dest.orig = []*otlpmetrics.ResourceMetrics(nil)
		return
	}
	oldLen := dest.Len()
	if newLen <= oldLen {
		(*dest.orig) = (*dest.orig)[:newLen]
		for i, el := range *es.orig {
			newResourceMetrics(&el).CopyTo(newResourceMetrics(&(*dest.orig)[i]))
		}
		return
	}
	origs := make([]otlpmetrics.ResourceMetrics, newLen)
	wrappers := make([]*otlpmetrics.ResourceMetrics, newLen)
	for i, el := range *es.orig {
		wrappers[i] = &origs[i]
		newResourceMetrics(&el).CopyTo(newResourceMetrics(&wrappers[i]))
	}
	*dest.orig = wrappers
}

// Resize is an operation that resizes the slice:
// 1. If newLen is 0 then the slice is replaced with a nil slice.
// 2. If the newLen <= len then equivalent with slice[0:newLen].
// 3. If the newLen > len then (newLen - len) empty elements will be appended to the slice.
//
// Here is how a new ResourceMetricsSlice can be initialized:
// es := NewResourceMetricsSlice()
// es.Resize(4)
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     // Here should set all the values for e.
// }
func (es ResourceMetricsSlice) Resize(newLen int) {
	if newLen == 0 {
		(*es.orig) = []*otlpmetrics.ResourceMetrics(nil)
		return
	}
	oldLen := len(*es.orig)
	if newLen <= oldLen {
		(*es.orig) = (*es.orig)[:newLen]
		return
	}
	// TODO: Benchmark and optimize this logic.
	extraOrigs := make([]otlpmetrics.ResourceMetrics, newLen-oldLen)
	oldOrig := (*es.orig)
	for i := range extraOrigs {
		oldOrig = append(oldOrig, &extraOrigs[i])
	}
	(*es.orig) = oldOrig
}

// Append will increase the length of the ResourceMetricsSlice by one and set the
// given ResourceMetrics at that new position.  The original ResourceMetrics
// could still be referenced so do not reuse it after passing it to this
// method.
func (es ResourceMetricsSlice) Append(e ResourceMetrics) {
	*es.orig = append(*es.orig, *e.orig)
}

// InstrumentationLibraryMetrics is a collection of metrics from a LibraryInstrumentation.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewResourceMetrics function to create new instances.
// Important: zero-initialized instance is not valid for use.
type ResourceMetrics struct {
	// orig points to the pointer otlpmetrics.ResourceMetrics field contained somewhere else.
	// We use pointer-to-pointer to be able to modify it in InitEmpty func.
	orig **otlpmetrics.ResourceMetrics
}

func newResourceMetrics(orig **otlpmetrics.ResourceMetrics) ResourceMetrics {
	return ResourceMetrics{orig}
}

// NewResourceMetrics creates a new "nil" ResourceMetrics.
// To initialize the struct call "InitEmpty".
//
// This must be used only in testing code since no "Set" method available.
func NewResourceMetrics() ResourceMetrics {
	orig := (*otlpmetrics.ResourceMetrics)(nil)
	return newResourceMetrics(&orig)
}

// InitEmpty overwrites the current value with empty.
func (ms ResourceMetrics) InitEmpty() {
	*ms.orig = &otlpmetrics.ResourceMetrics{}
}

// IsNil returns true if the underlying data are nil.
//
// Important: All other functions will cause a runtime error if this returns "true".
func (ms ResourceMetrics) IsNil() bool {
	return *ms.orig == nil
}

// Resource returns the resource associated with this ResourceMetrics.
// If no resource available, it creates an empty message and associates it with this ResourceMetrics.
//
//  Empty initialized ResourceMetrics will return "nil" Resource.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms ResourceMetrics) Resource() Resource {
	return newResource(&(*ms.orig).Resource)
}

// InstrumentationLibraryMetrics returns the InstrumentationLibraryMetrics associated with this ResourceMetrics.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms ResourceMetrics) InstrumentationLibraryMetrics() InstrumentationLibraryMetricsSlice {
	return newInstrumentationLibraryMetricsSlice(&(*ms.orig).InstrumentationLibraryMetrics)
}

// CopyTo copies all properties from the current struct to the dest.
func (ms ResourceMetrics) CopyTo(dest ResourceMetrics) {
	if ms.IsNil() {
		*dest.orig = nil
		return
	}
	if dest.IsNil() {
		dest.InitEmpty()
	}
	ms.Resource().CopyTo(dest.Resource())
	ms.InstrumentationLibraryMetrics().CopyTo(dest.InstrumentationLibraryMetrics())
}

// InstrumentationLibraryMetricsSlice logically represents a slice of InstrumentationLibraryMetrics.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewInstrumentationLibraryMetricsSlice function to create new instances.
// Important: zero-initialized instance is not valid for use.
type InstrumentationLibraryMetricsSlice struct {
	// orig points to the slice otlpmetrics.InstrumentationLibraryMetrics field contained somewhere else.
	// We use pointer-to-slice to be able to modify it in functions like Resize.
	orig *[]*otlpmetrics.InstrumentationLibraryMetrics
}

func newInstrumentationLibraryMetricsSlice(orig *[]*otlpmetrics.InstrumentationLibraryMetrics) InstrumentationLibraryMetricsSlice {
	return InstrumentationLibraryMetricsSlice{orig}
}

// NewInstrumentationLibraryMetricsSlice creates a InstrumentationLibraryMetricsSlice with 0 elements.
// Can use "Resize" to initialize with a given length.
func NewInstrumentationLibraryMetricsSlice() InstrumentationLibraryMetricsSlice {
	orig := []*otlpmetrics.InstrumentationLibraryMetrics(nil)
	return InstrumentationLibraryMetricsSlice{&orig}
}

// Len returns the number of elements in the slice.
//
// Returns "0" for a newly instance created with "NewInstrumentationLibraryMetricsSlice()".
func (es InstrumentationLibraryMetricsSlice) Len() int {
	return len(*es.orig)
}

// At returns the element at the given index.
//
// This function is used mostly for iterating over all the values in the slice:
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     ... // Do something with the element
// }
func (es InstrumentationLibraryMetricsSlice) At(ix int) InstrumentationLibraryMetrics {
	return newInstrumentationLibraryMetrics(&(*es.orig)[ix])
}

// MoveAndAppendTo moves all elements from the current slice and appends them to the dest.
// The current slice will be cleared.
func (es InstrumentationLibraryMetricsSlice) MoveAndAppendTo(dest InstrumentationLibraryMetricsSlice) {
	if es.Len() == 0 {
		// Just to ensure that we always return a Slice with nil elements.
		*es.orig = nil
		return
	}
	if dest.Len() == 0 {
		*dest.orig = *es.orig
		*es.orig = nil
		return
	}
	*dest.orig = append(*dest.orig, *es.orig...)
	*es.orig = nil
	return
}

// CopyTo copies all elements from the current slice to the dest.
func (es InstrumentationLibraryMetricsSlice) CopyTo(dest InstrumentationLibraryMetricsSlice) {
	newLen := es.Len()
	if newLen == 0 {
		*dest.orig = []*otlpmetrics.InstrumentationLibraryMetrics(nil)
		return
	}
	oldLen := dest.Len()
	if newLen <= oldLen {
		(*dest.orig) = (*dest.orig)[:newLen]
		for i, el := range *es.orig {
			newInstrumentationLibraryMetrics(&el).CopyTo(newInstrumentationLibraryMetrics(&(*dest.orig)[i]))
		}
		return
	}
	origs := make([]otlpmetrics.InstrumentationLibraryMetrics, newLen)
	wrappers := make([]*otlpmetrics.InstrumentationLibraryMetrics, newLen)
	for i, el := range *es.orig {
		wrappers[i] = &origs[i]
		newInstrumentationLibraryMetrics(&el).CopyTo(newInstrumentationLibraryMetrics(&wrappers[i]))
	}
	*dest.orig = wrappers
}

// Resize is an operation that resizes the slice:
// 1. If newLen is 0 then the slice is replaced with a nil slice.
// 2. If the newLen <= len then equivalent with slice[0:newLen].
// 3. If the newLen > len then (newLen - len) empty elements will be appended to the slice.
//
// Here is how a new InstrumentationLibraryMetricsSlice can be initialized:
// es := NewInstrumentationLibraryMetricsSlice()
// es.Resize(4)
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     // Here should set all the values for e.
// }
func (es InstrumentationLibraryMetricsSlice) Resize(newLen int) {
	if newLen == 0 {
		(*es.orig) = []*otlpmetrics.InstrumentationLibraryMetrics(nil)
		return
	}
	oldLen := len(*es.orig)
	if newLen <= oldLen {
		(*es.orig) = (*es.orig)[:newLen]
		return
	}
	// TODO: Benchmark and optimize this logic.
	extraOrigs := make([]otlpmetrics.InstrumentationLibraryMetrics, newLen-oldLen)
	oldOrig := (*es.orig)
	for i := range extraOrigs {
		oldOrig = append(oldOrig, &extraOrigs[i])
	}
	(*es.orig) = oldOrig
}

// Append will increase the length of the InstrumentationLibraryMetricsSlice by one and set the
// given InstrumentationLibraryMetrics at that new position.  The original InstrumentationLibraryMetrics
// could still be referenced so do not reuse it after passing it to this
// method.
func (es InstrumentationLibraryMetricsSlice) Append(e InstrumentationLibraryMetrics) {
	*es.orig = append(*es.orig, *e.orig)
}

// InstrumentationLibraryMetrics is a collection of metrics from a LibraryInstrumentation.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewInstrumentationLibraryMetrics function to create new instances.
// Important: zero-initialized instance is not valid for use.
type InstrumentationLibraryMetrics struct {
	// orig points to the pointer otlpmetrics.InstrumentationLibraryMetrics field contained somewhere else.
	// We use pointer-to-pointer to be able to modify it in InitEmpty func.
	orig **otlpmetrics.InstrumentationLibraryMetrics
}

func newInstrumentationLibraryMetrics(orig **otlpmetrics.InstrumentationLibraryMetrics) InstrumentationLibraryMetrics {
	return InstrumentationLibraryMetrics{orig}
}

// NewInstrumentationLibraryMetrics creates a new "nil" InstrumentationLibraryMetrics.
// To initialize the struct call "InitEmpty".
//
// This must be used only in testing code since no "Set" method available.
func NewInstrumentationLibraryMetrics() InstrumentationLibraryMetrics {
	orig := (*otlpmetrics.InstrumentationLibraryMetrics)(nil)
	return newInstrumentationLibraryMetrics(&orig)
}

// InitEmpty overwrites the current value with empty.
func (ms InstrumentationLibraryMetrics) InitEmpty() {
	*ms.orig = &otlpmetrics.InstrumentationLibraryMetrics{}
}

// IsNil returns true if the underlying data are nil.
//
// Important: All other functions will cause a runtime error if this returns "true".
func (ms InstrumentationLibraryMetrics) IsNil() bool {
	return *ms.orig == nil
}

// InstrumentationLibrary returns the instrumentationlibrary associated with this InstrumentationLibraryMetrics.
// If no instrumentationlibrary available, it creates an empty message and associates it with this InstrumentationLibraryMetrics.
//
//  Empty initialized InstrumentationLibraryMetrics will return "nil" InstrumentationLibrary.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms InstrumentationLibraryMetrics) InstrumentationLibrary() InstrumentationLibrary {
	return newInstrumentationLibrary(&(*ms.orig).InstrumentationLibrary)
}

// Metrics returns the Metrics associated with this InstrumentationLibraryMetrics.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms InstrumentationLibraryMetrics) Metrics() MetricSlice {
	return newMetricSlice(&(*ms.orig).Metrics)
}

// CopyTo copies all properties from the current struct to the dest.
func (ms InstrumentationLibraryMetrics) CopyTo(dest InstrumentationLibraryMetrics) {
	if ms.IsNil() {
		*dest.orig = nil
		return
	}
	if dest.IsNil() {
		dest.InitEmpty()
	}
	ms.InstrumentationLibrary().CopyTo(dest.InstrumentationLibrary())
	ms.Metrics().CopyTo(dest.Metrics())
}

// MetricSlice logically represents a slice of Metric.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewMetricSlice function to create new instances.
// Important: zero-initialized instance is not valid for use.
type MetricSlice struct {
	// orig points to the slice otlpmetrics.Metric field contained somewhere else.
	// We use pointer-to-slice to be able to modify it in functions like Resize.
	orig *[]*otlpmetrics.Metric
}

func newMetricSlice(orig *[]*otlpmetrics.Metric) MetricSlice {
	return MetricSlice{orig}
}

// NewMetricSlice creates a MetricSlice with 0 elements.
// Can use "Resize" to initialize with a given length.
func NewMetricSlice() MetricSlice {
	orig := []*otlpmetrics.Metric(nil)
	return MetricSlice{&orig}
}

// Len returns the number of elements in the slice.
//
// Returns "0" for a newly instance created with "NewMetricSlice()".
func (es MetricSlice) Len() int {
	return len(*es.orig)
}

// At returns the element at the given index.
//
// This function is used mostly for iterating over all the values in the slice:
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     ... // Do something with the element
// }
func (es MetricSlice) At(ix int) Metric {
	return newMetric(&(*es.orig)[ix])
}

// MoveAndAppendTo moves all elements from the current slice and appends them to the dest.
// The current slice will be cleared.
func (es MetricSlice) MoveAndAppendTo(dest MetricSlice) {
	if es.Len() == 0 {
		// Just to ensure that we always return a Slice with nil elements.
		*es.orig = nil
		return
	}
	if dest.Len() == 0 {
		*dest.orig = *es.orig
		*es.orig = nil
		return
	}
	*dest.orig = append(*dest.orig, *es.orig...)
	*es.orig = nil
	return
}

// CopyTo copies all elements from the current slice to the dest.
func (es MetricSlice) CopyTo(dest MetricSlice) {
	newLen := es.Len()
	if newLen == 0 {
		*dest.orig = []*otlpmetrics.Metric(nil)
		return
	}
	oldLen := dest.Len()
	if newLen <= oldLen {
		(*dest.orig) = (*dest.orig)[:newLen]
		for i, el := range *es.orig {
			newMetric(&el).CopyTo(newMetric(&(*dest.orig)[i]))
		}
		return
	}
	origs := make([]otlpmetrics.Metric, newLen)
	wrappers := make([]*otlpmetrics.Metric, newLen)
	for i, el := range *es.orig {
		wrappers[i] = &origs[i]
		newMetric(&el).CopyTo(newMetric(&wrappers[i]))
	}
	*dest.orig = wrappers
}

// Resize is an operation that resizes the slice:
// 1. If newLen is 0 then the slice is replaced with a nil slice.
// 2. If the newLen <= len then equivalent with slice[0:newLen].
// 3. If the newLen > len then (newLen - len) empty elements will be appended to the slice.
//
// Here is how a new MetricSlice can be initialized:
// es := NewMetricSlice()
// es.Resize(4)
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     // Here should set all the values for e.
// }
func (es MetricSlice) Resize(newLen int) {
	if newLen == 0 {
		(*es.orig) = []*otlpmetrics.Metric(nil)
		return
	}
	oldLen := len(*es.orig)
	if newLen <= oldLen {
		(*es.orig) = (*es.orig)[:newLen]
		return
	}
	// TODO: Benchmark and optimize this logic.
	extraOrigs := make([]otlpmetrics.Metric, newLen-oldLen)
	oldOrig := (*es.orig)
	for i := range extraOrigs {
		oldOrig = append(oldOrig, &extraOrigs[i])
	}
	(*es.orig) = oldOrig
}

// Append will increase the length of the MetricSlice by one and set the
// given Metric at that new position.  The original Metric
// could still be referenced so do not reuse it after passing it to this
// method.
func (es MetricSlice) Append(e Metric) {
	*es.orig = append(*es.orig, *e.orig)
}

// Metric represents one metric as a collection of datapoints.
// See Metric definition in OTLP: https://github.com/open-telemetry/opentelemetry-proto/blob/master/opentelemetry/proto/metrics/v1/metrics.proto
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewMetric function to create new instances.
// Important: zero-initialized instance is not valid for use.
type Metric struct {
	// orig points to the pointer otlpmetrics.Metric field contained somewhere else.
	// We use pointer-to-pointer to be able to modify it in InitEmpty func.
	orig **otlpmetrics.Metric
}

func newMetric(orig **otlpmetrics.Metric) Metric {
	return Metric{orig}
}

// NewMetric creates a new "nil" Metric.
// To initialize the struct call "InitEmpty".
//
// This must be used only in testing code since no "Set" method available.
func NewMetric() Metric {
	orig := (*otlpmetrics.Metric)(nil)
	return newMetric(&orig)
}

// InitEmpty overwrites the current value with empty.
func (ms Metric) InitEmpty() {
	*ms.orig = &otlpmetrics.Metric{}
}

// IsNil returns true if the underlying data are nil.
//
// Important: All other functions will cause a runtime error if this returns "true".
func (ms Metric) IsNil() bool {
	return *ms.orig == nil
}

// Name returns the name associated with this Metric.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms Metric) Name() string {
	return (*ms.orig).Name
}

// SetName replaces the name associated with this Metric.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms Metric) SetName(v string) {
	(*ms.orig).Name = v
}

// Description returns the description associated with this Metric.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms Metric) Description() string {
	return (*ms.orig).Description
}

// SetDescription replaces the description associated with this Metric.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms Metric) SetDescription(v string) {
	(*ms.orig).Description = v
}

// Unit returns the unit associated with this Metric.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms Metric) Unit() string {
	return (*ms.orig).Unit
}

// SetUnit replaces the unit associated with this Metric.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms Metric) SetUnit(v string) {
	(*ms.orig).Unit = v
}

// CopyTo copies all properties from the current struct to the dest.
func (ms Metric) CopyTo(dest Metric) {
	if ms.IsNil() {
		*dest.orig = nil
		return
	}
	if dest.IsNil() {
		dest.InitEmpty()
	}
	dest.SetName(ms.Name())
	dest.SetDescription(ms.Description())
	dest.SetUnit(ms.Unit())
	copyData((*ms.orig), (*dest.orig))
}

// IntGauge represents the type of a int scalar metric that always exports the "current value" for every data point.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewIntGauge function to create new instances.
// Important: zero-initialized instance is not valid for use.
type IntGauge struct {
	// orig points to the pointer otlpmetrics.IntGauge field contained somewhere else.
	// We use pointer-to-pointer to be able to modify it in InitEmpty func.
	orig **otlpmetrics.IntGauge
}

func newIntGauge(orig **otlpmetrics.IntGauge) IntGauge {
	return IntGauge{orig}
}

// NewIntGauge creates a new "nil" IntGauge.
// To initialize the struct call "InitEmpty".
//
// This must be used only in testing code since no "Set" method available.
func NewIntGauge() IntGauge {
	orig := (*otlpmetrics.IntGauge)(nil)
	return newIntGauge(&orig)
}

// InitEmpty overwrites the current value with empty.
func (ms IntGauge) InitEmpty() {
	*ms.orig = &otlpmetrics.IntGauge{}
}

// IsNil returns true if the underlying data are nil.
//
// Important: All other functions will cause a runtime error if this returns "true".
func (ms IntGauge) IsNil() bool {
	return *ms.orig == nil
}

// DataPoints returns the DataPoints associated with this IntGauge.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms IntGauge) DataPoints() IntDataPointSlice {
	return newIntDataPointSlice(&(*ms.orig).DataPoints)
}

// CopyTo copies all properties from the current struct to the dest.
func (ms IntGauge) CopyTo(dest IntGauge) {
	if ms.IsNil() {
		*dest.orig = nil
		return
	}
	if dest.IsNil() {
		dest.InitEmpty()
	}
	ms.DataPoints().CopyTo(dest.DataPoints())
}

// DoubleGauge represents the type of a double scalar metric that always exports the "current value" for every data point.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewDoubleGauge function to create new instances.
// Important: zero-initialized instance is not valid for use.
type DoubleGauge struct {
	// orig points to the pointer otlpmetrics.DoubleGauge field contained somewhere else.
	// We use pointer-to-pointer to be able to modify it in InitEmpty func.
	orig **otlpmetrics.DoubleGauge
}

func newDoubleGauge(orig **otlpmetrics.DoubleGauge) DoubleGauge {
	return DoubleGauge{orig}
}

// NewDoubleGauge creates a new "nil" DoubleGauge.
// To initialize the struct call "InitEmpty".
//
// This must be used only in testing code since no "Set" method available.
func NewDoubleGauge() DoubleGauge {
	orig := (*otlpmetrics.DoubleGauge)(nil)
	return newDoubleGauge(&orig)
}

// InitEmpty overwrites the current value with empty.
func (ms DoubleGauge) InitEmpty() {
	*ms.orig = &otlpmetrics.DoubleGauge{}
}

// IsNil returns true if the underlying data are nil.
//
// Important: All other functions will cause a runtime error if this returns "true".
func (ms DoubleGauge) IsNil() bool {
	return *ms.orig == nil
}

// DataPoints returns the DataPoints associated with this DoubleGauge.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms DoubleGauge) DataPoints() DoubleDataPointSlice {
	return newDoubleDataPointSlice(&(*ms.orig).DataPoints)
}

// CopyTo copies all properties from the current struct to the dest.
func (ms DoubleGauge) CopyTo(dest DoubleGauge) {
	if ms.IsNil() {
		*dest.orig = nil
		return
	}
	if dest.IsNil() {
		dest.InitEmpty()
	}
	ms.DataPoints().CopyTo(dest.DataPoints())
}

// IntSum represents the type of a numeric int scalar metric that is calculated as a sum of all reported measurements over a time interval.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewIntSum function to create new instances.
// Important: zero-initialized instance is not valid for use.
type IntSum struct {
	// orig points to the pointer otlpmetrics.IntSum field contained somewhere else.
	// We use pointer-to-pointer to be able to modify it in InitEmpty func.
	orig **otlpmetrics.IntSum
}

func newIntSum(orig **otlpmetrics.IntSum) IntSum {
	return IntSum{orig}
}

// NewIntSum creates a new "nil" IntSum.
// To initialize the struct call "InitEmpty".
//
// This must be used only in testing code since no "Set" method available.
func NewIntSum() IntSum {
	orig := (*otlpmetrics.IntSum)(nil)
	return newIntSum(&orig)
}

// InitEmpty overwrites the current value with empty.
func (ms IntSum) InitEmpty() {
	*ms.orig = &otlpmetrics.IntSum{}
}

// IsNil returns true if the underlying data are nil.
//
// Important: All other functions will cause a runtime error if this returns "true".
func (ms IntSum) IsNil() bool {
	return *ms.orig == nil
}

// AggregationTemporality returns the aggregationtemporality associated with this IntSum.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms IntSum) AggregationTemporality() AggregationTemporality {
	return AggregationTemporality((*ms.orig).AggregationTemporality)
}

// SetAggregationTemporality replaces the aggregationtemporality associated with this IntSum.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms IntSum) SetAggregationTemporality(v AggregationTemporality) {
	(*ms.orig).AggregationTemporality = otlpmetrics.AggregationTemporality(v)
}

// IsMonotonic returns the ismonotonic associated with this IntSum.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms IntSum) IsMonotonic() bool {
	return (*ms.orig).IsMonotonic
}

// SetIsMonotonic replaces the ismonotonic associated with this IntSum.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms IntSum) SetIsMonotonic(v bool) {
	(*ms.orig).IsMonotonic = v
}

// DataPoints returns the DataPoints associated with this IntSum.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms IntSum) DataPoints() IntDataPointSlice {
	return newIntDataPointSlice(&(*ms.orig).DataPoints)
}

// CopyTo copies all properties from the current struct to the dest.
func (ms IntSum) CopyTo(dest IntSum) {
	if ms.IsNil() {
		*dest.orig = nil
		return
	}
	if dest.IsNil() {
		dest.InitEmpty()
	}
	dest.SetAggregationTemporality(ms.AggregationTemporality())
	dest.SetIsMonotonic(ms.IsMonotonic())
	ms.DataPoints().CopyTo(dest.DataPoints())
}

// DoubleSum represents the type of a numeric double scalar metric that is calculated as a sum of all reported measurements over a time interval.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewDoubleSum function to create new instances.
// Important: zero-initialized instance is not valid for use.
type DoubleSum struct {
	// orig points to the pointer otlpmetrics.DoubleSum field contained somewhere else.
	// We use pointer-to-pointer to be able to modify it in InitEmpty func.
	orig **otlpmetrics.DoubleSum
}

func newDoubleSum(orig **otlpmetrics.DoubleSum) DoubleSum {
	return DoubleSum{orig}
}

// NewDoubleSum creates a new "nil" DoubleSum.
// To initialize the struct call "InitEmpty".
//
// This must be used only in testing code since no "Set" method available.
func NewDoubleSum() DoubleSum {
	orig := (*otlpmetrics.DoubleSum)(nil)
	return newDoubleSum(&orig)
}

// InitEmpty overwrites the current value with empty.
func (ms DoubleSum) InitEmpty() {
	*ms.orig = &otlpmetrics.DoubleSum{}
}

// IsNil returns true if the underlying data are nil.
//
// Important: All other functions will cause a runtime error if this returns "true".
func (ms DoubleSum) IsNil() bool {
	return *ms.orig == nil
}

// AggregationTemporality returns the aggregationtemporality associated with this DoubleSum.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms DoubleSum) AggregationTemporality() AggregationTemporality {
	return AggregationTemporality((*ms.orig).AggregationTemporality)
}

// SetAggregationTemporality replaces the aggregationtemporality associated with this DoubleSum.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms DoubleSum) SetAggregationTemporality(v AggregationTemporality) {
	(*ms.orig).AggregationTemporality = otlpmetrics.AggregationTemporality(v)
}

// IsMonotonic returns the ismonotonic associated with this DoubleSum.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms DoubleSum) IsMonotonic() bool {
	return (*ms.orig).IsMonotonic
}

// SetIsMonotonic replaces the ismonotonic associated with this DoubleSum.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms DoubleSum) SetIsMonotonic(v bool) {
	(*ms.orig).IsMonotonic = v
}

// DataPoints returns the DataPoints associated with this DoubleSum.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms DoubleSum) DataPoints() DoubleDataPointSlice {
	return newDoubleDataPointSlice(&(*ms.orig).DataPoints)
}

// CopyTo copies all properties from the current struct to the dest.
func (ms DoubleSum) CopyTo(dest DoubleSum) {
	if ms.IsNil() {
		*dest.orig = nil
		return
	}
	if dest.IsNil() {
		dest.InitEmpty()
	}
	dest.SetAggregationTemporality(ms.AggregationTemporality())
	dest.SetIsMonotonic(ms.IsMonotonic())
	ms.DataPoints().CopyTo(dest.DataPoints())
}

// IntHistogram represents the type of a metric that is calculated by aggregating as a Histogram of all reported double measurements over a time interval.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewIntHistogram function to create new instances.
// Important: zero-initialized instance is not valid for use.
type IntHistogram struct {
	// orig points to the pointer otlpmetrics.IntHistogram field contained somewhere else.
	// We use pointer-to-pointer to be able to modify it in InitEmpty func.
	orig **otlpmetrics.IntHistogram
}

func newIntHistogram(orig **otlpmetrics.IntHistogram) IntHistogram {
	return IntHistogram{orig}
}

// NewIntHistogram creates a new "nil" IntHistogram.
// To initialize the struct call "InitEmpty".
//
// This must be used only in testing code since no "Set" method available.
func NewIntHistogram() IntHistogram {
	orig := (*otlpmetrics.IntHistogram)(nil)
	return newIntHistogram(&orig)
}

// InitEmpty overwrites the current value with empty.
func (ms IntHistogram) InitEmpty() {
	*ms.orig = &otlpmetrics.IntHistogram{}
}

// IsNil returns true if the underlying data are nil.
//
// Important: All other functions will cause a runtime error if this returns "true".
func (ms IntHistogram) IsNil() bool {
	return *ms.orig == nil
}

// AggregationTemporality returns the aggregationtemporality associated with this IntHistogram.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms IntHistogram) AggregationTemporality() AggregationTemporality {
	return AggregationTemporality((*ms.orig).AggregationTemporality)
}

// SetAggregationTemporality replaces the aggregationtemporality associated with this IntHistogram.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms IntHistogram) SetAggregationTemporality(v AggregationTemporality) {
	(*ms.orig).AggregationTemporality = otlpmetrics.AggregationTemporality(v)
}

// DataPoints returns the DataPoints associated with this IntHistogram.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms IntHistogram) DataPoints() IntHistogramDataPointSlice {
	return newIntHistogramDataPointSlice(&(*ms.orig).DataPoints)
}

// CopyTo copies all properties from the current struct to the dest.
func (ms IntHistogram) CopyTo(dest IntHistogram) {
	if ms.IsNil() {
		*dest.orig = nil
		return
	}
	if dest.IsNil() {
		dest.InitEmpty()
	}
	dest.SetAggregationTemporality(ms.AggregationTemporality())
	ms.DataPoints().CopyTo(dest.DataPoints())
}

// DoubleHistogram represents the type of a metric that is calculated by aggregating as a Histogram of all reported double measurements over a time interval.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewDoubleHistogram function to create new instances.
// Important: zero-initialized instance is not valid for use.
type DoubleHistogram struct {
	// orig points to the pointer otlpmetrics.DoubleHistogram field contained somewhere else.
	// We use pointer-to-pointer to be able to modify it in InitEmpty func.
	orig **otlpmetrics.DoubleHistogram
}

func newDoubleHistogram(orig **otlpmetrics.DoubleHistogram) DoubleHistogram {
	return DoubleHistogram{orig}
}

// NewDoubleHistogram creates a new "nil" DoubleHistogram.
// To initialize the struct call "InitEmpty".
//
// This must be used only in testing code since no "Set" method available.
func NewDoubleHistogram() DoubleHistogram {
	orig := (*otlpmetrics.DoubleHistogram)(nil)
	return newDoubleHistogram(&orig)
}

// InitEmpty overwrites the current value with empty.
func (ms DoubleHistogram) InitEmpty() {
	*ms.orig = &otlpmetrics.DoubleHistogram{}
}

// IsNil returns true if the underlying data are nil.
//
// Important: All other functions will cause a runtime error if this returns "true".
func (ms DoubleHistogram) IsNil() bool {
	return *ms.orig == nil
}

// AggregationTemporality returns the aggregationtemporality associated with this DoubleHistogram.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms DoubleHistogram) AggregationTemporality() AggregationTemporality {
	return AggregationTemporality((*ms.orig).AggregationTemporality)
}

// SetAggregationTemporality replaces the aggregationtemporality associated with this DoubleHistogram.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms DoubleHistogram) SetAggregationTemporality(v AggregationTemporality) {
	(*ms.orig).AggregationTemporality = otlpmetrics.AggregationTemporality(v)
}

// DataPoints returns the DataPoints associated with this DoubleHistogram.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms DoubleHistogram) DataPoints() DoubleHistogramDataPointSlice {
	return newDoubleHistogramDataPointSlice(&(*ms.orig).DataPoints)
}

// CopyTo copies all properties from the current struct to the dest.
func (ms DoubleHistogram) CopyTo(dest DoubleHistogram) {
	if ms.IsNil() {
		*dest.orig = nil
		return
	}
	if dest.IsNil() {
		dest.InitEmpty()
	}
	dest.SetAggregationTemporality(ms.AggregationTemporality())
	ms.DataPoints().CopyTo(dest.DataPoints())
}

// IntDataPointSlice logically represents a slice of IntDataPoint.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewIntDataPointSlice function to create new instances.
// Important: zero-initialized instance is not valid for use.
type IntDataPointSlice struct {
	// orig points to the slice otlpmetrics.IntDataPoint field contained somewhere else.
	// We use pointer-to-slice to be able to modify it in functions like Resize.
	orig *[]*otlpmetrics.IntDataPoint
}

func newIntDataPointSlice(orig *[]*otlpmetrics.IntDataPoint) IntDataPointSlice {
	return IntDataPointSlice{orig}
}

// NewIntDataPointSlice creates a IntDataPointSlice with 0 elements.
// Can use "Resize" to initialize with a given length.
func NewIntDataPointSlice() IntDataPointSlice {
	orig := []*otlpmetrics.IntDataPoint(nil)
	return IntDataPointSlice{&orig}
}

// Len returns the number of elements in the slice.
//
// Returns "0" for a newly instance created with "NewIntDataPointSlice()".
func (es IntDataPointSlice) Len() int {
	return len(*es.orig)
}

// At returns the element at the given index.
//
// This function is used mostly for iterating over all the values in the slice:
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     ... // Do something with the element
// }
func (es IntDataPointSlice) At(ix int) IntDataPoint {
	return newIntDataPoint(&(*es.orig)[ix])
}

// MoveAndAppendTo moves all elements from the current slice and appends them to the dest.
// The current slice will be cleared.
func (es IntDataPointSlice) MoveAndAppendTo(dest IntDataPointSlice) {
	if es.Len() == 0 {
		// Just to ensure that we always return a Slice with nil elements.
		*es.orig = nil
		return
	}
	if dest.Len() == 0 {
		*dest.orig = *es.orig
		*es.orig = nil
		return
	}
	*dest.orig = append(*dest.orig, *es.orig...)
	*es.orig = nil
	return
}

// CopyTo copies all elements from the current slice to the dest.
func (es IntDataPointSlice) CopyTo(dest IntDataPointSlice) {
	newLen := es.Len()
	if newLen == 0 {
		*dest.orig = []*otlpmetrics.IntDataPoint(nil)
		return
	}
	oldLen := dest.Len()
	if newLen <= oldLen {
		(*dest.orig) = (*dest.orig)[:newLen]
		for i, el := range *es.orig {
			newIntDataPoint(&el).CopyTo(newIntDataPoint(&(*dest.orig)[i]))
		}
		return
	}
	origs := make([]otlpmetrics.IntDataPoint, newLen)
	wrappers := make([]*otlpmetrics.IntDataPoint, newLen)
	for i, el := range *es.orig {
		wrappers[i] = &origs[i]
		newIntDataPoint(&el).CopyTo(newIntDataPoint(&wrappers[i]))
	}
	*dest.orig = wrappers
}

// Resize is an operation that resizes the slice:
// 1. If newLen is 0 then the slice is replaced with a nil slice.
// 2. If the newLen <= len then equivalent with slice[0:newLen].
// 3. If the newLen > len then (newLen - len) empty elements will be appended to the slice.
//
// Here is how a new IntDataPointSlice can be initialized:
// es := NewIntDataPointSlice()
// es.Resize(4)
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     // Here should set all the values for e.
// }
func (es IntDataPointSlice) Resize(newLen int) {
	if newLen == 0 {
		(*es.orig) = []*otlpmetrics.IntDataPoint(nil)
		return
	}
	oldLen := len(*es.orig)
	if newLen <= oldLen {
		(*es.orig) = (*es.orig)[:newLen]
		return
	}
	// TODO: Benchmark and optimize this logic.
	extraOrigs := make([]otlpmetrics.IntDataPoint, newLen-oldLen)
	oldOrig := (*es.orig)
	for i := range extraOrigs {
		oldOrig = append(oldOrig, &extraOrigs[i])
	}
	(*es.orig) = oldOrig
}

// Append will increase the length of the IntDataPointSlice by one and set the
// given IntDataPoint at that new position.  The original IntDataPoint
// could still be referenced so do not reuse it after passing it to this
// method.
func (es IntDataPointSlice) Append(e IntDataPoint) {
	*es.orig = append(*es.orig, *e.orig)
}

// IntDataPoint is a single data point in a timeseries that describes the time-varying values of a scalar int metric.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewIntDataPoint function to create new instances.
// Important: zero-initialized instance is not valid for use.
type IntDataPoint struct {
	// orig points to the pointer otlpmetrics.IntDataPoint field contained somewhere else.
	// We use pointer-to-pointer to be able to modify it in InitEmpty func.
	orig **otlpmetrics.IntDataPoint
}

func newIntDataPoint(orig **otlpmetrics.IntDataPoint) IntDataPoint {
	return IntDataPoint{orig}
}

// NewIntDataPoint creates a new "nil" IntDataPoint.
// To initialize the struct call "InitEmpty".
//
// This must be used only in testing code since no "Set" method available.
func NewIntDataPoint() IntDataPoint {
	orig := (*otlpmetrics.IntDataPoint)(nil)
	return newIntDataPoint(&orig)
}

// InitEmpty overwrites the current value with empty.
func (ms IntDataPoint) InitEmpty() {
	*ms.orig = &otlpmetrics.IntDataPoint{}
}

// IsNil returns true if the underlying data are nil.
//
// Important: All other functions will cause a runtime error if this returns "true".
func (ms IntDataPoint) IsNil() bool {
	return *ms.orig == nil
}

// LabelsMap returns the Labels associated with this IntDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms IntDataPoint) LabelsMap() StringMap {
	return newStringMap(&(*ms.orig).Labels)
}

// StartTime returns the starttime associated with this IntDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms IntDataPoint) StartTime() TimestampUnixNano {
	return TimestampUnixNano((*ms.orig).StartTimeUnixNano)
}

// SetStartTime replaces the starttime associated with this IntDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms IntDataPoint) SetStartTime(v TimestampUnixNano) {
	(*ms.orig).StartTimeUnixNano = uint64(v)
}

// Timestamp returns the timestamp associated with this IntDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms IntDataPoint) Timestamp() TimestampUnixNano {
	return TimestampUnixNano((*ms.orig).TimeUnixNano)
}

// SetTimestamp replaces the timestamp associated with this IntDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms IntDataPoint) SetTimestamp(v TimestampUnixNano) {
	(*ms.orig).TimeUnixNano = uint64(v)
}

// Value returns the value associated with this IntDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms IntDataPoint) Value() int64 {
	return (*ms.orig).Value
}

// SetValue replaces the value associated with this IntDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms IntDataPoint) SetValue(v int64) {
	(*ms.orig).Value = v
}

// Exemplars returns the Exemplars associated with this IntDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms IntDataPoint) Exemplars() IntExemplarSlice {
	return newIntExemplarSlice(&(*ms.orig).Exemplars)
}

// CopyTo copies all properties from the current struct to the dest.
func (ms IntDataPoint) CopyTo(dest IntDataPoint) {
	if ms.IsNil() {
		*dest.orig = nil
		return
	}
	if dest.IsNil() {
		dest.InitEmpty()
	}
	ms.LabelsMap().CopyTo(dest.LabelsMap())
	dest.SetStartTime(ms.StartTime())
	dest.SetTimestamp(ms.Timestamp())
	dest.SetValue(ms.Value())
	ms.Exemplars().CopyTo(dest.Exemplars())
}

// DoubleDataPointSlice logically represents a slice of DoubleDataPoint.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewDoubleDataPointSlice function to create new instances.
// Important: zero-initialized instance is not valid for use.
type DoubleDataPointSlice struct {
	// orig points to the slice otlpmetrics.DoubleDataPoint field contained somewhere else.
	// We use pointer-to-slice to be able to modify it in functions like Resize.
	orig *[]*otlpmetrics.DoubleDataPoint
}

func newDoubleDataPointSlice(orig *[]*otlpmetrics.DoubleDataPoint) DoubleDataPointSlice {
	return DoubleDataPointSlice{orig}
}

// NewDoubleDataPointSlice creates a DoubleDataPointSlice with 0 elements.
// Can use "Resize" to initialize with a given length.
func NewDoubleDataPointSlice() DoubleDataPointSlice {
	orig := []*otlpmetrics.DoubleDataPoint(nil)
	return DoubleDataPointSlice{&orig}
}

// Len returns the number of elements in the slice.
//
// Returns "0" for a newly instance created with "NewDoubleDataPointSlice()".
func (es DoubleDataPointSlice) Len() int {
	return len(*es.orig)
}

// At returns the element at the given index.
//
// This function is used mostly for iterating over all the values in the slice:
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     ... // Do something with the element
// }
func (es DoubleDataPointSlice) At(ix int) DoubleDataPoint {
	return newDoubleDataPoint(&(*es.orig)[ix])
}

// MoveAndAppendTo moves all elements from the current slice and appends them to the dest.
// The current slice will be cleared.
func (es DoubleDataPointSlice) MoveAndAppendTo(dest DoubleDataPointSlice) {
	if es.Len() == 0 {
		// Just to ensure that we always return a Slice with nil elements.
		*es.orig = nil
		return
	}
	if dest.Len() == 0 {
		*dest.orig = *es.orig
		*es.orig = nil
		return
	}
	*dest.orig = append(*dest.orig, *es.orig...)
	*es.orig = nil
	return
}

// CopyTo copies all elements from the current slice to the dest.
func (es DoubleDataPointSlice) CopyTo(dest DoubleDataPointSlice) {
	newLen := es.Len()
	if newLen == 0 {
		*dest.orig = []*otlpmetrics.DoubleDataPoint(nil)
		return
	}
	oldLen := dest.Len()
	if newLen <= oldLen {
		(*dest.orig) = (*dest.orig)[:newLen]
		for i, el := range *es.orig {
			newDoubleDataPoint(&el).CopyTo(newDoubleDataPoint(&(*dest.orig)[i]))
		}
		return
	}
	origs := make([]otlpmetrics.DoubleDataPoint, newLen)
	wrappers := make([]*otlpmetrics.DoubleDataPoint, newLen)
	for i, el := range *es.orig {
		wrappers[i] = &origs[i]
		newDoubleDataPoint(&el).CopyTo(newDoubleDataPoint(&wrappers[i]))
	}
	*dest.orig = wrappers
}

// Resize is an operation that resizes the slice:
// 1. If newLen is 0 then the slice is replaced with a nil slice.
// 2. If the newLen <= len then equivalent with slice[0:newLen].
// 3. If the newLen > len then (newLen - len) empty elements will be appended to the slice.
//
// Here is how a new DoubleDataPointSlice can be initialized:
// es := NewDoubleDataPointSlice()
// es.Resize(4)
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     // Here should set all the values for e.
// }
func (es DoubleDataPointSlice) Resize(newLen int) {
	if newLen == 0 {
		(*es.orig) = []*otlpmetrics.DoubleDataPoint(nil)
		return
	}
	oldLen := len(*es.orig)
	if newLen <= oldLen {
		(*es.orig) = (*es.orig)[:newLen]
		return
	}
	// TODO: Benchmark and optimize this logic.
	extraOrigs := make([]otlpmetrics.DoubleDataPoint, newLen-oldLen)
	oldOrig := (*es.orig)
	for i := range extraOrigs {
		oldOrig = append(oldOrig, &extraOrigs[i])
	}
	(*es.orig) = oldOrig
}

// Append will increase the length of the DoubleDataPointSlice by one and set the
// given DoubleDataPoint at that new position.  The original DoubleDataPoint
// could still be referenced so do not reuse it after passing it to this
// method.
func (es DoubleDataPointSlice) Append(e DoubleDataPoint) {
	*es.orig = append(*es.orig, *e.orig)
}

// DoubleDataPoint is a single data point in a timeseries that describes the time-varying value of a double metric.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewDoubleDataPoint function to create new instances.
// Important: zero-initialized instance is not valid for use.
type DoubleDataPoint struct {
	// orig points to the pointer otlpmetrics.DoubleDataPoint field contained somewhere else.
	// We use pointer-to-pointer to be able to modify it in InitEmpty func.
	orig **otlpmetrics.DoubleDataPoint
}

func newDoubleDataPoint(orig **otlpmetrics.DoubleDataPoint) DoubleDataPoint {
	return DoubleDataPoint{orig}
}

// NewDoubleDataPoint creates a new "nil" DoubleDataPoint.
// To initialize the struct call "InitEmpty".
//
// This must be used only in testing code since no "Set" method available.
func NewDoubleDataPoint() DoubleDataPoint {
	orig := (*otlpmetrics.DoubleDataPoint)(nil)
	return newDoubleDataPoint(&orig)
}

// InitEmpty overwrites the current value with empty.
func (ms DoubleDataPoint) InitEmpty() {
	*ms.orig = &otlpmetrics.DoubleDataPoint{}
}

// IsNil returns true if the underlying data are nil.
//
// Important: All other functions will cause a runtime error if this returns "true".
func (ms DoubleDataPoint) IsNil() bool {
	return *ms.orig == nil
}

// LabelsMap returns the Labels associated with this DoubleDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms DoubleDataPoint) LabelsMap() StringMap {
	return newStringMap(&(*ms.orig).Labels)
}

// StartTime returns the starttime associated with this DoubleDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms DoubleDataPoint) StartTime() TimestampUnixNano {
	return TimestampUnixNano((*ms.orig).StartTimeUnixNano)
}

// SetStartTime replaces the starttime associated with this DoubleDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms DoubleDataPoint) SetStartTime(v TimestampUnixNano) {
	(*ms.orig).StartTimeUnixNano = uint64(v)
}

// Timestamp returns the timestamp associated with this DoubleDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms DoubleDataPoint) Timestamp() TimestampUnixNano {
	return TimestampUnixNano((*ms.orig).TimeUnixNano)
}

// SetTimestamp replaces the timestamp associated with this DoubleDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms DoubleDataPoint) SetTimestamp(v TimestampUnixNano) {
	(*ms.orig).TimeUnixNano = uint64(v)
}

// Value returns the value associated with this DoubleDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms DoubleDataPoint) Value() float64 {
	return (*ms.orig).Value
}

// SetValue replaces the value associated with this DoubleDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms DoubleDataPoint) SetValue(v float64) {
	(*ms.orig).Value = v
}

// Exemplars returns the Exemplars associated with this DoubleDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms DoubleDataPoint) Exemplars() DoubleExemplarSlice {
	return newDoubleExemplarSlice(&(*ms.orig).Exemplars)
}

// CopyTo copies all properties from the current struct to the dest.
func (ms DoubleDataPoint) CopyTo(dest DoubleDataPoint) {
	if ms.IsNil() {
		*dest.orig = nil
		return
	}
	if dest.IsNil() {
		dest.InitEmpty()
	}
	ms.LabelsMap().CopyTo(dest.LabelsMap())
	dest.SetStartTime(ms.StartTime())
	dest.SetTimestamp(ms.Timestamp())
	dest.SetValue(ms.Value())
	ms.Exemplars().CopyTo(dest.Exemplars())
}

// IntHistogramDataPointSlice logically represents a slice of IntHistogramDataPoint.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewIntHistogramDataPointSlice function to create new instances.
// Important: zero-initialized instance is not valid for use.
type IntHistogramDataPointSlice struct {
	// orig points to the slice otlpmetrics.IntHistogramDataPoint field contained somewhere else.
	// We use pointer-to-slice to be able to modify it in functions like Resize.
	orig *[]*otlpmetrics.IntHistogramDataPoint
}

func newIntHistogramDataPointSlice(orig *[]*otlpmetrics.IntHistogramDataPoint) IntHistogramDataPointSlice {
	return IntHistogramDataPointSlice{orig}
}

// NewIntHistogramDataPointSlice creates a IntHistogramDataPointSlice with 0 elements.
// Can use "Resize" to initialize with a given length.
func NewIntHistogramDataPointSlice() IntHistogramDataPointSlice {
	orig := []*otlpmetrics.IntHistogramDataPoint(nil)
	return IntHistogramDataPointSlice{&orig}
}

// Len returns the number of elements in the slice.
//
// Returns "0" for a newly instance created with "NewIntHistogramDataPointSlice()".
func (es IntHistogramDataPointSlice) Len() int {
	return len(*es.orig)
}

// At returns the element at the given index.
//
// This function is used mostly for iterating over all the values in the slice:
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     ... // Do something with the element
// }
func (es IntHistogramDataPointSlice) At(ix int) IntHistogramDataPoint {
	return newIntHistogramDataPoint(&(*es.orig)[ix])
}

// MoveAndAppendTo moves all elements from the current slice and appends them to the dest.
// The current slice will be cleared.
func (es IntHistogramDataPointSlice) MoveAndAppendTo(dest IntHistogramDataPointSlice) {
	if es.Len() == 0 {
		// Just to ensure that we always return a Slice with nil elements.
		*es.orig = nil
		return
	}
	if dest.Len() == 0 {
		*dest.orig = *es.orig
		*es.orig = nil
		return
	}
	*dest.orig = append(*dest.orig, *es.orig...)
	*es.orig = nil
	return
}

// CopyTo copies all elements from the current slice to the dest.
func (es IntHistogramDataPointSlice) CopyTo(dest IntHistogramDataPointSlice) {
	newLen := es.Len()
	if newLen == 0 {
		*dest.orig = []*otlpmetrics.IntHistogramDataPoint(nil)
		return
	}
	oldLen := dest.Len()
	if newLen <= oldLen {
		(*dest.orig) = (*dest.orig)[:newLen]
		for i, el := range *es.orig {
			newIntHistogramDataPoint(&el).CopyTo(newIntHistogramDataPoint(&(*dest.orig)[i]))
		}
		return
	}
	origs := make([]otlpmetrics.IntHistogramDataPoint, newLen)
	wrappers := make([]*otlpmetrics.IntHistogramDataPoint, newLen)
	for i, el := range *es.orig {
		wrappers[i] = &origs[i]
		newIntHistogramDataPoint(&el).CopyTo(newIntHistogramDataPoint(&wrappers[i]))
	}
	*dest.orig = wrappers
}

// Resize is an operation that resizes the slice:
// 1. If newLen is 0 then the slice is replaced with a nil slice.
// 2. If the newLen <= len then equivalent with slice[0:newLen].
// 3. If the newLen > len then (newLen - len) empty elements will be appended to the slice.
//
// Here is how a new IntHistogramDataPointSlice can be initialized:
// es := NewIntHistogramDataPointSlice()
// es.Resize(4)
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     // Here should set all the values for e.
// }
func (es IntHistogramDataPointSlice) Resize(newLen int) {
	if newLen == 0 {
		(*es.orig) = []*otlpmetrics.IntHistogramDataPoint(nil)
		return
	}
	oldLen := len(*es.orig)
	if newLen <= oldLen {
		(*es.orig) = (*es.orig)[:newLen]
		return
	}
	// TODO: Benchmark and optimize this logic.
	extraOrigs := make([]otlpmetrics.IntHistogramDataPoint, newLen-oldLen)
	oldOrig := (*es.orig)
	for i := range extraOrigs {
		oldOrig = append(oldOrig, &extraOrigs[i])
	}
	(*es.orig) = oldOrig
}

// Append will increase the length of the IntHistogramDataPointSlice by one and set the
// given IntHistogramDataPoint at that new position.  The original IntHistogramDataPoint
// could still be referenced so do not reuse it after passing it to this
// method.
func (es IntHistogramDataPointSlice) Append(e IntHistogramDataPoint) {
	*es.orig = append(*es.orig, *e.orig)
}

// IntHistogramDataPoint is a single data point in a timeseries that describes the time-varying values of a Histogram of int values.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewIntHistogramDataPoint function to create new instances.
// Important: zero-initialized instance is not valid for use.
type IntHistogramDataPoint struct {
	// orig points to the pointer otlpmetrics.IntHistogramDataPoint field contained somewhere else.
	// We use pointer-to-pointer to be able to modify it in InitEmpty func.
	orig **otlpmetrics.IntHistogramDataPoint
}

func newIntHistogramDataPoint(orig **otlpmetrics.IntHistogramDataPoint) IntHistogramDataPoint {
	return IntHistogramDataPoint{orig}
}

// NewIntHistogramDataPoint creates a new "nil" IntHistogramDataPoint.
// To initialize the struct call "InitEmpty".
//
// This must be used only in testing code since no "Set" method available.
func NewIntHistogramDataPoint() IntHistogramDataPoint {
	orig := (*otlpmetrics.IntHistogramDataPoint)(nil)
	return newIntHistogramDataPoint(&orig)
}

// InitEmpty overwrites the current value with empty.
func (ms IntHistogramDataPoint) InitEmpty() {
	*ms.orig = &otlpmetrics.IntHistogramDataPoint{}
}

// IsNil returns true if the underlying data are nil.
//
// Important: All other functions will cause a runtime error if this returns "true".
func (ms IntHistogramDataPoint) IsNil() bool {
	return *ms.orig == nil
}

// LabelsMap returns the Labels associated with this IntHistogramDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms IntHistogramDataPoint) LabelsMap() StringMap {
	return newStringMap(&(*ms.orig).Labels)
}

// StartTime returns the starttime associated with this IntHistogramDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms IntHistogramDataPoint) StartTime() TimestampUnixNano {
	return TimestampUnixNano((*ms.orig).StartTimeUnixNano)
}

// SetStartTime replaces the starttime associated with this IntHistogramDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms IntHistogramDataPoint) SetStartTime(v TimestampUnixNano) {
	(*ms.orig).StartTimeUnixNano = uint64(v)
}

// Timestamp returns the timestamp associated with this IntHistogramDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms IntHistogramDataPoint) Timestamp() TimestampUnixNano {
	return TimestampUnixNano((*ms.orig).TimeUnixNano)
}

// SetTimestamp replaces the timestamp associated with this IntHistogramDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms IntHistogramDataPoint) SetTimestamp(v TimestampUnixNano) {
	(*ms.orig).TimeUnixNano = uint64(v)
}

// Count returns the count associated with this IntHistogramDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms IntHistogramDataPoint) Count() uint64 {
	return (*ms.orig).Count
}

// SetCount replaces the count associated with this IntHistogramDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms IntHistogramDataPoint) SetCount(v uint64) {
	(*ms.orig).Count = v
}

// Sum returns the sum associated with this IntHistogramDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms IntHistogramDataPoint) Sum() int64 {
	return (*ms.orig).Sum
}

// SetSum replaces the sum associated with this IntHistogramDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms IntHistogramDataPoint) SetSum(v int64) {
	(*ms.orig).Sum = v
}

// BucketCounts returns the bucketcounts associated with this IntHistogramDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms IntHistogramDataPoint) BucketCounts() []uint64 {
	return (*ms.orig).BucketCounts
}

// SetBucketCounts replaces the bucketcounts associated with this IntHistogramDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms IntHistogramDataPoint) SetBucketCounts(v []uint64) {
	(*ms.orig).BucketCounts = v
}

// ExplicitBounds returns the explicitbounds associated with this IntHistogramDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms IntHistogramDataPoint) ExplicitBounds() []float64 {
	return (*ms.orig).ExplicitBounds
}

// SetExplicitBounds replaces the explicitbounds associated with this IntHistogramDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms IntHistogramDataPoint) SetExplicitBounds(v []float64) {
	(*ms.orig).ExplicitBounds = v
}

// Exemplars returns the Exemplars associated with this IntHistogramDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms IntHistogramDataPoint) Exemplars() IntExemplarSlice {
	return newIntExemplarSlice(&(*ms.orig).Exemplars)
}

// CopyTo copies all properties from the current struct to the dest.
func (ms IntHistogramDataPoint) CopyTo(dest IntHistogramDataPoint) {
	if ms.IsNil() {
		*dest.orig = nil
		return
	}
	if dest.IsNil() {
		dest.InitEmpty()
	}
	ms.LabelsMap().CopyTo(dest.LabelsMap())
	dest.SetStartTime(ms.StartTime())
	dest.SetTimestamp(ms.Timestamp())
	dest.SetCount(ms.Count())
	dest.SetSum(ms.Sum())
	dest.SetBucketCounts(ms.BucketCounts())
	dest.SetExplicitBounds(ms.ExplicitBounds())
	ms.Exemplars().CopyTo(dest.Exemplars())
}

// DoubleHistogramDataPointSlice logically represents a slice of DoubleHistogramDataPoint.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewDoubleHistogramDataPointSlice function to create new instances.
// Important: zero-initialized instance is not valid for use.
type DoubleHistogramDataPointSlice struct {
	// orig points to the slice otlpmetrics.DoubleHistogramDataPoint field contained somewhere else.
	// We use pointer-to-slice to be able to modify it in functions like Resize.
	orig *[]*otlpmetrics.DoubleHistogramDataPoint
}

func newDoubleHistogramDataPointSlice(orig *[]*otlpmetrics.DoubleHistogramDataPoint) DoubleHistogramDataPointSlice {
	return DoubleHistogramDataPointSlice{orig}
}

// NewDoubleHistogramDataPointSlice creates a DoubleHistogramDataPointSlice with 0 elements.
// Can use "Resize" to initialize with a given length.
func NewDoubleHistogramDataPointSlice() DoubleHistogramDataPointSlice {
	orig := []*otlpmetrics.DoubleHistogramDataPoint(nil)
	return DoubleHistogramDataPointSlice{&orig}
}

// Len returns the number of elements in the slice.
//
// Returns "0" for a newly instance created with "NewDoubleHistogramDataPointSlice()".
func (es DoubleHistogramDataPointSlice) Len() int {
	return len(*es.orig)
}

// At returns the element at the given index.
//
// This function is used mostly for iterating over all the values in the slice:
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     ... // Do something with the element
// }
func (es DoubleHistogramDataPointSlice) At(ix int) DoubleHistogramDataPoint {
	return newDoubleHistogramDataPoint(&(*es.orig)[ix])
}

// MoveAndAppendTo moves all elements from the current slice and appends them to the dest.
// The current slice will be cleared.
func (es DoubleHistogramDataPointSlice) MoveAndAppendTo(dest DoubleHistogramDataPointSlice) {
	if es.Len() == 0 {
		// Just to ensure that we always return a Slice with nil elements.
		*es.orig = nil
		return
	}
	if dest.Len() == 0 {
		*dest.orig = *es.orig
		*es.orig = nil
		return
	}
	*dest.orig = append(*dest.orig, *es.orig...)
	*es.orig = nil
	return
}

// CopyTo copies all elements from the current slice to the dest.
func (es DoubleHistogramDataPointSlice) CopyTo(dest DoubleHistogramDataPointSlice) {
	newLen := es.Len()
	if newLen == 0 {
		*dest.orig = []*otlpmetrics.DoubleHistogramDataPoint(nil)
		return
	}
	oldLen := dest.Len()
	if newLen <= oldLen {
		(*dest.orig) = (*dest.orig)[:newLen]
		for i, el := range *es.orig {
			newDoubleHistogramDataPoint(&el).CopyTo(newDoubleHistogramDataPoint(&(*dest.orig)[i]))
		}
		return
	}
	origs := make([]otlpmetrics.DoubleHistogramDataPoint, newLen)
	wrappers := make([]*otlpmetrics.DoubleHistogramDataPoint, newLen)
	for i, el := range *es.orig {
		wrappers[i] = &origs[i]
		newDoubleHistogramDataPoint(&el).CopyTo(newDoubleHistogramDataPoint(&wrappers[i]))
	}
	*dest.orig = wrappers
}

// Resize is an operation that resizes the slice:
// 1. If newLen is 0 then the slice is replaced with a nil slice.
// 2. If the newLen <= len then equivalent with slice[0:newLen].
// 3. If the newLen > len then (newLen - len) empty elements will be appended to the slice.
//
// Here is how a new DoubleHistogramDataPointSlice can be initialized:
// es := NewDoubleHistogramDataPointSlice()
// es.Resize(4)
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     // Here should set all the values for e.
// }
func (es DoubleHistogramDataPointSlice) Resize(newLen int) {
	if newLen == 0 {
		(*es.orig) = []*otlpmetrics.DoubleHistogramDataPoint(nil)
		return
	}
	oldLen := len(*es.orig)
	if newLen <= oldLen {
		(*es.orig) = (*es.orig)[:newLen]
		return
	}
	// TODO: Benchmark and optimize this logic.
	extraOrigs := make([]otlpmetrics.DoubleHistogramDataPoint, newLen-oldLen)
	oldOrig := (*es.orig)
	for i := range extraOrigs {
		oldOrig = append(oldOrig, &extraOrigs[i])
	}
	(*es.orig) = oldOrig
}

// Append will increase the length of the DoubleHistogramDataPointSlice by one and set the
// given DoubleHistogramDataPoint at that new position.  The original DoubleHistogramDataPoint
// could still be referenced so do not reuse it after passing it to this
// method.
func (es DoubleHistogramDataPointSlice) Append(e DoubleHistogramDataPoint) {
	*es.orig = append(*es.orig, *e.orig)
}

// DoubleHistogramDataPoint is a single data point in a timeseries that describes the time-varying values of a Histogram of double values.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewDoubleHistogramDataPoint function to create new instances.
// Important: zero-initialized instance is not valid for use.
type DoubleHistogramDataPoint struct {
	// orig points to the pointer otlpmetrics.DoubleHistogramDataPoint field contained somewhere else.
	// We use pointer-to-pointer to be able to modify it in InitEmpty func.
	orig **otlpmetrics.DoubleHistogramDataPoint
}

func newDoubleHistogramDataPoint(orig **otlpmetrics.DoubleHistogramDataPoint) DoubleHistogramDataPoint {
	return DoubleHistogramDataPoint{orig}
}

// NewDoubleHistogramDataPoint creates a new "nil" DoubleHistogramDataPoint.
// To initialize the struct call "InitEmpty".
//
// This must be used only in testing code since no "Set" method available.
func NewDoubleHistogramDataPoint() DoubleHistogramDataPoint {
	orig := (*otlpmetrics.DoubleHistogramDataPoint)(nil)
	return newDoubleHistogramDataPoint(&orig)
}

// InitEmpty overwrites the current value with empty.
func (ms DoubleHistogramDataPoint) InitEmpty() {
	*ms.orig = &otlpmetrics.DoubleHistogramDataPoint{}
}

// IsNil returns true if the underlying data are nil.
//
// Important: All other functions will cause a runtime error if this returns "true".
func (ms DoubleHistogramDataPoint) IsNil() bool {
	return *ms.orig == nil
}

// LabelsMap returns the Labels associated with this DoubleHistogramDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms DoubleHistogramDataPoint) LabelsMap() StringMap {
	return newStringMap(&(*ms.orig).Labels)
}

// StartTime returns the starttime associated with this DoubleHistogramDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms DoubleHistogramDataPoint) StartTime() TimestampUnixNano {
	return TimestampUnixNano((*ms.orig).StartTimeUnixNano)
}

// SetStartTime replaces the starttime associated with this DoubleHistogramDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms DoubleHistogramDataPoint) SetStartTime(v TimestampUnixNano) {
	(*ms.orig).StartTimeUnixNano = uint64(v)
}

// Timestamp returns the timestamp associated with this DoubleHistogramDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms DoubleHistogramDataPoint) Timestamp() TimestampUnixNano {
	return TimestampUnixNano((*ms.orig).TimeUnixNano)
}

// SetTimestamp replaces the timestamp associated with this DoubleHistogramDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms DoubleHistogramDataPoint) SetTimestamp(v TimestampUnixNano) {
	(*ms.orig).TimeUnixNano = uint64(v)
}

// Count returns the count associated with this DoubleHistogramDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms DoubleHistogramDataPoint) Count() uint64 {
	return (*ms.orig).Count
}

// SetCount replaces the count associated with this DoubleHistogramDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms DoubleHistogramDataPoint) SetCount(v uint64) {
	(*ms.orig).Count = v
}

// Sum returns the sum associated with this DoubleHistogramDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms DoubleHistogramDataPoint) Sum() float64 {
	return (*ms.orig).Sum
}

// SetSum replaces the sum associated with this DoubleHistogramDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms DoubleHistogramDataPoint) SetSum(v float64) {
	(*ms.orig).Sum = v
}

// BucketCounts returns the bucketcounts associated with this DoubleHistogramDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms DoubleHistogramDataPoint) BucketCounts() []uint64 {
	return (*ms.orig).BucketCounts
}

// SetBucketCounts replaces the bucketcounts associated with this DoubleHistogramDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms DoubleHistogramDataPoint) SetBucketCounts(v []uint64) {
	(*ms.orig).BucketCounts = v
}

// ExplicitBounds returns the explicitbounds associated with this DoubleHistogramDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms DoubleHistogramDataPoint) ExplicitBounds() []float64 {
	return (*ms.orig).ExplicitBounds
}

// SetExplicitBounds replaces the explicitbounds associated with this DoubleHistogramDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms DoubleHistogramDataPoint) SetExplicitBounds(v []float64) {
	(*ms.orig).ExplicitBounds = v
}

// Exemplars returns the Exemplars associated with this DoubleHistogramDataPoint.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms DoubleHistogramDataPoint) Exemplars() DoubleExemplarSlice {
	return newDoubleExemplarSlice(&(*ms.orig).Exemplars)
}

// CopyTo copies all properties from the current struct to the dest.
func (ms DoubleHistogramDataPoint) CopyTo(dest DoubleHistogramDataPoint) {
	if ms.IsNil() {
		*dest.orig = nil
		return
	}
	if dest.IsNil() {
		dest.InitEmpty()
	}
	ms.LabelsMap().CopyTo(dest.LabelsMap())
	dest.SetStartTime(ms.StartTime())
	dest.SetTimestamp(ms.Timestamp())
	dest.SetCount(ms.Count())
	dest.SetSum(ms.Sum())
	dest.SetBucketCounts(ms.BucketCounts())
	dest.SetExplicitBounds(ms.ExplicitBounds())
	ms.Exemplars().CopyTo(dest.Exemplars())
}

// IntExemplarSlice logically represents a slice of IntExemplar.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewIntExemplarSlice function to create new instances.
// Important: zero-initialized instance is not valid for use.
type IntExemplarSlice struct {
	// orig points to the slice otlpmetrics.IntExemplar field contained somewhere else.
	// We use pointer-to-slice to be able to modify it in functions like Resize.
	orig *[]*otlpmetrics.IntExemplar
}

func newIntExemplarSlice(orig *[]*otlpmetrics.IntExemplar) IntExemplarSlice {
	return IntExemplarSlice{orig}
}

// NewIntExemplarSlice creates a IntExemplarSlice with 0 elements.
// Can use "Resize" to initialize with a given length.
func NewIntExemplarSlice() IntExemplarSlice {
	orig := []*otlpmetrics.IntExemplar(nil)
	return IntExemplarSlice{&orig}
}

// Len returns the number of elements in the slice.
//
// Returns "0" for a newly instance created with "NewIntExemplarSlice()".
func (es IntExemplarSlice) Len() int {
	return len(*es.orig)
}

// At returns the element at the given index.
//
// This function is used mostly for iterating over all the values in the slice:
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     ... // Do something with the element
// }
func (es IntExemplarSlice) At(ix int) IntExemplar {
	return newIntExemplar(&(*es.orig)[ix])
}

// MoveAndAppendTo moves all elements from the current slice and appends them to the dest.
// The current slice will be cleared.
func (es IntExemplarSlice) MoveAndAppendTo(dest IntExemplarSlice) {
	if es.Len() == 0 {
		// Just to ensure that we always return a Slice with nil elements.
		*es.orig = nil
		return
	}
	if dest.Len() == 0 {
		*dest.orig = *es.orig
		*es.orig = nil
		return
	}
	*dest.orig = append(*dest.orig, *es.orig...)
	*es.orig = nil
	return
}

// CopyTo copies all elements from the current slice to the dest.
func (es IntExemplarSlice) CopyTo(dest IntExemplarSlice) {
	newLen := es.Len()
	if newLen == 0 {
		*dest.orig = []*otlpmetrics.IntExemplar(nil)
		return
	}
	oldLen := dest.Len()
	if newLen <= oldLen {
		(*dest.orig) = (*dest.orig)[:newLen]
		for i, el := range *es.orig {
			newIntExemplar(&el).CopyTo(newIntExemplar(&(*dest.orig)[i]))
		}
		return
	}
	origs := make([]otlpmetrics.IntExemplar, newLen)
	wrappers := make([]*otlpmetrics.IntExemplar, newLen)
	for i, el := range *es.orig {
		wrappers[i] = &origs[i]
		newIntExemplar(&el).CopyTo(newIntExemplar(&wrappers[i]))
	}
	*dest.orig = wrappers
}

// Resize is an operation that resizes the slice:
// 1. If newLen is 0 then the slice is replaced with a nil slice.
// 2. If the newLen <= len then equivalent with slice[0:newLen].
// 3. If the newLen > len then (newLen - len) empty elements will be appended to the slice.
//
// Here is how a new IntExemplarSlice can be initialized:
// es := NewIntExemplarSlice()
// es.Resize(4)
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     // Here should set all the values for e.
// }
func (es IntExemplarSlice) Resize(newLen int) {
	if newLen == 0 {
		(*es.orig) = []*otlpmetrics.IntExemplar(nil)
		return
	}
	oldLen := len(*es.orig)
	if newLen <= oldLen {
		(*es.orig) = (*es.orig)[:newLen]
		return
	}
	// TODO: Benchmark and optimize this logic.
	extraOrigs := make([]otlpmetrics.IntExemplar, newLen-oldLen)
	oldOrig := (*es.orig)
	for i := range extraOrigs {
		oldOrig = append(oldOrig, &extraOrigs[i])
	}
	(*es.orig) = oldOrig
}

// Append will increase the length of the IntExemplarSlice by one and set the
// given IntExemplar at that new position.  The original IntExemplar
// could still be referenced so do not reuse it after passing it to this
// method.
func (es IntExemplarSlice) Append(e IntExemplar) {
	*es.orig = append(*es.orig, *e.orig)
}

// IntExemplar is a sample input int measurement.
//
// Exemplars also hold information about the environment when the measurement was recorded,
// for example the span and trace ID of the active span when the exemplar was recorded.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewIntExemplar function to create new instances.
// Important: zero-initialized instance is not valid for use.
type IntExemplar struct {
	// orig points to the pointer otlpmetrics.IntExemplar field contained somewhere else.
	// We use pointer-to-pointer to be able to modify it in InitEmpty func.
	orig **otlpmetrics.IntExemplar
}

func newIntExemplar(orig **otlpmetrics.IntExemplar) IntExemplar {
	return IntExemplar{orig}
}

// NewIntExemplar creates a new "nil" IntExemplar.
// To initialize the struct call "InitEmpty".
//
// This must be used only in testing code since no "Set" method available.
func NewIntExemplar() IntExemplar {
	orig := (*otlpmetrics.IntExemplar)(nil)
	return newIntExemplar(&orig)
}

// InitEmpty overwrites the current value with empty.
func (ms IntExemplar) InitEmpty() {
	*ms.orig = &otlpmetrics.IntExemplar{}
}

// IsNil returns true if the underlying data are nil.
//
// Important: All other functions will cause a runtime error if this returns "true".
func (ms IntExemplar) IsNil() bool {
	return *ms.orig == nil
}

// Timestamp returns the timestamp associated with this IntExemplar.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms IntExemplar) Timestamp() TimestampUnixNano {
	return TimestampUnixNano((*ms.orig).TimeUnixNano)
}

// SetTimestamp replaces the timestamp associated with this IntExemplar.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms IntExemplar) SetTimestamp(v TimestampUnixNano) {
	(*ms.orig).TimeUnixNano = uint64(v)
}

// Value returns the value associated with this IntExemplar.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms IntExemplar) Value() int64 {
	return (*ms.orig).Value
}

// SetValue replaces the value associated with this IntExemplar.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms IntExemplar) SetValue(v int64) {
	(*ms.orig).Value = v
}

// FilteredLabels returns the FilteredLabels associated with this IntExemplar.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms IntExemplar) FilteredLabels() StringMap {
	return newStringMap(&(*ms.orig).FilteredLabels)
}

// CopyTo copies all properties from the current struct to the dest.
func (ms IntExemplar) CopyTo(dest IntExemplar) {
	if ms.IsNil() {
		*dest.orig = nil
		return
	}
	if dest.IsNil() {
		dest.InitEmpty()
	}
	dest.SetTimestamp(ms.Timestamp())
	dest.SetValue(ms.Value())
	ms.FilteredLabels().CopyTo(dest.FilteredLabels())
}

// DoubleExemplarSlice logically represents a slice of DoubleExemplar.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewDoubleExemplarSlice function to create new instances.
// Important: zero-initialized instance is not valid for use.
type DoubleExemplarSlice struct {
	// orig points to the slice otlpmetrics.DoubleExemplar field contained somewhere else.
	// We use pointer-to-slice to be able to modify it in functions like Resize.
	orig *[]*otlpmetrics.DoubleExemplar
}

func newDoubleExemplarSlice(orig *[]*otlpmetrics.DoubleExemplar) DoubleExemplarSlice {
	return DoubleExemplarSlice{orig}
}

// NewDoubleExemplarSlice creates a DoubleExemplarSlice with 0 elements.
// Can use "Resize" to initialize with a given length.
func NewDoubleExemplarSlice() DoubleExemplarSlice {
	orig := []*otlpmetrics.DoubleExemplar(nil)
	return DoubleExemplarSlice{&orig}
}

// Len returns the number of elements in the slice.
//
// Returns "0" for a newly instance created with "NewDoubleExemplarSlice()".
func (es DoubleExemplarSlice) Len() int {
	return len(*es.orig)
}

// At returns the element at the given index.
//
// This function is used mostly for iterating over all the values in the slice:
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     ... // Do something with the element
// }
func (es DoubleExemplarSlice) At(ix int) DoubleExemplar {
	return newDoubleExemplar(&(*es.orig)[ix])
}

// MoveAndAppendTo moves all elements from the current slice and appends them to the dest.
// The current slice will be cleared.
func (es DoubleExemplarSlice) MoveAndAppendTo(dest DoubleExemplarSlice) {
	if es.Len() == 0 {
		// Just to ensure that we always return a Slice with nil elements.
		*es.orig = nil
		return
	}
	if dest.Len() == 0 {
		*dest.orig = *es.orig
		*es.orig = nil
		return
	}
	*dest.orig = append(*dest.orig, *es.orig...)
	*es.orig = nil
	return
}

// CopyTo copies all elements from the current slice to the dest.
func (es DoubleExemplarSlice) CopyTo(dest DoubleExemplarSlice) {
	newLen := es.Len()
	if newLen == 0 {
		*dest.orig = []*otlpmetrics.DoubleExemplar(nil)
		return
	}
	oldLen := dest.Len()
	if newLen <= oldLen {
		(*dest.orig) = (*dest.orig)[:newLen]
		for i, el := range *es.orig {
			newDoubleExemplar(&el).CopyTo(newDoubleExemplar(&(*dest.orig)[i]))
		}
		return
	}
	origs := make([]otlpmetrics.DoubleExemplar, newLen)
	wrappers := make([]*otlpmetrics.DoubleExemplar, newLen)
	for i, el := range *es.orig {
		wrappers[i] = &origs[i]
		newDoubleExemplar(&el).CopyTo(newDoubleExemplar(&wrappers[i]))
	}
	*dest.orig = wrappers
}

// Resize is an operation that resizes the slice:
// 1. If newLen is 0 then the slice is replaced with a nil slice.
// 2. If the newLen <= len then equivalent with slice[0:newLen].
// 3. If the newLen > len then (newLen - len) empty elements will be appended to the slice.
//
// Here is how a new DoubleExemplarSlice can be initialized:
// es := NewDoubleExemplarSlice()
// es.Resize(4)
// for i := 0; i < es.Len(); i++ {
//     e := es.At(i)
//     // Here should set all the values for e.
// }
func (es DoubleExemplarSlice) Resize(newLen int) {
	if newLen == 0 {
		(*es.orig) = []*otlpmetrics.DoubleExemplar(nil)
		return
	}
	oldLen := len(*es.orig)
	if newLen <= oldLen {
		(*es.orig) = (*es.orig)[:newLen]
		return
	}
	// TODO: Benchmark and optimize this logic.
	extraOrigs := make([]otlpmetrics.DoubleExemplar, newLen-oldLen)
	oldOrig := (*es.orig)
	for i := range extraOrigs {
		oldOrig = append(oldOrig, &extraOrigs[i])
	}
	(*es.orig) = oldOrig
}

// Append will increase the length of the DoubleExemplarSlice by one and set the
// given DoubleExemplar at that new position.  The original DoubleExemplar
// could still be referenced so do not reuse it after passing it to this
// method.
func (es DoubleExemplarSlice) Append(e DoubleExemplar) {
	*es.orig = append(*es.orig, *e.orig)
}

// DoubleExemplar is a sample input double measurement.
//
// Exemplars also hold information about the environment when the measurement was recorded,
// for example the span and trace ID of the active span when the exemplar was recorded.
//
// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewDoubleExemplar function to create new instances.
// Important: zero-initialized instance is not valid for use.
type DoubleExemplar struct {
	// orig points to the pointer otlpmetrics.DoubleExemplar field contained somewhere else.
	// We use pointer-to-pointer to be able to modify it in InitEmpty func.
	orig **otlpmetrics.DoubleExemplar
}

func newDoubleExemplar(orig **otlpmetrics.DoubleExemplar) DoubleExemplar {
	return DoubleExemplar{orig}
}

// NewDoubleExemplar creates a new "nil" DoubleExemplar.
// To initialize the struct call "InitEmpty".
//
// This must be used only in testing code since no "Set" method available.
func NewDoubleExemplar() DoubleExemplar {
	orig := (*otlpmetrics.DoubleExemplar)(nil)
	return newDoubleExemplar(&orig)
}

// InitEmpty overwrites the current value with empty.
func (ms DoubleExemplar) InitEmpty() {
	*ms.orig = &otlpmetrics.DoubleExemplar{}
}

// IsNil returns true if the underlying data are nil.
//
// Important: All other functions will cause a runtime error if this returns "true".
func (ms DoubleExemplar) IsNil() bool {
	return *ms.orig == nil
}

// Timestamp returns the timestamp associated with this DoubleExemplar.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms DoubleExemplar) Timestamp() TimestampUnixNano {
	return TimestampUnixNano((*ms.orig).TimeUnixNano)
}

// SetTimestamp replaces the timestamp associated with this DoubleExemplar.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms DoubleExemplar) SetTimestamp(v TimestampUnixNano) {
	(*ms.orig).TimeUnixNano = uint64(v)
}

// Value returns the value associated with this DoubleExemplar.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms DoubleExemplar) Value() float64 {
	return (*ms.orig).Value
}

// SetValue replaces the value associated with this DoubleExemplar.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms DoubleExemplar) SetValue(v float64) {
	(*ms.orig).Value = v
}

// FilteredLabels returns the FilteredLabels associated with this DoubleExemplar.
//
// Important: This causes a runtime error if IsNil() returns "true".
func (ms DoubleExemplar) FilteredLabels() StringMap {
	return newStringMap(&(*ms.orig).FilteredLabels)
}

// CopyTo copies all properties from the current struct to the dest.
func (ms DoubleExemplar) CopyTo(dest DoubleExemplar) {
	if ms.IsNil() {
		*dest.orig = nil
		return
	}
	if dest.IsNil() {
		dest.InitEmpty()
	}
	dest.SetTimestamp(ms.Timestamp())
	dest.SetValue(ms.Value())
	ms.FilteredLabels().CopyTo(dest.FilteredLabels())
}
