function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

import React from 'react';
import PropTypes from 'prop-types';

var Star = function (_React$Component) {
  _inherits(Star, _React$Component);

  function Star() {
    var _temp, _this, _ret;

    _classCallCheck(this, Star);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = _possibleConstructorReturn(this, _React$Component.call.apply(_React$Component, [this].concat(args))), _this), _this.onHover = function (e) {
      var _this$props = _this.props,
          onHover = _this$props.onHover,
          index = _this$props.index;

      onHover(e, index);
    }, _this.onClick = function (e) {
      var _this$props2 = _this.props,
          onClick = _this$props2.onClick,
          index = _this$props2.index;

      onClick(e, index);
    }, _this.onKeyDown = function (e) {
      var _this$props3 = _this.props,
          onClick = _this$props3.onClick,
          index = _this$props3.index;

      if (e.keyCode === 13) {
        onClick(e, index);
      }
    }, _temp), _possibleConstructorReturn(_this, _ret);
  }

  Star.prototype.getClassName = function getClassName() {
    var _props = this.props,
        prefixCls = _props.prefixCls,
        index = _props.index,
        value = _props.value,
        allowHalf = _props.allowHalf,
        focused = _props.focused;

    var starValue = index + 1;
    var className = prefixCls;
    if (value === 0 && index === 0 && focused) {
      className += ' ' + prefixCls + '-focused';
    } else if (allowHalf && value + 0.5 === starValue) {
      className += ' ' + prefixCls + '-half ' + prefixCls + '-active';
      if (focused) {
        className += ' ' + prefixCls + '-focused';
      }
    } else {
      className += starValue <= value ? ' ' + prefixCls + '-full' : ' ' + prefixCls + '-zero';
      if (starValue === value && focused) {
        className += ' ' + prefixCls + '-focused';
      }
    }
    return className;
  };

  Star.prototype.render = function render() {
    var onHover = this.onHover,
        onClick = this.onClick,
        onKeyDown = this.onKeyDown;
    var _props2 = this.props,
        disabled = _props2.disabled,
        prefixCls = _props2.prefixCls,
        character = _props2.character,
        index = _props2.index,
        count = _props2.count,
        value = _props2.value;

    return React.createElement(
      'li',
      {
        className: this.getClassName(),
        onClick: disabled ? null : onClick,
        onKeyDown: disabled ? null : onKeyDown,
        onMouseMove: disabled ? null : onHover,
        role: 'radio',
        'aria-checked': value > index ? 'true' : 'false',
        'aria-posinset': index + 1,
        'aria-setsize': count,
        tabIndex: 0
      },
      React.createElement(
        'div',
        { className: prefixCls + '-first' },
        character
      ),
      React.createElement(
        'div',
        { className: prefixCls + '-second' },
        character
      )
    );
  };

  return Star;
}(React.Component);

Star.propTypes = {
  value: PropTypes.number,
  index: PropTypes.number,
  prefixCls: PropTypes.string,
  allowHalf: PropTypes.bool,
  disabled: PropTypes.bool,
  onHover: PropTypes.func,
  onClick: PropTypes.func,
  character: PropTypes.node,
  focused: PropTypes.bool,
  count: PropTypes.number
};
export default Star;