Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.default = getRouteState;

var _locationEquals = require("./locationEquals");

var _locationEquals2 = _interopRequireDefault(_locationEquals);

var _isLocationValid = require("./isLocationValid");

var _isLocationValid2 = _interopRequireDefault(_isLocationValid);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function mergeParam(location, params) {
    return Object.keys(location).reduce(function (obj, key) {
        obj[key] = location[key];
        return obj;
    }, { params: params });
}

function getRouteState(newProps) {
    var props = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    if ((0, _isLocationValid2.default)(newProps.location) && !(0, _locationEquals2.default)(props.location, newProps.location)) {
        // additional params for the dynamic segments of the URL if available.
        var location = newProps.location,
            params = newProps.params;

        if (location.params || !params) {
            return location;
        }
        var routeState = mergeParam(location, params);
        return routeState;
    }
    return null;
}