Object.defineProperty(exports, "__esModule", {
    value: true
});

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

exports.default = isLocationValid;
/**
 * `location` is a plain object which represents the current location in browser similar to document.location.
 * see https://github.com/rackt/history/blob/master/docs/Location.md
 *
 * @method isLocationValid
 * @param location
 * @returns {boolean}
 */
function isLocationValid(location) {
    return !!location && (typeof location === "undefined" ? "undefined" : _typeof(location)) === "object" && location.hasOwnProperty("pathname") && location.hasOwnProperty("hash") && location.hasOwnProperty("search") && location.hasOwnProperty("state");
}