module.exports = defaultOptions

const merge = require('deepmerge')
const isPlainObject = require('is-plain-object')

const lowercaseKeys = require('./util/lowercase-keys')

function defaultOptions (defaults, route, options) {
  if (typeof route === 'string') {
    let [method, url] = route.split(' ')
    options = Object.assign(url ? { method, url } : { url: method }, options)
  } else {
    options = route || {}
  }

  // lowercase header names before merging with defaults to avoid duplicates
  options.headers = lowercaseKeys(options.headers)

  options = merge.all([defaults, options].filter(Boolean), { isMergeableObject: isPlainObject })

  return options
}
