import _classCallCheck from 'babel-runtime/helpers/classCallCheck';
import _createClass from 'babel-runtime/helpers/createClass';
import _possibleConstructorReturn from 'babel-runtime/helpers/possibleConstructorReturn';
import _inherits from 'babel-runtime/helpers/inherits';
import React, { Component } from 'react';
import PropTypes from 'prop-types';
import Trigger from 'rc-trigger';
import Panel from './Panel';
import placements from './placements';
import moment from 'moment';

function noop() {}

function refFn(field, component) {
  this[field] = component;
}

var Picker = function (_Component) {
  _inherits(Picker, _Component);

  function Picker(props) {
    _classCallCheck(this, Picker);

    var _this = _possibleConstructorReturn(this, (Picker.__proto__ || Object.getPrototypeOf(Picker)).call(this, props));

    _initialiseProps.call(_this);

    _this.saveInputRef = refFn.bind(_this, 'picker');
    _this.savePanelRef = refFn.bind(_this, 'panelInstance');
    var defaultOpen = props.defaultOpen,
        defaultValue = props.defaultValue,
        _props$open = props.open,
        open = _props$open === undefined ? defaultOpen : _props$open,
        _props$value = props.value,
        value = _props$value === undefined ? defaultValue : _props$value;

    _this.state = {
      open: open,
      value: value
    };
    return _this;
  }

  _createClass(Picker, [{
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      var value = nextProps.value,
          open = nextProps.open;

      if ('value' in nextProps) {
        this.setState({
          value: value
        });
      }
      if (open !== undefined) {
        this.setState({ open: open });
      }
    }
  }, {
    key: 'setValue',
    value: function setValue(value) {
      if (!('value' in this.props)) {
        this.setState({
          value: value
        });
      }
      this.props.onChange(value);
    }
  }, {
    key: 'getFormat',
    value: function getFormat() {
      var _props = this.props,
          format = _props.format,
          showHour = _props.showHour,
          showMinute = _props.showMinute,
          showSecond = _props.showSecond,
          use12Hours = _props.use12Hours;

      if (format) {
        return format;
      }

      if (use12Hours) {
        var fmtString = [showHour ? 'h' : '', showMinute ? 'mm' : '', showSecond ? 'ss' : ''].filter(function (item) {
          return !!item;
        }).join(':');

        return fmtString.concat(' a');
      }

      return [showHour ? 'HH' : '', showMinute ? 'mm' : '', showSecond ? 'ss' : ''].filter(function (item) {
        return !!item;
      }).join(':');
    }
  }, {
    key: 'getPanelElement',
    value: function getPanelElement() {
      var _props2 = this.props,
          prefixCls = _props2.prefixCls,
          placeholder = _props2.placeholder,
          disabledHours = _props2.disabledHours,
          disabledMinutes = _props2.disabledMinutes,
          disabledSeconds = _props2.disabledSeconds,
          hideDisabledOptions = _props2.hideDisabledOptions,
          inputReadOnly = _props2.inputReadOnly,
          allowEmpty = _props2.allowEmpty,
          showHour = _props2.showHour,
          showMinute = _props2.showMinute,
          showSecond = _props2.showSecond,
          defaultOpenValue = _props2.defaultOpenValue,
          clearText = _props2.clearText,
          addon = _props2.addon,
          use12Hours = _props2.use12Hours,
          focusOnOpen = _props2.focusOnOpen,
          onKeyDown = _props2.onKeyDown,
          hourStep = _props2.hourStep,
          minuteStep = _props2.minuteStep,
          secondStep = _props2.secondStep;

      return React.createElement(Panel, {
        clearText: clearText,
        prefixCls: prefixCls + '-panel',
        ref: this.savePanelRef,
        value: this.state.value,
        inputReadOnly: inputReadOnly,
        onChange: this.onPanelChange,
        onClear: this.onPanelClear,
        defaultOpenValue: defaultOpenValue,
        showHour: showHour,
        showMinute: showMinute,
        showSecond: showSecond,
        onEsc: this.onEsc,
        allowEmpty: allowEmpty,
        format: this.getFormat(),
        placeholder: placeholder,
        disabledHours: disabledHours,
        disabledMinutes: disabledMinutes,
        disabledSeconds: disabledSeconds,
        hideDisabledOptions: hideDisabledOptions,
        use12Hours: use12Hours,
        hourStep: hourStep,
        minuteStep: minuteStep,
        secondStep: secondStep,
        addon: addon,
        focusOnOpen: focusOnOpen,
        onKeyDown: onKeyDown
      });
    }
  }, {
    key: 'getPopupClassName',
    value: function getPopupClassName() {
      var _props3 = this.props,
          showHour = _props3.showHour,
          showMinute = _props3.showMinute,
          showSecond = _props3.showSecond,
          use12Hours = _props3.use12Hours,
          prefixCls = _props3.prefixCls;

      var popupClassName = this.props.popupClassName;
      // Keep it for old compatibility
      if ((!showHour || !showMinute || !showSecond) && !use12Hours) {
        popupClassName += ' ' + prefixCls + '-panel-narrow';
      }
      var selectColumnCount = 0;
      if (showHour) {
        selectColumnCount += 1;
      }
      if (showMinute) {
        selectColumnCount += 1;
      }
      if (showSecond) {
        selectColumnCount += 1;
      }
      if (use12Hours) {
        selectColumnCount += 1;
      }
      popupClassName += ' ' + prefixCls + '-panel-column-' + selectColumnCount;
      return popupClassName;
    }
  }, {
    key: 'setOpen',
    value: function setOpen(open) {
      var _props4 = this.props,
          onOpen = _props4.onOpen,
          onClose = _props4.onClose;

      if (this.state.open !== open) {
        if (!('open' in this.props)) {
          this.setState({ open: open });
        }
        if (open) {
          onOpen({ open: open });
        } else {
          onClose({ open: open });
        }
      }
    }
  }, {
    key: 'focus',
    value: function focus() {
      this.picker.focus();
    }
  }, {
    key: 'blur',
    value: function blur() {
      this.picker.blur();
    }
  }, {
    key: 'render',
    value: function render() {
      var _props5 = this.props,
          prefixCls = _props5.prefixCls,
          placeholder = _props5.placeholder,
          placement = _props5.placement,
          align = _props5.align,
          disabled = _props5.disabled,
          transitionName = _props5.transitionName,
          style = _props5.style,
          className = _props5.className,
          getPopupContainer = _props5.getPopupContainer,
          name = _props5.name,
          autoComplete = _props5.autoComplete,
          onFocus = _props5.onFocus,
          onBlur = _props5.onBlur,
          autoFocus = _props5.autoFocus,
          inputReadOnly = _props5.inputReadOnly;
      var _state = this.state,
          open = _state.open,
          value = _state.value;

      var popupClassName = this.getPopupClassName();
      return React.createElement(
        Trigger,
        {
          prefixCls: prefixCls + '-panel',
          popupClassName: popupClassName,
          popup: this.getPanelElement(),
          popupAlign: align,
          builtinPlacements: placements,
          popupPlacement: placement,
          action: disabled ? [] : ['click'],
          destroyPopupOnHide: true,
          getPopupContainer: getPopupContainer,
          popupTransitionName: transitionName,
          popupVisible: open,
          onPopupVisibleChange: this.onVisibleChange
        },
        React.createElement(
          'span',
          { className: prefixCls + ' ' + className, style: style },
          React.createElement('input', {
            className: prefixCls + '-input',
            ref: this.saveInputRef,
            type: 'text',
            placeholder: placeholder,
            name: name,
            onKeyDown: this.onKeyDown,
            disabled: disabled,
            value: value && value.format(this.getFormat()) || '',
            autoComplete: autoComplete,
            onFocus: onFocus,
            onBlur: onBlur,
            autoFocus: autoFocus,
            onChange: noop,
            readOnly: !!inputReadOnly
          }),
          React.createElement('span', { className: prefixCls + '-icon' })
        )
      );
    }
  }]);

  return Picker;
}(Component);

Picker.propTypes = {
  prefixCls: PropTypes.string,
  clearText: PropTypes.string,
  value: PropTypes.object,
  defaultOpenValue: PropTypes.object,
  inputReadOnly: PropTypes.bool,
  disabled: PropTypes.bool,
  allowEmpty: PropTypes.bool,
  defaultValue: PropTypes.object,
  open: PropTypes.bool,
  defaultOpen: PropTypes.bool,
  align: PropTypes.object,
  placement: PropTypes.any,
  transitionName: PropTypes.string,
  getPopupContainer: PropTypes.func,
  placeholder: PropTypes.string,
  format: PropTypes.string,
  showHour: PropTypes.bool,
  showMinute: PropTypes.bool,
  showSecond: PropTypes.bool,
  style: PropTypes.object,
  className: PropTypes.string,
  popupClassName: PropTypes.string,
  disabledHours: PropTypes.func,
  disabledMinutes: PropTypes.func,
  disabledSeconds: PropTypes.func,
  hideDisabledOptions: PropTypes.bool,
  onChange: PropTypes.func,
  onOpen: PropTypes.func,
  onClose: PropTypes.func,
  onFocus: PropTypes.func,
  onBlur: PropTypes.func,
  addon: PropTypes.func,
  name: PropTypes.string,
  autoComplete: PropTypes.string,
  use12Hours: PropTypes.bool,
  hourStep: PropTypes.number,
  minuteStep: PropTypes.number,
  secondStep: PropTypes.number,
  focusOnOpen: PropTypes.bool,
  onKeyDown: PropTypes.func,
  autoFocus: PropTypes.bool
};
Picker.defaultProps = {
  clearText: 'clear',
  prefixCls: 'rc-time-picker',
  defaultOpen: false,
  inputReadOnly: false,
  style: {},
  className: '',
  popupClassName: '',
  align: {},
  defaultOpenValue: moment(),
  allowEmpty: true,
  showHour: true,
  showMinute: true,
  showSecond: true,
  disabledHours: noop,
  disabledMinutes: noop,
  disabledSeconds: noop,
  hideDisabledOptions: false,
  placement: 'bottomLeft',
  onChange: noop,
  onOpen: noop,
  onClose: noop,
  onFocus: noop,
  onBlur: noop,
  addon: noop,
  use12Hours: false,
  focusOnOpen: false,
  onKeyDown: noop
};

var _initialiseProps = function _initialiseProps() {
  var _this2 = this;

  this.onPanelChange = function (value) {
    _this2.setValue(value);
  };

  this.onPanelClear = function () {
    _this2.setValue(null);
    _this2.setOpen(false);
  };

  this.onVisibleChange = function (open) {
    _this2.setOpen(open);
  };

  this.onEsc = function () {
    _this2.setOpen(false);
    _this2.focus();
  };

  this.onKeyDown = function (e) {
    if (e.keyCode === 40) {
      _this2.setOpen(true);
    }
  };
};

export default Picker;