import _toPath from 'lodash-es/toPath';


function createDeleteInWithCleanUp(structure) {
  var shouldDeleteDefault = function shouldDeleteDefault(structure) {
    return function (state, path) {
      return structure.getIn(state, path) !== undefined;
    };
  };

  var deepEqual = structure.deepEqual,
      empty = structure.empty,
      getIn = structure.getIn,
      deleteIn = structure.deleteIn,
      setIn = structure.setIn;


  return function () {
    var shouldDelete = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : shouldDeleteDefault;

    var deleteInWithCleanUp = function deleteInWithCleanUp(state, path) {
      if (path[path.length - 1] === ']') {
        // array path
        var pathTokens = _toPath(path);
        pathTokens.pop();
        var parent = getIn(state, pathTokens.join('.'));
        return parent ? setIn(state, path) : state;
      }

      var result = state;

      if (shouldDelete(structure)(state, path)) {
        result = deleteIn(state, path);
      }

      var dotIndex = path.lastIndexOf('.');
      if (dotIndex > 0) {
        var parentPath = path.substring(0, dotIndex);
        if (parentPath[parentPath.length - 1] !== ']') {
          var _parent = getIn(result, parentPath);
          if (deepEqual(_parent, empty)) {
            return deleteInWithCleanUp(result, parentPath);
          }
        }
      }
      return result;
    };

    return deleteInWithCleanUp;
  };
}

export default createDeleteInWithCleanUp;