'use strict';

exports.__esModule = true;
exports.isRSA = isRSA;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var _lodashIsplainobject = require('lodash.isplainobject');

var _lodashIsplainobject2 = _interopRequireDefault(_lodashIsplainobject);

var validKeys = {
  type: true,
  payload: true,
  error: true,
  meta: true
};

function isValidKey(key) {
  return validKeys[key];
}

function isRSA(action) {
  if (!_lodashIsplainobject2['default'](action)) {
    return false;
  }
  var type = action.type;
  var error = action.error;
  var payload = action.payload;

  var typeofType = typeof type;
  if (typeofType !== 'string' && typeofType !== 'symbol') {
    return false;
  }
  if (!Object.keys(action).every(isValidKey)) {
    return false;
  }

  if (error && !(payload instanceof Error)) {
    return false;
  }
  if (payload instanceof Error && !error) {
    return false;
  }
  return true;
}