// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/api/monitoring.proto

package serviceconfig // import "google.golang.org/genproto/googleapis/api/serviceconfig"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Monitoring configuration of the service.
//
// The example below shows how to configure monitored resources and metrics
// for monitoring. In the example, a monitored resource and two metrics are
// defined. The `library.googleapis.com/book/returned_count` metric is sent
// to both producer and consumer projects, whereas the
// `library.googleapis.com/book/overdue_count` metric is only sent to the
// consumer project.
//
//     monitored_resources:
//     - type: library.googleapis.com/branch
//       labels:
//       - key: /city
//         description: The city where the library branch is located in.
//       - key: /name
//         description: The name of the branch.
//     metrics:
//     - name: library.googleapis.com/book/returned_count
//       metric_kind: DELTA
//       value_type: INT64
//       labels:
//       - key: /customer_id
//     - name: library.googleapis.com/book/overdue_count
//       metric_kind: GAUGE
//       value_type: INT64
//       labels:
//       - key: /customer_id
//     monitoring:
//       producer_destinations:
//       - monitored_resource: library.googleapis.com/branch
//         metrics:
//         - library.googleapis.com/book/returned_count
//       consumer_destinations:
//       - monitored_resource: library.googleapis.com/branch
//         metrics:
//         - library.googleapis.com/book/returned_count
//         - library.googleapis.com/book/overdue_count
type Monitoring struct {
	// Monitoring configurations for sending metrics to the producer project.
	// There can be multiple producer destinations. A monitored resouce type may
	// appear in multiple monitoring destinations if different aggregations are
	// needed for different sets of metrics associated with that monitored
	// resource type. A monitored resource and metric pair may only be used once
	// in the Monitoring configuration.
	ProducerDestinations []*Monitoring_MonitoringDestination `protobuf:"bytes,1,rep,name=producer_destinations,json=producerDestinations,proto3" json:"producer_destinations,omitempty"`
	// Monitoring configurations for sending metrics to the consumer project.
	// There can be multiple consumer destinations. A monitored resouce type may
	// appear in multiple monitoring destinations if different aggregations are
	// needed for different sets of metrics associated with that monitored
	// resource type. A monitored resource and metric pair may only be used once
	// in the Monitoring configuration.
	ConsumerDestinations []*Monitoring_MonitoringDestination `protobuf:"bytes,2,rep,name=consumer_destinations,json=consumerDestinations,proto3" json:"consumer_destinations,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                            `json:"-"`
	XXX_unrecognized     []byte                              `json:"-"`
	XXX_sizecache        int32                               `json:"-"`
}

func (m *Monitoring) Reset()         { *m = Monitoring{} }
func (m *Monitoring) String() string { return proto.CompactTextString(m) }
func (*Monitoring) ProtoMessage()    {}
func (*Monitoring) Descriptor() ([]byte, []int) {
	return fileDescriptor_monitoring_607d42dbb71d0eb3, []int{0}
}
func (m *Monitoring) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Monitoring.Unmarshal(m, b)
}
func (m *Monitoring) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Monitoring.Marshal(b, m, deterministic)
}
func (dst *Monitoring) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Monitoring.Merge(dst, src)
}
func (m *Monitoring) XXX_Size() int {
	return xxx_messageInfo_Monitoring.Size(m)
}
func (m *Monitoring) XXX_DiscardUnknown() {
	xxx_messageInfo_Monitoring.DiscardUnknown(m)
}

var xxx_messageInfo_Monitoring proto.InternalMessageInfo

func (m *Monitoring) GetProducerDestinations() []*Monitoring_MonitoringDestination {
	if m != nil {
		return m.ProducerDestinations
	}
	return nil
}

func (m *Monitoring) GetConsumerDestinations() []*Monitoring_MonitoringDestination {
	if m != nil {
		return m.ConsumerDestinations
	}
	return nil
}

// Configuration of a specific monitoring destination (the producer project
// or the consumer project).
type Monitoring_MonitoringDestination struct {
	// The monitored resource type. The type must be defined in
	// [Service.monitored_resources][google.api.Service.monitored_resources] section.
	MonitoredResource string `protobuf:"bytes,1,opt,name=monitored_resource,json=monitoredResource,proto3" json:"monitored_resource,omitempty"`
	// Types of the metrics to report to this monitoring destination.
	// Each type must be defined in [Service.metrics][google.api.Service.metrics] section.
	Metrics              []string `protobuf:"bytes,2,rep,name=metrics,proto3" json:"metrics,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Monitoring_MonitoringDestination) Reset()         { *m = Monitoring_MonitoringDestination{} }
func (m *Monitoring_MonitoringDestination) String() string { return proto.CompactTextString(m) }
func (*Monitoring_MonitoringDestination) ProtoMessage()    {}
func (*Monitoring_MonitoringDestination) Descriptor() ([]byte, []int) {
	return fileDescriptor_monitoring_607d42dbb71d0eb3, []int{0, 0}
}
func (m *Monitoring_MonitoringDestination) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Monitoring_MonitoringDestination.Unmarshal(m, b)
}
func (m *Monitoring_MonitoringDestination) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Monitoring_MonitoringDestination.Marshal(b, m, deterministic)
}
func (dst *Monitoring_MonitoringDestination) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Monitoring_MonitoringDestination.Merge(dst, src)
}
func (m *Monitoring_MonitoringDestination) XXX_Size() int {
	return xxx_messageInfo_Monitoring_MonitoringDestination.Size(m)
}
func (m *Monitoring_MonitoringDestination) XXX_DiscardUnknown() {
	xxx_messageInfo_Monitoring_MonitoringDestination.DiscardUnknown(m)
}

var xxx_messageInfo_Monitoring_MonitoringDestination proto.InternalMessageInfo

func (m *Monitoring_MonitoringDestination) GetMonitoredResource() string {
	if m != nil {
		return m.MonitoredResource
	}
	return ""
}

func (m *Monitoring_MonitoringDestination) GetMetrics() []string {
	if m != nil {
		return m.Metrics
	}
	return nil
}

func init() {
	proto.RegisterType((*Monitoring)(nil), "google.api.Monitoring")
	proto.RegisterType((*Monitoring_MonitoringDestination)(nil), "google.api.Monitoring.MonitoringDestination")
}

func init() {
	proto.RegisterFile("google/api/monitoring.proto", fileDescriptor_monitoring_607d42dbb71d0eb3)
}

var fileDescriptor_monitoring_607d42dbb71d0eb3 = []byte{
	// 263 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x91, 0xcf, 0x4a, 0xc4, 0x30,
	0x10, 0xc6, 0xe9, 0x2a, 0xca, 0x46, 0x50, 0x0c, 0x2e, 0x14, 0xbd, 0x2c, 0x9e, 0xf6, 0xa0, 0x29,
	0xe8, 0xd1, 0x93, 0x8b, 0x22, 0x1e, 0x84, 0xd2, 0xa3, 0x97, 0x35, 0xa6, 0x63, 0x18, 0xd8, 0x66,
	0xe2, 0x24, 0xf5, 0x81, 0x7c, 0x06, 0x1f, 0x50, 0xb6, 0x7f, 0xb6, 0x55, 0x3c, 0x79, 0xcb, 0xe4,
	0x9b, 0x6f, 0x7e, 0xc3, 0x7c, 0xe2, 0xcc, 0x12, 0xd9, 0x35, 0x64, 0xda, 0x63, 0x56, 0x91, 0xc3,
	0x48, 0x8c, 0xce, 0x2a, 0xcf, 0x14, 0x49, 0x8a, 0x56, 0x54, 0xda, 0xe3, 0xf9, 0xd7, 0x44, 0x88,
	0xa7, 0x6d, 0x83, 0xd4, 0x62, 0xe6, 0x99, 0xca, 0xda, 0x00, 0xaf, 0x4a, 0x08, 0x11, 0x9d, 0x8e,
	0x48, 0x2e, 0xa4, 0xc9, 0x7c, 0x67, 0x71, 0x70, 0x75, 0xa1, 0x06, 0xab, 0x1a, 0x6c, 0xa3, 0xe7,
	0xdd, 0x60, 0x2a, 0x4e, 0xfa, 0x51, 0xa3, 0xcf, 0xb0, 0x41, 0x18, 0x72, 0xa1, 0xae, 0x7e, 0x23,
	0x26, 0xff, 0x41, 0xf4, 0xa3, 0xc6, 0x88, 0xd3, 0x17, 0x31, 0xfb, 0xb3, 0x5d, 0x5e, 0x0a, 0xd9,
	0x5d, 0x03, 0xca, 0x15, 0x43, 0xa0, 0x9a, 0x0d, 0xa4, 0xc9, 0x3c, 0x59, 0x4c, 0x8b, 0xe3, 0xad,
	0x52, 0x74, 0x82, 0x4c, 0xc5, 0x7e, 0x05, 0x91, 0xd1, 0xb4, 0xcb, 0x4d, 0x8b, 0xbe, 0x5c, 0xbe,
	0x8b, 0x43, 0x43, 0xd5, 0x68, 0xd5, 0xe5, 0xd1, 0x40, 0xcc, 0x37, 0x57, 0xce, 0x93, 0xe7, 0xfb,
	0x4e, 0xb6, 0xb4, 0xd6, 0xce, 0x2a, 0x62, 0x9b, 0x59, 0x70, 0x4d, 0x06, 0x59, 0x2b, 0x69, 0x8f,
	0xa1, 0xc9, 0x28, 0x00, 0x7f, 0xa0, 0x01, 0x43, 0xee, 0x0d, 0xed, 0xcd, 0x8f, 0xea, 0x73, 0xb2,
	0xfb, 0x70, 0x9b, 0x3f, 0xbe, 0xee, 0x35, 0xc6, 0xeb, 0xef, 0x00, 0x00, 0x00, 0xff, 0xff, 0xb1,
	0x9a, 0xd5, 0x79, 0xdb, 0x01, 0x00, 0x00,
}
