// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/webrisk/v1beta1/webrisk.proto

package webrisk // import "google.golang.org/genproto/googleapis/cloud/webrisk/v1beta1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"
import _ "google.golang.org/genproto/googleapis/api/annotations"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// The type of threat. This maps dirrectly to the threat list a threat may
// belong to.
type ThreatType int32

const (
	// Unknown.
	ThreatType_THREAT_TYPE_UNSPECIFIED ThreatType = 0
	// Malware targeting any platform.
	ThreatType_MALWARE ThreatType = 1
	// Social engineering targeting any platform.
	ThreatType_SOCIAL_ENGINEERING ThreatType = 2
	// Unwanted software targeting any platform.
	ThreatType_UNWANTED_SOFTWARE ThreatType = 3
)

var ThreatType_name = map[int32]string{
	0: "THREAT_TYPE_UNSPECIFIED",
	1: "MALWARE",
	2: "SOCIAL_ENGINEERING",
	3: "UNWANTED_SOFTWARE",
}
var ThreatType_value = map[string]int32{
	"THREAT_TYPE_UNSPECIFIED": 0,
	"MALWARE":                 1,
	"SOCIAL_ENGINEERING":      2,
	"UNWANTED_SOFTWARE":       3,
}

func (x ThreatType) String() string {
	return proto.EnumName(ThreatType_name, int32(x))
}
func (ThreatType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_webrisk_6b128999d2c68f99, []int{0}
}

// The ways in which threat entry sets can be compressed.
type CompressionType int32

const (
	// Unknown.
	CompressionType_COMPRESSION_TYPE_UNSPECIFIED CompressionType = 0
	// Raw, uncompressed data.
	CompressionType_RAW CompressionType = 1
	// Rice-Golomb encoded data.
	CompressionType_RICE CompressionType = 2
)

var CompressionType_name = map[int32]string{
	0: "COMPRESSION_TYPE_UNSPECIFIED",
	1: "RAW",
	2: "RICE",
}
var CompressionType_value = map[string]int32{
	"COMPRESSION_TYPE_UNSPECIFIED": 0,
	"RAW":                          1,
	"RICE":                         2,
}

func (x CompressionType) String() string {
	return proto.EnumName(CompressionType_name, int32(x))
}
func (CompressionType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_webrisk_6b128999d2c68f99, []int{1}
}

// The type of response sent to the client.
type ComputeThreatListDiffResponse_ResponseType int32

const (
	// Unknown.
	ComputeThreatListDiffResponse_RESPONSE_TYPE_UNSPECIFIED ComputeThreatListDiffResponse_ResponseType = 0
	// Partial updates are applied to the client's existing local database.
	ComputeThreatListDiffResponse_DIFF ComputeThreatListDiffResponse_ResponseType = 1
	// Full updates resets the client's entire local database. This means
	// that either the client had no state, was seriously out-of-date,
	// or the client is believed to be corrupt.
	ComputeThreatListDiffResponse_RESET ComputeThreatListDiffResponse_ResponseType = 2
)

var ComputeThreatListDiffResponse_ResponseType_name = map[int32]string{
	0: "RESPONSE_TYPE_UNSPECIFIED",
	1: "DIFF",
	2: "RESET",
}
var ComputeThreatListDiffResponse_ResponseType_value = map[string]int32{
	"RESPONSE_TYPE_UNSPECIFIED": 0,
	"DIFF":                      1,
	"RESET":                     2,
}

func (x ComputeThreatListDiffResponse_ResponseType) String() string {
	return proto.EnumName(ComputeThreatListDiffResponse_ResponseType_name, int32(x))
}
func (ComputeThreatListDiffResponse_ResponseType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_webrisk_6b128999d2c68f99, []int{1, 0}
}

// Describes an API diff request.
type ComputeThreatListDiffRequest struct {
	// Required. The ThreatList to update.
	ThreatType ThreatType `protobuf:"varint,1,opt,name=threat_type,json=threatType,proto3,enum=google.cloud.webrisk.v1beta1.ThreatType" json:"threat_type,omitempty"`
	// The current version token of the client for the requested list (the
	// client version that was received from the last successful diff).
	VersionToken []byte `protobuf:"bytes,2,opt,name=version_token,json=versionToken,proto3" json:"version_token,omitempty"`
	// The constraints associated with this request.
	Constraints          *ComputeThreatListDiffRequest_Constraints `protobuf:"bytes,3,opt,name=constraints,proto3" json:"constraints,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                  `json:"-"`
	XXX_unrecognized     []byte                                    `json:"-"`
	XXX_sizecache        int32                                     `json:"-"`
}

func (m *ComputeThreatListDiffRequest) Reset()         { *m = ComputeThreatListDiffRequest{} }
func (m *ComputeThreatListDiffRequest) String() string { return proto.CompactTextString(m) }
func (*ComputeThreatListDiffRequest) ProtoMessage()    {}
func (*ComputeThreatListDiffRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_webrisk_6b128999d2c68f99, []int{0}
}
func (m *ComputeThreatListDiffRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ComputeThreatListDiffRequest.Unmarshal(m, b)
}
func (m *ComputeThreatListDiffRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ComputeThreatListDiffRequest.Marshal(b, m, deterministic)
}
func (dst *ComputeThreatListDiffRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ComputeThreatListDiffRequest.Merge(dst, src)
}
func (m *ComputeThreatListDiffRequest) XXX_Size() int {
	return xxx_messageInfo_ComputeThreatListDiffRequest.Size(m)
}
func (m *ComputeThreatListDiffRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ComputeThreatListDiffRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ComputeThreatListDiffRequest proto.InternalMessageInfo

func (m *ComputeThreatListDiffRequest) GetThreatType() ThreatType {
	if m != nil {
		return m.ThreatType
	}
	return ThreatType_THREAT_TYPE_UNSPECIFIED
}

func (m *ComputeThreatListDiffRequest) GetVersionToken() []byte {
	if m != nil {
		return m.VersionToken
	}
	return nil
}

func (m *ComputeThreatListDiffRequest) GetConstraints() *ComputeThreatListDiffRequest_Constraints {
	if m != nil {
		return m.Constraints
	}
	return nil
}

// The constraints for this diff.
type ComputeThreatListDiffRequest_Constraints struct {
	// The maximum size in number of entries. The diff will not contain more
	// entries than this value.  This should be a power of 2 between 2**10 and
	// 2**20.  If zero, no diff size limit is set.
	MaxDiffEntries int32 `protobuf:"varint,1,opt,name=max_diff_entries,json=maxDiffEntries,proto3" json:"max_diff_entries,omitempty"`
	// Sets the maximum number of entries that the client is willing to have
	// in the local database. This should be a power of 2 between 2**10 and
	// 2**20. If zero, no database size limit is set.
	MaxDatabaseEntries int32 `protobuf:"varint,2,opt,name=max_database_entries,json=maxDatabaseEntries,proto3" json:"max_database_entries,omitempty"`
	// The compression types supported by the client.
	SupportedCompressions []CompressionType `protobuf:"varint,3,rep,packed,name=supported_compressions,json=supportedCompressions,proto3,enum=google.cloud.webrisk.v1beta1.CompressionType" json:"supported_compressions,omitempty"`
	XXX_NoUnkeyedLiteral  struct{}          `json:"-"`
	XXX_unrecognized      []byte            `json:"-"`
	XXX_sizecache         int32             `json:"-"`
}

func (m *ComputeThreatListDiffRequest_Constraints) Reset() {
	*m = ComputeThreatListDiffRequest_Constraints{}
}
func (m *ComputeThreatListDiffRequest_Constraints) String() string { return proto.CompactTextString(m) }
func (*ComputeThreatListDiffRequest_Constraints) ProtoMessage()    {}
func (*ComputeThreatListDiffRequest_Constraints) Descriptor() ([]byte, []int) {
	return fileDescriptor_webrisk_6b128999d2c68f99, []int{0, 0}
}
func (m *ComputeThreatListDiffRequest_Constraints) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ComputeThreatListDiffRequest_Constraints.Unmarshal(m, b)
}
func (m *ComputeThreatListDiffRequest_Constraints) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ComputeThreatListDiffRequest_Constraints.Marshal(b, m, deterministic)
}
func (dst *ComputeThreatListDiffRequest_Constraints) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ComputeThreatListDiffRequest_Constraints.Merge(dst, src)
}
func (m *ComputeThreatListDiffRequest_Constraints) XXX_Size() int {
	return xxx_messageInfo_ComputeThreatListDiffRequest_Constraints.Size(m)
}
func (m *ComputeThreatListDiffRequest_Constraints) XXX_DiscardUnknown() {
	xxx_messageInfo_ComputeThreatListDiffRequest_Constraints.DiscardUnknown(m)
}

var xxx_messageInfo_ComputeThreatListDiffRequest_Constraints proto.InternalMessageInfo

func (m *ComputeThreatListDiffRequest_Constraints) GetMaxDiffEntries() int32 {
	if m != nil {
		return m.MaxDiffEntries
	}
	return 0
}

func (m *ComputeThreatListDiffRequest_Constraints) GetMaxDatabaseEntries() int32 {
	if m != nil {
		return m.MaxDatabaseEntries
	}
	return 0
}

func (m *ComputeThreatListDiffRequest_Constraints) GetSupportedCompressions() []CompressionType {
	if m != nil {
		return m.SupportedCompressions
	}
	return nil
}

type ComputeThreatListDiffResponse struct {
	// The type of response. This may indicate that an action is required by the
	// client when the response is received.
	ResponseType ComputeThreatListDiffResponse_ResponseType `protobuf:"varint,4,opt,name=response_type,json=responseType,proto3,enum=google.cloud.webrisk.v1beta1.ComputeThreatListDiffResponse_ResponseType" json:"response_type,omitempty"`
	// A set of entries to add to a local threat type's list.
	Additions *ThreatEntryAdditions `protobuf:"bytes,5,opt,name=additions,proto3" json:"additions,omitempty"`
	// A set of entries to remove from a local threat type's list.
	// This field may be empty.
	Removals *ThreatEntryRemovals `protobuf:"bytes,6,opt,name=removals,proto3" json:"removals,omitempty"`
	// The new opaque client version token.
	NewVersionToken []byte `protobuf:"bytes,7,opt,name=new_version_token,json=newVersionToken,proto3" json:"new_version_token,omitempty"`
	// The expected SHA256 hash of the client state; that is, of the sorted list
	// of all hashes present in the database after applying the provided diff.
	// If the client state doesn't match the expected state, the client must
	// disregard this diff and retry later.
	Checksum *ComputeThreatListDiffResponse_Checksum `protobuf:"bytes,8,opt,name=checksum,proto3" json:"checksum,omitempty"`
	// The soonest the client should wait before issuing any diff
	// request. Querying sooner is unlikely to produce a meaningful diff.
	// Waiting longer is acceptable considering the use case.
	// If this field is not set clients may update as soon as they want.
	RecommendedNextDiff  *timestamp.Timestamp `protobuf:"bytes,2,opt,name=recommended_next_diff,json=recommendedNextDiff,proto3" json:"recommended_next_diff,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ComputeThreatListDiffResponse) Reset()         { *m = ComputeThreatListDiffResponse{} }
func (m *ComputeThreatListDiffResponse) String() string { return proto.CompactTextString(m) }
func (*ComputeThreatListDiffResponse) ProtoMessage()    {}
func (*ComputeThreatListDiffResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_webrisk_6b128999d2c68f99, []int{1}
}
func (m *ComputeThreatListDiffResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ComputeThreatListDiffResponse.Unmarshal(m, b)
}
func (m *ComputeThreatListDiffResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ComputeThreatListDiffResponse.Marshal(b, m, deterministic)
}
func (dst *ComputeThreatListDiffResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ComputeThreatListDiffResponse.Merge(dst, src)
}
func (m *ComputeThreatListDiffResponse) XXX_Size() int {
	return xxx_messageInfo_ComputeThreatListDiffResponse.Size(m)
}
func (m *ComputeThreatListDiffResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ComputeThreatListDiffResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ComputeThreatListDiffResponse proto.InternalMessageInfo

func (m *ComputeThreatListDiffResponse) GetResponseType() ComputeThreatListDiffResponse_ResponseType {
	if m != nil {
		return m.ResponseType
	}
	return ComputeThreatListDiffResponse_RESPONSE_TYPE_UNSPECIFIED
}

func (m *ComputeThreatListDiffResponse) GetAdditions() *ThreatEntryAdditions {
	if m != nil {
		return m.Additions
	}
	return nil
}

func (m *ComputeThreatListDiffResponse) GetRemovals() *ThreatEntryRemovals {
	if m != nil {
		return m.Removals
	}
	return nil
}

func (m *ComputeThreatListDiffResponse) GetNewVersionToken() []byte {
	if m != nil {
		return m.NewVersionToken
	}
	return nil
}

func (m *ComputeThreatListDiffResponse) GetChecksum() *ComputeThreatListDiffResponse_Checksum {
	if m != nil {
		return m.Checksum
	}
	return nil
}

func (m *ComputeThreatListDiffResponse) GetRecommendedNextDiff() *timestamp.Timestamp {
	if m != nil {
		return m.RecommendedNextDiff
	}
	return nil
}

// The expected state of a client's local database.
type ComputeThreatListDiffResponse_Checksum struct {
	// The SHA256 hash of the client state; that is, of the sorted list of all
	// hashes present in the database.
	Sha256               []byte   `protobuf:"bytes,1,opt,name=sha256,proto3" json:"sha256,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ComputeThreatListDiffResponse_Checksum) Reset() {
	*m = ComputeThreatListDiffResponse_Checksum{}
}
func (m *ComputeThreatListDiffResponse_Checksum) String() string { return proto.CompactTextString(m) }
func (*ComputeThreatListDiffResponse_Checksum) ProtoMessage()    {}
func (*ComputeThreatListDiffResponse_Checksum) Descriptor() ([]byte, []int) {
	return fileDescriptor_webrisk_6b128999d2c68f99, []int{1, 0}
}
func (m *ComputeThreatListDiffResponse_Checksum) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ComputeThreatListDiffResponse_Checksum.Unmarshal(m, b)
}
func (m *ComputeThreatListDiffResponse_Checksum) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ComputeThreatListDiffResponse_Checksum.Marshal(b, m, deterministic)
}
func (dst *ComputeThreatListDiffResponse_Checksum) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ComputeThreatListDiffResponse_Checksum.Merge(dst, src)
}
func (m *ComputeThreatListDiffResponse_Checksum) XXX_Size() int {
	return xxx_messageInfo_ComputeThreatListDiffResponse_Checksum.Size(m)
}
func (m *ComputeThreatListDiffResponse_Checksum) XXX_DiscardUnknown() {
	xxx_messageInfo_ComputeThreatListDiffResponse_Checksum.DiscardUnknown(m)
}

var xxx_messageInfo_ComputeThreatListDiffResponse_Checksum proto.InternalMessageInfo

func (m *ComputeThreatListDiffResponse_Checksum) GetSha256() []byte {
	if m != nil {
		return m.Sha256
	}
	return nil
}

// Request to check URI entries against threatLists.
type SearchUrisRequest struct {
	// The URI to be checked for matches.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	// Required. The ThreatLists to search in.
	ThreatTypes          []ThreatType `protobuf:"varint,2,rep,packed,name=threat_types,json=threatTypes,proto3,enum=google.cloud.webrisk.v1beta1.ThreatType" json:"threat_types,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *SearchUrisRequest) Reset()         { *m = SearchUrisRequest{} }
func (m *SearchUrisRequest) String() string { return proto.CompactTextString(m) }
func (*SearchUrisRequest) ProtoMessage()    {}
func (*SearchUrisRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_webrisk_6b128999d2c68f99, []int{2}
}
func (m *SearchUrisRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchUrisRequest.Unmarshal(m, b)
}
func (m *SearchUrisRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchUrisRequest.Marshal(b, m, deterministic)
}
func (dst *SearchUrisRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchUrisRequest.Merge(dst, src)
}
func (m *SearchUrisRequest) XXX_Size() int {
	return xxx_messageInfo_SearchUrisRequest.Size(m)
}
func (m *SearchUrisRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchUrisRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SearchUrisRequest proto.InternalMessageInfo

func (m *SearchUrisRequest) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

func (m *SearchUrisRequest) GetThreatTypes() []ThreatType {
	if m != nil {
		return m.ThreatTypes
	}
	return nil
}

type SearchUrisResponse struct {
	// The threat list matches. This may be empty if the URI is on no list.
	Threat               *SearchUrisResponse_ThreatUri `protobuf:"bytes,1,opt,name=threat,proto3" json:"threat,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *SearchUrisResponse) Reset()         { *m = SearchUrisResponse{} }
func (m *SearchUrisResponse) String() string { return proto.CompactTextString(m) }
func (*SearchUrisResponse) ProtoMessage()    {}
func (*SearchUrisResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_webrisk_6b128999d2c68f99, []int{3}
}
func (m *SearchUrisResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchUrisResponse.Unmarshal(m, b)
}
func (m *SearchUrisResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchUrisResponse.Marshal(b, m, deterministic)
}
func (dst *SearchUrisResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchUrisResponse.Merge(dst, src)
}
func (m *SearchUrisResponse) XXX_Size() int {
	return xxx_messageInfo_SearchUrisResponse.Size(m)
}
func (m *SearchUrisResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchUrisResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SearchUrisResponse proto.InternalMessageInfo

func (m *SearchUrisResponse) GetThreat() *SearchUrisResponse_ThreatUri {
	if m != nil {
		return m.Threat
	}
	return nil
}

// Contains threat information on a matching uri.
type SearchUrisResponse_ThreatUri struct {
	// The ThreatList this threat belongs to.
	ThreatTypes []ThreatType `protobuf:"varint,1,rep,packed,name=threat_types,json=threatTypes,proto3,enum=google.cloud.webrisk.v1beta1.ThreatType" json:"threat_types,omitempty"`
	// The cache lifetime for the returned match. Clients must not cache this
	// response past this timestamp to avoid false positives.
	ExpireTime           *timestamp.Timestamp `protobuf:"bytes,2,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *SearchUrisResponse_ThreatUri) Reset()         { *m = SearchUrisResponse_ThreatUri{} }
func (m *SearchUrisResponse_ThreatUri) String() string { return proto.CompactTextString(m) }
func (*SearchUrisResponse_ThreatUri) ProtoMessage()    {}
func (*SearchUrisResponse_ThreatUri) Descriptor() ([]byte, []int) {
	return fileDescriptor_webrisk_6b128999d2c68f99, []int{3, 0}
}
func (m *SearchUrisResponse_ThreatUri) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchUrisResponse_ThreatUri.Unmarshal(m, b)
}
func (m *SearchUrisResponse_ThreatUri) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchUrisResponse_ThreatUri.Marshal(b, m, deterministic)
}
func (dst *SearchUrisResponse_ThreatUri) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchUrisResponse_ThreatUri.Merge(dst, src)
}
func (m *SearchUrisResponse_ThreatUri) XXX_Size() int {
	return xxx_messageInfo_SearchUrisResponse_ThreatUri.Size(m)
}
func (m *SearchUrisResponse_ThreatUri) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchUrisResponse_ThreatUri.DiscardUnknown(m)
}

var xxx_messageInfo_SearchUrisResponse_ThreatUri proto.InternalMessageInfo

func (m *SearchUrisResponse_ThreatUri) GetThreatTypes() []ThreatType {
	if m != nil {
		return m.ThreatTypes
	}
	return nil
}

func (m *SearchUrisResponse_ThreatUri) GetExpireTime() *timestamp.Timestamp {
	if m != nil {
		return m.ExpireTime
	}
	return nil
}

// Request to return full hashes matched by the provided hash prefixes.
type SearchHashesRequest struct {
	// A hash prefix, consisting of the most significant 4-32 bytes of a SHA256
	// hash. For JSON requests, this field is base64-encoded.
	HashPrefix []byte `protobuf:"bytes,1,opt,name=hash_prefix,json=hashPrefix,proto3" json:"hash_prefix,omitempty"`
	// Required. The ThreatLists to search in.
	ThreatTypes          []ThreatType `protobuf:"varint,2,rep,packed,name=threat_types,json=threatTypes,proto3,enum=google.cloud.webrisk.v1beta1.ThreatType" json:"threat_types,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *SearchHashesRequest) Reset()         { *m = SearchHashesRequest{} }
func (m *SearchHashesRequest) String() string { return proto.CompactTextString(m) }
func (*SearchHashesRequest) ProtoMessage()    {}
func (*SearchHashesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_webrisk_6b128999d2c68f99, []int{4}
}
func (m *SearchHashesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchHashesRequest.Unmarshal(m, b)
}
func (m *SearchHashesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchHashesRequest.Marshal(b, m, deterministic)
}
func (dst *SearchHashesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchHashesRequest.Merge(dst, src)
}
func (m *SearchHashesRequest) XXX_Size() int {
	return xxx_messageInfo_SearchHashesRequest.Size(m)
}
func (m *SearchHashesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchHashesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SearchHashesRequest proto.InternalMessageInfo

func (m *SearchHashesRequest) GetHashPrefix() []byte {
	if m != nil {
		return m.HashPrefix
	}
	return nil
}

func (m *SearchHashesRequest) GetThreatTypes() []ThreatType {
	if m != nil {
		return m.ThreatTypes
	}
	return nil
}

type SearchHashesResponse struct {
	// The full hashes that matched the requested prefixes.
	// The hash will be populated in the key.
	Threats []*SearchHashesResponse_ThreatHash `protobuf:"bytes,1,rep,name=threats,proto3" json:"threats,omitempty"`
	// For requested entities that did not match the threat list, how long to
	// cache the response until.
	NegativeExpireTime   *timestamp.Timestamp `protobuf:"bytes,2,opt,name=negative_expire_time,json=negativeExpireTime,proto3" json:"negative_expire_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *SearchHashesResponse) Reset()         { *m = SearchHashesResponse{} }
func (m *SearchHashesResponse) String() string { return proto.CompactTextString(m) }
func (*SearchHashesResponse) ProtoMessage()    {}
func (*SearchHashesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_webrisk_6b128999d2c68f99, []int{5}
}
func (m *SearchHashesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchHashesResponse.Unmarshal(m, b)
}
func (m *SearchHashesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchHashesResponse.Marshal(b, m, deterministic)
}
func (dst *SearchHashesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchHashesResponse.Merge(dst, src)
}
func (m *SearchHashesResponse) XXX_Size() int {
	return xxx_messageInfo_SearchHashesResponse.Size(m)
}
func (m *SearchHashesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchHashesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SearchHashesResponse proto.InternalMessageInfo

func (m *SearchHashesResponse) GetThreats() []*SearchHashesResponse_ThreatHash {
	if m != nil {
		return m.Threats
	}
	return nil
}

func (m *SearchHashesResponse) GetNegativeExpireTime() *timestamp.Timestamp {
	if m != nil {
		return m.NegativeExpireTime
	}
	return nil
}

// Contains threat information on a matching hash.
type SearchHashesResponse_ThreatHash struct {
	// The ThreatList this threat belongs to.
	// This must contain at least one entry.
	ThreatTypes []ThreatType `protobuf:"varint,1,rep,packed,name=threat_types,json=threatTypes,proto3,enum=google.cloud.webrisk.v1beta1.ThreatType" json:"threat_types,omitempty"`
	// A 32 byte SHA256 hash. This field is in binary format. For JSON
	// requests, hashes are base64-encoded.
	Hash []byte `protobuf:"bytes,2,opt,name=hash,proto3" json:"hash,omitempty"`
	// The cache lifetime for the returned match. Clients must not cache this
	// response past this timestamp to avoid false positives.
	ExpireTime           *timestamp.Timestamp `protobuf:"bytes,3,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *SearchHashesResponse_ThreatHash) Reset()         { *m = SearchHashesResponse_ThreatHash{} }
func (m *SearchHashesResponse_ThreatHash) String() string { return proto.CompactTextString(m) }
func (*SearchHashesResponse_ThreatHash) ProtoMessage()    {}
func (*SearchHashesResponse_ThreatHash) Descriptor() ([]byte, []int) {
	return fileDescriptor_webrisk_6b128999d2c68f99, []int{5, 0}
}
func (m *SearchHashesResponse_ThreatHash) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchHashesResponse_ThreatHash.Unmarshal(m, b)
}
func (m *SearchHashesResponse_ThreatHash) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchHashesResponse_ThreatHash.Marshal(b, m, deterministic)
}
func (dst *SearchHashesResponse_ThreatHash) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchHashesResponse_ThreatHash.Merge(dst, src)
}
func (m *SearchHashesResponse_ThreatHash) XXX_Size() int {
	return xxx_messageInfo_SearchHashesResponse_ThreatHash.Size(m)
}
func (m *SearchHashesResponse_ThreatHash) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchHashesResponse_ThreatHash.DiscardUnknown(m)
}

var xxx_messageInfo_SearchHashesResponse_ThreatHash proto.InternalMessageInfo

func (m *SearchHashesResponse_ThreatHash) GetThreatTypes() []ThreatType {
	if m != nil {
		return m.ThreatTypes
	}
	return nil
}

func (m *SearchHashesResponse_ThreatHash) GetHash() []byte {
	if m != nil {
		return m.Hash
	}
	return nil
}

func (m *SearchHashesResponse_ThreatHash) GetExpireTime() *timestamp.Timestamp {
	if m != nil {
		return m.ExpireTime
	}
	return nil
}

// Contains the set of entries to add to a local database.
// May contain a combination of compressed and raw data in a single response.
type ThreatEntryAdditions struct {
	// The raw SHA256-formatted entries.
	// Repeated to allow returning sets of hashes with different prefix sizes.
	RawHashes []*RawHashes `protobuf:"bytes,1,rep,name=raw_hashes,json=rawHashes,proto3" json:"raw_hashes,omitempty"`
	// The encoded 4-byte prefixes of SHA256-formatted entries, using a
	// Golomb-Rice encoding. The hashes are converted to uint32, sorted in
	// ascending order, then delta encoded and stored as encoded_data.
	RiceHashes           *RiceDeltaEncoding `protobuf:"bytes,2,opt,name=rice_hashes,json=riceHashes,proto3" json:"rice_hashes,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *ThreatEntryAdditions) Reset()         { *m = ThreatEntryAdditions{} }
func (m *ThreatEntryAdditions) String() string { return proto.CompactTextString(m) }
func (*ThreatEntryAdditions) ProtoMessage()    {}
func (*ThreatEntryAdditions) Descriptor() ([]byte, []int) {
	return fileDescriptor_webrisk_6b128999d2c68f99, []int{6}
}
func (m *ThreatEntryAdditions) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ThreatEntryAdditions.Unmarshal(m, b)
}
func (m *ThreatEntryAdditions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ThreatEntryAdditions.Marshal(b, m, deterministic)
}
func (dst *ThreatEntryAdditions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ThreatEntryAdditions.Merge(dst, src)
}
func (m *ThreatEntryAdditions) XXX_Size() int {
	return xxx_messageInfo_ThreatEntryAdditions.Size(m)
}
func (m *ThreatEntryAdditions) XXX_DiscardUnknown() {
	xxx_messageInfo_ThreatEntryAdditions.DiscardUnknown(m)
}

var xxx_messageInfo_ThreatEntryAdditions proto.InternalMessageInfo

func (m *ThreatEntryAdditions) GetRawHashes() []*RawHashes {
	if m != nil {
		return m.RawHashes
	}
	return nil
}

func (m *ThreatEntryAdditions) GetRiceHashes() *RiceDeltaEncoding {
	if m != nil {
		return m.RiceHashes
	}
	return nil
}

// Contains the set of entries to remove from a local database.
type ThreatEntryRemovals struct {
	// The raw removal indices for a local list.
	RawIndices *RawIndices `protobuf:"bytes,1,opt,name=raw_indices,json=rawIndices,proto3" json:"raw_indices,omitempty"`
	// The encoded local, lexicographically-sorted list indices, using a
	// Golomb-Rice encoding. Used for sending compressed removal indices. The
	// removal indices (uint32) are sorted in ascending order, then delta encoded
	// and stored as encoded_data.
	RiceIndices          *RiceDeltaEncoding `protobuf:"bytes,2,opt,name=rice_indices,json=riceIndices,proto3" json:"rice_indices,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *ThreatEntryRemovals) Reset()         { *m = ThreatEntryRemovals{} }
func (m *ThreatEntryRemovals) String() string { return proto.CompactTextString(m) }
func (*ThreatEntryRemovals) ProtoMessage()    {}
func (*ThreatEntryRemovals) Descriptor() ([]byte, []int) {
	return fileDescriptor_webrisk_6b128999d2c68f99, []int{7}
}
func (m *ThreatEntryRemovals) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ThreatEntryRemovals.Unmarshal(m, b)
}
func (m *ThreatEntryRemovals) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ThreatEntryRemovals.Marshal(b, m, deterministic)
}
func (dst *ThreatEntryRemovals) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ThreatEntryRemovals.Merge(dst, src)
}
func (m *ThreatEntryRemovals) XXX_Size() int {
	return xxx_messageInfo_ThreatEntryRemovals.Size(m)
}
func (m *ThreatEntryRemovals) XXX_DiscardUnknown() {
	xxx_messageInfo_ThreatEntryRemovals.DiscardUnknown(m)
}

var xxx_messageInfo_ThreatEntryRemovals proto.InternalMessageInfo

func (m *ThreatEntryRemovals) GetRawIndices() *RawIndices {
	if m != nil {
		return m.RawIndices
	}
	return nil
}

func (m *ThreatEntryRemovals) GetRiceIndices() *RiceDeltaEncoding {
	if m != nil {
		return m.RiceIndices
	}
	return nil
}

// A set of raw indices to remove from a local list.
type RawIndices struct {
	// The indices to remove from a lexicographically-sorted local list.
	Indices              []int32  `protobuf:"varint,1,rep,packed,name=indices,proto3" json:"indices,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RawIndices) Reset()         { *m = RawIndices{} }
func (m *RawIndices) String() string { return proto.CompactTextString(m) }
func (*RawIndices) ProtoMessage()    {}
func (*RawIndices) Descriptor() ([]byte, []int) {
	return fileDescriptor_webrisk_6b128999d2c68f99, []int{8}
}
func (m *RawIndices) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RawIndices.Unmarshal(m, b)
}
func (m *RawIndices) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RawIndices.Marshal(b, m, deterministic)
}
func (dst *RawIndices) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RawIndices.Merge(dst, src)
}
func (m *RawIndices) XXX_Size() int {
	return xxx_messageInfo_RawIndices.Size(m)
}
func (m *RawIndices) XXX_DiscardUnknown() {
	xxx_messageInfo_RawIndices.DiscardUnknown(m)
}

var xxx_messageInfo_RawIndices proto.InternalMessageInfo

func (m *RawIndices) GetIndices() []int32 {
	if m != nil {
		return m.Indices
	}
	return nil
}

// The uncompressed threat entries in hash format.
// Hashes can be anywhere from 4 to 32 bytes in size. A large majority are 4
// bytes, but some hashes are lengthened if they collide with the hash of a
// popular URI.
//
// Used for sending ThreatEntryAdditons to clients that do not support
// compression, or when sending non-4-byte hashes to clients that do support
// compression.
type RawHashes struct {
	// The number of bytes for each prefix encoded below.  This field can be
	// anywhere from 4 (shortest prefix) to 32 (full SHA256 hash).
	PrefixSize int32 `protobuf:"varint,1,opt,name=prefix_size,json=prefixSize,proto3" json:"prefix_size,omitempty"`
	// The hashes, in binary format, concatenated into one long string. Hashes are
	// sorted in lexicographic order. For JSON API users, hashes are
	// base64-encoded.
	RawHashes            []byte   `protobuf:"bytes,2,opt,name=raw_hashes,json=rawHashes,proto3" json:"raw_hashes,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RawHashes) Reset()         { *m = RawHashes{} }
func (m *RawHashes) String() string { return proto.CompactTextString(m) }
func (*RawHashes) ProtoMessage()    {}
func (*RawHashes) Descriptor() ([]byte, []int) {
	return fileDescriptor_webrisk_6b128999d2c68f99, []int{9}
}
func (m *RawHashes) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RawHashes.Unmarshal(m, b)
}
func (m *RawHashes) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RawHashes.Marshal(b, m, deterministic)
}
func (dst *RawHashes) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RawHashes.Merge(dst, src)
}
func (m *RawHashes) XXX_Size() int {
	return xxx_messageInfo_RawHashes.Size(m)
}
func (m *RawHashes) XXX_DiscardUnknown() {
	xxx_messageInfo_RawHashes.DiscardUnknown(m)
}

var xxx_messageInfo_RawHashes proto.InternalMessageInfo

func (m *RawHashes) GetPrefixSize() int32 {
	if m != nil {
		return m.PrefixSize
	}
	return 0
}

func (m *RawHashes) GetRawHashes() []byte {
	if m != nil {
		return m.RawHashes
	}
	return nil
}

// The Rice-Golomb encoded data. Used for sending compressed 4-byte hashes or
// compressed removal indices.
type RiceDeltaEncoding struct {
	// The offset of the first entry in the encoded data, or, if only a single
	// integer was encoded, that single integer's value. If the field is empty or
	// missing, assume zero.
	FirstValue int64 `protobuf:"varint,1,opt,name=first_value,json=firstValue,proto3" json:"first_value,omitempty"`
	// The Golomb-Rice parameter, which is a number between 2 and 28. This field
	// is missing (that is, zero) if `num_entries` is zero.
	RiceParameter int32 `protobuf:"varint,2,opt,name=rice_parameter,json=riceParameter,proto3" json:"rice_parameter,omitempty"`
	// The number of entries that are delta encoded in the encoded data. If only a
	// single integer was encoded, this will be zero and the single value will be
	// stored in `first_value`.
	EntryCount int32 `protobuf:"varint,3,opt,name=entry_count,json=entryCount,proto3" json:"entry_count,omitempty"`
	// The encoded deltas that are encoded using the Golomb-Rice coder.
	EncodedData          []byte   `protobuf:"bytes,4,opt,name=encoded_data,json=encodedData,proto3" json:"encoded_data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RiceDeltaEncoding) Reset()         { *m = RiceDeltaEncoding{} }
func (m *RiceDeltaEncoding) String() string { return proto.CompactTextString(m) }
func (*RiceDeltaEncoding) ProtoMessage()    {}
func (*RiceDeltaEncoding) Descriptor() ([]byte, []int) {
	return fileDescriptor_webrisk_6b128999d2c68f99, []int{10}
}
func (m *RiceDeltaEncoding) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RiceDeltaEncoding.Unmarshal(m, b)
}
func (m *RiceDeltaEncoding) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RiceDeltaEncoding.Marshal(b, m, deterministic)
}
func (dst *RiceDeltaEncoding) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RiceDeltaEncoding.Merge(dst, src)
}
func (m *RiceDeltaEncoding) XXX_Size() int {
	return xxx_messageInfo_RiceDeltaEncoding.Size(m)
}
func (m *RiceDeltaEncoding) XXX_DiscardUnknown() {
	xxx_messageInfo_RiceDeltaEncoding.DiscardUnknown(m)
}

var xxx_messageInfo_RiceDeltaEncoding proto.InternalMessageInfo

func (m *RiceDeltaEncoding) GetFirstValue() int64 {
	if m != nil {
		return m.FirstValue
	}
	return 0
}

func (m *RiceDeltaEncoding) GetRiceParameter() int32 {
	if m != nil {
		return m.RiceParameter
	}
	return 0
}

func (m *RiceDeltaEncoding) GetEntryCount() int32 {
	if m != nil {
		return m.EntryCount
	}
	return 0
}

func (m *RiceDeltaEncoding) GetEncodedData() []byte {
	if m != nil {
		return m.EncodedData
	}
	return nil
}

func init() {
	proto.RegisterType((*ComputeThreatListDiffRequest)(nil), "google.cloud.webrisk.v1beta1.ComputeThreatListDiffRequest")
	proto.RegisterType((*ComputeThreatListDiffRequest_Constraints)(nil), "google.cloud.webrisk.v1beta1.ComputeThreatListDiffRequest.Constraints")
	proto.RegisterType((*ComputeThreatListDiffResponse)(nil), "google.cloud.webrisk.v1beta1.ComputeThreatListDiffResponse")
	proto.RegisterType((*ComputeThreatListDiffResponse_Checksum)(nil), "google.cloud.webrisk.v1beta1.ComputeThreatListDiffResponse.Checksum")
	proto.RegisterType((*SearchUrisRequest)(nil), "google.cloud.webrisk.v1beta1.SearchUrisRequest")
	proto.RegisterType((*SearchUrisResponse)(nil), "google.cloud.webrisk.v1beta1.SearchUrisResponse")
	proto.RegisterType((*SearchUrisResponse_ThreatUri)(nil), "google.cloud.webrisk.v1beta1.SearchUrisResponse.ThreatUri")
	proto.RegisterType((*SearchHashesRequest)(nil), "google.cloud.webrisk.v1beta1.SearchHashesRequest")
	proto.RegisterType((*SearchHashesResponse)(nil), "google.cloud.webrisk.v1beta1.SearchHashesResponse")
	proto.RegisterType((*SearchHashesResponse_ThreatHash)(nil), "google.cloud.webrisk.v1beta1.SearchHashesResponse.ThreatHash")
	proto.RegisterType((*ThreatEntryAdditions)(nil), "google.cloud.webrisk.v1beta1.ThreatEntryAdditions")
	proto.RegisterType((*ThreatEntryRemovals)(nil), "google.cloud.webrisk.v1beta1.ThreatEntryRemovals")
	proto.RegisterType((*RawIndices)(nil), "google.cloud.webrisk.v1beta1.RawIndices")
	proto.RegisterType((*RawHashes)(nil), "google.cloud.webrisk.v1beta1.RawHashes")
	proto.RegisterType((*RiceDeltaEncoding)(nil), "google.cloud.webrisk.v1beta1.RiceDeltaEncoding")
	proto.RegisterEnum("google.cloud.webrisk.v1beta1.ThreatType", ThreatType_name, ThreatType_value)
	proto.RegisterEnum("google.cloud.webrisk.v1beta1.CompressionType", CompressionType_name, CompressionType_value)
	proto.RegisterEnum("google.cloud.webrisk.v1beta1.ComputeThreatListDiffResponse_ResponseType", ComputeThreatListDiffResponse_ResponseType_name, ComputeThreatListDiffResponse_ResponseType_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// WebRiskServiceV1Beta1Client is the client API for WebRiskServiceV1Beta1 service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type WebRiskServiceV1Beta1Client interface {
	// Gets the most recent threat list diffs.
	ComputeThreatListDiff(ctx context.Context, in *ComputeThreatListDiffRequest, opts ...grpc.CallOption) (*ComputeThreatListDiffResponse, error)
	// This method is used to check whether a URI is on a given threatList.
	SearchUris(ctx context.Context, in *SearchUrisRequest, opts ...grpc.CallOption) (*SearchUrisResponse, error)
	// Gets the full hashes that match the requested hash prefix.
	// This is used after a hash prefix is looked up in a threatList
	// and there is a match. The client side threatList only holds partial hashes
	// so the client must query this method to determine if there is a full
	// hash match of a threat.
	SearchHashes(ctx context.Context, in *SearchHashesRequest, opts ...grpc.CallOption) (*SearchHashesResponse, error)
}

type webRiskServiceV1Beta1Client struct {
	cc *grpc.ClientConn
}

func NewWebRiskServiceV1Beta1Client(cc *grpc.ClientConn) WebRiskServiceV1Beta1Client {
	return &webRiskServiceV1Beta1Client{cc}
}

func (c *webRiskServiceV1Beta1Client) ComputeThreatListDiff(ctx context.Context, in *ComputeThreatListDiffRequest, opts ...grpc.CallOption) (*ComputeThreatListDiffResponse, error) {
	out := new(ComputeThreatListDiffResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.webrisk.v1beta1.WebRiskServiceV1Beta1/ComputeThreatListDiff", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *webRiskServiceV1Beta1Client) SearchUris(ctx context.Context, in *SearchUrisRequest, opts ...grpc.CallOption) (*SearchUrisResponse, error) {
	out := new(SearchUrisResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.webrisk.v1beta1.WebRiskServiceV1Beta1/SearchUris", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *webRiskServiceV1Beta1Client) SearchHashes(ctx context.Context, in *SearchHashesRequest, opts ...grpc.CallOption) (*SearchHashesResponse, error) {
	out := new(SearchHashesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.webrisk.v1beta1.WebRiskServiceV1Beta1/SearchHashes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// WebRiskServiceV1Beta1Server is the server API for WebRiskServiceV1Beta1 service.
type WebRiskServiceV1Beta1Server interface {
	// Gets the most recent threat list diffs.
	ComputeThreatListDiff(context.Context, *ComputeThreatListDiffRequest) (*ComputeThreatListDiffResponse, error)
	// This method is used to check whether a URI is on a given threatList.
	SearchUris(context.Context, *SearchUrisRequest) (*SearchUrisResponse, error)
	// Gets the full hashes that match the requested hash prefix.
	// This is used after a hash prefix is looked up in a threatList
	// and there is a match. The client side threatList only holds partial hashes
	// so the client must query this method to determine if there is a full
	// hash match of a threat.
	SearchHashes(context.Context, *SearchHashesRequest) (*SearchHashesResponse, error)
}

func RegisterWebRiskServiceV1Beta1Server(s *grpc.Server, srv WebRiskServiceV1Beta1Server) {
	s.RegisterService(&_WebRiskServiceV1Beta1_serviceDesc, srv)
}

func _WebRiskServiceV1Beta1_ComputeThreatListDiff_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ComputeThreatListDiffRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WebRiskServiceV1Beta1Server).ComputeThreatListDiff(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.webrisk.v1beta1.WebRiskServiceV1Beta1/ComputeThreatListDiff",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WebRiskServiceV1Beta1Server).ComputeThreatListDiff(ctx, req.(*ComputeThreatListDiffRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WebRiskServiceV1Beta1_SearchUris_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchUrisRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WebRiskServiceV1Beta1Server).SearchUris(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.webrisk.v1beta1.WebRiskServiceV1Beta1/SearchUris",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WebRiskServiceV1Beta1Server).SearchUris(ctx, req.(*SearchUrisRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _WebRiskServiceV1Beta1_SearchHashes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchHashesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(WebRiskServiceV1Beta1Server).SearchHashes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.webrisk.v1beta1.WebRiskServiceV1Beta1/SearchHashes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(WebRiskServiceV1Beta1Server).SearchHashes(ctx, req.(*SearchHashesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _WebRiskServiceV1Beta1_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.webrisk.v1beta1.WebRiskServiceV1Beta1",
	HandlerType: (*WebRiskServiceV1Beta1Server)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ComputeThreatListDiff",
			Handler:    _WebRiskServiceV1Beta1_ComputeThreatListDiff_Handler,
		},
		{
			MethodName: "SearchUris",
			Handler:    _WebRiskServiceV1Beta1_SearchUris_Handler,
		},
		{
			MethodName: "SearchHashes",
			Handler:    _WebRiskServiceV1Beta1_SearchHashes_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/webrisk/v1beta1/webrisk.proto",
}

func init() {
	proto.RegisterFile("google/cloud/webrisk/v1beta1/webrisk.proto", fileDescriptor_webrisk_6b128999d2c68f99)
}

var fileDescriptor_webrisk_6b128999d2c68f99 = []byte{
	// 1333 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x57, 0xcd, 0x6f, 0x1b, 0x45,
	0x14, 0x67, 0xed, 0x7c, 0xbe, 0x75, 0x53, 0x67, 0x9a, 0x04, 0x63, 0x52, 0x1a, 0x16, 0x01, 0x56,
	0x24, 0xec, 0xc6, 0x08, 0x0e, 0xa9, 0x38, 0x38, 0xce, 0x3a, 0xb5, 0x9a, 0x3a, 0xd6, 0xd8, 0x49,
	0x04, 0xaa, 0xb4, 0x4c, 0xd6, 0x63, 0x7b, 0x94, 0x78, 0x77, 0x99, 0x59, 0xe7, 0xa3, 0x27, 0x04,
	0x67, 0x4e, 0xa8, 0x67, 0x24, 0x8e, 0x3d, 0x71, 0x40, 0x1c, 0xf8, 0x13, 0x7a, 0xe1, 0xc0, 0xbf,
	0xc0, 0x89, 0x3b, 0x37, 0x0e, 0x68, 0x66, 0x67, 0xd7, 0x6e, 0x1b, 0xd2, 0xa4, 0xe9, 0x6d, 0xf6,
	0xbd, 0x37, 0xbf, 0xf7, 0x39, 0xef, 0xbd, 0x85, 0xd5, 0x9e, 0xef, 0xf7, 0x8e, 0x68, 0xc9, 0x3d,
	0xf2, 0x87, 0x9d, 0xd2, 0x09, 0x3d, 0xe0, 0x4c, 0x1c, 0x96, 0x8e, 0xd7, 0x0e, 0x68, 0x48, 0xd6,
	0xe2, 0xef, 0x62, 0xc0, 0xfd, 0xd0, 0x47, 0xcb, 0x91, 0x6c, 0x51, 0xc9, 0x16, 0x63, 0x9e, 0x96,
	0xcd, 0x6b, 0x6e, 0x89, 0x04, 0xac, 0x44, 0x3c, 0xcf, 0x0f, 0x49, 0xc8, 0x7c, 0x4f, 0x44, 0x77,
	0xf3, 0x77, 0x34, 0x57, 0x7d, 0x1d, 0x0c, 0xbb, 0xa5, 0x90, 0x0d, 0xa8, 0x08, 0xc9, 0x20, 0x88,
	0x04, 0xac, 0x67, 0x69, 0x58, 0xae, 0xfa, 0x83, 0x60, 0x18, 0xd2, 0x76, 0x9f, 0x53, 0x12, 0x6e,
	0x33, 0x11, 0x6e, 0xb2, 0x6e, 0x17, 0xd3, 0x6f, 0x86, 0x54, 0x84, 0xa8, 0x0e, 0x66, 0xa8, 0x18,
	0x4e, 0x78, 0x16, 0xd0, 0x9c, 0xb1, 0x62, 0x14, 0xe6, 0xca, 0x85, 0xe2, 0x45, 0x36, 0x15, 0x23,
	0xa4, 0xf6, 0x59, 0x40, 0x31, 0x84, 0xc9, 0x19, 0x7d, 0x00, 0x37, 0x8e, 0x29, 0x17, 0xcc, 0xf7,
	0x9c, 0xd0, 0x3f, 0xa4, 0x5e, 0x2e, 0xb5, 0x62, 0x14, 0x32, 0x38, 0xa3, 0x89, 0x6d, 0x49, 0x43,
	0x7d, 0x30, 0x5d, 0xdf, 0x13, 0x21, 0x27, 0xcc, 0x0b, 0x45, 0x2e, 0xbd, 0x62, 0x14, 0xcc, 0x72,
	0xed, 0x62, 0x7d, 0x17, 0x39, 0x50, 0xac, 0x8e, 0xd0, 0xf0, 0x38, 0x74, 0xfe, 0x0f, 0x03, 0xcc,
	0x31, 0x26, 0x2a, 0x40, 0x76, 0x40, 0x4e, 0x9d, 0x0e, 0xeb, 0x76, 0x1d, 0xea, 0x85, 0x9c, 0x51,
	0xa1, 0xdc, 0x9d, 0xc4, 0x73, 0x03, 0x72, 0x2a, 0x21, 0xed, 0x88, 0x8a, 0xee, 0xc2, 0x82, 0x92,
	0x24, 0x21, 0x39, 0x20, 0x82, 0x26, 0xd2, 0x29, 0x25, 0x8d, 0xa4, 0xb4, 0x66, 0xc5, 0x37, 0x3a,
	0xb0, 0x24, 0x86, 0x41, 0xe0, 0xf3, 0x90, 0x76, 0x1c, 0xd7, 0x1f, 0x04, 0x9c, 0x0a, 0xe9, 0xb3,
	0x74, 0x30, 0x5d, 0x98, 0x2b, 0x7f, 0xf2, 0x6a, 0x07, 0xf5, 0x0d, 0x15, 0xd5, 0xc5, 0x04, 0x6c,
	0x8c, 0x23, 0xac, 0x7f, 0x26, 0xe0, 0xf6, 0xff, 0xc4, 0x42, 0x04, 0xbe, 0x27, 0x28, 0x1a, 0xc0,
	0x0d, 0xae, 0xcf, 0x51, 0x3e, 0x27, 0x54, 0x3e, 0xef, 0xbf, 0x56, 0x7c, 0x23, 0x9c, 0x62, 0x7c,
	0x50, 0x96, 0x65, 0xf8, 0xd8, 0x17, 0x6a, 0xc2, 0x2c, 0xe9, 0x74, 0x98, 0xaa, 0xc8, 0xdc, 0xa4,
	0x4a, 0x65, 0xf9, 0x32, 0xa5, 0x23, 0xc3, 0x76, 0x56, 0x89, 0x6f, 0xe2, 0x11, 0x08, 0x7a, 0x08,
	0x33, 0x9c, 0x0e, 0xfc, 0x63, 0x72, 0x24, 0x72, 0x53, 0x0a, 0x70, 0xed, 0xd2, 0x80, 0x58, 0x5f,
	0xc4, 0x09, 0x04, 0x5a, 0x85, 0x79, 0x8f, 0x9e, 0x38, 0xcf, 0x97, 0xe5, 0xb4, 0x2a, 0xcb, 0x9b,
	0x1e, 0x3d, 0xd9, 0x1b, 0xaf, 0xcc, 0xaf, 0x61, 0xc6, 0xed, 0x53, 0xf7, 0x50, 0x0c, 0x07, 0xb9,
	0x19, 0xa5, 0x7a, 0xf3, 0x3a, 0x61, 0xab, 0x6a, 0x2c, 0x9c, 0xa0, 0xa2, 0x06, 0x2c, 0x72, 0xea,
	0xfa, 0x83, 0x01, 0xf5, 0x3a, 0xb4, 0xe3, 0x78, 0xf4, 0x34, 0x54, 0xe5, 0xa8, 0x0a, 0xcb, 0x2c,
	0xe7, 0x63, 0x75, 0xf1, 0x6b, 0x2e, 0xb6, 0xe3, 0xd7, 0x8c, 0x6f, 0x8d, 0x5d, 0x6c, 0xd0, 0x53,
	0xa5, 0x2a, 0x6f, 0xc1, 0x4c, 0xac, 0x05, 0x2d, 0xc1, 0x94, 0xe8, 0x93, 0xf2, 0x67, 0x9f, 0xab,
	0x9a, 0xce, 0x60, 0xfd, 0x65, 0x6d, 0x40, 0x66, 0x3c, 0x81, 0xe8, 0x36, 0xbc, 0x83, 0xed, 0x56,
	0x73, 0xa7, 0xd1, 0xb2, 0x9d, 0xf6, 0x97, 0x4d, 0xdb, 0xd9, 0x6d, 0xb4, 0x9a, 0x76, 0xb5, 0x5e,
	0xab, 0xdb, 0x9b, 0xd9, 0xb7, 0xd0, 0x0c, 0x4c, 0x6c, 0xd6, 0x6b, 0xb5, 0xac, 0x81, 0x66, 0x61,
	0x12, 0xdb, 0x2d, 0xbb, 0x9d, 0x4d, 0x59, 0x1c, 0xe6, 0x5b, 0x94, 0x70, 0xb7, 0xbf, 0xcb, 0x99,
	0x88, 0x1b, 0x47, 0x16, 0xd2, 0x43, 0xce, 0x94, 0xb6, 0x59, 0x2c, 0x8f, 0xe8, 0x01, 0x64, 0xc6,
	0x5a, 0x89, 0x7c, 0x2e, 0xe9, 0x2b, 0xf5, 0x12, 0x73, 0xd4, 0x4b, 0x84, 0xf5, 0x6d, 0x0a, 0xd0,
	0xb8, 0x52, 0x5d, 0xe0, 0x18, 0xa6, 0x22, 0x29, 0xa5, 0xd8, 0x2c, 0xaf, 0x5f, 0x8c, 0xfe, 0x32,
	0x82, 0x56, 0xb8, 0xcb, 0x19, 0xd6, 0x48, 0xf9, 0x27, 0x06, 0xcc, 0x26, 0xd4, 0x97, 0xbc, 0x30,
	0xae, 0xe1, 0x05, 0xba, 0x07, 0x26, 0x3d, 0x0d, 0x18, 0xa7, 0x8e, 0x6c, 0xcc, 0x97, 0xc8, 0x33,
	0x44, 0xe2, 0x92, 0x60, 0x7d, 0x6f, 0xc0, 0xad, 0xc8, 0x81, 0xfb, 0x44, 0xf4, 0x69, 0x12, 0xf9,
	0x3b, 0x60, 0xf6, 0x89, 0xe8, 0x3b, 0x01, 0xa7, 0x5d, 0x76, 0xaa, 0xf3, 0x0d, 0x92, 0xd4, 0x54,
	0x94, 0x37, 0x9b, 0x88, 0xbf, 0x53, 0xb0, 0xf0, 0xbc, 0x15, 0x3a, 0x15, 0xfb, 0x30, 0x1d, 0xc9,
	0x45, 0x31, 0x32, 0xcb, 0x5f, 0x5c, 0x26, 0x17, 0xcf, 0x83, 0x68, 0xad, 0x92, 0x88, 0x63, 0x34,
	0xb4, 0x0d, 0x0b, 0x1e, 0xed, 0x91, 0x90, 0x1d, 0x53, 0xe7, 0x6a, 0xd1, 0x43, 0xf1, 0x3d, 0x3b,
	0x89, 0x62, 0xfe, 0xa9, 0x01, 0x30, 0xd2, 0xf2, 0x66, 0xd3, 0x8b, 0x60, 0x42, 0x86, 0x5d, 0x0f,
	0x3a, 0x75, 0x7e, 0x31, 0xe5, 0xe9, 0x2b, 0xa5, 0xfc, 0x17, 0x03, 0x16, 0xce, 0x6b, 0x91, 0xa8,
	0x06, 0xc0, 0xc9, 0x89, 0xd3, 0x57, 0xd1, 0xd3, 0xf1, 0xfe, 0xf8, 0x62, 0xa3, 0x31, 0x39, 0xd1,
	0xc1, 0x9e, 0xe5, 0xf1, 0x11, 0x35, 0xc1, 0xe4, 0xcc, 0xa5, 0x31, 0x50, 0x14, 0xd2, 0xd2, 0x2b,
	0x80, 0x98, 0x4b, 0x37, 0xe9, 0x51, 0x48, 0x6c, 0xcf, 0xf5, 0x3b, 0xcc, 0xeb, 0x61, 0x90, 0x18,
	0x11, 0xa2, 0xf5, 0xab, 0x01, 0xb7, 0xce, 0x69, 0xc2, 0x72, 0xb1, 0x90, 0x16, 0x33, 0xaf, 0xc3,
	0x5c, 0x3d, 0x69, 0xcd, 0x57, 0xc5, 0x19, 0x93, 0x93, 0x7a, 0x24, 0x8f, 0xa5, 0xbb, 0xfa, 0x8c,
	0x30, 0x64, 0x94, 0xd1, 0x31, 0xd6, 0x6b, 0x5a, 0xad, 0x3c, 0xd7, 0x98, 0xd6, 0x47, 0x00, 0x23,
	0x6d, 0x28, 0x07, 0xd3, 0x23, 0x43, 0xd3, 0x85, 0x49, 0x1c, 0x7f, 0x5a, 0x0f, 0x60, 0x36, 0x09,
	0xa4, 0x7c, 0x79, 0xd1, 0xa3, 0x73, 0x04, 0x7b, 0x4c, 0xf5, 0xf6, 0x00, 0x11, 0xa9, 0xc5, 0x1e,
	0xcb, 0xee, 0x3a, 0x9e, 0xa6, 0xa8, 0x2c, 0x46, 0xd1, 0xb7, 0x7e, 0x32, 0x60, 0xfe, 0x25, 0xbb,
	0x24, 0x6a, 0x97, 0x71, 0x11, 0x3a, 0xc7, 0xe4, 0x68, 0x18, 0xa1, 0xa6, 0x31, 0x28, 0xd2, 0x9e,
	0xa4, 0xa0, 0x0f, 0x61, 0x4e, 0xf9, 0x1f, 0x10, 0x4e, 0x06, 0x34, 0xa4, 0x5c, 0x6f, 0x22, 0x37,
	0x24, 0xb5, 0x19, 0x13, 0x25, 0x8e, 0xdc, 0x54, 0xce, 0x1c, 0xd7, 0x1f, 0x7a, 0xa1, 0xaa, 0xbc,
	0x49, 0x0c, 0x8a, 0x54, 0x95, 0x14, 0xf4, 0x3e, 0x64, 0xa8, 0x54, 0x4a, 0x3b, 0x6a, 0xb7, 0x51,
	0xcb, 0x41, 0x06, 0x9b, 0x9a, 0x26, 0x77, 0x9a, 0x55, 0x1a, 0x3f, 0x16, 0x35, 0x2c, 0xde, 0x85,
	0xb7, 0xdb, 0xf7, 0xb1, 0x5d, 0x69, 0x9f, 0x37, 0x2a, 0x4c, 0x98, 0x7e, 0x58, 0xd9, 0xde, 0xaf,
	0x60, 0x3b, 0x6b, 0xa0, 0x25, 0x40, 0xad, 0x9d, 0x6a, 0xbd, 0xb2, 0xed, 0xd8, 0x8d, 0xad, 0x7a,
	0xc3, 0xb6, 0x71, 0xbd, 0xb1, 0x95, 0x4d, 0xa1, 0x45, 0x98, 0xdf, 0x6d, 0xec, 0x57, 0x1a, 0x6d,
	0x7b, 0xd3, 0x69, 0xed, 0xd4, 0xda, 0x4a, 0x3c, 0xbd, 0x5a, 0x83, 0x9b, 0x2f, 0xec, 0x3c, 0x68,
	0x05, 0x96, 0xab, 0x3b, 0x0f, 0x9b, 0xd8, 0x6e, 0xb5, 0xea, 0x3b, 0x8d, 0xf3, 0x14, 0x4e, 0x43,
	0x1a, 0x57, 0xf6, 0xb3, 0x86, 0x1c, 0x52, 0xb8, 0x5e, 0xb5, 0xb3, 0xa9, 0xf2, 0xbf, 0x69, 0x58,
	0xdc, 0xa7, 0x07, 0x98, 0x89, 0xc3, 0x16, 0xe5, 0xc7, 0xcc, 0xa5, 0x7b, 0x6b, 0x1b, 0x32, 0xfd,
	0xe8, 0x77, 0x03, 0x16, 0xcf, 0x1d, 0xd0, 0x68, 0xfd, 0xf5, 0x97, 0xcd, 0xfc, 0xbd, 0x6b, 0x6c,
	0x04, 0x56, 0xe1, 0xbb, 0x3f, 0xff, 0xfa, 0x31, 0x65, 0xa1, 0x95, 0xe4, 0x47, 0x20, 0x4c, 0x04,
	0xc5, 0xba, 0x1b, 0xdd, 0x55, 0x26, 0xfe, 0x60, 0x00, 0x8c, 0x46, 0x17, 0x2a, 0x5d, 0x7e, 0xc8,
	0x45, 0x66, 0xde, 0xbd, 0xea, 0x54, 0xb4, 0x96, 0x95, 0x6d, 0x4b, 0x68, 0x21, 0xb1, 0x6d, 0xc8,
	0x99, 0x58, 0x17, 0x4a, 0x12, 0x3d, 0x31, 0x20, 0x33, 0xde, 0xbe, 0xd1, 0xda, 0x55, 0x5a, 0x7d,
	0x64, 0x53, 0xf9, 0xea, 0xd3, 0xc1, 0x7a, 0x4f, 0x59, 0x95, 0x43, 0x4b, 0x89, 0x55, 0xd1, 0xcb,
	0xd2, 0x76, 0x6d, 0xfc, 0x66, 0x40, 0xde, 0xf5, 0x07, 0x31, 0xf2, 0x0b, 0x98, 0x1b, 0x19, 0x5d,
	0x1a, 0x4d, 0xd9, 0x74, 0x9b, 0xc6, 0x57, 0x55, 0x2d, 0xd7, 0xf3, 0x8f, 0x88, 0xd7, 0x2b, 0xfa,
	0xbc, 0x57, 0xea, 0x51, 0x4f, 0xb5, 0xe4, 0x52, 0xc4, 0x22, 0x01, 0x13, 0xe7, 0xff, 0xb4, 0xdd,
	0xd3, 0xdf, 0x3f, 0xa7, 0x26, 0xb6, 0xaa, 0xfb, 0xf8, 0x69, 0x6a, 0x79, 0x2b, 0x02, 0xab, 0x2a,
	0x77, 0xb4, 0xa6, 0xa2, 0x2e, 0xbf, 0x67, 0x31, 0xfb, 0x91, 0x62, 0x3f, 0xd2, 0xec, 0x47, 0x7b,
	0x11, 0xd8, 0xc1, 0x94, 0x52, 0xfa, 0xe9, 0x7f, 0x01, 0x00, 0x00, 0xff, 0xff, 0xca, 0x5c, 0x3e,
	0xd4, 0x28, 0x0e, 0x00, 0x00,
}
