define(["require", "exports", "vscode-languageserver-protocol", "vscode-jsonrpc", "vscode-languageserver-protocol/lib/main"], function (require, exports, vscode_languageserver_protocol_1, vscode_jsonrpc_1, main_1) {
    /* --------------------------------------------------------------------------------------------
     * Copyright (c) 2018 TypeFox GmbH (http://www.typefox.io). All rights reserved.
     * Licensed under the MIT License. See License.txt in the project root for license information.
     * ------------------------------------------------------------------------------------------ */
    'use strict';
    function __export(m) {
        for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
    }
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Disposable = vscode_jsonrpc_1.Disposable;
    exports.CancellationToken = vscode_jsonrpc_1.CancellationToken;
    exports.Event = vscode_jsonrpc_1.Event;
    exports.Emitter = vscode_jsonrpc_1.Emitter;
    __export(main_1);
    var Services;
    (function (Services) {
        const global = window;
        const symbol = Symbol('Services');
        Services.get = () => {
            const services = global[symbol];
            if (!services) {
                throw new Error('Language Client services has not been installed');
            }
            return services;
        };
        function install(services) {
            if (global[symbol]) {
                console.error(new Error('Language Client services has been overridden'));
            }
            global[symbol] = services;
            return vscode_jsonrpc_1.Disposable.create(() => global[symbol] = undefined);
        }
        Services.install = install;
    })(Services = exports.Services || (exports.Services = {}));
    function isDocumentSelector(selector) {
        if (!selector || !Array.isArray(selector)) {
            return false;
        }
        return selector.every(value => typeof value === 'string' || vscode_languageserver_protocol_1.DocumentFilter.is(value));
    }
    exports.isDocumentSelector = isDocumentSelector;
    var SignatureHelpTriggerKind;
    (function (SignatureHelpTriggerKind) {
        SignatureHelpTriggerKind[SignatureHelpTriggerKind["Invoke"] = 1] = "Invoke";
        SignatureHelpTriggerKind[SignatureHelpTriggerKind["TriggerCharacter"] = 2] = "TriggerCharacter";
        SignatureHelpTriggerKind[SignatureHelpTriggerKind["ContentChange"] = 3] = "ContentChange";
    })(SignatureHelpTriggerKind = exports.SignatureHelpTriggerKind || (exports.SignatureHelpTriggerKind = {}));
    // runtime support
    var VsCodeDiagnosticSeverity;
    (function (VsCodeDiagnosticSeverity) {
        VsCodeDiagnosticSeverity[VsCodeDiagnosticSeverity["Error"] = 0] = "Error";
        VsCodeDiagnosticSeverity[VsCodeDiagnosticSeverity["Warning"] = 1] = "Warning";
        VsCodeDiagnosticSeverity[VsCodeDiagnosticSeverity["Information"] = 2] = "Information";
        VsCodeDiagnosticSeverity[VsCodeDiagnosticSeverity["Hint"] = 3] = "Hint";
    })(VsCodeDiagnosticSeverity = exports.VsCodeDiagnosticSeverity || (exports.VsCodeDiagnosticSeverity = {}));
    var DocumentIdentifier;
    (function (DocumentIdentifier) {
        function is(arg) {
            return !!arg && ('uri' in arg) && ('languageId' in arg);
        }
        DocumentIdentifier.is = is;
    })(DocumentIdentifier = exports.DocumentIdentifier || (exports.DocumentIdentifier = {}));
    var ConfigurationTarget;
    (function (ConfigurationTarget) {
        ConfigurationTarget[ConfigurationTarget["Global"] = 1] = "Global";
        ConfigurationTarget[ConfigurationTarget["Workspace"] = 2] = "Workspace";
        ConfigurationTarget[ConfigurationTarget["WorkspaceFolder"] = 3] = "WorkspaceFolder";
    })(ConfigurationTarget = exports.ConfigurationTarget || (exports.ConfigurationTarget = {}));
});
//# sourceMappingURL=services.js.map