import React from 'react';
import { iconSearch } from 'carbon-icons';
import SecondaryButton from '../SecondaryButton';
import { shallow, mount } from 'enzyme';
describe('SecondaryButton', function () {
  describe('Renders as expected', function () {
    var wrapper = shallow(React.createElement(SecondaryButton, {
      small: true,
      className: "extra-class"
    }, React.createElement("div", {
      className: "child"
    }, "Test"), React.createElement("div", {
      className: "child"
    }, "Test")));
    it('Renders children as expected', function () {
      expect(wrapper.find('.child').length).toBe(2);
      expect(wrapper.find('svg').length).toBe(0);
    });
    it('Renders wrapper as expected', function () {
      expect(wrapper.length).toBe(1);
    });
    it('Has the expected kind set to "secondary"', function () {
      expect(wrapper.props().kind).toEqual('secondary');
    });
    it('Has the expected small property set to true', function () {
      expect(wrapper.props().small).toEqual(true);
    });
    it('Should add extra classes that are passed via className', function () {
      expect(wrapper.hasClass('extra-class')).toEqual(true);
    });
    describe('Renders icon buttons', function () {
      var iconButton = mount(React.createElement(SecondaryButton, {
        icon: iconSearch,
        iconDescription: "Search"
      }, "Search"));
      var icon = iconButton.find('svg');
      it('should have the appropriate icon', function () {
        expect(icon.hasClass('bx--btn__icon')).toBe(true);
      });
    });
  });
});