import React, { useState } from 'react';
import { css } from '@patternfly/react-styles';
import styles from '@patternfly/react-styles/css/components/TreeView/tree-view';
import AngleRightIcon from '@patternfly/react-icons/dist/js/icons/angle-right-icon';
import AngleDownIcon from '@patternfly/react-icons/dist/js/icons/angle-down-icon';
import { Badge } from '../Badge';
export const TreeViewListItem = ({ name, id, defaultExpanded = false, children = null, onSelect, onCheck, hasCheck = false, checkProps = {
    checked: false
}, hasBadge = false, badgeProps = { isRead: true }, activeItems = [], itemData, parentItem, icon, expandedIcon, action, actionProps = {
    onClick: (evt) => {
        evt.stopPropagation();
        evt.preventDefault();
        onSelect && onSelect(evt, itemData, parentItem);
    }
}, compareItems }) => {
    const [isExpanded, setIsExpanded] = useState(defaultExpanded);
    return (React.createElement("li", Object.assign({ id: id, className: css(styles.treeViewListItem, !!children && styles.modifiers.expandable, isExpanded && styles.modifiers.expanded) }, (isExpanded && { 'aria-expanded': 'true' }), { role: "treeitem", tabIndex: 0 }),
        React.createElement("div", { className: css(styles.treeViewContent) },
            React.createElement("button", { className: css(styles.treeViewNode, activeItems &&
                    activeItems.length > 0 &&
                    activeItems.some(item => compareItems && item && compareItems(item, itemData))
                    ? children
                        ? styles.modifiers.active
                        : styles.modifiers.current
                    : ''), onClick: (evt) => {
                    if (children) {
                        setIsExpanded(!isExpanded);
                    }
                    onSelect && onSelect(evt, itemData, parentItem);
                } },
                children && (React.createElement("span", { className: css(styles.treeViewNodeToggleIcon) },
                    !isExpanded && React.createElement(AngleRightIcon, { "aria-hidden": "true" }),
                    isExpanded && React.createElement(AngleDownIcon, { "aria-hidden": "true" }))),
                hasCheck && (React.createElement("span", { className: css(styles.treeViewNodeCheck) },
                    React.createElement("input", Object.assign({ type: "checkbox", onChange: (evt) => onCheck && onCheck(evt, itemData, parentItem), onClick: (evt) => evt.stopPropagation() }, checkProps)))),
                icon && (React.createElement("span", { className: css(styles.treeViewNodeIcon) },
                    !isExpanded && icon,
                    isExpanded && (expandedIcon || icon))),
                React.createElement("span", { className: css(styles.treeViewNodeText) }, name),
                hasBadge && children && (React.createElement("span", { className: css(styles.treeViewNodeCount) },
                    React.createElement(Badge, Object.assign({}, badgeProps), children.props.data.length)))),
            action && (React.createElement("button", Object.assign({ className: css(styles.treeViewAction) }, actionProps), action))),
        isExpanded && children));
};
TreeViewListItem.displayName = 'TreeViewListItem';
//# sourceMappingURL=TreeViewListItem.js.map