"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const react_styles_1 = require("@patternfly/react-styles");
const description_list_1 = tslib_1.__importDefault(require("@patternfly/react-styles/css/components/DescriptionList/description-list"));
const helpers_1 = require("../../helpers");
exports.DescriptionList = (_a) => {
    var { className = '', children = null, isHorizontal = false, isAutoColumnWidths, isInlineGrid, columnModifier } = _a, props = tslib_1.__rest(_a, ["className", "children", "isHorizontal", "isAutoColumnWidths", "isInlineGrid", "columnModifier"]);
    return (React.createElement("dl", Object.assign({ className: react_styles_1.css(description_list_1.default.descriptionList, isHorizontal && description_list_1.default.modifiers.horizontal, isAutoColumnWidths && description_list_1.default.modifiers.autoColumnWidths, helpers_1.formatBreakpointMods(columnModifier, description_list_1.default), isInlineGrid && description_list_1.default.modifiers.inlineGrid, className) }, props), children));
};
exports.DescriptionList.displayName = 'DescriptionList';
//# sourceMappingURL=DescriptionList.js.map