"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var tslib_1 = require("tslib");
var React = tslib_1.__importStar(require("react"));
var apollo_client_1 = tslib_1.__importDefault(require("apollo-client"));
var apollo_cache_inmemory_1 = require("apollo-cache-inmemory");
var _1 = require("./");
var test_links_1 = require("./test-links");
tslib_1.__exportStar(require("./test-links"), exports);
var MockedProvider = (function (_super) {
    tslib_1.__extends(MockedProvider, _super);
    function MockedProvider(props) {
        var _this = _super.call(this, props) || this;
        var _a = _this.props, mocks = _a.mocks, addTypename = _a.addTypename, defaultOptions = _a.defaultOptions, cache = _a.cache, resolvers = _a.resolvers;
        var client = new apollo_client_1.default({
            cache: cache || new apollo_cache_inmemory_1.InMemoryCache({ addTypename: addTypename }),
            defaultOptions: defaultOptions,
            link: new test_links_1.MockLink(mocks || [], addTypename),
            resolvers: resolvers,
        });
        _this.state = { client: client };
        return _this;
    }
    MockedProvider.prototype.render = function () {
        var _a = this.props, children = _a.children, childProps = _a.childProps;
        return children
            ? (React.createElement(_1.ApolloProvider, { client: this.state.client }, React.cloneElement(React.Children.only(children), tslib_1.__assign({}, childProps))))
            : null;
    };
    MockedProvider.prototype.componentWillUnmount = function () {
        this.state.client.stop();
    };
    MockedProvider.defaultProps = {
        addTypename: true,
    };
    return MockedProvider;
}(React.Component));
exports.MockedProvider = MockedProvider;
//# sourceMappingURL=test-utils.js.map