'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _Requestable2 = require('./Requestable');

var _Requestable3 = _interopRequireDefault(_Requestable2);

var _debug = require('debug');

var _debug2 = _interopRequireDefault(_debug);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /**
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @file
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @copyright  2016 Matt Smith (Development Seed)
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * @license    Licensed under {@link https://spdx.org/licenses/BSD-3-Clause-Clear.html BSD-3-Clause-Clear}.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *             Github.js is freely distributable.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */

var log = (0, _debug2.default)('github:team');

/**
 * A Team allows scoping of API requests to a particular Github Organization Team.
 */

var Team = function (_Requestable) {
  _inherits(Team, _Requestable);

  /**
   * Create a Team.
   * @param {string} [teamId] - the id for the team
   * @param {Requestable.auth} [auth] - information required to authenticate to Github
   * @param {string} [apiBase=https://api.github.com] - the base Github API URL
   */
  function Team(teamId, auth, apiBase) {
    _classCallCheck(this, Team);

    var _this = _possibleConstructorReturn(this, (Team.__proto__ || Object.getPrototypeOf(Team)).call(this, auth, apiBase));

    _this.__teamId = teamId;
    return _this;
  }

  /**
   * Get Team information
   * @see https://developer.github.com/v3/orgs/teams/#get-team
   * @param {Requestable.callback} [cb] - will receive the team
   * @return {Promise} - the promise for the http request
   */


  _createClass(Team, [{
    key: 'getTeam',
    value: function getTeam(cb) {
      log('Fetching Team ' + this.__teamId);
      return this._request('Get', '/teams/' + this.__teamId, undefined, cb);
    }

    /**
     * List the Team's repositories
     * @see https://developer.github.com/v3/orgs/teams/#list-team-repos
     * @param {Requestable.callback} [cb] - will receive the list of repositories
     * @return {Promise} - the promise for the http request
     */

  }, {
    key: 'listRepos',
    value: function listRepos(cb) {
      log('Fetching repositories for Team ' + this.__teamId);
      return this._requestAllPages('/teams/' + this.__teamId + '/repos', undefined, cb);
    }

    /**
     * Edit Team information
     * @see https://developer.github.com/v3/orgs/teams/#edit-team
     * @param {object} options - Parameters for team edit
     * @param {string} options.name - The name of the team
     * @param {string} [options.description] - Team description
     * @param {string} [options.repo_names] - Repos to add the team to
     * @param {string} [options.privacy=secret] - The level of privacy the team should have. Can be either one
     * of: `secret`, or `closed`
     * @param {Requestable.callback} [cb] - will receive the updated team
     * @return {Promise} - the promise for the http request
     */

  }, {
    key: 'editTeam',
    value: function editTeam(options, cb) {
      log('Editing Team ' + this.__teamId);
      return this._request('PATCH', '/teams/' + this.__teamId, options, cb);
    }

    /**
     * List the users who are members of the Team
     * @see https://developer.github.com/v3/orgs/teams/#list-team-members
     * @param {object} options - Parameters for listing team users
     * @param {string} [options.role=all] - can be one of: `all`, `maintainer`, or `member`
     * @param {Requestable.callback} [cb] - will receive the list of users
     * @return {Promise} - the promise for the http request
     */

  }, {
    key: 'listMembers',
    value: function listMembers(options, cb) {
      log('Getting members of Team ' + this.__teamId);
      return this._requestAllPages('/teams/' + this.__teamId + '/members', options, cb);
    }

    /**
     * Get Team membership status for a user
     * @see https://developer.github.com/v3/orgs/teams/#get-team-membership
     * @param {string} username - can be one of: `all`, `maintainer`, or `member`
     * @param {Requestable.callback} [cb] - will receive the membership status of a user
     * @return {Promise} - the promise for the http request
     */

  }, {
    key: 'getMembership',
    value: function getMembership(username, cb) {
      log('Getting membership of user ' + username + ' in Team ' + this.__teamId);
      return this._request('GET', '/teams/' + this.__teamId + '/memberships/' + username, undefined, cb);
    }

    /**
     * Add a member to the Team
     * @see https://developer.github.com/v3/orgs/teams/#add-team-membership
     * @param {string} username - can be one of: `all`, `maintainer`, or `member`
     * @param {object} options - Parameters for adding a team member
     * @param {string} [options.role=member] - The role that this user should have in the team. Can be one
     * of: `member`, or `maintainer`
     * @param {Requestable.callback} [cb] - will receive the membership status of added user
     * @return {Promise} - the promise for the http request
     */

  }, {
    key: 'addMembership',
    value: function addMembership(username, options, cb) {
      log('Adding user ' + username + ' to Team ' + this.__teamId);
      return this._request('PUT', '/teams/' + this.__teamId + '/memberships/' + username, options, cb);
    }

    /**
     * Get repo management status for team
     * @see https://developer.github.com/v3/orgs/teams/#remove-team-membership
     * @param {string} owner - Organization name
     * @param {string} repo - Repo name
     * @param {Requestable.callback} [cb] - will receive the membership status of added user
     * @return {Promise} - the promise for the http request
     */

  }, {
    key: 'isManagedRepo',
    value: function isManagedRepo(owner, repo, cb) {
      log('Getting repo management by Team ' + this.__teamId + ' for repo ' + owner + '/' + repo);
      return this._request204or404('/teams/' + this.__teamId + '/repos/' + owner + '/' + repo, undefined, cb);
    }

    /**
     * Add or Update repo management status for team
     * @see https://developer.github.com/v3/orgs/teams/#add-or-update-team-repository
     * @param {string} owner - Organization name
     * @param {string} repo - Repo name
     * @param {object} options - Parameters for adding or updating repo management for the team
     * @param {string} [options.permission] - The permission to grant the team on this repository. Can be one
     * of: `pull`, `push`, or `admin`
     * @param {Requestable.callback} [cb] - will receive the membership status of added user
     * @return {Promise} - the promise for the http request
     */

  }, {
    key: 'manageRepo',
    value: function manageRepo(owner, repo, options, cb) {
      log('Adding or Updating repo management by Team ' + this.__teamId + ' for repo ' + owner + '/' + repo);
      return this._request204or404('/teams/' + this.__teamId + '/repos/' + owner + '/' + repo, options, cb, 'PUT');
    }

    /**
     * Remove repo management status for team
     * @see https://developer.github.com/v3/orgs/teams/#remove-team-repository
     * @param {string} owner - Organization name
     * @param {string} repo - Repo name
     * @param {Requestable.callback} [cb] - will receive the membership status of added user
     * @return {Promise} - the promise for the http request
     */

  }, {
    key: 'unmanageRepo',
    value: function unmanageRepo(owner, repo, cb) {
      log('Remove repo management by Team ' + this.__teamId + ' for repo ' + owner + '/' + repo);
      return this._request204or404('/teams/' + this.__teamId + '/repos/' + owner + '/' + repo, undefined, cb, 'DELETE');
    }

    /**
     * Delete Team
     * @see https://developer.github.com/v3/orgs/teams/#delete-team
     * @param {Requestable.callback} [cb] - will receive the list of repositories
     * @return {Promise} - the promise for the http request
     */

  }, {
    key: 'deleteTeam',
    value: function deleteTeam(cb) {
      log('Deleting Team ' + this.__teamId);
      return this._request204or404('/teams/' + this.__teamId, undefined, cb, 'DELETE');
    }
  }]);

  return Team;
}(_Requestable3.default);

module.exports = Team;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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
//# sourceMappingURL=Team.js.map
