define(["require", "exports", "./monaco-converter", "./monaco-commands", "./monaco-languages", "./monaco-workspace", "./console-window", "./services"], function (require, exports, monaco_converter_1, monaco_commands_1, monaco_languages_1, monaco_workspace_1, console_window_1, services_1) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var MonacoServices;
    (function (MonacoServices) {
        function create(editor, options = {}) {
            const m2p = new monaco_converter_1.MonacoToProtocolConverter();
            const p2m = new monaco_converter_1.ProtocolToMonacoConverter();
            return {
                commands: new monaco_commands_1.MonacoCommands(editor),
                languages: new monaco_languages_1.MonacoLanguages(p2m, m2p),
                workspace: new monaco_workspace_1.MonacoWorkspace(p2m, m2p, options.rootUri),
                window: new console_window_1.ConsoleWindow()
            };
        }
        MonacoServices.create = create;
        function install(editor, options = {}) {
            const services = create(editor, options);
            services_1.Services.install(services);
            return services;
        }
        MonacoServices.install = install;
        function get() {
            return services_1.Services.get();
        }
        MonacoServices.get = get;
    })(MonacoServices = exports.MonacoServices || (exports.MonacoServices = {}));
});
//# sourceMappingURL=monaco-services.js.map