import * as React from 'react';
export interface SearchInputProps extends Omit<React.HTMLProps<HTMLDivElement>, 'onChange' | 'results'> {
    /** Additional classes added to the banner */
    className?: string;
    /** Value of the search input */
    value?: string;
    /** The number of search results returned. Either a total number of results,
     * or a string representing the current result over the total number of results. i.e. "1 / 5" */
    resultsCount?: number | string;
    /** An accessible label for the search input */
    'aria-label'?: string;
    /** placeholder text of the search input */
    placeholder?: string;
    /** A callback for when the input value changes. */
    onChange?: (value: string, event: React.FormEvent<HTMLInputElement>) => void;
    /** A callback for when the user clicks the clear button */
    onClear?: (event: React.SyntheticEvent<HTMLButtonElement>) => void;
    /** Function called when user clicks to navigate to next result */
    onNextClick?: (event: React.SyntheticEvent<HTMLButtonElement>) => void;
    /** Function called when user clicks to navigate to previous result */
    onPreviousClick?: (event: React.SyntheticEvent<HTMLButtonElement>) => void;
}
export declare const SearchInput: React.FunctionComponent<SearchInputProps>;
//# sourceMappingURL=SearchInput.d.ts.map