import { __rest } from "tslib";
import * as React from 'react';
import { css } from '@patternfly/react-styles';
import styles from '@patternfly/react-styles/css/components/ToggleGroup/toggle-group';
import ToggleGroupContext from './ToggleGroupContext';
export var ToggleGroupItemVariant;
(function (ToggleGroupItemVariant) {
    ToggleGroupItemVariant["icon"] = "icon";
    ToggleGroupItemVariant["text"] = "text";
})(ToggleGroupItemVariant || (ToggleGroupItemVariant = {}));
export const ToggleGroupItem = (_a) => {
    var { children, className, variant = 'text', isDisabled = false, isSelected = false, 'aria-label': ariaLabel = '', onChange = () => { }, buttonId = '' } = _a, props = __rest(_a, ["children", "className", "variant", "isDisabled", "isSelected", 'aria-label', "onChange", "buttonId"]);
    const toggleGroupContext = React.useContext(ToggleGroupContext);
    const handleChange = (event) => {
        onChange(!isSelected, event);
    };
    if (!ariaLabel && variant === ToggleGroupItemVariant.icon) {
        /* eslint-disable no-console */
        console.warn('An accessible aria-label is required when using the toggle group item icon variant.');
    }
    return (React.createElement("div", Object.assign({ className: css(styles.toggleGroupItem, className) }, props),
        React.createElement("button", Object.assign({ className: css(styles.toggleGroupButton, toggleGroupContext.variant === 'light' && styles.modifiers.light, isSelected && styles.modifiers.selected), "aria-pressed": isSelected, onClick: handleChange }, (ariaLabel && { 'aria-label': ariaLabel }), (isDisabled && { disabled: true }), (buttonId && { id: buttonId })),
            React.createElement("span", { className: css(variant === 'icon' && styles.toggleGroupIcon, variant === 'text' && styles.toggleGroupText) }, children))));
};
ToggleGroupItem.displayName = 'ToggleGroupItem';
//# sourceMappingURL=ToggleGroupItem.js.map