"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const react_styles_1 = require("@patternfly/react-styles");
const toggle_group_1 = tslib_1.__importDefault(require("@patternfly/react-styles/css/components/ToggleGroup/toggle-group"));
const ToggleGroupContext_1 = tslib_1.__importDefault(require("./ToggleGroupContext"));
var ToggleGroupItemVariant;
(function (ToggleGroupItemVariant) {
    ToggleGroupItemVariant["icon"] = "icon";
    ToggleGroupItemVariant["text"] = "text";
})(ToggleGroupItemVariant = exports.ToggleGroupItemVariant || (exports.ToggleGroupItemVariant = {}));
exports.ToggleGroupItem = (_a) => {
    var { children, className, variant = 'text', isDisabled = false, isSelected = false, 'aria-label': ariaLabel = '', onChange = () => { }, buttonId = '' } = _a, props = tslib_1.__rest(_a, ["children", "className", "variant", "isDisabled", "isSelected", 'aria-label', "onChange", "buttonId"]);
    const toggleGroupContext = React.useContext(ToggleGroupContext_1.default);
    const handleChange = (event) => {
        onChange(!isSelected, event);
    };
    if (!ariaLabel && variant === ToggleGroupItemVariant.icon) {
        /* eslint-disable no-console */
        console.warn('An accessible aria-label is required when using the toggle group item icon variant.');
    }
    return (React.createElement("div", Object.assign({ className: react_styles_1.css(toggle_group_1.default.toggleGroupItem, className) }, props),
        React.createElement("button", Object.assign({ className: react_styles_1.css(toggle_group_1.default.toggleGroupButton, toggleGroupContext.variant === 'light' && toggle_group_1.default.modifiers.light, isSelected && toggle_group_1.default.modifiers.selected), "aria-pressed": isSelected, onClick: handleChange }, (ariaLabel && { 'aria-label': ariaLabel }), (isDisabled && { disabled: true }), (buttonId && { id: buttonId })),
            React.createElement("span", { className: react_styles_1.css(variant === 'icon' && toggle_group_1.default.toggleGroupIcon, variant === 'text' && toggle_group_1.default.toggleGroupText) }, children))));
};
exports.ToggleGroupItem.displayName = 'ToggleGroupItem';
//# sourceMappingURL=ToggleGroupItem.js.map