'use strict';

exports.__esModule = true;
exports.default = scssTokenize;
var SINGLE_QUOTE = 39;
var DOUBLE_QUOTE = 34;
var BACKSLASH = 92;
var SLASH = 47;
var NEWLINE = 10;
var SPACE = 32;
var FEED = 12;
var TAB = 9;
var CR = 13;
var OPEN_SQUARE = 91;
var CLOSE_SQUARE = 93;
var OPEN_PARENTHESES = 40;
var CLOSE_PARENTHESES = 41;
var OPEN_CURLY = 123;
var CLOSE_CURLY = 125;
var SEMICOLON = 59;
var ASTERICK = 42;
var COLON = 58;
var AT = 64;

// SCSS PATCH {
var COMMA = 44;
var HASH = 35;
// } SCSS PATCH

var RE_AT_END = /[ \n\t\r\f\{\(\)'"\\;/\[\]#]/g;
var RE_WORD_END = /[ \n\t\r\f\(\)\{\}:;@!'"\\\]\[#]|\/(?=\*)/g;
var RE_BAD_BRACKET = /.[\\\/\("'\n]/;

var RE_NEW_LINE = /[\r\f\n]/g; // SCSS PATCH

// SCSS PATCH function name was changed
function scssTokenize(input) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

    var tokens = [];
    var css = input.css.valueOf();

    var ignore = options.ignoreErrors;

    var code = void 0,
        next = void 0,
        quote = void 0,
        lines = void 0,
        last = void 0,
        content = void 0,
        escape = void 0,
        nextLine = void 0,
        nextOffset = void 0,
        escaped = void 0,
        escapePos = void 0,
        prev = void 0,
        n = void 0;

    var brackets = void 0; // SCSS PATCH

    var length = css.length;
    var offset = -1;
    var line = 1;
    var pos = 0;

    function unclosed(what) {
        throw input.error('Unclosed ' + what, line, pos - offset);
    }

    while (pos < length) {
        code = css.charCodeAt(pos);

        if (code === NEWLINE || code === FEED || code === CR && css.charCodeAt(pos + 1) !== NEWLINE) {
            offset = pos;
            line += 1;
        }

        switch (code) {
            case NEWLINE:
            case SPACE:
            case TAB:
            case CR:
            case FEED:
                next = pos;
                do {
                    next += 1;
                    code = css.charCodeAt(next);
                    if (code === NEWLINE) {
                        offset = next;
                        line += 1;
                    }
                } while (code === SPACE || code === NEWLINE || code === TAB || code === CR || code === FEED);

                tokens.push(['space', css.slice(pos, next)]);
                pos = next - 1;
                break;

            case OPEN_SQUARE:
                tokens.push(['[', '[', line, pos - offset]);
                break;

            case CLOSE_SQUARE:
                tokens.push([']', ']', line, pos - offset]);
                break;

            case OPEN_CURLY:
                tokens.push(['{', '{', line, pos - offset]);
                break;

            case CLOSE_CURLY:
                tokens.push(['}', '}', line, pos - offset]);
                break;

            // SCSS PATCH {
            case COMMA:
                tokens.push(['word', ',', line, pos - offset, line, pos - offset + 1]);
                break;
            // } SCSS PATCH

            case COLON:
                tokens.push([':', ':', line, pos - offset]);
                break;

            case SEMICOLON:
                tokens.push([';', ';', line, pos - offset]);
                break;

            case OPEN_PARENTHESES:
                prev = tokens.length ? tokens[tokens.length - 1][1] : '';
                n = css.charCodeAt(pos + 1);
                if (prev === 'url' && n !== SINGLE_QUOTE && n !== DOUBLE_QUOTE && n !== SPACE && n !== NEWLINE && n !== TAB && n !== FEED && n !== CR) {
                    // SCSS PATCH {
                    brackets = 1;
                    escaped = false;
                    next = pos + 1;
                    while (next <= css.length - 1) {
                        n = css.charCodeAt(next);
                        if (n === BACKSLASH) {
                            escaped = !escaped;
                        } else if (n === OPEN_PARENTHESES) {
                            brackets += 1;
                        } else if (n === CLOSE_PARENTHESES) {
                            brackets -= 1;
                            if (brackets === 0) break;
                        }
                        next += 1;
                    }
                    // } SCSS PATCH

                    tokens.push(['brackets', css.slice(pos, next + 1), line, pos - offset, line, next - offset]);
                    pos = next;
                } else {
                    next = css.indexOf(')', pos + 1);
                    content = css.slice(pos, next + 1);

                    if (next === -1 || RE_BAD_BRACKET.test(content)) {
                        tokens.push(['(', '(', line, pos - offset]);
                    } else {
                        tokens.push(['brackets', content, line, pos - offset, line, next - offset]);
                        pos = next;
                    }
                }

                break;

            case CLOSE_PARENTHESES:
                tokens.push([')', ')', line, pos - offset]);
                break;

            case SINGLE_QUOTE:
            case DOUBLE_QUOTE:
                quote = code === SINGLE_QUOTE ? '\'' : '"';
                next = pos;
                do {
                    escaped = false;
                    next = css.indexOf(quote, next + 1);
                    if (next === -1) {
                        if (ignore) {
                            next = pos + 1;
                            break;
                        } else {
                            unclosed('quote');
                        }
                    }
                    escapePos = next;
                    while (css.charCodeAt(escapePos - 1) === BACKSLASH) {
                        escapePos -= 1;
                        escaped = !escaped;
                    }
                } while (escaped);

                content = css.slice(pos, next + 1);
                lines = content.split('\n');
                last = lines.length - 1;

                if (last > 0) {
                    nextLine = line + last;
                    nextOffset = next - lines[last].length;
                } else {
                    nextLine = line;
                    nextOffset = offset;
                }

                tokens.push(['string', css.slice(pos, next + 1), line, pos - offset, nextLine, next - nextOffset]);

                offset = nextOffset;
                line = nextLine;
                pos = next;
                break;

            case AT:
                RE_AT_END.lastIndex = pos + 1;
                RE_AT_END.test(css);
                if (RE_AT_END.lastIndex === 0) {
                    next = css.length - 1;
                } else {
                    next = RE_AT_END.lastIndex - 2;
                }
                tokens.push(['at-word', css.slice(pos, next + 1), line, pos - offset, line, next - offset]);
                pos = next;
                break;

            case BACKSLASH:
                next = pos;
                escape = true;
                while (css.charCodeAt(next + 1) === BACKSLASH) {
                    next += 1;
                    escape = !escape;
                }
                code = css.charCodeAt(next + 1);
                if (escape && code !== SLASH && code !== SPACE && code !== NEWLINE && code !== TAB && code !== CR && code !== FEED) {
                    next += 1;
                }
                tokens.push(['word', css.slice(pos, next + 1), line, pos - offset, line, next - offset]);
                pos = next;
                break;

            default:
                // SCSS PATCH {
                n = css.charCodeAt(pos + 1);

                if (code === HASH && n === OPEN_CURLY) {
                    var deep = 1;
                    next = pos;
                    while (deep > 0) {
                        next += 1;
                        if (css.length <= next) unclosed('interpolation');

                        code = css.charCodeAt(next);
                        n = css.charCodeAt(next + 1);

                        if (code === CLOSE_CURLY) {
                            deep -= 1;
                        } else if (code === HASH && n === OPEN_CURLY) {
                            deep += 1;
                        }
                    }

                    content = css.slice(pos, next + 1);
                    lines = content.split('\n');
                    last = lines.length - 1;

                    if (last > 0) {
                        nextLine = line + last;
                        nextOffset = next - lines[last].length;
                    } else {
                        nextLine = line;
                        nextOffset = offset;
                    }

                    tokens.push(['word', content, line, pos - offset, nextLine, next - nextOffset]);

                    offset = nextOffset;
                    line = nextLine;
                    pos = next;
                } else if (code === SLASH && n === ASTERICK) {
                    // } SCSS PATCH

                    next = css.indexOf('*/', pos + 2) + 1;
                    if (next === 0) {
                        if (ignore) {
                            next = css.length;
                        } else {
                            unclosed('comment');
                        }
                    }

                    content = css.slice(pos, next + 1);
                    lines = content.split('\n');
                    last = lines.length - 1;

                    if (last > 0) {
                        nextLine = line + last;
                        nextOffset = next - lines[last].length;
                    } else {
                        nextLine = line;
                        nextOffset = offset;
                    }

                    tokens.push(['comment', content, line, pos - offset, nextLine, next - nextOffset]);

                    offset = nextOffset;
                    line = nextLine;
                    pos = next;

                    // SCSS PATCH {
                } else if (code === SLASH && n === SLASH) {
                    RE_NEW_LINE.lastIndex = pos + 1;
                    RE_NEW_LINE.test(css);
                    if (RE_NEW_LINE.lastIndex === 0) {
                        next = css.length - 1;
                    } else {
                        next = RE_NEW_LINE.lastIndex - 2;
                    }

                    content = css.slice(pos, next + 1);

                    tokens.push(['comment', content, line, pos - offset, line, next - offset, 'inline']);

                    pos = next;
                    // } SCSS PATCH
                } else {
                    RE_WORD_END.lastIndex = pos + 1;
                    RE_WORD_END.test(css);
                    if (RE_WORD_END.lastIndex === 0) {
                        next = css.length - 1;
                    } else {
                        next = RE_WORD_END.lastIndex - 2;
                    }

                    tokens.push(['word', css.slice(pos, next + 1), line, pos - offset, line, next - offset]);
                    pos = next;
                }

                break;
        }

        pos++;
    }

    return tokens;
}
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
