function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

/*
 * A utility to find the parent of the given item.
 *
 * @param {object} item
 * @param {array} items
 * @return {object}
 */
export var findParent = function findParent(item) {
  var items = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];

  var parent = void 0;
  if (item.parentId) {
    items.some(function (theItem) {
      if (theItem.id === item.parentId) {
        parent = theItem;
        return true;
      }
      return false;
    });
  }
  return parent;
};

/**
 * A utility to build the hierarchy of the given item starting from root.
 */
export var buildHierarchy = function buildHierarchy(item) {
  var items = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];

  var hierarchy = [];
  if (item.parentId) {
    var parent = findParent(item, items);
    if (parent) {
      var parentHierarchy = buildHierarchy(parent, items);
      hierarchy.push.apply(hierarchy, _toConsumableArray(parentHierarchy));
    }
  }
  hierarchy.push(item);
  return hierarchy;
};

/**
 * Use the local `localCompare` with the `numeric` option to sort two,
 * potentially alpha-numeric, strings in a list of items.
 *
 * @param {string} itemA
 * @param {string} itemB
 * @param {Object} options
 * @param {string} options.locale
 * @returns {number}
 */
export var defaultCompareItems = function defaultCompareItems(itemA, itemB, _ref) {
  var locale = _ref.locale;
  return itemA.localeCompare(itemB, locale, {
    numeric: true
  });
};

/**
 * Default sorting algorithm for options in a selection control
 */
export var defaultSortItems = function defaultSortItems(items, _ref2) {
  var itemToString = _ref2.itemToString,
      compareItems = _ref2.compareItems,
      _ref2$locale = _ref2.locale,
      locale = _ref2$locale === undefined ? 'en' : _ref2$locale;

  var itemArr = [].concat(_toConsumableArray(items));
  return items.sort(function (itemA, itemB) {
    var hierarchyA = buildHierarchy(itemA, itemArr);
    var hierarchyB = buildHierarchy(itemB, itemArr);
    var depth = hierarchyA.length > hierarchyB.length ? hierarchyA.length : hierarchyB.length;

    var compareResult = 0;

    for (var i = 0; i < depth; i += 1) {
      var currentA = hierarchyA[i];
      var currentB = hierarchyB[i];

      if (currentA && !currentB) {
        // `currentA` is a child of `currentB`
        // always place the child after the parent
        return 1;
      } else if (!currentA && currentB) {
        // `currentB` is a child of `currentA`
        // always place the child after the parent
        return -1;
      }

      compareResult = compareItems(itemToString(currentA), itemToString(currentB), {
        locale: locale
      });

      if (compareResult !== 0) {
        return compareResult;
      }
    }

    return compareResult;
  });
};