import * as React from 'react';
export interface DrawerPanelContentProps extends React.HTMLProps<HTMLDivElement> {
    /** Additional classes added to the drawer. */
    className?: string;
    /** Content to be rendered in the drawer panel. */
    children?: React.ReactNode;
    /** Flag indicating that the drawer panel should not have a border. */
    hasNoBorder?: boolean;
    /** Flag indicating that the drawer panel should be resizable. */
    isResizable?: boolean;
    /** The minimum size of a resizable drawer, in pixels. Defaults to the starting width of the drawer. */
    minSize?: number;
    /** The maximum size of a resizable drawer, in pixels. Defaults to the max width of the parent container. */
    maxSize?: number;
    /** The increment amount for keyboard drawer resizing, in pixels. */
    increment?: number;
    /** Aria label for the resizable drawer splitter. */
    resizeAriaLabel?: string;
    /** Aria described by label for the resizable drawer splitter. */
    resizeAriaDescribedBy?: string;
    /** Width for drawer panel at various breakpoints */
    widths?: {
        default?: 'width_25' | 'width_33' | 'width_50' | 'width_66' | 'width_75' | 'width_100';
        lg?: 'width_25' | 'width_33' | 'width_50' | 'width_66' | 'width_75' | 'width_100';
        xl?: 'width_25' | 'width_33' | 'width_50' | 'width_66' | 'width_75' | 'width_100';
        '2xl'?: 'width_25' | 'width_33' | 'width_50' | 'width_66' | 'width_75' | 'width_100';
    };
}
export declare const DrawerPanelContent: React.FunctionComponent<DrawerPanelContentProps>;
//# sourceMappingURL=DrawerPanelContent.d.ts.map