"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Menu = void 0;
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const menu_1 = tslib_1.__importDefault(require("@patternfly/react-styles/css/components/Menu/menu"));
const react_styles_1 = require("@patternfly/react-styles");
const helpers_1 = require("../../helpers");
const MenuContext_1 = require("./MenuContext");
class MenuBase extends React.Component {
    constructor() {
        super(...arguments);
        this.state = {
            ouiaStateId: helpers_1.getDefaultOUIAId(exports.Menu.displayName),
            searchInputValue: ''
        };
    }
    render() {
        const _a = this.props, { 'aria-label': ariaLabel, children, className, onSelect, selected = null, onActionClick, ouiaId, ouiaSafe, containsFlyout, activeItemId = null, innerRef } = _a, props = tslib_1.__rest(_a, ['aria-label', "children", "className", "onSelect", "selected", "onActionClick", "ouiaId", "ouiaSafe", "containsFlyout", "activeItemId", "innerRef"]);
        return (React.createElement(MenuContext_1.MenuContext.Provider, { value: { onSelect, onActionClick, activeItemId, selected } },
            React.createElement("div", Object.assign({ className: react_styles_1.css(menu_1.default.menu, containsFlyout && menu_1.default.modifiers.flyout, className), "aria-label": ariaLabel || containsFlyout ? 'Local' : 'Global', ref: innerRef }, helpers_1.getOUIAProps(exports.Menu.displayName, ouiaId !== undefined ? ouiaId : this.state.ouiaStateId, ouiaSafe), props), children)));
    }
}
MenuBase.defaultProps = {
    ouiaSafe: true
};
exports.Menu = React.forwardRef((props, ref) => (React.createElement(MenuBase, Object.assign({}, props, { innerRef: ref }))));
exports.Menu.displayName = 'Menu';
//# sourceMappingURL=Menu.js.map