import { __rest } from "tslib";
import * as React from 'react';
import hoistNonReactStatics from 'hoist-non-react-statics';
import { VictoryArea } from 'victory-area';
import { ChartContainer } from '../ChartContainer';
import { getTheme } from '../ChartUtils';
export var ChartAreaSortOrder;
(function (ChartAreaSortOrder) {
    ChartAreaSortOrder["ascending"] = "ascending";
    ChartAreaSortOrder["descending"] = "descending";
})(ChartAreaSortOrder || (ChartAreaSortOrder = {}));
export const ChartArea = (_a) => {
    var { containerComponent = React.createElement(ChartContainer, null), themeColor, themeVariant, 
    // destructure last
    theme = getTheme(themeColor, themeVariant) } = _a, rest = __rest(_a, ["containerComponent", "themeColor", "themeVariant", "theme"]);
    // Clone so users can override container props
    const container = React.cloneElement(containerComponent, Object.assign({ theme }, containerComponent.props));
    // Note: containerComponent is required for theme
    return React.createElement(VictoryArea, Object.assign({ containerComponent: container, theme: theme }, rest));
};
ChartArea.displayName = 'ChartArea';
// Note: VictoryArea.role must be hoisted
hoistNonReactStatics(ChartArea, VictoryArea);
//# sourceMappingURL=ChartArea.js.map