import { __rest } from "tslib";
import * as React from 'react';
import { Data, Helpers } from 'victory-core';
import { VictoryPie } from 'victory-pie';
import hoistNonReactStatics from 'hoist-non-react-statics';
import { ChartContainer } from '../ChartContainer';
import { ChartDonut } from '../ChartDonut';
import { ChartDonutStyles } from '../ChartTheme';
import { getDonutThresholdDynamicTheme, getDonutThresholdStaticTheme, getPaddingForSide } from '../ChartUtils';
export var ChartDonutThresholdDonutOrientation;
(function (ChartDonutThresholdDonutOrientation) {
    ChartDonutThresholdDonutOrientation["left"] = "left";
    ChartDonutThresholdDonutOrientation["right"] = "right";
    ChartDonutThresholdDonutOrientation["top"] = "top";
})(ChartDonutThresholdDonutOrientation || (ChartDonutThresholdDonutOrientation = {}));
export var ChartDonutThresholdLabelOrientation;
(function (ChartDonutThresholdLabelOrientation) {
    ChartDonutThresholdLabelOrientation["horizontal"] = "horizontal";
    ChartDonutThresholdLabelOrientation["vertical"] = "vertical";
})(ChartDonutThresholdLabelOrientation || (ChartDonutThresholdLabelOrientation = {}));
export var ChartDonutThresholdLabelPosition;
(function (ChartDonutThresholdLabelPosition) {
    ChartDonutThresholdLabelPosition["centroid"] = "centroid";
    ChartDonutThresholdLabelPosition["endAngle"] = "endAngle";
    ChartDonutThresholdLabelPosition["startAngle"] = "startAngle";
})(ChartDonutThresholdLabelPosition || (ChartDonutThresholdLabelPosition = {}));
export var ChartDonutThresholdSortOrder;
(function (ChartDonutThresholdSortOrder) {
    ChartDonutThresholdSortOrder["ascending"] = "ascending";
    ChartDonutThresholdSortOrder["descending"] = "descending";
})(ChartDonutThresholdSortOrder || (ChartDonutThresholdSortOrder = {}));
export var ChartDonutThresholdSubTitlePosition;
(function (ChartDonutThresholdSubTitlePosition) {
    ChartDonutThresholdSubTitlePosition["bottom"] = "bottom";
    ChartDonutThresholdSubTitlePosition["center"] = "center";
    ChartDonutThresholdSubTitlePosition["right"] = "right";
})(ChartDonutThresholdSubTitlePosition || (ChartDonutThresholdSubTitlePosition = {}));
export const ChartDonutThreshold = (_a) => {
    var { allowTooltip = true, ariaDesc, ariaTitle, children, constrainToVisibleArea = false, containerComponent = React.createElement(ChartContainer, null), data = [], invert = false, labels = [], // Don't show any tooltip labels by default, let consumer override if needed
    padding, radius, standalone = true, subTitlePosition = ChartDonutStyles.label.subTitlePosition, themeColor, themeVariant, x, y, 
    // destructure last
    theme = getDonutThresholdStaticTheme(themeColor, themeVariant, invert), height = theme.pie.height, width = theme.pie.width } = _a, rest = __rest(_a, ["allowTooltip", "ariaDesc", "ariaTitle", "children", "constrainToVisibleArea", "containerComponent", "data", "invert", "labels", "padding", "radius", "standalone", "subTitlePosition", "themeColor", "themeVariant", "x", "y", "theme", "height", "width"]);
    const defaultPadding = {
        bottom: getPaddingForSide('bottom', padding, theme.pie.padding),
        left: getPaddingForSide('left', padding, theme.pie.padding),
        right: getPaddingForSide('right', padding, theme.pie.padding),
        top: getPaddingForSide('top', padding, theme.pie.padding)
    };
    const chartRadius = radius ||
        Helpers.getRadius({
            height,
            width,
            padding: defaultPadding
        });
    // Returns computed data representing pie chart slices
    const getComputedData = () => {
        // Format and sort data. Sorting ensures thresholds are displayed in the correct order and simplifies calculations.
        const datum = Data.formatData(data, Object.assign({ x, y }, rest), ['x', 'y']).sort((a, b) => a._y - b._y);
        // Data must be offset so that the sum of all data point y-values (including the final slice) == 100.
        const [prev, computedData] = datum.reduce((acc, dataPoint) => [
            dataPoint._y,
            [
                ...acc[1],
                {
                    x: dataPoint._x,
                    y: dataPoint._y - acc[0] // Must be offset by previous value
                }
            ]
        ], [0, []]);
        return [
            ...computedData,
            {
                y: prev ? 100 - prev : 0
            }
        ];
    };
    // Render dynamic utilization donut cart
    const renderChildren = () => React.Children.toArray(children).map((child, index) => {
        if (React.isValidElement(child)) {
            const _a = child.props, { data: childData } = _a, childProps = __rest(_a, ["data"]);
            const datum = Data.formatData([childData], childProps, ['x', 'y']); // Format child data independently of this component's props
            const dynamicTheme = childProps.theme ||
                getDonutThresholdDynamicTheme(childProps.themeColor || themeColor, childProps.themeVariant || themeVariant);
            return React.cloneElement(child, Object.assign({ constrainToVisibleArea, data: childData, endAngle: 360 * (datum[0]._y ? datum[0]._y / 100 : 0), height,
                invert, key: `pf-chart-donut-threshold-child-${index}`, padding: defaultPadding, radius: chartRadius - 14, showStatic: false, standalone: false, subTitlePosition: childProps.subTitlePosition || subTitlePosition, theme: dynamicTheme, width }, childProps));
        }
        return child;
    });
    // Static threshold donut chart
    const chart = (React.createElement(ChartDonut, Object.assign({ allowTooltip: allowTooltip, constrainToVisibleArea: constrainToVisibleArea, data: getComputedData(), height: height, key: "pf-chart-donut-threshold", labels: labels, padding: defaultPadding, standalone: false, theme: theme, width: width }, rest)));
    // Clone so users can override container props
    const container = React.cloneElement(containerComponent, Object.assign({ desc: ariaDesc, height, title: ariaTitle, width,
        theme }, containerComponent.props), [chart, renderChildren()]);
    return standalone ? (React.createElement(React.Fragment, null, container)) : (React.createElement(React.Fragment, null,
        chart,
        renderChildren()));
};
ChartDonutThreshold.displayName = 'ChartDonutThreshold';
// Note: VictoryPie.role must be hoisted
hoistNonReactStatics(ChartDonutThreshold, VictoryPie);
//# sourceMappingURL=ChartDonutThreshold.js.map