/// <reference types="react" />
import { ColorScalePropType, OrientationTypes, StringOrNumberOrCallback } from 'victory-core';
import { ChartLegendProps } from '../ChartLegend';
import { ChartThemeDefinition } from '../ChartTheme';
interface ChartCursorTooltipCenterOffsetInterface {
    offsetCursorDimensionX?: boolean;
    offsetCursorDimensionY?: boolean;
    theme?: ChartThemeDefinition;
}
interface ChartCursorTooltipPoniterOrientationInterface {
    horizontal?: boolean;
    theme?: ChartThemeDefinition;
}
interface ChartLegendTooltipFlyoutInterface {
    legendData: any;
    legendOrientation?: 'horizontal' | 'vertical';
    legendProps?: any;
    text?: StringOrNumberOrCallback | string[] | number[];
    theme: ChartThemeDefinition;
}
interface ChartLegendTooltipVisibleDataInterface {
    activePoints?: any[];
    colorScale?: ColorScalePropType;
    legendData: any;
    text?: StringOrNumberOrCallback | string[] | number[];
    textAsLegendData?: boolean;
    theme: ChartThemeDefinition;
}
interface ChartLegendTooltipVisibleTextInterface {
    activePoints?: any[];
    legendData: any;
    text: StringOrNumberOrCallback | string[] | number[];
}
/**
 * When using a cursor container, the tooltip can be offset from the cursor point. If offsetCursorDimensionX is true,
 * the tooltip will appear to the right the vertical cursor. If offsetCursorDimensionY is true, the tooltip will appear
 * above the vertical cursor.
 */
export declare const getCursorTooltipCenterOffset: ({ offsetCursorDimensionX, offsetCursorDimensionY, theme }: ChartCursorTooltipCenterOffsetInterface) => {
    x: number | (({ center, flyoutWidth, width }: any) => any);
    y: number | (({ center, flyoutHeight, width }: any) => any);
};
/**
 * When using a cursor container, the tooltip pointer orientation can be adjusted as the cursor approaches the edge of
 * the chart. If horizontal is true, the tooltip pointer will either be 'left' or 'right'. If horizontal is true, the
 * tooltip pointer will either be 'top' or 'bottom'.
 */
export declare const getCursorTooltipPoniterOrientation: ({ horizontal, theme }: ChartCursorTooltipPoniterOrientationInterface) => (props: any) => OrientationTypes;
export declare const getLegendTooltipDataProps: (defaultProps: ChartLegendProps) => {
    borderComponent?: import("react").ReactElement<any, string | ((props: any) => import("react").ReactElement<any, string | any | (new (props: any) => import("react").Component<any, any, any>)>) | (new (props: any) => import("react").Component<any, any, any>)>;
    borderPadding: import("victory-core").PaddingProps;
    centerTitle?: boolean;
    colorScale?: ColorScalePropType;
    containerComponent?: import("react").ReactElement<any, string | ((props: any) => import("react").ReactElement<any, string | any | (new (props: any) => import("react").Component<any, any, any>)>) | (new (props: any) => import("react").Component<any, any, any>)>;
    data?: {
        name?: string;
        labels?: {
            fill?: string;
        };
        symbol?: {
            fill?: string;
            type?: string;
        };
    }[];
    dataComponent?: import("react").ReactElement<any, string | ((props: any) => import("react").ReactElement<any, string | any | (new (props: any) => import("react").Component<any, any, any>)>) | (new (props: any) => import("react").Component<any, any, any>)>;
    eventKey?: string | number | import("victory-core").VictoryStringOrNumberCallback | string[];
    events?: import("victory-core").EventPropTypeInterface<import("victory-legend").VictoryLegendTTargetType, StringOrNumberOrCallback>[];
    externalEventMutations?: import("victory-core").EventCallbackInterface<string | string[], import("victory-core").StringOrNumberOrList>[];
    groupComponent?: import("react").ReactElement<any, string | ((props: any) => import("react").ReactElement<any, string | any | (new (props: any) => import("react").Component<any, any, any>)>) | (new (props: any) => import("react").Component<any, any, any>)>;
    gutter: number | {
        left: number;
        right: number;
    };
    height?: number;
    itemsPerRow?: number;
    labelComponent?: import("react").ReactElement<any, string | ((props: any) => import("react").ReactElement<any, string | any | (new (props: any) => import("react").Component<any, any, any>)>) | (new (props: any) => import("react").Component<any, any, any>)>;
    orientation: string;
    padding: import("victory-core").PaddingProps;
    responsive?: boolean;
    rowGutter: number | Pick<import("victory-core").BlockProps, "bottom" | "top">;
    sharedEvents?: {
        events: any[];
        getEventState: Function;
    };
    standalone?: boolean;
    style: (import("victory-core").VictoryStyleInterface & {
        title?: import("victory-core").VictoryStyleObject;
    }) | {
        labels: {
            fill: any;
            lineHeight: number;
            padding: number;
        };
        title: {
            fill: any;
            padding: number;
        };
    };
    symbolSpacer?: number;
    theme?: import("../ChartTheme").ChartThemeDefinitionInterface;
    themeColor?: string;
    themeVariant?: string;
    title?: string | string[];
    titleComponent?: import("react").ReactElement<any, string | ((props: any) => import("react").ReactElement<any, string | any | (new (props: any) => import("react").Component<any, any, any>)>) | (new (props: any) => import("react").Component<any, any, any>)>;
    titleOrientation?: OrientationTypes;
    width?: number;
    x?: number;
    y?: number;
    animate?: boolean | import("victory-core").AnimatePropTypeInterface;
    domainPadding?: import("victory-core").DomainPaddingPropType;
    horizontal?: boolean;
    maxDomain?: number | {
        x?: number;
        y?: number;
    };
    minDomain?: number | {
        x?: number;
        y?: number;
    };
    name?: string;
    origin?: import("victory-core").OriginType;
    polar?: boolean;
    range?: import("victory-core").RangePropType;
    scale?: "linear" | "time" | "log" | "sqrt" | import("victory-core").D3Scale | {
        x?: "linear" | "time" | "log" | "sqrt" | import("victory-core").D3Scale;
        y?: "linear" | "time" | "log" | "sqrt" | import("victory-core").D3Scale;
    };
    singleQuadrantDomainPadding?: boolean | {
        x?: boolean;
        y?: boolean;
    };
    categories?: import("victory-core").CategoryPropType;
    domain?: import("victory-core").DomainPropType;
    samples?: number;
    sortKey?: import("victory-core").DataGetterPropType;
    sortOrder?: import("victory-core").SortOrderPropType;
    y0?: import("victory-core").DataGetterPropType;
    label?: string | ((data: any) => string | number);
};
export declare const getLegendTooltipSize: ({ legendData, legendOrientation, legendProps, text, theme }: ChartLegendTooltipFlyoutInterface) => {
    height: any;
    width: number;
};
export declare const getLegendTooltipVisibleData: ({ activePoints, colorScale, legendData, text, textAsLegendData, theme }: ChartLegendTooltipVisibleDataInterface) => {
    name: any;
    symbol: any;
}[];
export declare const getLegendTooltipVisibleText: ({ activePoints, legendData, text }: ChartLegendTooltipVisibleTextInterface) => any[];
export {};
//# sourceMappingURL=chart-tooltip.d.ts.map