"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChartVoronoiContainer = exports.ChartVoronoiDimension = void 0;
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const hoist_non_react_statics_1 = tslib_1.__importDefault(require("hoist-non-react-statics"));
const victory_voronoi_container_1 = require("victory-voronoi-container");
const ChartTooltip_1 = require("../ChartTooltip");
const ChartUtils_1 = require("../ChartUtils");
var ChartVoronoiDimension;
(function (ChartVoronoiDimension) {
    ChartVoronoiDimension["x"] = "x";
    ChartVoronoiDimension["y"] = "y";
})(ChartVoronoiDimension = exports.ChartVoronoiDimension || (exports.ChartVoronoiDimension = {}));
exports.ChartVoronoiContainer = (_a) => {
    var { className, constrainToVisibleArea = false, themeColor, themeVariant, 
    // destructure last
    theme = ChartUtils_1.getTheme(themeColor, themeVariant), labelComponent = React.createElement(ChartTooltip_1.ChartTooltip, null) } = _a, // Note that Victory provides its own tooltip component here
    rest = tslib_1.__rest(_a, ["className", "constrainToVisibleArea", "themeColor", "themeVariant", "theme", "labelComponent"]);
    const chartClassName = ChartUtils_1.getClassName({ className });
    const chartLabelComponent = React.cloneElement(labelComponent, Object.assign({ constrainToVisibleArea,
        theme }, labelComponent.props));
    // Note: theme is required by voronoiContainerMixin
    return (
    // Note: className is valid, but Victory is missing a type
    React.createElement(victory_voronoi_container_1.VictoryVoronoiContainer, Object.assign({ className: chartClassName, labelComponent: chartLabelComponent, theme: theme }, rest)));
};
exports.ChartVoronoiContainer.displayName = 'ChartVoronoiContainer';
exports.ChartVoronoiContainer.defaultProps = victory_voronoi_container_1.VictoryVoronoiContainer.defaultProps;
// Note: VictoryVoronoiContainer.defaultEvents & VictoryContainer.role must be hoisted
hoist_non_react_statics_1.default(exports.ChartVoronoiContainer, victory_voronoi_container_1.VictoryVoronoiContainer);
//# sourceMappingURL=ChartVoronoiContainer.js.map