function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

import cx from 'classnames';
import PropTypes from 'prop-types';
import React from 'react';
import { settings } from 'carbon-components';
var prefix = settings.prefix;

var TableContainer = function TableContainer(_ref) {
  var className = _ref.className,
      children = _ref.children,
      title = _ref.title,
      rest = _objectWithoutProperties(_ref, ["className", "children", "title"]);

  var tableContainerClasses = cx(className, "".concat(prefix, "--data-table-v2-container"));
  return React.createElement("div", _extends({}, rest, {
    className: tableContainerClasses
  }), title && React.createElement("h4", {
    className: "".concat(prefix, "--data-table-v2-header")
  }, title), children);
};

TableContainer.propTypes = {
  className: PropTypes.string,
  children: PropTypes.node,

  /**
   * Provide a title for the Table
   */
  title: PropTypes.node
};
export default TableContainer;