"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AcmExpandableWrapper = void 0;
var react_1 = __importStar(require("react"));
var styles_1 = require("@material-ui/styles");
var AcmButton_1 = require("../../AcmButton/AcmButton");
var react_core_1 = require("@patternfly/react-core");
var useStyles = styles_1.makeStyles({
    root: {
        display: 'flex',
        flexDirection: 'column',
    },
    headerCount: {
        fontWeight: 'lighter',
    },
    wrapperContainer: {
        margin: '1rem 0',
    },
    gallery: {
        gridTemplateColumns: 'repeat(auto-fill, minmax(300px, 1fr))',
    },
    hideExtras: {
        maxHeight: function (props) { return props.maxHeight; },
        overflow: 'hidden',
    },
    showAllButton: {
        margin: '1rem auto',
    },
});
exports.AcmExpandableWrapper = function (props) {
    var children = props.children, headerLabel = props.headerLabel, withCount = props.withCount, expandable = props.expandable;
    var classes = useStyles(props);
    var _a = react_1.useState(false), showAll = _a[0], setShowAll = _a[1];
    return (react_1.default.createElement("div", { className: classes.root },
        headerLabel && (react_1.default.createElement(react_core_1.Title, { headingLevel: "h4" },
            headerLabel,
            withCount && (react_1.default.createElement("span", { className: classes.headerCount },
                " ", "( " + react_1.default.Children.count(children) + " total )")))),
        react_1.default.createElement("div", { className: showAll ? "" + classes.wrapperContainer : classes.wrapperContainer + " " + classes.hideExtras },
            react_1.default.createElement(react_core_1.Gallery, { hasGutter: true, className: classes.gallery }, react_1.default.Children.map(props.children, function (child, idx) {
                return (react_1.default.createElement(react_core_1.GalleryItem, null,
                    react_1.default.createElement("div", { key: "item-" + idx }, child)));
            }))),
        expandable && (react_1.default.createElement(AcmButton_1.AcmButton, { className: classes.showAllButton, variant: 'secondary', onClick: function () { return setShowAll(!showAll); } }, showAll ? 'Show less' : "Show all (" + react_1.default.Children.count(children) + ")"))));
};
//# sourceMappingURL=AcmExpandableWrapper.js.map