import React, { HTMLAttributes, ReactNode } from 'react';
export interface AcmAlertInfo {
    type?: 'success' | 'danger' | 'warning' | 'info' | 'default';
    title: ReactNode;
    message?: ReactNode;
    actions?: ReactNode;
    id?: string;
}
interface IAlertContext {
    readonly alertInfos: AcmAlertInfo[];
    addAlert: (alertInfo: AcmAlertInfo) => void;
    removeAlert: (alertInfo: AcmAlertInfo) => void;
    clearAlerts: () => void;
    readonly clear: number;
}
export declare const AcmAlertContext: React.Context<IAlertContext>;
export declare function AcmAlertProvider(props: {
    children: ReactNode;
}): JSX.Element;
export declare function AcmAlert(props: {
    alertInfo?: AcmAlertInfo;
    isInline?: boolean;
    title?: ReactNode;
    subtitle?: ReactNode;
    message?: ReactNode;
    noClose?: boolean;
    variant?: 'success' | 'danger' | 'warning' | 'info' | 'default';
    style?: HTMLAttributes<HTMLDivElement>;
}): JSX.Element;
export declare function AcmAlertGroup(props: {
    isInline?: boolean;
    canClose?: boolean;
}): JSX.Element;
export {};
