"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _isEmpty2 = _interopRequireDefault(require("lodash/isEmpty"));

var _assign2 = _interopRequireDefault(require("lodash/assign"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _victoryCore = require("victory-core");

var _helperMethods = require("./helper-methods");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (typeof call === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var fallbackProps = {
  width: 450,
  height: 300,
  padding: 50
};
var options = {
  components: [{
    name: "axis",
    index: 0
  }, {
    name: "axisLabel",
    index: 0
  }, {
    name: "grid"
  }, {
    name: "parent",
    index: "parent"
  }, {
    name: "ticks"
  }, {
    name: "tickLabels"
  }]
};

var VictoryPolarAxis =
/*#__PURE__*/
function (_React$Component) {
  _inherits(VictoryPolarAxis, _React$Component);

  function VictoryPolarAxis() {
    _classCallCheck(this, VictoryPolarAxis);

    return _possibleConstructorReturn(this, (VictoryPolarAxis.__proto__ || Object.getPrototypeOf(VictoryPolarAxis)).apply(this, arguments));
  }

  _createClass(VictoryPolarAxis, [{
    key: "renderAxisLine",
    value: function renderAxisLine(props) {
      var dependentAxis = props.dependentAxis;
      var axisComponent = dependentAxis ? props.axisComponent : props.circularAxisComponent;
      var axisProps = this.getComponentProps(axisComponent, "axis", 0);
      return _react.default.cloneElement(axisComponent, axisProps);
    }
  }, {
    key: "renderLabel",
    value: function renderLabel(props) {
      var axisLabelComponent = props.axisLabelComponent,
          dependentAxis = props.dependentAxis,
          label = props.label;

      if (!label || !dependentAxis) {
        return null;
      }

      var axisLabelProps = this.getComponentProps(axisLabelComponent, "axisLabel", 0);
      return _react.default.cloneElement(axisLabelComponent, axisLabelProps);
    }
  }, {
    key: "renderAxis",
    value: function renderAxis(props) {
      var _this = this;

      var tickComponent = props.tickComponent,
          tickLabelComponent = props.tickLabelComponent,
          name = props.name;

      var shouldRender = function (componentProps) {
        var _componentProps$style = componentProps.style,
            style = _componentProps$style === void 0 ? {} : _componentProps$style,
            _componentProps$event = componentProps.events,
            events = _componentProps$event === void 0 ? {} : _componentProps$event;
        var visible = style.stroke !== "transparent" && style.stroke !== "none" && style.strokeWidth !== 0;
        return visible || !(0, _isEmpty2.default)(events);
      };

      var axisType = props.dependentAxis ? "radial" : "angular";
      var gridComponent = axisType === "radial" ? props.circularGridComponent : props.gridComponent;
      var tickComponents = this.dataKeys.map(function (key, index) {
        var tickProps = (0, _assign2.default)({
          key: "".concat(name, "-tick-").concat(key)
        }, _this.getComponentProps(tickComponent, "ticks", index));

        var TickComponent = _react.default.cloneElement(tickComponent, tickProps);

        return shouldRender(TickComponent.props) ? TickComponent : undefined;
      }).filter(Boolean);
      var gridComponents = this.dataKeys.map(function (key, index) {
        var gridProps = (0, _assign2.default)({
          key: "".concat(name, "-grid-").concat(key)
        }, _this.getComponentProps(gridComponent, "grid", index));

        var GridComponent = _react.default.cloneElement(gridComponent, gridProps);

        return shouldRender(GridComponent.props) ? GridComponent : undefined;
      }).filter(Boolean);
      var tickLabelComponents = this.dataKeys.map(function (key, index) {
        var tickLabelProps = (0, _assign2.default)({
          key: "".concat(name, "-tick-").concat(key)
        }, _this.getComponentProps(tickLabelComponent, "tickLabels", index));
        return _react.default.cloneElement(tickLabelComponent, tickLabelProps);
      });
      var axis = this.renderAxisLine(props);
      var axisLabel = this.renderLabel(props);
      var children = [axis, axisLabel].concat(_toConsumableArray(tickComponents), _toConsumableArray(gridComponents), _toConsumableArray(tickLabelComponents));
      return this.renderGroup(props, children);
    } // Overridden in victory-native

  }, {
    key: "renderGroup",
    value: function renderGroup(props, children) {
      var groupComponent = props.groupComponent;
      return _react.default.cloneElement(groupComponent, {}, children);
    }
  }, {
    key: "shouldAnimate",
    value: function shouldAnimate() {
      return !!this.props.animate;
    }
  }, {
    key: "render",
    value: function render() {
      var animationWhitelist = VictoryPolarAxis.animationWhitelist;

      var props = _victoryCore.Axis.modifyProps(this.props, fallbackProps);

      if (this.shouldAnimate()) {
        return this.animateComponent(props, animationWhitelist);
      }

      var children = this.renderAxis(props);
      return props.standalone ? this.renderContainer(props.containerComponent, children) : children;
    }
  }]);

  return VictoryPolarAxis;
}(_react.default.Component);

Object.defineProperty(VictoryPolarAxis, "animationWhitelist", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: ["style", "domain", "range", "tickCount", "tickValues", "padding", "width", "height"]
});
Object.defineProperty(VictoryPolarAxis, "displayName", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: "VictoryAxis"
});
Object.defineProperty(VictoryPolarAxis, "role", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: "axis"
});
Object.defineProperty(VictoryPolarAxis, "defaultTransitions", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    onExit: {
      duration: 500
    },
    onEnter: {
      duration: 500
    }
  }
});
Object.defineProperty(VictoryPolarAxis, "propTypes", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: _objectSpread({}, _victoryCore.CommonProps.baseProps, {
    axisAngle: _propTypes.default.number,
    axisComponent: _propTypes.default.element,
    axisLabelComponent: _propTypes.default.element,
    axisValue: _propTypes.default.oneOfType([_propTypes.default.number, _propTypes.default.string, _propTypes.default.object]),
    categories: _propTypes.default.oneOfType([_propTypes.default.arrayOf(_propTypes.default.string), _propTypes.default.shape({
      x: _propTypes.default.arrayOf(_propTypes.default.string),
      y: _propTypes.default.arrayOf(_propTypes.default.string)
    })]),
    circularAxisComponent: _propTypes.default.element,
    circularGridComponent: _propTypes.default.element,
    containerComponent: _propTypes.default.element,
    dependentAxis: _propTypes.default.bool,
    endAngle: _propTypes.default.number,
    events: _propTypes.default.arrayOf(_propTypes.default.shape({
      target: _propTypes.default.oneOf(["axis", "axisLabel", "grid", "ticks", "tickLabels"]),
      eventKey: _propTypes.default.oneOfType([_propTypes.default.array, _victoryCore.PropTypes.allOfType([_victoryCore.PropTypes.integer, _victoryCore.PropTypes.nonNegative]), _propTypes.default.string]),
      eventHandlers: _propTypes.default.object
    })),
    gridComponent: _propTypes.default.element,
    innerRadius: _victoryCore.PropTypes.nonNegative,
    labelPlacement: _propTypes.default.oneOf(["parallel", "perpendicular", "vertical"]),
    startAngle: _propTypes.default.number,
    stringMap: _propTypes.default.object,
    style: _propTypes.default.shape({
      parent: _propTypes.default.object,
      axis: _propTypes.default.object,
      axisLabel: _propTypes.default.object,
      grid: _propTypes.default.object,
      ticks: _propTypes.default.object,
      tickLabels: _propTypes.default.object
    }),
    tickComponent: _propTypes.default.element,
    tickCount: _victoryCore.PropTypes.allOfType([_victoryCore.PropTypes.integer, _victoryCore.PropTypes.greaterThanZero]),
    tickFormat: _propTypes.default.oneOfType([_propTypes.default.func, _victoryCore.PropTypes.homogeneousArray]),
    tickLabelComponent: _propTypes.default.element,
    tickValues: _victoryCore.PropTypes.homogeneousArray
  })
});
Object.defineProperty(VictoryPolarAxis, "defaultProps", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: {
    axisComponent: _react.default.createElement(_victoryCore.LineSegment, {
      type: "axis"
    }),
    axisLabelComponent: _react.default.createElement(_victoryCore.VictoryLabel, null),
    circularAxisComponent: _react.default.createElement(_victoryCore.Arc, {
      type: "axis"
    }),
    circularGridComponent: _react.default.createElement(_victoryCore.Arc, {
      type: "grid"
    }),
    containerComponent: _react.default.createElement(_victoryCore.VictoryContainer, null),
    endAngle: 360,
    gridComponent: _react.default.createElement(_victoryCore.LineSegment, {
      type: "grid"
    }),
    groupComponent: _react.default.createElement("g", {
      role: "presentation"
    }),
    labelPlacement: "parallel",
    startAngle: 0,
    standalone: true,
    theme: _victoryCore.VictoryTheme.grayscale,
    tickComponent: _react.default.createElement(_victoryCore.LineSegment, {
      type: "tick"
    }),
    tickLabelComponent: _react.default.createElement(_victoryCore.VictoryLabel, null)
  }
});
Object.defineProperty(VictoryPolarAxis, "getDomain", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: _victoryCore.Axis.getDomain
});
Object.defineProperty(VictoryPolarAxis, "getAxis", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: _victoryCore.Axis.getAxis
});
Object.defineProperty(VictoryPolarAxis, "getScale", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: _helperMethods.getScale
});
Object.defineProperty(VictoryPolarAxis, "getStyles", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: function (props) {
    return (0, _helperMethods.getStyles)(props, fallbackProps.style);
  }
});
Object.defineProperty(VictoryPolarAxis, "getBaseProps", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: function (props) {
    return (0, _helperMethods.getBaseProps)(props, fallbackProps);
  }
});
Object.defineProperty(VictoryPolarAxis, "expectedComponents", {
  configurable: true,
  enumerable: true,
  writable: true,
  value: ["axisComponent", "circularAxisComponent", "groupComponent", "containerComponent", "tickComponent", "tickLabelComponent", "gridComponent", "circularGridComponent"]
});

var _default = (0, _victoryCore.addEvents)(VictoryPolarAxis, options);

exports.default = _default;