"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AcmLabelsInput = void 0;
var react_core_1 = require("@patternfly/react-core");
var react_1 = __importStar(require("react"));
function AcmLabelsInput(props) {
    var _a = react_1.useState(), inputValue = _a[0], setInputValue = _a[1];
    var _b = react_1.useState(false), showInput = _b[0], setShowInput = _b[1];
    function addLabel(input) {
        /* istanbul ignore next */
        var newlabels = input
            .split(',')
            .join(' ')
            .split(' ')
            .map(function (label) { return label.trim(); })
            .filter(function (label) { return label !== ''; })
            .reduce(function (value, label) {
            var parts = label.split('=');
            if (parts.length === 1) {
                value[parts[0]] = '';
            }
            else {
                value[parts[0]] = parts.slice(1).join('=');
            }
            return value;
        }, __assign({}, props.value));
        props.onChange(newlabels);
    }
    function removeLabel(key) {
        /* istanbul ignore next */
        var newLabels = __assign({}, props.value);
        delete newLabels[key];
        props.onChange(newLabels);
    }
    return (react_1.default.createElement(react_1.Fragment, null,
        react_1.default.createElement(react_core_1.FormGroup, { id: props.id + "-label", label: props.label, fieldId: props.id, hidden: props.hidden },
            react_1.default.createElement("div", { id: "label-input-button", className: "pf-c-form-control", style: {
                    padding: 0,
                    paddingTop: '1px',
                    display: 'flex',
                    alignItems: 'start',
                    flexWrap: 'wrap',
                    height: 'unset',
                    minHeight: '36px',
                }, onClick: function () {
                    setInputValue(undefined);
                    setShowInput(true);
                } },
                props.value &&
                    Object.keys(props.value).map(function (key) { return (react_1.default.createElement(react_core_1.Label, { key: key, style: { margin: 2 }, onClose: function () { return removeLabel(key); }, variant: "outline", closeBtnProps: { id: "remove-" + key } },
                        key,
                        props.value && props.value[key].trim() != '' && '=' + props.value[key])); }),
                !showInput ? (react_1.default.createElement(react_1.Fragment, null)) : (react_1.default.createElement("input", { style: { marginLeft: '2px', marginTop: '1px' }, id: props.id, onChange: function (e) {
                        setInputValue(e.target.value);
                    }, hidden: !showInput, autoFocus: true, onKeyDown: function (e) {
                        switch (e.key) {
                            case ' ':
                            case ',':
                            case 'Enter':
                                {
                                    e.stopPropagation();
                                    // istanbul ignore else
                                    if (inputValue) {
                                        addLabel(inputValue);
                                    }
                                    var inputElement_1 = e.target;
                                    setInputValue('');
                                    inputElement_1.value = '';
                                    setTimeout(function () { return (inputElement_1.value = ''); }, 0);
                                }
                                break;
                            case 'Escape':
                                setShowInput(false);
                                break;
                        }
                    }, onBlur: 
                    /* istanbul ignore next */
                    function (e) {
                        addLabel(e.target.value);
                        setShowInput(false);
                    } }))))));
}
exports.AcmLabelsInput = AcmLabelsInput;
//# sourceMappingURL=AcmLabelsInput.js.map