import { __rest } from "tslib";
import * as React from 'react';
import hoistNonReactStatics from 'hoist-non-react-statics';
import { Helpers } from 'victory-core';
import { VictoryPie } from 'victory-pie';
import { getDonutTheme } from '../ChartUtils/chart-theme';
import { ChartContainer } from '../ChartContainer';
import { ChartLabel } from '../ChartLabel';
import { ChartPie } from '../ChartPie';
import { ChartCommonStyles, ChartDonutStyles } from '../ChartTheme';
import { getPieLabelX, getPieLabelY, getPaddingForSide } from '../ChartUtils';
export var ChartDonutLabelPosition;
(function (ChartDonutLabelPosition) {
    ChartDonutLabelPosition["centroid"] = "centroid";
    ChartDonutLabelPosition["endAngle"] = "endAngle";
    ChartDonutLabelPosition["startAngle"] = "startAngle";
})(ChartDonutLabelPosition || (ChartDonutLabelPosition = {}));
export var ChartDonutSortOrder;
(function (ChartDonutSortOrder) {
    ChartDonutSortOrder["ascending"] = "ascending";
    ChartDonutSortOrder["descending"] = "descending";
})(ChartDonutSortOrder || (ChartDonutSortOrder = {}));
export var ChartDonutSubTitlePosition;
(function (ChartDonutSubTitlePosition) {
    ChartDonutSubTitlePosition["bottom"] = "bottom";
    ChartDonutSubTitlePosition["center"] = "center";
    ChartDonutSubTitlePosition["right"] = "right";
})(ChartDonutSubTitlePosition || (ChartDonutSubTitlePosition = {}));
export const ChartDonut = (_a) => {
    var { allowTooltip = true, ariaDesc, ariaTitle, capHeight = 1.1, containerComponent = React.createElement(ChartContainer, null), innerRadius, legendAllowWrap, legendPosition = ChartCommonStyles.legend.position, padding, radius, standalone = true, subTitle, subTitleComponent, subTitlePosition = ChartDonutStyles.label.subTitlePosition, themeColor, themeVariant, title, titleComponent = React.createElement(ChartLabel, null), 
    // destructure last
    theme = getDonutTheme(themeColor, themeVariant), height = theme.pie.height, width = theme.pie.width } = _a, rest = __rest(_a, ["allowTooltip", "ariaDesc", "ariaTitle", "capHeight", "containerComponent", "innerRadius", "legendAllowWrap", "legendPosition", "padding", "radius", "standalone", "subTitle", "subTitleComponent", "subTitlePosition", "themeColor", "themeVariant", "title", "titleComponent", "theme", "height", "width"]);
    const defaultPadding = {
        bottom: getPaddingForSide('bottom', padding, theme.pie.padding),
        left: getPaddingForSide('left', padding, theme.pie.padding),
        right: getPaddingForSide('right', padding, theme.pie.padding),
        top: getPaddingForSide('top', padding, theme.pie.padding)
    };
    const chartRadius = radius
        ? radius
        : Helpers.getRadius({
            height,
            width,
            padding: defaultPadding
        });
    const chartInnerRadius = innerRadius ? innerRadius : chartRadius - 9; // Todo: Add pf-core variable
    const centerSubTitle = subTitle && subTitlePosition === ChartDonutSubTitlePosition.center;
    // Returns title and subtitle
    const getAllTitles = () => {
        if (!subTitleComponent && centerSubTitle) {
            return getTitle({
                styles: [ChartDonutStyles.label.title, ChartDonutStyles.label.subTitle],
                titles: [title, subTitle]
            });
        }
        return (React.createElement(React.Fragment, { key: "pf-chart-donut-titles" },
            getTitle({ titles: title, dy: centerSubTitle ? -8 : 0 }),
            getSubTitle({ textComponent: subTitleComponent, dy: centerSubTitle ? 15 : 0 })));
    };
    // Returns subtitle
    const getSubTitle = ({ dy = 0, textComponent = React.createElement(ChartLabel, null) }) => {
        if (!subTitle) {
            return null;
        }
        const subTitleProps = textComponent.props ? textComponent.props : {};
        return React.cloneElement(textComponent, Object.assign({ key: 'pf-chart-donut-subtitle', style: ChartDonutStyles.label.subTitle, text: subTitle, textAnchor: subTitlePosition === 'right' ? 'start' : 'middle', verticalAnchor: 'middle', x: getPieLabelX({
                height,
                labelPosition: subTitlePosition,
                legendPosition,
                padding: defaultPadding,
                width
            }), y: getPieLabelY({
                dy,
                height,
                labelPosition: subTitlePosition,
                padding: defaultPadding,
                width
            }) }, subTitleProps));
    };
    // Returns title
    const getTitle = ({ dy = 0, styles = ChartDonutStyles.label.title, titles = title }) => {
        if (!titles) {
            return null;
        }
        const titleProps = titleComponent ? titleComponent.props : {};
        return React.cloneElement(titleComponent, Object.assign(Object.assign(Object.assign({}, (Array.isArray(titles) && { capHeight })), { key: 'pf-chart-donut-title', style: styles, text: titles, textAnchor: 'middle', verticalAnchor: 'middle', x: getPieLabelX({
                height,
                labelPosition: 'center',
                legendPosition,
                padding: defaultPadding,
                width
            }), y: getPieLabelY({
                dy,
                height,
                labelPosition: 'center',
                padding: defaultPadding,
                width
            }) }), titleProps));
    };
    const chart = (React.createElement(ChartPie, Object.assign({ allowTooltip: allowTooltip, height: height, innerRadius: chartInnerRadius > 0 ? chartInnerRadius : 0, key: "pf-chart-donut-pie", legendAllowWrap: legendAllowWrap, legendPosition: legendPosition, padding: padding, radius: chartRadius > 0 ? chartRadius : 0, standalone: false, theme: theme, width: width }, rest)));
    // Clone so users can override container props
    const container = React.cloneElement(containerComponent, Object.assign({ desc: ariaDesc, height, title: ariaTitle, width,
        theme }, containerComponent.props), [chart, getAllTitles()]);
    return standalone ? (React.createElement(React.Fragment, null, container)) : (React.createElement(React.Fragment, null,
        chart,
        getAllTitles()));
};
ChartDonut.displayName = 'ChartDonut';
// Note: VictoryPie.role must be hoisted
hoistNonReactStatics(ChartDonut, VictoryPie);
//# sourceMappingURL=ChartDonut.js.map