import { __rest } from "tslib";
import * as React from 'react';
import hoistNonReactStatics from 'hoist-non-react-statics';
import { Helpers } from 'victory-core';
import { VictoryTooltip } from 'victory-tooltip';
import { ChartCursorTooltip } from '../ChartCursorTooltip';
import { ChartLegendTooltipContent } from './ChartLegendTooltipContent';
import { ChartLegendTooltipStyles } from '../ChartTheme';
import { ChartTooltip } from '../ChartTooltip';
import { getLegendTooltipDataProps, getLegendTooltipSize, getLegendTooltipVisibleData, getLegendTooltipVisibleText, getTheme } from '../ChartUtils';
export const ChartLegendTooltip = (_a) => {
    var { activePoints, datum, center = { x: 0, y: 0 }, flyoutHeight, flyoutWidth, height, isCursorTooltip = true, labelComponent = React.createElement(ChartLegendTooltipContent, null), legendData, text, themeColor, themeVariant, title, width, 
    // destructure last
    theme = getTheme(themeColor, themeVariant) } = _a, rest = __rest(_a, ["activePoints", "datum", "center", "flyoutHeight", "flyoutWidth", "height", "isCursorTooltip", "labelComponent", "legendData", "text", "themeColor", "themeVariant", "title", "width", "theme"]);
    const pointerLength = theme && theme.tooltip ? Helpers.evaluateProp(theme.tooltip.pointerLength) : 10;
    const legendTooltipProps = {
        legendData: getLegendTooltipVisibleData({ activePoints, legendData, text, theme }),
        legendProps: getLegendTooltipDataProps(labelComponent.props.legendComponent),
        text: getLegendTooltipVisibleText({ activePoints, legendData, text }),
        theme
    };
    // Returns flyout height based on legend size
    const getFlyoutHeight = () => {
        const _flyoutHeight = getLegendTooltipSize(legendTooltipProps).height + ChartLegendTooltipStyles.flyout.padding;
        return title ? _flyoutHeight : _flyoutHeight - 10;
    };
    // Returns flyout width based on legend size
    const getFlyoutWidth = () => getLegendTooltipSize(legendTooltipProps).width + ChartLegendTooltipStyles.flyout.padding;
    // Returns the tooltip content component
    const getTooltipContentComponent = () => React.cloneElement(labelComponent, Object.assign({ center, flyoutHeight: flyoutHeight || getFlyoutHeight(), flyoutWidth: flyoutWidth || getFlyoutWidth(), height,
        legendData,
        title,
        width }, labelComponent.props));
    // Returns the tooltip component
    const getTooltipComponent = () => {
        const _flyoutWidth = getFlyoutWidth();
        const tooltipComponent = isCursorTooltip ? React.createElement(ChartCursorTooltip, null) : React.createElement(ChartTooltip, null);
        return React.cloneElement(tooltipComponent, Object.assign(Object.assign(Object.assign({ activePoints,
            center,
            datum, flyoutHeight: flyoutHeight || getFlyoutHeight(), flyoutWidth: flyoutWidth || getFlyoutWidth(), height, labelComponent: getTooltipContentComponent() }, (flyoutWidth === undefined && {
            showPointer: width > _flyoutWidth + center.x + pointerLength || center.x > _flyoutWidth + pointerLength
        })), { text,
            theme,
            width }), rest));
    };
    return getTooltipComponent();
};
ChartLegendTooltip.displayName = 'ChartLegendTooltip';
// Note: VictoryTooltip.defaultEvents must be hoisted
hoistNonReactStatics(ChartLegendTooltip, VictoryTooltip);
//# sourceMappingURL=ChartLegendTooltip.js.map