import { __rest } from "tslib";
import * as React from 'react';
import { Helpers, Path } from 'victory-core';
import { PathHelpers } from './path-helpers';
const getPath = (props) => {
    const { x, y } = props;
    const size = Helpers.evaluateProp(props.size, props);
    if (props.getPath) {
        return props.getPath(x, y, size);
    }
    const pathFunctions = {
        circle: PathHelpers.circle,
        square: PathHelpers.square,
        diamond: PathHelpers.diamond,
        eyeSlash: PathHelpers.eyeSlash,
        triangleDown: PathHelpers.triangleDown,
        triangleUp: PathHelpers.triangleUp,
        plus: PathHelpers.plus,
        minus: PathHelpers.minus,
        star: PathHelpers.star,
        dash: PathHelpers.dash,
        threshold: PathHelpers.threshold
    };
    const symbol = Helpers.evaluateProp(props.symbol, props);
    const key = symbol;
    const symbolFunction = typeof pathFunctions[key] === 'function' ? pathFunctions[key] : pathFunctions.square;
    return symbolFunction(x, y, size);
};
export const ChartPoint = (_a) => {
    var { active, className, clipPath, datum, desc, events, pathComponent = React.createElement(Path, null), role = 'presentation', shapeRendering = 'auto', tabIndex, transform } = _a, rest = __rest(_a, ["active", "className", "clipPath", "datum", "desc", "events", "pathComponent", "role", "shapeRendering", "tabIndex", "transform"]);
    const props = Object.assign({ active,
        className,
        clipPath,
        datum,
        desc,
        events,
        role,
        shapeRendering,
        tabIndex,
        transform }, rest);
    return React.cloneElement(pathComponent, Object.assign(Object.assign({ className,
        clipPath, d: getPath(props), desc: Helpers.evaluateProp(desc, props) }, events), { role,
        shapeRendering, style: Helpers.evaluateStyle(rest.style, props), tabIndex: Helpers.evaluateProp(tabIndex, props), transform }));
};
ChartPoint.displayName = 'ChartPoint';
//# sourceMappingURL=ChartPoint.js.map