import { __rest } from "tslib";
import * as React from 'react';
import hoistNonReactStatics from 'hoist-non-react-statics';
import cloneDeep from 'lodash/cloneDeep';
import { VictoryLine } from 'victory-line';
import { ChartLine } from '../ChartLine';
import { getThresholdTheme } from '../ChartUtils';
export const ChartThreshold = (_a) => {
    var { style = {}, themeColor, themeVariant, 
    // destructure last
    theme = getThresholdTheme(themeColor, themeVariant) } = _a, rest = __rest(_a, ["style", "themeColor", "themeVariant", "theme"]);
    // Returned style prop takes precedence over default theme
    const getStrokeDasharray = () => {
        if (style && style.data && style.data.strokeDasharray) {
            return style.data.strokeDasharray;
        }
        return getThresholdTheme(themeColor, themeVariant).line.style.data.strokeDasharray;
    };
    const getStrokeWidth = () => {
        if (style && style.data && style.data.strokeWidth) {
            return style.data.strokeWidth;
        }
        return getThresholdTheme(themeColor, themeVariant).line.style.data.strokeWidth;
    };
    // Clone style and apply strokeDasharray prop
    const thresholdStyle = cloneDeep(style);
    if (thresholdStyle.data) {
        thresholdStyle.data.strokeDasharray = getStrokeDasharray();
        thresholdStyle.data.strokeWidth = getStrokeWidth();
    }
    else {
        thresholdStyle.data = {
            strokeDasharray: getStrokeDasharray(),
            strokeWidth: getStrokeWidth()
        };
    }
    return React.createElement(ChartLine, Object.assign({ style: thresholdStyle, theme: theme }, rest));
};
ChartThreshold.displayName = 'ChartThreshold';
// Note: VictoryLine.role must be hoisted
hoistNonReactStatics(ChartThreshold, VictoryLine);
//# sourceMappingURL=ChartThreshold.js.map