function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/**
 * @param {Object<string, Function>} propTypes The list of type checkers, keyed by prop names.
 * @returns {Object<string, Function>}
 *   The new prop type checkers that checks if one of the given props exist,
 *   in addition to the original type checkings.
 */
export default function isRequiredOneOf(propTypes) {
  var names = Object.keys(propTypes);

  var checker = function checker(propType) {
    return function (props, propName, componentName) {
      if (process.env.NODE_ENV !== "production" && names.every(function (name) {
        return !props.hasOwnProperty(name);
      })) {
        return new Error("".concat(componentName, " requires one of the following props: ").concat(names.join(', ')));
      }

      for (var _len = arguments.length, rest = new Array(_len > 3 ? _len - 3 : 0), _key = 3; _key < _len; _key++) {
        rest[_key - 3] = arguments[_key];
      }

      return propType.apply(void 0, [props, propName, componentName].concat(rest));
    };
  };

  return names.reduce(function (o, name) {
    return _objectSpread({}, o, _defineProperty({}, name, checker(propTypes[name])));
  }, {});
}