/*
Copyright (c) 2014, Matteo Collina <hello@matteocollina.com>

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted, provided that the above
copyright notice and this permission notice appear in all copies.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR
IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
*/

'use strict';

var through = require('through2')

function transform(chunk, enc, cb) {
  var list = chunk.toString('utf8').split(this.matcher)
    , remaining = list.pop()
    , i

  if (list.length >= 1) {
    push(this, this.mapper((this._last + list.shift())))
  } else {
    remaining = this._last + remaining
  }

  for (i = 0; i < list.length; i++) {
    push(this, this.mapper(list[i]))
  }

  this._last = remaining

  cb()
}

function flush(cb) {
  if (this._last)
    push(this, this.mapper(this._last))

  cb()
}

function push(self, val) {
  if (val !== undefined)
    self.push(val)
}

function noop(incoming) {
  return incoming
}

function split(matcher, mapper, options) {

  if (typeof matcher === 'object' && !(matcher instanceof RegExp)) {
    options = matcher
    matcher = null
  }

  if (typeof matcher === 'function') {
    mapper = matcher
    matcher = null
  }

  options = options || {}

  var stream = through(options, transform, flush)

  // this stream is in objectMode only in the readable part
  stream._readableState.objectMode = true;

  stream._last = ''
  stream.matcher = matcher || /\r?\n/
  stream.mapper = mapper || noop

  return stream
}

module.exports = split
