import { __rest } from "tslib";
import * as React from 'react';
import styles from '@patternfly/react-styles/css/components/Menu/menu';
import { css } from '@patternfly/react-styles';
import { getOUIAProps, getDefaultOUIAId } from '../../helpers';
import { MenuContext } from './MenuContext';
class MenuBase extends React.Component {
    constructor() {
        super(...arguments);
        this.state = {
            ouiaStateId: getDefaultOUIAId(Menu.displayName),
            searchInputValue: ''
        };
    }
    render() {
        const _a = this.props, { 'aria-label': ariaLabel, children, className, onSelect, selected = null, onActionClick, ouiaId, ouiaSafe, containsFlyout, activeItemId = null, innerRef } = _a, props = __rest(_a, ['aria-label', "children", "className", "onSelect", "selected", "onActionClick", "ouiaId", "ouiaSafe", "containsFlyout", "activeItemId", "innerRef"]);
        return (React.createElement(MenuContext.Provider, { value: { onSelect, onActionClick, activeItemId, selected } },
            React.createElement("div", Object.assign({ className: css(styles.menu, containsFlyout && styles.modifiers.flyout, className), "aria-label": ariaLabel || containsFlyout ? 'Local' : 'Global', ref: innerRef }, getOUIAProps(Menu.displayName, ouiaId !== undefined ? ouiaId : this.state.ouiaStateId, ouiaSafe), props), children)));
    }
}
MenuBase.defaultProps = {
    ouiaSafe: true
};
export const Menu = React.forwardRef((props, ref) => (React.createElement(MenuBase, Object.assign({}, props, { innerRef: ref }))));
Menu.displayName = 'Menu';
//# sourceMappingURL=Menu.js.map