"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BaseTheme = void 0;
const tslib_1 = require("tslib");
/* eslint-disable camelcase */
const chart_global_FontFamily_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_global_FontFamily"));
const chart_global_letter_spacing_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_global_letter_spacing"));
const chart_global_FontSize_sm_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_global_FontSize_sm"));
const chart_global_label_Padding_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_global_label_Padding"));
const chart_global_label_stroke_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_global_label_stroke"));
const chart_global_label_text_anchor_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_global_label_text_anchor"));
const chart_global_layout_Padding_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_global_layout_Padding"));
const chart_global_layout_Height_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_global_layout_Height"));
const chart_global_layout_Width_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_global_layout_Width"));
const chart_global_stroke_line_cap_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_global_stroke_line_cap"));
const chart_global_stroke_line_join_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_global_stroke_line_join"));
const chart_area_data_Fill_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_area_data_Fill"));
const chart_area_Opacity_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_area_Opacity"));
const chart_area_stroke_Width_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_area_stroke_Width"));
const chart_axis_axis_stroke_Width_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_axis_axis_stroke_Width"));
const chart_axis_axis_stroke_Color_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_axis_axis_stroke_Color"));
const chart_axis_axis_Fill_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_axis_axis_Fill"));
const chart_axis_axis_label_Padding_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_axis_axis_label_Padding"));
const chart_axis_axis_label_stroke_Color_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_axis_axis_label_stroke_Color"));
const chart_axis_grid_Fill_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_axis_grid_Fill"));
const chart_axis_grid_PointerEvents_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_axis_grid_PointerEvents"));
const chart_axis_tick_Fill_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_axis_tick_Fill"));
const chart_axis_tick_Size_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_axis_tick_Size"));
const chart_axis_tick_stroke_Color_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_axis_tick_stroke_Color"));
const chart_axis_tick_Width_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_axis_tick_Width"));
const chart_axis_tick_label_Fill_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_axis_tick_label_Fill"));
const chart_bar_Width_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_bar_Width"));
const chart_bar_data_stroke_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_bar_data_stroke"));
const chart_bar_data_Fill_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_bar_data_Fill"));
const chart_bar_data_Padding_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_bar_data_Padding"));
const chart_bar_data_stroke_Width_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_bar_data_stroke_Width"));
const chart_boxplot_max_Padding_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_boxplot_max_Padding"));
const chart_boxplot_max_stroke_Color_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_boxplot_max_stroke_Color"));
const chart_boxplot_max_stroke_Width_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_boxplot_max_stroke_Width"));
const chart_boxplot_median_Padding_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_boxplot_median_Padding"));
const chart_boxplot_median_stroke_Color_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_boxplot_median_stroke_Color"));
const chart_boxplot_median_stroke_Width_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_boxplot_median_stroke_Width"));
const chart_boxplot_min_Padding_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_boxplot_min_Padding"));
const chart_boxplot_min_stroke_Width_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_boxplot_min_stroke_Width"));
const chart_boxplot_min_stroke_Color_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_boxplot_min_stroke_Color"));
const chart_boxplot_lower_quartile_Padding_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_boxplot_lower_quartile_Padding"));
const chart_boxplot_lower_quartile_Fill_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_boxplot_lower_quartile_Fill"));
const chart_boxplot_upper_quartile_Padding_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_boxplot_upper_quartile_Padding"));
const chart_boxplot_upper_quartile_Fill_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_boxplot_upper_quartile_Fill"));
const chart_boxplot_box_Width_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_boxplot_box_Width"));
const chart_candelstick_data_stroke_Width_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_candelstick_data_stroke_Width"));
const chart_candelstick_data_stroke_Color_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_candelstick_data_stroke_Color"));
const chart_candelstick_candle_positive_Color_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_candelstick_candle_positive_Color"));
const chart_candelstick_candle_negative_Color_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_candelstick_candle_negative_Color"));
const chart_errorbar_BorderWidth_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_errorbar_BorderWidth"));
const chart_errorbar_data_Fill_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_errorbar_data_Fill"));
const chart_errorbar_data_Opacity_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_errorbar_data_Opacity"));
const chart_errorbar_data_stroke_Width_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_errorbar_data_stroke_Width"));
const chart_errorbar_data_stroke_Color_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_errorbar_data_stroke_Color"));
const chart_legend_gutter_Width_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_legend_gutter_Width"));
const chart_legend_orientation_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_legend_orientation"));
const chart_legend_title_orientation_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_legend_title_orientation"));
const chart_legend_data_type_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_legend_data_type"));
const chart_legend_title_Padding_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_legend_title_Padding"));
const chart_line_data_Fill_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_line_data_Fill"));
const chart_line_data_Opacity_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_line_data_Opacity"));
const chart_line_data_stroke_Width_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_line_data_stroke_Width"));
const chart_line_data_stroke_Color_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_line_data_stroke_Color"));
const chart_pie_Padding_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_pie_Padding"));
const chart_pie_data_Padding_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_pie_data_Padding"));
const chart_pie_data_stroke_Width_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_pie_data_stroke_Width"));
const chart_pie_data_stroke_Color_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_pie_data_stroke_Color"));
const chart_pie_labels_Padding_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_pie_labels_Padding"));
const chart_pie_Height_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_pie_Height"));
const chart_pie_Width_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_pie_Width"));
const chart_scatter_data_stroke_Color_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_scatter_data_stroke_Color"));
const chart_scatter_data_stroke_Width_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_scatter_data_stroke_Width"));
const chart_scatter_data_Opacity_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_scatter_data_Opacity"));
const chart_scatter_data_Fill_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_scatter_data_Fill"));
const chart_stack_data_stroke_Width_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_stack_data_stroke_Width"));
const chart_tooltip_corner_radius_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_tooltip_corner_radius"));
const chart_tooltip_pointer_length_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_tooltip_pointer_length"));
const chart_tooltip_Fill_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_tooltip_Fill"));
const chart_tooltip_flyoutStyle_corner_radius_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_tooltip_flyoutStyle_corner_radius"));
const chart_tooltip_flyoutStyle_stroke_Width_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_tooltip_flyoutStyle_stroke_Width"));
const chart_tooltip_flyoutStyle_PointerEvents_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_tooltip_flyoutStyle_PointerEvents"));
const chart_tooltip_flyoutStyle_stroke_Color_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_tooltip_flyoutStyle_stroke_Color"));
const chart_tooltip_flyoutStyle_Fill_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_tooltip_flyoutStyle_Fill"));
const chart_tooltip_pointer_Width_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_tooltip_pointer_Width"));
const chart_tooltip_Padding_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_tooltip_Padding"));
const chart_tooltip_PointerEvents_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_tooltip_PointerEvents"));
const chart_voronoi_data_Fill_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_voronoi_data_Fill"));
const chart_voronoi_data_stroke_Color_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_voronoi_data_stroke_Color"));
const chart_voronoi_data_stroke_Width_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_voronoi_data_stroke_Width"));
const chart_voronoi_labels_Fill_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_voronoi_labels_Fill"));
const chart_voronoi_labels_Padding_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_voronoi_labels_Padding"));
const chart_voronoi_labels_PointerEvents_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_voronoi_labels_PointerEvents"));
const chart_voronoi_flyout_stroke_Width_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_voronoi_flyout_stroke_Width"));
const chart_voronoi_flyout_PointerEvents_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_voronoi_flyout_PointerEvents"));
const chart_voronoi_flyout_stroke_Color_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_voronoi_flyout_stroke_Color"));
const chart_voronoi_flyout_stroke_Fill_1 = tslib_1.__importDefault(require("@patternfly/react-tokens/dist/js/chart_voronoi_flyout_stroke_Fill"));
// Note: Values must be in pixles
// Typography
const TYPOGRAPHY_FONT_FAMILY = chart_global_FontFamily_1.default.var;
const TYPOGRAPHY_LETTER_SPACING = chart_global_letter_spacing_1.default.var;
const TYPOGRAPHY_FONT_SIZE = chart_global_FontSize_sm_1.default.value;
// Labels
const LABEL_PROPS = {
    fontFamily: TYPOGRAPHY_FONT_FAMILY,
    fontSize: TYPOGRAPHY_FONT_SIZE,
    letterSpacing: TYPOGRAPHY_LETTER_SPACING,
    padding: chart_global_label_Padding_1.default.value,
    stroke: chart_global_label_stroke_1.default.value
};
const LABEL_CENTERED_PROPS = Object.assign(Object.assign({}, LABEL_PROPS), { textAnchor: chart_global_label_text_anchor_1.default.value });
// Layout
const LAYOUT_PROPS = {
    padding: chart_global_layout_Padding_1.default.value,
    height: chart_global_layout_Height_1.default.value,
    width: chart_global_layout_Width_1.default.value
};
// Strokes
const STROKE_LINE_CAP = chart_global_stroke_line_cap_1.default.value;
const STROKE_LINE_JOIN = chart_global_stroke_line_join_1.default.value;
// Victory theme properties only
exports.BaseTheme = {
    area: Object.assign(Object.assign({}, LAYOUT_PROPS), { style: {
            data: {
                fill: chart_area_data_Fill_1.default.value,
                fillOpacity: chart_area_Opacity_1.default.value,
                // Omit stroke to add a line border from color scale
                // stroke: chart_global_label_stroke.value,
                strokeWidth: chart_area_stroke_Width_1.default.value
            },
            labels: LABEL_CENTERED_PROPS
        } }),
    axis: Object.assign(Object.assign({}, LAYOUT_PROPS), { style: {
            axis: {
                fill: chart_axis_axis_Fill_1.default.value,
                strokeWidth: chart_axis_axis_stroke_Width_1.default.value,
                stroke: chart_axis_axis_stroke_Color_1.default.value,
                strokeLinecap: STROKE_LINE_CAP,
                strokeLinejoin: STROKE_LINE_JOIN
            },
            axisLabel: Object.assign(Object.assign({}, LABEL_CENTERED_PROPS), { padding: chart_axis_axis_label_Padding_1.default.value, stroke: chart_axis_axis_label_stroke_Color_1.default.value }),
            grid: {
                fill: chart_axis_grid_Fill_1.default.value,
                stroke: 'none',
                pointerEvents: chart_axis_grid_PointerEvents_1.default.value,
                strokeLinecap: STROKE_LINE_CAP,
                strokeLinejoin: STROKE_LINE_JOIN
            },
            ticks: {
                fill: chart_axis_tick_Fill_1.default.value,
                size: chart_axis_tick_Size_1.default.value,
                stroke: chart_axis_tick_stroke_Color_1.default.value,
                strokeLinecap: STROKE_LINE_CAP,
                strokeLinejoin: STROKE_LINE_JOIN,
                strokeWidth: chart_axis_tick_Width_1.default.value
            },
            tickLabels: Object.assign(Object.assign({}, LABEL_PROPS), { fill: chart_axis_tick_label_Fill_1.default.value })
        } }),
    bar: Object.assign(Object.assign({}, LAYOUT_PROPS), { barWidth: chart_bar_Width_1.default.value, style: {
            data: {
                fill: chart_bar_data_Fill_1.default.value,
                padding: chart_bar_data_Padding_1.default.value,
                stroke: chart_bar_data_stroke_1.default.value,
                strokeWidth: chart_bar_data_stroke_Width_1.default.value
            },
            labels: LABEL_PROPS
        } }),
    boxplot: Object.assign(Object.assign({}, LAYOUT_PROPS), { style: {
            max: {
                padding: chart_boxplot_max_Padding_1.default.value,
                stroke: chart_boxplot_max_stroke_Color_1.default.value,
                strokeWidth: chart_boxplot_max_stroke_Width_1.default.value
            },
            maxLabels: LABEL_PROPS,
            median: {
                padding: chart_boxplot_median_Padding_1.default.value,
                stroke: chart_boxplot_median_stroke_Color_1.default.value,
                strokeWidth: chart_boxplot_median_stroke_Width_1.default.value
            },
            medianLabels: LABEL_PROPS,
            min: {
                padding: chart_boxplot_min_Padding_1.default.value,
                stroke: chart_boxplot_min_stroke_Color_1.default.value,
                strokeWidth: chart_boxplot_min_stroke_Width_1.default.value
            },
            minLabels: LABEL_PROPS,
            q1: {
                fill: chart_boxplot_lower_quartile_Fill_1.default.value,
                padding: chart_boxplot_lower_quartile_Padding_1.default.value
            },
            q1Labels: LABEL_PROPS,
            q3: {
                fill: chart_boxplot_upper_quartile_Fill_1.default.value,
                padding: chart_boxplot_upper_quartile_Padding_1.default.value
            },
            q3Labels: LABEL_PROPS
        }, boxWidth: chart_boxplot_box_Width_1.default.value }),
    candlestick: Object.assign(Object.assign({}, LAYOUT_PROPS), { candleColors: {
            positive: chart_candelstick_candle_positive_Color_1.default.value,
            negative: chart_candelstick_candle_negative_Color_1.default.value
        }, style: {
            data: {
                stroke: chart_candelstick_data_stroke_Color_1.default.value,
                strokeWidth: chart_candelstick_data_stroke_Width_1.default.value
            },
            labels: LABEL_CENTERED_PROPS
        } }),
    chart: Object.assign({}, LAYOUT_PROPS),
    errorbar: Object.assign(Object.assign({}, LAYOUT_PROPS), { borderWidth: chart_errorbar_BorderWidth_1.default.value, style: {
            data: {
                fill: chart_errorbar_data_Fill_1.default.value,
                opacity: chart_errorbar_data_Opacity_1.default.value,
                stroke: chart_errorbar_data_stroke_Color_1.default.value,
                strokeWidth: chart_errorbar_data_stroke_Width_1.default.value
            },
            labels: LABEL_CENTERED_PROPS
        } }),
    group: Object.assign({}, LAYOUT_PROPS),
    legend: {
        gutter: chart_legend_gutter_Width_1.default.value,
        orientation: chart_legend_orientation_1.default.value,
        titleOrientation: chart_legend_title_orientation_1.default.value,
        style: {
            data: {
                type: chart_legend_data_type_1.default.value
            },
            labels: LABEL_PROPS,
            title: Object.assign(Object.assign({}, LABEL_PROPS), { fontSize: TYPOGRAPHY_FONT_SIZE, padding: chart_legend_title_Padding_1.default.value })
        }
    },
    line: Object.assign(Object.assign({}, LAYOUT_PROPS), { style: {
            data: {
                fill: chart_line_data_Fill_1.default.value,
                opacity: chart_line_data_Opacity_1.default.value,
                stroke: chart_line_data_stroke_Color_1.default.value,
                strokeWidth: chart_line_data_stroke_Width_1.default.value
            },
            labels: LABEL_CENTERED_PROPS
        } }),
    pie: {
        padding: chart_pie_Padding_1.default.value,
        style: {
            data: {
                padding: chart_pie_data_Padding_1.default.value,
                stroke: chart_pie_data_stroke_Color_1.default.value,
                strokeWidth: chart_pie_data_stroke_Width_1.default.value
            },
            labels: Object.assign(Object.assign({}, LABEL_PROPS), { padding: chart_pie_labels_Padding_1.default.value })
        },
        height: chart_pie_Height_1.default.value,
        width: chart_pie_Width_1.default.value
    },
    scatter: Object.assign(Object.assign({}, LAYOUT_PROPS), { style: {
            data: {
                fill: chart_scatter_data_Fill_1.default.value,
                opacity: chart_scatter_data_Opacity_1.default.value,
                stroke: chart_scatter_data_stroke_Color_1.default.value,
                strokeWidth: chart_scatter_data_stroke_Width_1.default.value
            },
            labels: LABEL_CENTERED_PROPS
        } }),
    stack: Object.assign(Object.assign({}, LAYOUT_PROPS), { style: {
            data: {
                strokeWidth: chart_stack_data_stroke_Width_1.default.value
            }
        } }),
    tooltip: {
        cornerRadius: chart_tooltip_corner_radius_1.default.value,
        flyoutPadding: chart_tooltip_Padding_1.default.value,
        flyoutStyle: {
            cornerRadius: chart_tooltip_flyoutStyle_corner_radius_1.default.value,
            fill: chart_tooltip_flyoutStyle_Fill_1.default.value,
            pointerEvents: chart_tooltip_flyoutStyle_PointerEvents_1.default.value,
            stroke: chart_tooltip_flyoutStyle_stroke_Color_1.default.value,
            strokeWidth: chart_tooltip_flyoutStyle_stroke_Width_1.default.value
        },
        pointerLength: chart_tooltip_pointer_length_1.default.value,
        pointerWidth: chart_tooltip_pointer_Width_1.default.value,
        style: {
            fill: chart_tooltip_Fill_1.default.value,
            pointerEvents: chart_tooltip_PointerEvents_1.default.value
        }
    },
    voronoi: Object.assign(Object.assign({}, LAYOUT_PROPS), { style: {
            data: {
                fill: chart_voronoi_data_Fill_1.default.value,
                stroke: chart_voronoi_data_stroke_Color_1.default.value,
                strokeWidth: chart_voronoi_data_stroke_Width_1.default.value
            },
            labels: Object.assign(Object.assign({}, LABEL_CENTERED_PROPS), { fill: chart_voronoi_labels_Fill_1.default.value, padding: chart_voronoi_labels_Padding_1.default.value, pointerEvents: chart_voronoi_labels_PointerEvents_1.default.value }),
            // Note: These properties override tooltip
            flyout: {
                fill: chart_voronoi_flyout_stroke_Fill_1.default.value,
                pointerEvents: chart_voronoi_flyout_PointerEvents_1.default.value,
                stroke: chart_voronoi_flyout_stroke_Color_1.default.value,
                strokeWidth: chart_voronoi_flyout_stroke_Width_1.default.value
            }
        } })
};
//# sourceMappingURL=base-theme.js.map