import _isRegExp from "lodash/isRegExp";
import _isString from "lodash/isString";
import _includes from "lodash/includes";
import _isEmpty from "lodash/isEmpty";
import _isFunction from "lodash/isFunction";
import _throttle from "lodash/throttle";
import _assign from "lodash/assign";

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }

import { Selection, Data, Helpers } from "victory-core";
import isEqual from "react-fast-compare";
import Delaunay from "delaunay-find/lib/index.js";
import React from "react";
var VoronoiHelpers = {
  withinBounds: function (props, point) {
    var width = props.width,
        height = props.height,
        polar = props.polar,
        origin = props.origin,
        scale = props.scale;
    var padding = Helpers.getPadding(props, "voronoiPadding");
    var x = point.x,
        y = point.y;

    if (polar) {
      var distanceSquared = Math.pow(x - origin.x, 2) + Math.pow(y - origin.y, 2);
      var radius = Math.max.apply(Math, _toConsumableArray(scale.y.range()));
      return distanceSquared < Math.pow(radius, 2);
    } else {
      return x >= padding.left && x <= width - padding.right && y >= padding.top && y <= height - padding.bottom;
    }
  },
  getDatasets: function (props) {
    var children = React.Children.toArray(props.children);

    var addMeta = function (data, name, child) {
      var continuous = child && child.type && child.type.continuous;
      var style = child ? child.props && child.props.style : props.style;
      return data.map(function (datum, index) {
        var _Helpers$getPoint = Helpers.getPoint(datum),
            x = _Helpers$getPoint.x,
            y = _Helpers$getPoint.y,
            y0 = _Helpers$getPoint.y0,
            x0 = _Helpers$getPoint.x0;

        var voronoiX = (+x + +x0) / 2;
        var voronoiY = (+y + +y0) / 2;
        return _assign({
          _voronoiX: props.voronoiDimension === "y" ? 0 : voronoiX,
          _voronoiY: props.voronoiDimension === "x" ? 0 : voronoiY,
          eventKey: index,
          childName: name,
          continuous: continuous,
          style: style
        }, datum);
      });
    };

    if (props.data) {
      return addMeta(props.data);
    }

    var getData = function (childProps) {
      var data = Data.getData(childProps);
      return Array.isArray(data) && data.length > 0 ? data : undefined;
    };

    var iteratee = function (child, childName) {
      var childProps = child.props || {};
      var name = childProps.name || childName;
      var blacklist = props.voronoiBlacklist || [];
      var blacklistStr = blacklist.filter(_isString);
      var blacklistRegExp = blacklist.filter(_isRegExp);
      var isRegExpMatch = blacklistRegExp.some(function (regExp) {
        return regExp.test(name);
      });

      if (!Data.isDataComponent(child) || _includes(blacklistStr, name) || isRegExpMatch) {
        return null;
      }

      var getChildData = child.type && _isFunction(child.type.getData) ? child.type.getData : getData;
      var childData = getChildData(child.props);
      return childData ? addMeta(childData, name, child) : null;
    };

    return Helpers.reduceChildren(children, iteratee, props);
  },
  findPoints: function (datasets, point) {
    return datasets.filter(function (d) {
      return point._voronoiX === d._voronoiX && point._voronoiY === d._voronoiY;
    });
  },
  withinRadius: function (point, mousePosition, radius) {
    if (!point) {
      return false;
    }

    if (!radius) {
      return true;
    }

    var x = mousePosition.x,
        y = mousePosition.y;
    var distanceSquared = Math.pow(x - point[0], 2) + Math.pow(y - point[1], 2);
    return distanceSquared < Math.pow(radius, 2);
  },
  getVoronoiPoints: function (props, mousePosition) {
    var datasets = this.getDatasets(props);
    var scaledData = datasets.map(function (d) {
      var _Helpers$scalePoint = Helpers.scalePoint(props, d),
          x = _Helpers$scalePoint.x,
          y = _Helpers$scalePoint.y;

      return [x, y];
    });
    var delaunay = Delaunay.from(scaledData);
    var index = delaunay.find(mousePosition.x, mousePosition.y);
    var withinRadius = this.withinRadius(scaledData[index], mousePosition, props.radius);
    var points = withinRadius ? this.findPoints(datasets, datasets[index]) : [];
    return {
      points: points,
      index: index
    };
  },
  getActiveMutations: function (props, point) {
    var childName = point.childName,
        continuous = point.continuous;
    var activateData = props.activateData,
        activateLabels = props.activateLabels,
        labels = props.labels;

    if (!activateData && !activateLabels) {
      return [];
    }

    var defaultTarget = activateData ? ["data"] : [];
    var targets = labels && !activateLabels ? defaultTarget : defaultTarget.concat("labels");

    if (_isEmpty(targets)) {
      return [];
    }

    return targets.map(function (target) {
      var eventKey = continuous === true && target === "data" ? "all" : point.eventKey;
      return {
        childName: childName,
        eventKey: eventKey,
        target: target,
        mutation: function () {
          return {
            active: true
          };
        }
      };
    });
  },
  getInactiveMutations: function (props, point) {
    var childName = point.childName,
        continuous = point.continuous;
    var activateData = props.activateData,
        activateLabels = props.activateLabels,
        labels = props.labels;

    if (!activateData && !activateLabels) {
      return [];
    }

    var defaultTarget = activateData ? ["data"] : [];
    var targets = labels && !activateLabels ? defaultTarget : defaultTarget.concat("labels");

    if (_isEmpty(targets)) {
      return [];
    }

    return targets.map(function (target) {
      var eventKey = continuous && target === "data" ? "all" : point.eventKey;
      return {
        childName: childName,
        eventKey: eventKey,
        target: target,
        mutation: function () {
          return null;
        }
      };
    });
  },
  // eslint-disable-next-line max-params
  getParentMutation: function (activePoints, mousePosition, parentSVG, vIndex) {
    return [{
      target: "parent",
      eventKey: "parent",
      mutation: function () {
        return {
          activePoints: activePoints,
          mousePosition: mousePosition,
          parentSVG: parentSVG,
          vIndex: vIndex
        };
      }
    }];
  },
  onActivated: function (props, points) {
    if (_isFunction(props.onActivated)) {
      props.onActivated(points, props);
    }
  },
  onDeactivated: function (props, points) {
    if (_isFunction(props.onDeactivated)) {
      props.onDeactivated(points, props);
    }
  },
  onMouseLeave: function (evt, targetProps) {
    var _this = this,
        _getParentMutation;

    var activePoints = targetProps.activePoints || [];
    this.onDeactivated(targetProps, activePoints);
    var inactiveMutations = activePoints.length ? activePoints.map(function (point) {
      return _this.getInactiveMutations(targetProps, point);
    }) : [];
    return (_getParentMutation = this.getParentMutation([])).concat.apply(_getParentMutation, _toConsumableArray(inactiveMutations));
  },
  onMouseMove: function (evt, targetProps) {
    var _this2 = this;

    // eslint-disable-line max-statements
    var activePoints = targetProps.activePoints || [];
    var parentSVG = targetProps.parentSVG || Selection.getParentSVG(evt);
    var mousePosition = Selection.getSVGEventCoordinates(evt, parentSVG);

    if (!this.withinBounds(targetProps, mousePosition)) {
      var _getParentMutation2;

      this.onDeactivated(targetProps, activePoints);
      var inactiveMutations = activePoints.length ? activePoints.map(function (point) {
        return _this2.getInactiveMutations(targetProps, point);
      }) : [];
      return (_getParentMutation2 = this.getParentMutation([], mousePosition, parentSVG)).concat.apply(_getParentMutation2, _toConsumableArray(inactiveMutations));
    }

    var _getVoronoiPoints = this.getVoronoiPoints(targetProps, mousePosition),
        _getVoronoiPoints$poi = _getVoronoiPoints.points,
        points = _getVoronoiPoints$poi === void 0 ? [] : _getVoronoiPoints$poi,
        index = _getVoronoiPoints.index;

    var parentMutations = this.getParentMutation(points, mousePosition, parentSVG, index);

    if (activePoints.length && isEqual(points, activePoints)) {
      return parentMutations;
    } else {
      this.onActivated(targetProps, points);
      this.onDeactivated(targetProps, activePoints);
      var activeMutations = points.length ? points.map(function (point) {
        return _this2.getActiveMutations(targetProps, point);
      }) : [];

      var _inactiveMutations = activePoints.length ? activePoints.map(function (point) {
        return _this2.getInactiveMutations(targetProps, point);
      }) : [];

      return parentMutations.concat.apply(parentMutations, _toConsumableArray(_inactiveMutations).concat(_toConsumableArray(activeMutations)));
    }
  }
};
export default {
  onMouseLeave: VoronoiHelpers.onMouseLeave.bind(VoronoiHelpers),
  onMouseMove: _throttle(VoronoiHelpers.onMouseMove.bind(VoronoiHelpers), 32, // eslint-disable-line no-magic-numbers
  {
    leading: true,
    trailing: false
  })
};